/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.AbstractDefaultTimeValueUI;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.RunReportParam;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class DefaultTimeValueUI
extends AbstractDefaultTimeValueUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(DefaultTimeValueUI.class);
    private boolean isinitLayout = false;
    private boolean isCancel = false;

    public DefaultTimeValueUI() throws Exception {
        this.initLayout();
        this.kDButtonGroup1.add((AbstractButton)this.rbSystem);
        this.kDButtonGroup1.add((AbstractButton)this.rbFix);
    }

    public DefaultTimeValueUI(String value) throws Exception {
        this();
        if (value.startsWith("getSystemTime()")) {
            this.rbSystem.setSelected(true);
        } else {
            this.rbFix.setSelected(true);
            String formatString = "HH:mm:ss";
            Date date = null;
            if (value != null && !value.equals("")) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(formatString);
                    date = sdf.parse(value);
                }
                catch (ParseException e) {}
            } else {
                date = RunReportParam.getServerDate(null);
            }
            this.time1.setValue((Object)date);
        }
    }

    public DefaultTimeValueUI(String value, boolean isProcedure) throws Exception {
        this(value);
        if (isProcedure) {
            this.rbSystem.setEnabled(false);
            this.btnClear.setEnabled(false);
        }
    }

    public void initLayout() {
        if (!this.isinitLayout) {
            super.initLayout();
            this.isinitLayout = true;
        }
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.closeWin();
    }

    private void closeWin() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = false;
        this.closeWin();
    }

    protected void btnClear_actionPerformed(ActionEvent e) throws Exception {
        this.time1.setEnabled(true);
        this.rbFix.setSelected(true);
    }

    protected void rbFix_itemStateChanged(ItemEvent e) throws Exception {
        this.time1.setEnabled(true);
    }

    protected void rbSystem_itemStateChanged(ItemEvent e) throws Exception {
        this.time1.setEnabled(false);
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public String getDateSelected() {
        String ret = null;
        if (this.rbSystem.isSelected()) {
            ret = "getSystemTime()";
        } else {
            ret = CtrlReportUtil.getObjectString(this.time1.getText());
            if (!ret.equals("")) {
                String formatString = "HH:mm:ss";
                String pattern = this.time1.getTimePattern();
                ret = CtrlReportUtil.formatDate(pattern, formatString, ret);
            }
        }
        return ret;
    }
}

