/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.client;

import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtColumn;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetTextFactory;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import com.kingdee.eas.util.client.AdvMsgBox;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;

public class ExtExcuteValueUI
extends TypicalDialog {
    private static final long serialVersionUID = 3352484457969289004L;
    private ExtDataSetManager _manager;
    private KDTabbedPane _tabbedPane;
    private KDWorkButton _btnExportData;
    private KDWorkButton _btnExportAllData;

    public ExtExcuteValueUI(ExtDataSetManager manager) {
        this.intiUI(manager);
    }

    public ExtExcuteValueUI(ExtDataSetManager manager, Frame own) {
        super(own);
        this.intiUI(manager);
    }

    public ExtExcuteValueUI(ExtDataSetManager manager, Dialog own) {
        super(own);
        this.intiUI(manager);
    }

    private void intiUI(ExtDataSetManager manager) {
        this._manager = manager;
        this._tabbedPane = new KDTabbedPane();
        this._tabbedPane.setForcedHide(false);
        this.mode2ui();
    }

    private void mode2ui() {
        int size = this._manager.size();
        for (int i = 0; i < size; ++i) {
            ExtDataSet dataset = this._manager.getAt(i);
            SortedObjectArray _columns = dataset.getColumns();
            ExtColumn[] columns = new ExtColumn[_columns.size()];
            ArrayList<ExtColumn> files = new ArrayList<ExtColumn>();
            for (int j = 0; j < columns.length; ++j) {
                ExtColumn col = (ExtColumn)_columns.get(j);
                int index = (Integer)col.getIndex().getValue();
                if (index >= columns.length) {
                    files.add(col);
                    continue;
                }
                columns[index] = col;
            }
            int fileSize = files.size();
            if (fileSize > 0) {
                String detail = "\u6570\u636e\u6e90\uff1a" + dataset.getAlias() + "\n" + "\u4e0d\u4e00\u81f4\u5b57\u6bb5\uff1a" + "[" + ((ExtColumn)files.get(0)).getAlias() + "]";
                String errorInfo = "\u5b9e\u9645\u8fd4\u56de\u7684\u6570\u636e\u96c6\u5217\u6570\u4e0e\u62a5\u8868\u5f15\u5165\u7684\u6570\u636e\u96c6\u5b9a\u4e49\u5217\u6570\u4e0d\u4e00\u81f4\uff0c\u53ef\u80fd\u5728\u62a5\u8868\u4e2d\u5f15\u5165\u6570\u636e\u96c6\u540e\u4fee\u6539\u4e86\u6570\u636e\u96c6\u7684\u5b9a\u4e49\u3002";
                for (int j = 1; j < fileSize; ++j) {
                    detail = detail + ", [" + ((ExtColumn)files.get(j)).getAlias() + "]";
                }
                detail = detail + "\u3002";
                AdvMsgBox msgBox = AdvMsgBox.createAdvMsgBox((Component)((Object)this), (String)"\u9519\u8bef\u4fe1\u606f", (String)errorInfo, (String)detail, (int)0, (int)8188);
                msgBox.show();
                return;
            }
            if (columns.length <= 0) {
                return;
            }
            KDTable table = new KDTable();
            this.setTaleHeader(table, columns);
            this.bindDataSet(table, dataset);
            String tableName = dataset.getName();
            if (StringUtil.isEmptyString((String)dataset.getAlias())) {
                tableName = tableName + "(" + dataset.getAlias() + ")";
            }
            this._tabbedPane.addTab(tableName, null, (Component)table, true);
        }
    }

    private void setTaleHeader(KDTable table, ExtColumn[] columns) {
        int length = columns.length;
        table.addColumns(length);
        IRow headRow = table.addHeadRow();
        for (int i = 0; i < length; ++i) {
            String rowHeader = columns[i].getName();
            headRow.getCell(i).setValue((Object)rowHeader.toUpperCase());
        }
    }

    private void bindDataSet(KDTable table, ExtDataSet dataset) {
        Variant[][] data = dataset.getData();
        if (data == null || data.length <= 0) {
            return;
        }
        int rows = data.length;
        int cols = data[0].length;
        for (int r = 0; r < rows; ++r) {
            table.addRow();
            for (int c = 0; c < cols; ++c) {
                Variant value = data[r][c];
                table.getCell(r, c).setValue((Object)value);
            }
        }
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        parent.add((Component)this._tabbedPane, thisCell);
        KDToolBar toolBar = new KDToolBar();
        toolBar.add((Component)this._btnExportData);
        toolBar.add((Component)this._btnExportAllData);
        this.addToolBar((JToolBar)toolBar);
    }

    protected void todoInit() {
        this.setTitle("\u6267\u884c\u7ed3\u679c\u6570\u636e");
        this.setSize(800, 600);
        this.btnCancel.setVisible(false);
        this._btnExportData = new KDWorkButton("\u5bfc\u51fa\u6570\u636e");
        this._btnExportData.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this._btnExportData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean isSure;
                String path = ExtExcuteValueUI.this.getChooserFile();
                if (path == null) {
                    return;
                }
                ExtDataSet dataSet = ExtExcuteValueUI.this._manager.getAt(ExtExcuteValueUI.this._tabbedPane.getSelectedIndex());
                File file = new File(path + "\\" + dataSet.getName() + ".txt");
                if (file.exists() && !(isSure = WindowUtil.msgboxYesNo((Component)ExtExcuteValueUI.this._tabbedPane, (Object)("\u6587\u4ef6: " + dataSet.getName() + ".txt " + "\u5df2\u7ecf\u5b58\u5728\uff0c\u786e\u5b9a\u8981\u8986\u76d6\u5417\uff1f"), (String)"\u5bfc\u51fa\u6587\u672c\u6570\u636e\u6e90"))) {
                    return;
                }
                boolean succeed = ExtDataSetTextFactory.exportDataSet((ExtDataSet)dataSet, (File)file);
                WindowUtil.msgboxInfo((Object)("\u5bfc\u51fa" + (succeed ? "\u6210\u529f" : "\u5931\u8d25")), (String)"\u5bfc\u51fa\u4fe1\u606f", (Component)ExtExcuteValueUI.this._tabbedPane);
            }
        });
        this._btnExportAllData = new KDWorkButton("\u5bfc\u51fa\u6240\u6709\u6570\u636e");
        this._btnExportAllData.setIcon(EASResource.getIcon((String)"imgTbtn_dcdwj"));
        this._btnExportAllData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String path = ExtExcuteValueUI.this.getChooserFile();
                if (path == null) {
                    return;
                }
                int size = ExtExcuteValueUI.this._manager.size();
                boolean isAll = false;
                boolean succeed = true;
                for (int i = 0; i < size; ++i) {
                    ExtDataSet dataSet = ExtExcuteValueUI.this._manager.getAt(i);
                    File file = new File(path + "\\" + dataSet.getName() + ".txt");
                    if (file.exists() && !isAll) {
                        int choose = MessageDialog.show((Component)ExtExcuteValueUI.this._tabbedPane, (Object)("\u6587\u4ef6: " + dataSet.getName() + ".txt " + "\u5df2\u7ecf\u5b58\u5728\uff0c\u786e\u5b9a\u8981\u8986\u76d6\u5417\uff1f"), (String)"\u5bfc\u51fa\u6587\u672c\u6570\u636e\u6e90", (int)4, (int)3);
                        if (choose == 1) continue;
                        if (choose == 3) {
                            isAll = true;
                        }
                        succeed = succeed && ExtDataSetTextFactory.exportDataSet((ExtDataSet)dataSet, (File)file);
                        continue;
                    }
                    succeed = succeed && ExtDataSetTextFactory.exportDataSet((ExtDataSet)dataSet, (File)file);
                }
                WindowUtil.msgboxInfo((Object)("\u5bfc\u51fa" + (succeed ? "\u6210\u529f" : "\u5931\u8d25")), (String)"\u5bfc\u51fa\u4fe1\u606f", (Component)ExtExcuteValueUI.this._tabbedPane);
            }
        });
    }

    private String getChooserFile() {
        KDFileChooser chooser = new KDFileChooser();
        chooser.setDialogType(1);
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label51"));
        FileFilter[] ff = chooser.getChoosableFileFilters();
        for (int i = 0; i < ff.length; ++i) {
            chooser.removeChoosableFileFilter(ff[i]);
        }
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }

            public String getDescription() {
                return "\u6587\u672c\u6587\u6863(*.txt)";
            }
        });
        int r = chooser.showSaveDialog((Component)((Object)this));
        if (r == 0) {
            String path = chooser.getSelectedFile().getPath();
            return path;
        }
        return null;
    }
}

