/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.client;

import com.kingdee.bos.ctrl.common.datacenter.DataCenterDBType;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.ExtReportOutDBBO;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.MessageUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.AbstractOutDBUI;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.DesignUI;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class OutDBUI
extends AbstractOutDBUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(OutDBUI.class);
    private ArrayList outDBList = null;
    Color colorOld = null;
    String outDBName = "";

    public OutDBUI() throws Exception {
        this.init();
    }

    private void init() {
        this.initLayout();
        this.table.checkParsed();
        this.setOpaque(false);
        this.table.getSelectManager().setSelectMode(2);
        this.btnUse.setEnabled(false);
        this.initOutDBList();
        this.installListener();
    }

    private void installListener() {
        this.btnUse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    int rowIndex = OutDBUI.this.table.getSelectManager().getActiveRowIndex();
                    if (rowIndex < 0) {
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label8"));
                        return;
                    }
                    IRow irow = OutDBUI.this.table.getRow(rowIndex);
                    if (OutDBUI.this.btnUse.getText().equals(MessageUtil.getMsgInfo("label292"))) {
                        irow.getCell(2).setValue((Object)"Y");
                        irow.getStyleAttributes().setFontColor(Color.blue);
                        irow.getStyleAttributes().setBold(true);
                        OutDBUI.this.btnUse.setText(MessageUtil.getMsgInfo("label293"));
                        OutDBUI.this.labelErr.setText("");
                        HashMap mapData = (HashMap)irow.getUserObject();
                        OutDBUI.this.outDBName = CtrlReportUtil.getObjectString(mapData.get("fdbcentername"));
                        OutDBUI.this.setOutDBNameToModel();
                    } else {
                        irow.getCell(2).setValue((Object)"N");
                        irow.getStyleAttributes().setFontColor(OutDBUI.this.colorOld);
                        irow.getStyleAttributes().setBold(false);
                        OutDBUI.this.btnUse.setText(MessageUtil.getMsgInfo("label292"));
                        OutDBUI.this.outDBName = "";
                        OutDBUI.this.setOutDBNameToModel();
                    }
                    for (int i = 0; i < OutDBUI.this.table.getRowCount(); ++i) {
                        irow = OutDBUI.this.table.getRow(i);
                        String useText = irow.getCell(2).getValue().toString();
                        if (!useText.equals("Y") || i == rowIndex) continue;
                        irow.getCell(2).setValue((Object)"N");
                        irow.getStyleAttributes().setFontColor(OutDBUI.this.colorOld);
                        irow.getStyleAttributes().setBold(false);
                    }
                }
                catch (Exception e1) {
                    logger.error((Object)"editInuptCtrl", (Throwable)e1);
                }
            }
        });
        this.table.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                OutDBUI.this.setBtnText();
            }
        });
        this.table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                OutDBUI.this.setBtnText();
            }
        });
    }

    private void setBtnText() {
        this.btnUse.setEnabled(true);
        try {
            int rowIndex = this.table.getSelectManager().getActiveRowIndex();
            IRow irow = this.table.getRow(rowIndex);
            String cellValue = irow.getCell(2).getValue().toString();
            if (cellValue.equals("Y")) {
                this.btnUse.setText(MessageUtil.getMsgInfo("label293"));
            } else {
                this.btnUse.setText(MessageUtil.getMsgInfo("label292"));
            }
        }
        catch (Exception exc) {
            logger.error((Object)"setBtnText", (Throwable)exc);
        }
    }

    private void initOutDBList() {
        if (this.outDBList == null) {
            try {
                this.outDBList = ExtReportOutDBBO.getDBList(null);
            }
            catch (Exception e) {
                logger.error((Object)e);
                this.outDBList = new ArrayList();
            }
        }
        this.refreshTable();
    }

    void refreshTable() {
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)DesignUI.getInstance().getModel().getQuery();
        String outDB = CtrlReportUtil.getObjectString(ksqlQuery.getOutDB());
        boolean isFind = false;
        this.table.removeRows();
        for (HashMap map : this.outDBList) {
            IRow irow = this.table.addRow();
            irow.getStyleAttributes().setLocked(true);
            String fdbcentername = CtrlReportUtil.getObjectString(map.get("fdbcentername"));
            irow.getCell(0).setValue((Object)fdbcentername);
            int dbtype = Integer.parseInt(CtrlReportUtil.getObjectString(map.get("fdbtype")));
            irow.getCell(1).setValue((Object)DataCenterDBType.getDBType((int)dbtype));
            irow.getCell(2).setValue((Object)"N");
            irow.setUserObject((Object)map);
            if (outDB.equals("") || !fdbcentername.equals(outDB)) continue;
            irow.getCell(2).setValue((Object)"Y");
            this.colorOld = irow.getStyleAttributes().getFontColor();
            irow.getStyleAttributes().setFontColor(Color.blue);
            irow.getStyleAttributes().setBold(true);
            isFind = true;
            this.outDBName = outDB;
        }
        if (!isFind && !outDB.equals("")) {
            this.labelErr.setText(MessageUtil.getMsgInfo("label294") + outDB);
            this.labelErr.setForeground(Color.red);
        }
    }

    private void setOutDBNameToModel() {
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)DesignUI.getInstance().getModel().getQuery();
        ksqlQuery.setOutDB(this.outDBName);
    }
}

