/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.client;

import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.MessageUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.AbstractSetupAloneBoxUI;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.DesignDataType;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.IInputCtrl;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.InputCtrlImpl;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.InputType;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class SetupAloneBoxUI
extends AbstractSetupAloneBoxUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(SetupAloneBoxUI.class);
    private boolean isCancel = false;
    private InputType inputType;
    InputCtrlImpl inputCtrl;
    DesignDataType dataType;

    public void setValueFromParam(DesignParameter p) throws Exception {
        this.dataType = p.getDesignDataType();
        IInputCtrl inputCtrl = p.getInputCtrl();
        if (inputCtrl != null) {
            DefObj defValue = inputCtrl.getDefValue();
            this.txtSelectedValue.setText(defValue.getName());
            this.txtSelectedAlias.setText(defValue.getAlias());
            DefObj defDisplay = inputCtrl.getDefDisplay();
            this.txtNoSelectedValue.setText(defDisplay.getName());
            this.txtNoSelectedAlias.setText(defDisplay.getAlias());
        }
    }

    public boolean destroyWindow() {
        this.isCancel = true;
        return super.destroyWindow();
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.closeWin();
    }

    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        String selectedValue = this.txtSelectedValue.getText().trim();
        String noSelectedValue = this.txtNoSelectedValue.getText().trim();
        if (!selectedValue.equals("")) {
            if (this.dataType.equals(DesignDataType.NUMERICAL)) {
                if (!selectedValue.matches("(-|\\+)?\\d+\\.?\\d*")) {
                    MessageUtil.showInfo("label415", true);
                    this.txtSelectedValue.requestFocus();
                    return;
                }
            } else if (this.dataType.equals(DesignDataType.BOOLEAN) && !selectedValue.equalsIgnoreCase("true") && !selectedValue.equalsIgnoreCase("false")) {
                MessageUtil.showInfo("label422", true);
                this.txtSelectedValue.requestFocus();
                return;
            }
        }
        if (!noSelectedValue.equals("")) {
            if (this.dataType.equals(DesignDataType.NUMERICAL)) {
                if (!noSelectedValue.matches("(-|\\+)?\\d+\\.?\\d*")) {
                    MessageUtil.showInfo("label415", true);
                    this.txtNoSelectedValue.requestFocus();
                    return;
                }
            } else if (this.dataType.equals(DesignDataType.BOOLEAN) && !noSelectedValue.equalsIgnoreCase("true") && !noSelectedValue.equalsIgnoreCase("false")) {
                MessageUtil.showInfo("label422", true);
                this.txtNoSelectedValue.requestFocus();
                return;
            }
        }
        this.inputCtrl = new InputCtrlImpl();
        this.inputCtrl.setInputType(this.inputType);
        DefObj defValue = new DefObj();
        defValue.setName(selectedValue);
        defValue.setAlias(this.txtSelectedAlias.getText().trim());
        DefObj defDisplay = new DefObj();
        defDisplay.setName(noSelectedValue);
        defDisplay.setAlias(this.txtNoSelectedAlias.getText().trim());
        this.inputCtrl.setDefValue(defValue);
        this.inputCtrl.setDefDisplay(defDisplay);
        this.isCancel = false;
        this.closeWin();
    }

    public InputCtrlImpl getInputCtrl() {
        return this.inputCtrl;
    }

    private void closeWin() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    public boolean isCancel() {
        return this.isCancel;
    }
}

