/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.client;

import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.MessageUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.AbstractSetupSpinnerUI;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.IInputCtrl;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.InputCtrlImpl;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.InputType;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class SetupSpinnerUI
extends AbstractSetupSpinnerUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(SetupSpinnerUI.class);
    private boolean isCancel = false;
    private InputType inputType;
    InputCtrlImpl inputCtrl;

    public void setValueFromParam(DesignParameter p) throws Exception {
        IInputCtrl inputCtrl = p.getInputCtrl();
        if (inputCtrl != null) {
            DefObj def = inputCtrl.getDefValue();
            String value = def.getName();
            String[] valueArr = value.split(";");
            this.txtUpperLimit.setText(valueArr[0]);
            this.txtLowerLimit.setText(valueArr[1]);
            this.txtStep.setText(valueArr[2]);
        }
    }

    public boolean destroyWindow() {
        this.isCancel = true;
        return super.destroyWindow();
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.closeWin();
    }

    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        String upperLimit = this.txtUpperLimit.getText().trim();
        if (!upperLimit.matches("(-|\\+)?\\d+\\.?\\d*")) {
            MessageUtil.showInfo("label415", true);
            this.txtUpperLimit.requestFocus();
            return;
        }
        String lowerLimit = this.txtLowerLimit.getText().trim();
        if (!lowerLimit.matches("(-|\\+)?\\d+\\.?\\d*")) {
            MessageUtil.showInfo("label415", true);
            this.txtLowerLimit.requestFocus();
            return;
        }
        String step = this.txtStep.getText().trim();
        if (!step.matches("(-|\\+)?\\d+\\.?\\d*")) {
            MessageUtil.showInfo("label415", true);
            this.txtStep.requestFocus();
            return;
        }
        String name = upperLimit + ";" + lowerLimit + ";" + step;
        this.inputCtrl = new InputCtrlImpl();
        this.inputCtrl.setInputType(this.inputType);
        DefObj def = new DefObj();
        def.setName(name);
        this.inputCtrl.setDefValue(def);
        this.isCancel = false;
        this.closeWin();
    }

    public InputCtrlImpl getInputCtrl() {
        return this.inputCtrl;
    }

    private void closeWin() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    public boolean isCancel() {
        return this.isCancel;
    }
}

