/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.dispatch;

import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.ReportDialog;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.DefaultDateTimeValueUI;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.DefaultDateValueUI;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.DefaultTimeValueUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class DispatchDatePicker
implements KDPromptSelector,
DataChangeListener {
    private DefaultTimeValueUI timeUI;
    private DefaultDateValueUI dateUI;
    private DefaultDateTimeValueUI dtUI;
    private int type;
    private ReportDialog dialog;
    private Logger logger = Logger.getLogger(DispatchDatePicker.class);

    public DispatchDatePicker(int type, String value) {
        this.type = type;
        this.updateUI(type, value);
    }

    private void updateUI(int type, String value) {
        try {
            switch (type) {
                case 2: {
                    this.dateUI = StringUtils.isEmpty((String)value) ? new DefaultDateValueUI() : new DefaultDateValueUI(value, 2);
                    break;
                }
                case 4: {
                    this.dtUI = StringUtils.isEmpty((String)value) ? new DefaultDateTimeValueUI() : new DefaultDateTimeValueUI(value, 4);
                    break;
                }
                case 5: {
                    this.timeUI = StringUtils.isEmpty((String)value) ? new DefaultTimeValueUI() : new DefaultTimeValueUI(value);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"\u521b\u5efa\u65e5\u671f\u9009\u4e2d\u5668\u5931\u8d25", (Throwable)e);
        }
    }

    public Object getData() {
        String data = null;
        switch (this.type) {
            case 2: {
                data = this.dateUI.getDateSelected();
                break;
            }
            case 4: {
                data = this.dtUI.getDateSelected();
                break;
            }
            case 5: {
                data = this.timeUI.getDateSelected();
            }
        }
        return data;
    }

    public boolean isCanceled() {
        boolean data = false;
        switch (this.type) {
            case 2: {
                data = this.dateUI.isCancel();
                break;
            }
            case 4: {
                data = this.dtUI.isCancel();
                break;
            }
            case 5: {
                data = this.timeUI.isCancel();
            }
        }
        return data;
    }

    public void show() {
        CoreUI data = null;
        String title = null;
        switch (this.type) {
            case 2: {
                data = this.dateUI;
                title = "\u65e5\u671f\u9009\u62e9";
                break;
            }
            case 4: {
                data = this.dtUI;
                title = "\u65e5\u671f\u65f6\u95f4\u9009\u62e9";
                break;
            }
            case 5: {
                data = this.timeUI;
                title = "\u65f6\u95f4\u9009\u62e9";
            }
        }
        if (this.dialog == null) {
            try {
                this.dialog = ReportDialog.showDialog((CoreUIObject)data, title, true);
            }
            catch (Exception e) {
                this.logger.error((Object)"\u521b\u5efa\u65e5\u671f\u9009\u4e2d\u5668\u5931\u8d25", (Throwable)e);
            }
        } else {
            this.dialog.setVisible(true);
        }
    }

    public void dataChanged(DataChangeEvent eventObj) {
        Object newValue = eventObj.getNewValue();
        if (newValue instanceof DefObj[]) {
            DefObj[] valueArray = (DefObj[])newValue;
            try {
                DefObj value = valueArray[0];
                String realValue = value.getName();
                this.updateUI(this.type, realValue);
            }
            catch (Exception e) {}
        } else if (newValue instanceof String) {
            this.updateUI(this.type, newValue.toString());
        }
    }
}

