/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.data;

import com.kingdee.bos.ctrl.data.process.dataset.group.GroupNode;
import com.kingdee.bos.ctrl.data.process.dataset.group.resultset.GroupTotalResultSetUtil;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import java.awt.Color;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class DataBindUtil {
    private static Color[] clrs = new Color[]{new Color(255, 238, 255), new Color(255, 255, 238), new Color(238, 255, 255), new Color(238, 238, 255), new Color(238, 255, 238)};

    public static int bindResultSet(KDTable table, ResultSet rs, boolean append, boolean onlyAddHead) throws SQLException {
        int bindRow = 0;
        int cols = rs.getMetaData().getColumnCount();
        int row = 0;
        if (append && (row = table.getRowCount()) == 0) {
            append = false;
        }
        if (!append) {
            table.removeColumns();
            table.addColumns(cols);
            IRow headRow = table.addHeadRow();
            for (int i = 0; i < cols; ++i) {
                headRow.getCell(i).setValue((Object)rs.getMetaData().getColumnName(i + 1));
            }
            String[] colFields = new String[cols];
            for (int i = 0; i < colFields.length; ++i) {
                colFields[i] = rs.getMetaData().getColumnName(i + 1);
            }
            table.putBindContents("member", colFields);
            table.checkParsed();
        }
        if (onlyAddHead) {
            return 0;
        }
        while (rs.next()) {
            table.addRow();
            for (int col = 0; col < cols; ++col) {
                Object value = rs.getObject(col + 1);
                table.getCell(row, col).setValue(value);
            }
            ++row;
            ++bindRow;
        }
        return bindRow;
    }

    public static void bindGroupTree(KDTree tree, GroupNode root, int levels) {
        if (levels == -1) {
            levels = Integer.MAX_VALUE;
        }
        Stack<DefaultKingdeeTreeNode> nodes = new Stack<DefaultKingdeeTreeNode>();
        DefaultKingdeeTreeNode rootNode = new DefaultKingdeeTreeNode();
        rootNode.setUserObject((Object)root);
        rootNode.setText("ALL");
        nodes.push(rootNode);
        tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)rootNode));
        while (!nodes.isEmpty()) {
            ArrayList children;
            DefaultKingdeeTreeNode n = (DefaultKingdeeTreeNode)nodes.pop();
            GroupNode gn = (GroupNode)n.getUserObject();
            if (gn.getLevel() >= levels || (children = gn.getSubGroups()) == null) continue;
            for (int i = 0; i < children.size(); ++i) {
                GroupNode subGroup = (GroupNode)children.get(i);
                DefaultKingdeeTreeNode n2 = new DefaultKingdeeTreeNode();
                n2.setUserObject((Object)subGroup);
                n2.setText(subGroup.getData() == null ? "<NULL>" : subGroup.getData().toString());
                nodes.push(n2);
                n.add((MutableTreeNode)n2);
            }
        }
        tree.expandAllNodes(true, (TreeNode)rootNode);
    }

    public static void fillKDTableGrouping(KDTable kdt, int startRow, ResultSet rs) throws SQLException {
        if (GroupTotalResultSetUtil.isTotal((ResultSet)rs)) {
            while (rs.next()) {
                ++startRow;
                int lvl = GroupTotalResultSetUtil.getCurrentTotalLevel((ResultSet)rs);
                if (lvl < 0) continue;
                kdt.getRow(startRow).getStyleAttributes().setBackground(clrs[lvl]);
            }
        }
    }

    public static StringBuffer makeString(RequestRowSetEvent e) {
        StringBuffer sb = new StringBuffer();
        sb.append(":| KDTable-RequestRowSetEvent: start=");
        sb.append(e.getParam1());
        sb.append(", end=");
        sb.append(e.getParam2());
        sb.append("\r\n  ds=");
        sb.append(e.getDataSourceID());
        sb.append("\r\n  fields={");
        String[] flds = e.getFields();
        for (int i = 0; i < flds.length; ++i) {
            sb.append(flds[i]);
            sb.append(",");
        }
        sb.append("}");
        return sb;
    }
}

