/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.data;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.data.modal.io.Def2Xml;
import com.kingdee.bos.ctrl.data.modal.query.Column;
import com.kingdee.bos.ctrl.data.modal.query.Condition;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.data.modal.query.IQueryObjList;
import com.kingdee.bos.ctrl.data.modal.query.io.Query2Xml;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.OutputXmlTool;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

public class QueryXmlTool {
    public static Element toXml(IQuery obj) {
        Element e = new Element("Query");
        if (obj != null) {
            Def2Xml.makeDefObj((IDefObj)obj, (Element)e);
            e.setAttribute("version", "1.0");
            if (obj.getQueryType() != null) {
                e.setAttribute("type", obj.getQueryType().getName());
            }
            if (obj.isDistinct()) {
                e.setAttribute("distinct", Boolean.toString(obj.isDistinct()));
            }
            e.addContent(QueryXmlTool.makeColumns((IQueryObjList)obj.getColumns()));
            e.addContent(Query2Xml.makeTables((IQueryObjList)obj.getTables()));
            e.addContent(Query2Xml.makeJoins((IQueryObjList)obj.getJoins()));
            e.addContent(Query2Xml.makeOrders((IQueryObjList)obj.getOrders()));
            e.addContent(Query2Xml.makeFilter((Condition)obj.getFilter()));
            e.addContent(Query2Xml.makeContent((String)obj.getContent()));
        }
        return e;
    }

    public static Element makeColumns(IQueryObjList cols) {
        Element xmlCols = new Element("Columns");
        if (cols != null) {
            int len = cols.size();
            for (int i = 0; i < len; ++i) {
                xmlCols.addContent(QueryXmlTool.makeColumn((Column)cols.get(i)));
            }
        }
        return xmlCols;
    }

    public static Element makeColumn(Column col) {
        Element xmlCol = new Element("Column");
        if (col != null) {
            String s;
            OutputXmlTool.makeDefObj((IDefObj)col, xmlCol);
            if (col.getDataType() != null) {
                xmlCol.setAttribute("dataType", col.getDataType().getName());
            }
            if (!StringUtil.isEmptyString((String)(s = col.getExpr()))) {
                xmlCol.setAttribute("expr", s);
            }
        }
        return xmlCol;
    }

    public static ArrayList parseColumns(Element xmlCols) {
        ArrayList<Column> cols = new ArrayList<Column>();
        List lst = xmlCols.getChildren("Column");
        int len = lst.size();
        for (int i = 0; i < len; ++i) {
            cols.add(QueryXmlTool.parseColumn((Element)lst.get(i)));
        }
        return cols;
    }

    public static Column parseColumn(Element xmlCol) {
        Column col = new Column();
        OutputXmlTool.parseDefObj((IDefObj)col, xmlCol);
        col.setDataType(DataType.fromName((String)xmlCol.getAttributeValue("dataType")));
        col.setExpr(xmlCol.getAttributeValue("expr"));
        return col;
    }
}

