/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.model;

import com.kingdee.bos.ctrl.common.code.AOutputStream;
import com.kingdee.bos.ctrl.common.util.ExceptionUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.KSQLReportBO;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.CustKSQLReportFactory;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.CustKSQLReportInfo;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.CustTreeInfo;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.ICustKSQLReport;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.ExtContextUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;

public class CtrlDesignOutputStream
extends AOutputStream {
    String fid;
    String systemID;
    HashMap mapName;
    boolean isSQL;
    boolean isSuccess;
    String flastupdatetime;
    int customType = 1;
    boolean isSys;

    public CtrlDesignOutputStream(HashMap mapName, String fid, String systemID, boolean isSQL, int customType, boolean isSys) {
        this.mapName = mapName;
        this.fid = fid;
        this.systemID = systemID;
        this.isSQL = isSQL;
        this.customType = customType;
        this.isSys = isSys;
        this.setProvider(new ByteArrayOutputStream());
    }

    public CtrlDesignOutputStream(HashMap mapName, String fid, String systemID, boolean isSQL, int customType, String flastupdatetime, boolean isSys) {
        this.mapName = mapName;
        this.fid = fid;
        this.systemID = systemID;
        this.isSQL = isSQL;
        this.customType = customType;
        this.flastupdatetime = flastupdatetime;
        this.isSys = isSys;
        this.setProvider(new ByteArrayOutputStream());
    }

    public void flush() throws IOException {
        super.flush();
        ByteArrayOutputStream baos = (ByteArrayOutputStream)this.getProvider();
        try {
            byte[] data = baos.toByteArray();
            if (this.isSys) {
                this.fid = KSQLReportBO.saveKSQL(null, data, this.fid, this.mapName, this.systemID, this.isSQL, this.customType, this.flastupdatetime);
            } else {
                ICustKSQLReport report = CustKSQLReportFactory.getRemoteInstance();
                CustKSQLReportInfo info = null;
                if (StringUtils.isEmpty((String)this.fid)) {
                    info = new CustKSQLReportInfo();
                    CustTreeInfo tree = new CustTreeInfo();
                    String treeID = "";
                    if (this.mapName.containsKey("treeID")) {
                        treeID = (String)this.mapName.get("treeID");
                    }
                    tree.setId(BOSUuid.read((String)treeID));
                    info.setTreeNode(tree);
                    info.setOrgUnit((FullOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit());
                    info.setContent(data);
                    info.setLength(data.length);
                    info.setIsDynamicSQL(this.isSQL);
                    info.setCustomType(this.customType);
                    LanguageCollection lc = ExtContextUtils.getMetaDataLoader().getSolution().getLanguages();
                    int z = lc.size();
                    for (int i = 0; i < z; ++i) {
                        LanguageInfo li = lc.get(i);
                        String alias = (String)this.mapName.get(li.getLocale().toString());
                        info.setName(alias, li.getLocale());
                    }
                    this.fid = report.addnew((CoreBaseInfo)info).toString();
                } else {
                    info = report.getCustKSQLReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.fid)));
                    info.setContent(data);
                    info.setLength(data.length);
                    info.setIsDynamicSQL(this.isSQL);
                    info.setCustomType(this.customType);
                    report.update((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.fid)), (CoreBaseInfo)info);
                }
            }
            this.isSuccess = true;
        }
        catch (Exception ex) {
            this.isSuccess = false;
            throw new IOException(ExceptionUtil.makeMessageStack((Throwable)ex));
        }
        finally {
            baos.reset();
        }
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public String getFid() {
        return this.fid;
    }

    public boolean isSys() {
        return this.isSys;
    }
}

