/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.model;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.ui.joineditor.ModelField;
import com.kingdee.bos.ctrl.common.ui.joineditor.ModelTable;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.data.modal.query.ITable;
import com.kingdee.bos.ctrl.data.modal.query.ITableList;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.DesignBmd2Meta;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.exception.NoFoundQueryException;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignFinal;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.ExtContextUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

public class KsqlObjectSelector
implements Serializable {
    private HashMap mapTable2MetaClass = new HashMap();

    public HashMap getMapTable2MetaClass() {
        return this.mapTable2MetaClass;
    }

    public MetaClass createMetaClass(BOSObjectType bosType, String fullName) throws NoFoundQueryException {
        MetaClass mc = null;
        IObjectValue bosObj = CtrlDesignUtil.getBosObj(bosType, fullName);
        if (bosObj instanceof QueryInfo) {
            Iterator it;
            ArrayList<MetaField> lstMetaFields = new ArrayList<MetaField>();
            QueryInfo queryInfo = (QueryInfo)bosObj;
            try {
                it = queryInfo.getSelector().getFields().iterator();
            }
            catch (Exception e) {
                throw new NoFoundQueryException(queryInfo.getFullName());
            }
            while (it.hasNext()) {
                QueryFieldInfo qfi = (QueryFieldInfo)it.next();
                MetaField mf = DesignBmd2Meta.parseQueryField(qfi);
                lstMetaFields.add(mf);
            }
            lstMetaFields.trimToSize();
            mc = new MetaClass();
            mc.setName(queryInfo.getName());
            mc.setExpr(queryInfo.getFullName());
            mc.setType(null);
            mc.setFields(lstMetaFields);
            LanguageCollection lc = ExtContextUtils.getMetaDataLoader().getSolution().getLanguages();
            int size = lc.size();
            for (int i = 0; i < size; ++i) {
                LanguageInfo li = lc.get(i);
                Locale locale = li.getLocale();
                String name = queryInfo.getAlias(locale);
                if (StringUtil.isEmptyString((String)name)) {
                    name = queryInfo.getName();
                }
                String localString = li.getLocaleString();
                mc.setProperty("alias." + localString, (Object)name);
            }
            mc.setProperty("alias", (Object)"#1");
        } else if (bosObj instanceof DataTableInfo) {
            Iterator it;
            ArrayList<MetaField> lstMetaFields = new ArrayList<MetaField>();
            DataTableInfo dti = (DataTableInfo)bosObj;
            try {
                it = dti.getColumns().iterator();
            }
            catch (Exception e) {
                throw new NoFoundQueryException(dti.getName());
            }
            while (it.hasNext()) {
                ColumnInfo ci = (ColumnInfo)it.next();
                MetaField mf = DesignBmd2Meta.parseColumn(ci);
                if (mf == null) continue;
                lstMetaFields.add(mf);
            }
            lstMetaFields.trimToSize();
            mc = new MetaClass();
            mc.setName(dti.getName());
            mc.setExpr(dti.getFullName());
            mc.setType(null);
            mc.setFields(lstMetaFields);
            LanguageCollection lc = ExtContextUtils.getMetaDataLoader().getSolution().getLanguages();
            int size = lc.size();
            for (int i = 0; i < size; ++i) {
                LanguageInfo li = lc.get(i);
                Locale locale = li.getLocale();
                String name = dti.getAlias(locale);
                if (StringUtil.isEmptyString((String)name)) {
                    name = dti.getName();
                }
                String localString = li.getLocaleString();
                mc.setProperty("alias." + localString, (Object)name);
            }
            mc.setProperty("alias", (Object)"#1");
        } else if (bosObj instanceof EntityObjectInfo) {
            // empty if block
        }
        return mc;
    }

    public void cacheTable2MetaClass(IQuery query) throws NoFoundQueryException {
        ITableList queryTables = query.getTables();
        for (int i = 0; i < queryTables.size(); ++i) {
            ITable table = (ITable)queryTables.get(i);
            String category = CtrlDesignUtil.getDesignTableType(table.getExpr());
            String fullName = CtrlDesignUtil.getDesignTableExp(table.getExpr());
            BOSObjectType bosType = CtrlDesignFinal.getMetaDataType(category);
            MetaClass mc = this.createMetaClass(bosType, fullName);
            this.cacheTable2MetaClass(table.getName(), mc);
        }
    }

    public void cacheTable2MetaClass(String key, MetaClass mc) {
        this.mapTable2MetaClass.put(key, mc);
    }

    public void changeCacheTable2MetaClass(String oldkey, String newkey) {
        if (this.mapTable2MetaClass.containsKey(oldkey)) {
            MetaClass mc = (MetaClass)this.mapTable2MetaClass.get(oldkey);
            this.mapTable2MetaClass.remove(oldkey);
            this.cacheTable2MetaClass(newkey, mc);
        }
    }

    public MetaClass getMetaClassFromCache(String key) {
        if (this.mapTable2MetaClass.containsKey(key)) {
            return (MetaClass)this.mapTable2MetaClass.get(key);
        }
        return null;
    }

    public boolean buildModelTable(ITable queryTable, ModelTable joinTable) {
        MetaClass mc = this.getMetaClassFromCache(queryTable.getName());
        if (mc == null) {
            return false;
        }
        ArrayList<ModelField> listTemp = new ArrayList<ModelField>();
        for (MetaField mf : mc.getFields()) {
            ModelField joinField = new ModelField();
            joinField.setId(mf.getName());
            joinField.setAlias(mf.getAlias());
            if (mf.getType() == null) {
                joinField.setType(DataType.STRING);
            } else {
                joinField.setType(mf.getType());
            }
            listTemp.add(joinField);
        }
        joinTable.setFields(listTemp);
        joinTable.setId(queryTable.getName());
        joinTable.setAlias(queryTable.getAlias());
        return true;
    }
}

