/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.data.modal.query.QueryType;
import com.kingdee.bos.ctrl.data.modal.query.design.DesignedFilter;
import com.kingdee.bos.ctrl.data.modal.query.design.DesignedFilterList;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.Format;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.KSQLReportBO;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.ExtBizData;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.ExtStringUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.MessageUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.DesignDataType;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignCommonQuery;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignCondition;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.DateUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.SqlDSModelDrill;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.SqlParamParser;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.param.DefaultArgInput;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.app.ContextUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.sql.DATE;
import oracle.sql.TIMESTAMP;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class RunReportParam {
    private static final Logger logger = Logger.getLogger(RunReportParam.class);
    public static final String Slash = "\\";
    public static final String PARAM_SIGN = "@";
    public static final String splitArt = "@@";
    public static final String splitSlash = "\\\\";
    public static final String DataSetType = "DataSetType";
    public static final String DbSourceName = "DbSourceName";
    public static final String OrgID = "OrgID";
    public static final String OrgName = "OrgName";
    public static final String SystemID = "SystemID";
    public static final String DbSourceID = "DbSourceID";
    public static final String InnerLink = "InnerLink";
    public static final String InnerFlag = "InnerLink";
    public static final String entityfieldname = "entityfieldname";
    public static final String enetitytype = "enetitytype";

    public static final HashMap setExecuteParam(ArrayList reportDBModel, String parameterXmlString) throws JDOMException, IOException {
        HashMap mapDesignParameter = RunReportParam.ChangWhereValueToMapParams(parameterXmlString);
        return mapDesignParameter;
    }

    public static final HashMap ChangWhereValueToMapParams(String whereValue) throws JDOMException, IOException {
        HashMap<String, DesignParameter> param = new HashMap<String, DesignParameter>();
        if (null != whereValue && whereValue.length() > 0) {
            StringReader in = new StringReader(whereValue);
            SAXBuilder sb = new SAXBuilder();
            Document doc = sb.build((Reader)in);
            RunReportParam.closeReader(in);
            Element root = doc.getRootElement();
            boolean lowVersion = false;
            String version = CtrlReportUtil.getObjectString(root.getAttributeValue(CtrlDesignUtil.VERSION));
            if (version.length() <= 0) {
                lowVersion = true;
            }
            List lst = root.getChildren();
            for (Element et : lst) {
                String name = CtrlReportUtil.getObjectString(et.getAttributeValue("name"));
                String value = CtrlReportUtil.getObjectString(et.getAttributeValue("value"));
                String valueAlias = CtrlReportUtil.getObjectString(et.getAttributeValue("valueAlias"));
                String dataType = CtrlReportUtil.getObjectString(et.getAttributeValue("dataType"));
                if (lowVersion) {
                    if (!value.equals("") && value.indexOf(";") != -1) {
                        value = ExtStringUtil.replace(value, ";", "0xx1xx");
                    }
                    if (!valueAlias.equals("") && valueAlias.indexOf(";") != -1) {
                        valueAlias = ExtStringUtil.replace(valueAlias, ";", "0xx1xx");
                    }
                }
                DesignParameter dp = new DesignParameter();
                dp.setName(name);
                dp.setCurentValue(value);
                dp.setCurentValueAlias(valueAlias);
                dp.setDesignDataType(DesignDataType.getDataType(Integer.parseInt(dataType)));
                param.put(name, dp);
            }
        }
        return param;
    }

    public static final void putServerDefalutListParamsMap(Context ctx, HashMap mapDesignParam) {
        String systemTimeMillis = "-1";
        if (null != ContextUtil.getCurrentAdminUnit((Context)ctx)) {
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentAdminUnitID", ContextUtil.getCurrentAdminUnit((Context)ctx).getId());
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentAdminUnitName", ContextUtil.getCurrentAdminUnit((Context)ctx).getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentAdminUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentAdminUnitName", systemTimeMillis);
        }
        if (null != ContextUtil.getCurrentCostUnit((Context)ctx)) {
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentCostUnitID", ContextUtil.getCurrentCostUnit((Context)ctx).getId());
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentCostUnitName", ContextUtil.getCurrentCostUnit((Context)ctx).getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentCostUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentCostUnitName", systemTimeMillis);
        }
        if (null != ContextUtil.getCurrentCtrlUnit((Context)ctx)) {
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentCtrlUnitID", ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentCtrlUnitName", ContextUtil.getCurrentCtrlUnit((Context)ctx).getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentCtrlUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentCtrlUnitName", systemTimeMillis);
        }
        if (null != ContextUtil.getCurrentFIUnit((Context)ctx)) {
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentFIUnitID", ContextUtil.getCurrentFIUnit((Context)ctx).getId());
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentFIUnitName", ContextUtil.getCurrentFIUnit((Context)ctx).getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentFIUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentFIUnitName", systemTimeMillis);
        }
        if (null != ContextUtil.getCurrentOrgUnit((Context)ctx)) {
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentOrgUnitID", ContextUtil.getCurrentOrgUnit((Context)ctx).getId());
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentOrgUnitName", ContextUtil.getCurrentOrgUnit((Context)ctx).getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentOrgUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentOrgUnitName", systemTimeMillis);
        }
        if (null != ContextUtil.getCurrentProfitUnit((Context)ctx)) {
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentProfitUnitID", ContextUtil.getCurrentProfitUnit((Context)ctx).getId());
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentProfitUnitName", ContextUtil.getCurrentProfitUnit((Context)ctx).getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentProfitUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentProfitUnitName", systemTimeMillis);
        }
        if (null != ContextUtil.getCurrentPurchaseUnit((Context)ctx)) {
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentPurchaseUnitID", ContextUtil.getCurrentPurchaseUnit((Context)ctx).getId());
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentPurchaseUnitName", ContextUtil.getCurrentPurchaseUnit((Context)ctx).getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentPurchaseUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentPurchaseUnitName", systemTimeMillis);
        }
        if (null != ContextUtil.getCurrentSaleUnit((Context)ctx)) {
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentSaleUnitID", ContextUtil.getCurrentSaleUnit((Context)ctx).getId());
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentSaleUnitName", ContextUtil.getCurrentSaleUnit((Context)ctx).getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentSaleUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentSaleUnitName", systemTimeMillis);
        }
        if (null != ContextUtil.getCurrentStorageUnit((Context)ctx)) {
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentStorageUnitID", ContextUtil.getCurrentStorageUnit((Context)ctx).getId());
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentStorageUnitName", ContextUtil.getCurrentStorageUnit((Context)ctx).getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentStorageUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentStorageUnitName", systemTimeMillis);
        }
        if (null != ContextUtil.getCurrentUserInfo((Context)ctx)) {
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentUserInfoID", ContextUtil.getCurrentUserInfo((Context)ctx).getId());
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentUserInfoName", ContextUtil.getCurrentUserInfo((Context)ctx).getName());
            if (null != ContextUtil.getCurrentUserInfo((Context)ctx).getPerson()) {
                RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentUserPersonID", ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId());
                RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentUserPersonName", ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getName());
            } else {
                RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentUserPersonID", systemTimeMillis);
                RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentUserPersonName", systemTimeMillis);
            }
        } else {
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentUserInfoID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentUserInfoName", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentUserPersonID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentUserPersonName", systemTimeMillis);
        }
        if (null != ContextUtil.getCurrentHRUnit((Context)ctx)) {
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentHRUnitID", ContextUtil.getCurrentHRUnit((Context)ctx).getId());
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentHRUnitName", ContextUtil.getCurrentHRUnit((Context)ctx).getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentHRUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentHRUnitName", systemTimeMillis);
        }
        if (null != ContextUtil.getCurrentTransportUnit((Context)ctx)) {
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentTransportUnitID", ContextUtil.getCurrentTransportUnit((Context)ctx).getId());
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentTransportUnitName", ContextUtil.getCurrentTransportUnit((Context)ctx).getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentTransportUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParam, "ExtRptCurrentTransportUnitName", systemTimeMillis);
        }
    }

    public static final void putParamsMap(HashMap mapDesignParam, String paramName, Object objValue) {
        String value = CtrlReportUtil.getObjectString(objValue);
        DesignParameter dp = new DesignParameter();
        dp.setName(paramName);
        dp.setCurentValue(value);
        dp.setDesignDataType(DesignDataType.getDataType(0));
        mapDesignParam.put(paramName, dp);
    }

    public static void closeReader(Reader reader) {
        try {
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final HashMap setMultParams(ArrayList queryList, HashMap tempParams, HashMap paramTypeMap) {
        return tempParams;
    }

    protected static void reWriteFilterCondition(ArrayList queryList, HashMap mapParam, HashMap paramTypeMap, String paramName, Object[] paramValues) {
        if (null != queryList) {
            for (IQuery query : queryList) {
                RunReportParam.reWriteFilterCondition(query, mapParam, paramTypeMap, paramName, paramValues);
            }
        }
    }

    public static final void reWriteFilterCondition(IQuery query, HashMap mapParam, HashMap paramTypeMap, String paramName, Object[] paramValues) {
        boolean isFind = false;
        if (QueryType.SQL_CUSTOM.equals(query.getQueryType())) {
            String dContent = SqlParamParser.customSQLReg(query.getContent(), mapParam, paramTypeMap, paramName, paramValues);
            if (null != dContent) {
                ((CtrlDesignKsqlQuery)query).setDynamicContent(dContent);
            }
        } else {
            DesignedFilterList list = (DesignedFilterList)query.getFilter().getExtObj();
            if (list != null) {
                CtrlDesignCondition cdc;
                String whereExpr;
                String oldWhere = null;
                StringBuffer newWhere = new StringBuffer();
                for (int i = 0; i < list.getFilterList().size(); ++i) {
                    String paramValue;
                    String newParamNameTemp;
                    String currentNewParamName;
                    int n;
                    int length;
                    DesignedFilter filter = (DesignedFilter)list.getFilterList().get(i);
                    String value = filter.getValue();
                    if (!RunReportParam.isParamName(value, paramName)) continue;
                    String expr = filter.getExpression();
                    String operator = filter.getOperator();
                    String newParamName = paramName + String.valueOf(CtrlReportUtil.getSystemTime());
                    if (operator.equals("IN")) {
                        oldWhere = expr + "  IN (" + value + ")";
                        newWhere.append(expr).append(" ").append(operator).append(" (");
                        length = paramValues.length;
                        for (n = 0; n < length; ++n) {
                            currentNewParamName = newParamName + "_" + n;
                            newParamNameTemp = ExtStringUtil.replace(value, paramName, currentNewParamName);
                            newWhere.append(newParamNameTemp);
                            if (n < length - 1) {
                                newWhere.append(", ");
                            }
                            paramValue = CtrlReportUtil.getObjectString(paramValues[n]);
                            if (value.equals("")) continue;
                            mapParam.put(currentNewParamName, paramValue);
                            paramTypeMap.put(currentNewParamName, paramTypeMap.get(paramName));
                        }
                        newWhere.append(")");
                        isFind = true;
                        continue;
                    }
                    oldWhere = expr + " " + operator + " " + value;
                    newWhere.append("(");
                    length = paramValues.length;
                    for (n = 0; n < length; ++n) {
                        currentNewParamName = newParamName + "_" + n;
                        newParamNameTemp = ExtStringUtil.replace(value, paramName, currentNewParamName);
                        newWhere.append(expr).append(" ").append(operator).append(" ").append(newParamNameTemp);
                        if (n < length - 1) {
                            newWhere.append(" OR ");
                        }
                        paramValue = CtrlReportUtil.getObjectString(paramValues[n]);
                        if (value.equals("")) continue;
                        mapParam.put(currentNewParamName, paramValue);
                        paramTypeMap.put(currentNewParamName, paramTypeMap.get(paramName));
                    }
                    newWhere.append(")");
                    isFind = true;
                }
                if (isFind && (whereExpr = (cdc = (CtrlDesignCondition)query.getFilter()).getDynamicExpr() != null ? CtrlReportUtil.getObjectString(cdc.getDynamicExpr()) : CtrlReportUtil.getObjectString(cdc.getExpr())).length() > 0) {
                    whereExpr = ExtStringUtil.replace(whereExpr, oldWhere, newWhere.toString());
                    cdc.setDynamicExpr(whereExpr);
                }
            }
        }
    }

    private static final boolean isParamName(String exp, String paramName) {
        if ((exp = exp.trim()).endsWith(PARAM_SIGN + paramName)) {
            return true;
        }
        String reg = "@(" + paramName + ")" + "[,|%|\\(|\\)|\\s|'|\"|@]";
        String name = SqlParamParser.getValueByReg(exp, reg);
        return name.equalsIgnoreCase(paramName);
    }

    public static final String getSystemFullLabel(DefaultKingdeeTreeNode nodeRoot, String systemID) {
        String pathStringLabel = null;
        try {
            Enumeration enume = nodeRoot.children();
            while (enume.hasMoreElements()) {
                DefaultKingdeeTreeNode repNode = (DefaultKingdeeTreeNode)enume.nextElement();
                IBriefViewTreeNode bvNode = (IBriefViewTreeNode)repNode.getUserObject();
                String currentSystemID = bvNode.getFullName();
                if (StringUtil.equals((String)currentSystemID, (String)systemID)) {
                    Object[] pathtoRoot = repNode.getPath();
                    pathStringLabel = RunReportParam.getPathString(pathtoRoot);
                    return pathStringLabel;
                }
                pathStringLabel = RunReportParam.getSystemFullLabel(repNode, systemID);
                if (null == pathStringLabel) continue;
                return pathStringLabel;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return pathStringLabel;
    }

    public static final String getPathString(Object[] obs) {
        StringBuffer sb = new StringBuffer();
        int size = obs.length;
        for (int i = 0; i < size; ++i) {
            sb.append(obs[i].toString());
            if (i >= size - 1) continue;
            sb.append(Slash);
        }
        return sb.toString();
    }

    public static final Variant getVariant(String[] values, int dataType) {
        if (values == null) {
            return Variant.nullVariant;
        }
        String value = "";
        for (int i = 0; i < values.length; ++i) {
            String temp = CtrlReportUtil.getObjectString(values[i]);
            value = value + temp + "0xx1xx";
        }
        if (!value.equals("")) {
            value = value.substring(0, value.length() - "0xx1xx".length());
        }
        return RunReportParam.getVariant(value, dataType);
    }

    public static final Variant getVariant(String value, int dataType) {
        value = CtrlReportUtil.getObjectString(value);
        int mulSelected = value.indexOf("0xx1xx");
        if (value.length() == 0) {
            return Variant.nullVariant;
        }
        if (dataType == 0) {
            if (mulSelected != -1) {
                String[] arr = value.split("0xx1xx");
                int len = arr.length;
                Variant[] vts = new Variant[len];
                for (int n = 0; n < len; ++n) {
                    Variant vt;
                    vts[n] = vt = new Variant((Object)arr[n], 11);
                }
                return new Variant((Object)vts, 512);
            }
            return new Variant((Object)value, 11);
        }
        if (dataType == 1) {
            if (mulSelected != -1) {
                String[] arr = value.split("0xx1xx");
                int len = arr.length;
                Variant[] vts = new Variant[len];
                for (int n = 0; n < len; ++n) {
                    Variant vt = Variant.nullVariant;
                    String temp = arr[n];
                    BigDecimal bd = null;
                    try {
                        bd = new BigDecimal(temp);
                        vt = new Variant((Object)bd, 10);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    vts[n] = vt;
                }
                return new Variant((Object)vts, 512);
            }
            BigDecimal bd = null;
            try {
                bd = new BigDecimal(value);
                return new Variant((Object)bd, 10);
            }
            catch (Exception e) {
                return Variant.nullVariant;
            }
        }
        if (dataType == 2) {
            if (mulSelected != -1) {
                String[] arr = value.split("0xx1xx");
                int len = arr.length;
                Variant[] vts = new Variant[len];
                for (int n = 0; n < len; ++n) {
                    String temp = arr[n];
                    vts[n] = Format.parseData((String)temp, (boolean)true);
                }
                return new Variant((Object)vts, 512);
            }
            return Format.parseData((String)value, (boolean)true);
        }
        if (dataType == 4) {
            if (mulSelected != -1) {
                String[] arr = value.split("0xx1xx");
                int len = arr.length;
                Variant[] vts = new Variant[len];
                for (int n = 0; n < len; ++n) {
                    String temp = arr[n];
                    vts[n] = Format.parseData((String)temp, (boolean)true);
                }
                return new Variant((Object)vts, 512);
            }
            return Format.parseData((String)value, (boolean)true);
        }
        if (dataType == 5) {
            if (mulSelected != -1) {
                String[] arr = value.split("0xx1xx");
                int len = arr.length;
                Variant[] vts = new Variant[len];
                for (int n = 0; n < len; ++n) {
                    String temp = "1900-01-01 " + arr[n];
                    vts[n] = Format.parseData((String)temp, (boolean)true);
                }
                return new Variant((Object)vts, 512);
            }
            value = "1900-01-01 " + value;
            return Format.parseData((String)value, (boolean)true);
        }
        if (dataType == 3) {
            if (mulSelected != -1) {
                String[] arr = value.split("0xx1xx");
                int len = arr.length;
                Variant[] vts = new Variant[len];
                for (int n = 0; n < len; ++n) {
                    Variant vt = Variant.nullVariant;
                    String temp = arr[n];
                    Boolean b = null;
                    try {
                        b = new Boolean(temp);
                        vt = new Variant((Object)b, 8);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    vts[n] = vt;
                }
                return new Variant((Object)vts, 512);
            }
            Boolean b = null;
            try {
                b = new Boolean(value);
                return new Variant((Object)b, 8);
            }
            catch (Exception e) {
                return Variant.nullVariant;
            }
        }
        return new Variant((Object)value, 11);
    }

    public static final Variant getOutputParamVariant(Object value, int dataType) {
        if (dataType == 0) {
            return new Variant(value, 11);
        }
        if (dataType == 1 || dataType == 2) {
            BigDecimal bd = null;
            try {
                bd = new BigDecimal(String.valueOf(value));
                return new Variant((Object)bd, 10);
            }
            catch (Exception e) {
                return Variant.nullVariant;
            }
        }
        if (dataType == 3) {
            java.util.Date date = null;
            try {
                if (value instanceof DATE) {
                    date = new java.util.Date(((DATE)value).timestampValue().getTime());
                } else if (value instanceof Date) {
                    date = new java.util.Date(((Date)value).getTime());
                } else if (value instanceof java.util.Date) {
                    date = (java.util.Date)value;
                } else if (value instanceof String) {
                    date = CtrlReportUtil.sdf_yyyy_MM_dd.parse((String)value);
                }
                String temp = CtrlReportUtil.formatDate(date);
                return Format.parseData((String)temp, (boolean)true);
            }
            catch (Exception e) {
                return Variant.nullVariant;
            }
        }
        if (dataType == 4) {
            java.util.Date date = null;
            try {
                if (value instanceof TIMESTAMP) {
                    try {
                        date = new java.util.Date(((TIMESTAMP)value).timestampValue().getTime());
                    }
                    catch (SQLException e) {}
                } else if (value instanceof Timestamp) {
                    date = new java.util.Date(((Timestamp)value).getTime());
                } else if (value instanceof java.util.Date) {
                    date = (java.util.Date)value;
                } else if (value instanceof String) {
                    date = CtrlReportUtil.sdfDateTime.parse((String)value);
                }
                String temp = CtrlReportUtil.formatDateTime(date);
                return Format.parseData((String)temp, (boolean)true);
            }
            catch (Exception e) {
                return Variant.nullVariant;
            }
        }
        return new Variant(value, 11);
    }

    public static final Object getOracleDateValue(Object value) {
        if (value instanceof TIMESTAMP) {
            TIMESTAMP oracleTS = (TIMESTAMP)value;
            try {
                Timestamp date = new Timestamp(oracleTS.timestampValue().getTime());
                return date;
            }
            catch (SQLException e) {
                return value;
            }
        }
        if (value instanceof DATE) {
            DATE oracleD = (DATE)value;
            Date date = new Date(oracleD.timestampValue().getTime());
            return date;
        }
        return value;
    }

    public static final Map splitDefine2Map(String define) {
        HashMap<String, String> mapDefine = new HashMap<String, String>(5);
        String[] arr = define.split(splitArt);
        if (arr.length == 3) {
            mapDefine.put("InnerLink", arr[1]);
        }
        mapDefine.put(DataSetType, arr[0]);
        define = arr[arr.length - 1];
        arr = define.split(splitSlash);
        mapDefine.put(DbSourceName, arr[0]);
        mapDefine.put(DbSourceID, arr[2]);
        arr = arr[1].split(" ");
        mapDefine.put(OrgID, arr[0]);
        mapDefine.put(OrgName, arr[1]);
        return mapDefine;
    }

    public static final HashMap splitDefineToMap(String define) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] arr = define.split(splitArt);
        if (arr.length == 3) {
            map.put("InnerLink", arr[1]);
        }
        String dataSetType = arr[0];
        String dbsourcename = null;
        String orgID = null;
        String orgName = null;
        String systemid = null;
        String dbsourceid = null;
        if (dataSetType.equals("sql_ksql")) {
            define = arr[arr.length - 1];
            arr = define.split(splitSlash);
            dbsourcename = arr[arr.length - 4];
            String orgIDName = arr[arr.length - 3];
            systemid = arr[arr.length - 2];
            dbsourceid = arr[arr.length - 1];
            int n = orgIDName.indexOf(" ");
            if (n != -1) {
                orgID = orgIDName.substring(0, n);
                orgName = orgIDName.substring(n + 1);
            }
        } else if (dataSetType.equals("sql_enum") || dataSetType.equals("sql_bosquery")) {
            define = arr[arr.length - 1];
            arr = define.split(splitSlash);
            dbsourceid = arr[arr.length - 1];
        }
        map.put(DataSetType, dataSetType);
        map.put(DbSourceName, dbsourcename);
        map.put(OrgID, orgID);
        map.put(OrgName, orgName);
        map.put(SystemID, systemid);
        map.put(DbSourceID, dbsourceid);
        return map;
    }

    private static void showErrMsg(String dbsourcename) throws CtrlReportException {
        String msg = MessageUtil.getMsgInfo("label271");
        String msg0 = MessageUtil.getMsgInfo("label277");
        String msg1 = MessageUtil.getMsgInfo("label272");
        String msg2 = MessageUtil.getMsgInfo("label273");
        String msg3 = MessageUtil.getMsgInfo("label274");
        String msg4 = MessageUtil.getMsgInfo("label275");
        String msg5 = MessageUtil.getMsgInfo("label282");
        String msge = MessageUtil.getMsgInfo("label276");
        StringBuffer sb = new StringBuffer();
        sb.append(msg).append("\uff1a").append(dbsourcename).append("\r\n").append(msg0).append("\r\n");
        sb.append(msg1).append("\r\n").append(msg2).append("\r\n").append(msg3).append("\r\n").append(msg4).append("\r\n").append(msg5).append("\r\n").append(msge);
        throw new CtrlReportException(sb.toString());
    }

    public static final boolean cacheDbSourceModel(Context ctx, ExtDataSet[] datasets, ArrayList allUnionParam, HashMap mapPRelationFN) throws CtrlReportException {
        String paramRelationFullName = "";
        String paramRelationDbSName = "";
        for (int i = 0; i < datasets.length; ++i) {
            CtrlDesignQueryModel model;
            ExtDataSet ds = datasets[i];
            String define = ds.getDefine();
            HashMap mapDefine = RunReportParam.splitDefineToMap(define);
            String innerLink = CtrlReportUtil.getObjectString(mapDefine.get("InnerLink"));
            String dataSetType = CtrlReportUtil.getObjectString(mapDefine.get(DataSetType));
            String dbsourceid = CtrlReportUtil.getObjectString(mapDefine.get(DbSourceID));
            String orgID = CtrlReportUtil.getObjectString(mapDefine.get(OrgID));
            String systemid = CtrlReportUtil.getObjectString(mapDefine.get(SystemID));
            String dbsourcename = CtrlReportUtil.getObjectString(mapDefine.get(DbSourceName));
            String innerLinkXmlString = null;
            if (!dataSetType.equals("sql_ksql")) continue;
            if (innerLink.equals("")) {
                if (orgID.equals("")) {
                    RunReportParam.showErrMsg(dbsourcename);
                    return false;
                }
            } else {
                innerLinkXmlString = SqlDSModelDrill.split2(ds.getMeta());
            }
            if ((model = KSQLReportBO.initModel(ctx, systemid, dbsourcename, orgID, dbsourceid, innerLinkXmlString, true)) == null) {
                RunReportParam.showErrMsg(dbsourcename);
                return false;
            }
            String curParamRelationFullName = CtrlReportUtil.getObjectString(model.getCommonQuery().getProperty(CtrlDesignUtil.ParamRelationFullName));
            if (!curParamRelationFullName.equals("")) {
                if (paramRelationFullName.equals("")) {
                    paramRelationFullName = curParamRelationFullName;
                    paramRelationDbSName = dbsourcename;
                } else if (paramRelationFullName.equals(curParamRelationFullName)) {
                    String msg = "\u6570\u636e\u6e90\u53c2\u6570\u63d2\u4ef6\u7c7b\u6709\u51b2\u7a81\r\n\u6570\u636e\u6e90\u540d\u79f0\uff1a " + paramRelationDbSName + "\r\n\u63d2\u4ef6\u7c7b \uff1a" + paramRelationFullName + "\r\n";
                    msg = msg + " \u51b2\u7a81\u540d\u79f0\uff1a " + dbsourcename + "\r\n\u63d2\u4ef6\u7c7b \uff1a" + curParamRelationFullName + "\r\n\u8bf7\u91cd\u65b0\u8bbe\u8ba1\u6570\u636e\u6e90";
                    throw new CtrlReportException(msg);
                }
            }
            RunReportParam.unionKsqlParam(allUnionParam, model);
        }
        if (null != mapPRelationFN) {
            mapPRelationFN.put(CtrlDesignUtil.ParamRelationFullName, paramRelationFullName);
        }
        return true;
    }

    public static final boolean cacheDbSourceModel(Context ctx, ExtDataSet[] datasets, ArrayList reportDBModel, ArrayList allUnionParam, HashMap mapPRelationFN, String sourceReportOrgID, String userLogginOrgID) throws CtrlReportException, Exception {
        String paramRelationFullName = "";
        String paramRelationDbSName = "";
        for (int i = 0; i < datasets.length; ++i) {
            CtrlDesignQueryModel model;
            ExtDataSet ds = datasets[i];
            String define = ds.getDefine();
            Map mapDefine = new HashMap(1);
            mapDefine = define.indexOf("rZns4x88ShmCrA4shCy6yENOfX0=\u3010\u6c47\u603b\u4e0a\u62a5\u4e13\u7528\u3011") != -1 ? RunReportParam.splitDefine2Map(define) : RunReportParam.splitDefineToMap(define);
            String innerLink = CtrlReportUtil.getObjectString(mapDefine.get("InnerLink"));
            String dataSetType = CtrlReportUtil.getObjectString(mapDefine.get(DataSetType));
            String dbsourceid = CtrlReportUtil.getObjectString(mapDefine.get(DbSourceID));
            String orgID = CtrlReportUtil.getObjectString(mapDefine.get(OrgID));
            String systemid = CtrlReportUtil.getObjectString(mapDefine.get(SystemID));
            String dbsourcename = CtrlReportUtil.getObjectString(mapDefine.get(DbSourceName));
            String innerLinkXmlString = null;
            if (!dataSetType.equals("sql_ksql")) continue;
            if (!orgID.equals("")) {
                if (sourceReportOrgID.equals("") && innerLink.equals("")) {
                    throw new CtrlReportException("\u627e\u4e0d\u5230\u6e90\u62a5\u8868\u6240\u5c5e\u7ec4\u7ec7");
                }
                orgID = sourceReportOrgID;
            }
            if (innerLink.equals("")) {
                if (orgID.equals("")) {
                    RunReportParam.showErrMsg(dbsourcename);
                    return false;
                }
            } else {
                innerLinkXmlString = SqlDSModelDrill.split2(ds.getMeta());
            }
            if ((model = KSQLReportBO.initModel(ctx, systemid, dbsourcename, orgID, dbsourceid, innerLinkXmlString, true)) == null) {
                RunReportParam.showErrMsg(dbsourcename);
                return false;
            }
            String curParamRelationFullName = CtrlReportUtil.getObjectString(model.getCommonQuery().getProperty(CtrlDesignUtil.ParamRelationFullName));
            if (!curParamRelationFullName.equals("")) {
                if (paramRelationFullName.equals("")) {
                    paramRelationFullName = curParamRelationFullName;
                    paramRelationDbSName = dbsourcename;
                } else if (paramRelationFullName.equals(curParamRelationFullName)) {
                    String msg = "\u6570\u636e\u6e90\u53c2\u6570\u63d2\u4ef6\u7c7b\u6709\u51b2\u7a81\r\n\u6570\u636e\u6e90\u540d\u79f0\uff1a " + paramRelationDbSName + "\r\n\u63d2\u4ef6\u7c7b \uff1a" + paramRelationFullName + "\r\n";
                    msg = msg + " \u51b2\u7a81\u540d\u79f0\uff1a " + dbsourcename + "\r\n\u63d2\u4ef6\u7c7b \uff1a" + curParamRelationFullName + "\r\n\u8bf7\u91cd\u65b0\u8bbe\u8ba1\u6570\u636e\u6e90";
                    throw new CtrlReportException(msg);
                }
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("type", "sql_ksql");
            map.put("dbsourceid", dbsourceid);
            map.put("model", model);
            RunReportParam.unionKsqlParam(allUnionParam, model);
            reportDBModel.add(map);
        }
        if (null != mapPRelationFN) {
            mapPRelationFN.put(CtrlDesignUtil.ParamRelationFullName, paramRelationFullName);
        }
        return true;
    }

    private static void unionKsqlParam(ArrayList allUnionParam, CtrlDesignQueryModel model) {
        List currentList = model.getCommonQuery().getParameters();
        if (null != currentList) {
            for (DesignParameter pCurrent : currentList) {
                String currentParamName = pCurrent.getName();
                if (null == currentParamName) continue;
                boolean isFind = false;
                for (DesignParameter pAll : allUnionParam) {
                    String paramName = pAll.getName();
                    if (!currentParamName.equalsIgnoreCase(paramName)) continue;
                    isFind = true;
                    break;
                }
                if (isFind) continue;
                allUnionParam.add(pCurrent);
            }
        }
    }

    public static final HashMap getParamDefalutValue(Context ctx, CtrlDesignQueryModel model) {
        HashMap<String, DesignParameter> mapDesignParam = new HashMap<String, DesignParameter>();
        List currentList = model.getCommonQuery().getParameters();
        if (null != currentList) {
            for (DesignParameter pCurrent : currentList) {
                String currentParamName = pCurrent.getName();
                if (null == currentParamName) continue;
                DesignParameter p = new DesignParameter();
                DesignDataType ddt = pCurrent.getDesignDataType();
                String defaultValue = CtrlReportUtil.getObjectString(pCurrent.getDefaultValue());
                if (ddt.equals(DesignDataType.DATE) || ddt.equals(DesignDataType.DATETIME)) {
                    defaultValue = RunReportParam.getDateValue(ctx, ddt, defaultValue);
                } else if (ddt.equals(DesignDataType.TIME)) {
                    defaultValue = RunReportParam.getTimeValue(defaultValue);
                }
                p.setName(currentParamName);
                p.setCurentValue(defaultValue);
                p.setDesignDataType(pCurrent.getDesignDataType());
                mapDesignParam.put(currentParamName, p);
            }
            if (ctx != null) {
                RunReportParam.putServerDefalutListParamsMap(ctx, mapDesignParam);
            } else {
                DefaultArgInput.putClientDefalutListParamsMap(mapDesignParam);
            }
        }
        return mapDesignParam;
    }

    public static final String getRealFieldName(DefObj def) {
        String fieldName = def.getName();
        String fieldNameReal = CtrlReportUtil.getObjectString(def.getProperty(entityfieldname));
        if (!fieldNameReal.equals("")) {
            fieldName = fieldNameReal.startsWith("f") ? fieldNameReal.substring(1) : fieldNameReal;
        }
        return fieldName;
    }

    public static final String getSQLVersion(CtrlDesignQueryModel model) {
        CtrlDesignCommonQuery commonQuery = model.getCommonQuery();
        String version = "";
        Map map = commonQuery.getProperties();
        if (null != map) {
            version = CtrlReportUtil.getObjectString(map.get(CtrlDesignUtil.VERSION));
        }
        return version;
    }

    public static final void setSQLVersion(CtrlDesignQueryModel model) {
        CtrlDesignCommonQuery commonQuery = model.getCommonQuery();
        Map map = commonQuery.getProperties();
        map.put(CtrlDesignUtil.VERSION, "2");
    }

    public static final void upgradeParam(CtrlDesignQueryModel model) {
        CtrlDesignCommonQuery commonQuery = model.getCommonQuery();
        Map map = commonQuery.getProperties();
        String version = CtrlReportUtil.getObjectString(map.get(CtrlDesignUtil.VERSION));
        if (version.equals("") || version.equals("-1")) {
            List currentList = model.getCommonQuery().getParameters();
            if (null != currentList) {
                for (DesignParameter p : currentList) {
                    String defalutAlias;
                    String defalutValue = CtrlReportUtil.getObjectString(p.getDefaultValue());
                    if (!defalutValue.equals("") && defalutValue.indexOf(";") != -1) {
                        defalutValue = ExtStringUtil.replace(defalutValue, ";", "0xx1xx");
                        p.setDefaultValue(defalutValue);
                    }
                    if ((defalutAlias = CtrlReportUtil.getObjectString(p.getDefaultAlias())).equals("") || defalutAlias.indexOf(";") == -1) continue;
                    defalutAlias = ExtStringUtil.replace(defalutAlias, ";", "0xx1xx");
                    p.setDefaultAlias(defalutAlias);
                }
            }
            RunReportParam.setSQLVersion(model);
        }
    }

    public static java.util.Date getServerDate(Context ctx) {
        java.util.Date date = null;
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getInfoFromServer");
        try {
            RptParams ps_r = FacadeFactory.commonExecute(ctx, pr);
            date = (java.util.Date)ps_r.getObject("Date");
        }
        catch (BOSException e) {
            date = null;
        }
        return date;
    }

    public static final ArrayList getBizDataList(Context ctx, boolean ds, String dbsourceid, String orgID, String orgName) throws Exception {
        return RunReportParam.getBizDataList(ctx, ds, dbsourceid, orgID, orgName, null);
    }

    public static final ArrayList getBizDataList(Context ctx, boolean isKSQL, String dbsourceid, String orgID, String orgName, Map models) throws Exception {
        ArrayList reportDBModel = new ArrayList();
        HashMap mapDesignParam = new HashMap();
        String systemID = "";
        String dbSourceName = "";
        if (isKSQL) {
            String dataMeta;
            String[] arr = dbsourceid.split(splitSlash);
            if (arr.length > 1) {
                dbsourceid = arr[0];
                systemID = arr[1];
                dbSourceName = arr[2];
            }
            CtrlDesignQueryModel model = null;
            if (models != null && !StringUtil.isEmptyString((String)(dataMeta = (String)models.get(SqlDSModelDrill.getKey(dbSourceName, systemID))))) {
                model = KSQLReportBO.initModel(ctx, null, null, null, null, dataMeta, true);
            }
            if (model == null) {
                model = KSQLReportBO.initModel(ctx, systemID, dbSourceName, orgID, dbsourceid, null, true);
            }
            if (model == null) {
                String msg = MessageUtil.getMsgInfo("label280");
                String msg0 = MessageUtil.getMsgInfo("label277");
                String msg1 = MessageUtil.getMsgInfo("label272");
                String msg2 = MessageUtil.getMsgInfo("label273");
                String msg3 = MessageUtil.getMsgInfo("label281");
                String msg4 = MessageUtil.getMsgInfo("label275");
                String msg5 = MessageUtil.getMsgInfo("label282");
                String msge = MessageUtil.getMsgInfo("label279");
                StringBuffer sb = new StringBuffer();
                sb.append(msg).append("\uff1a").append(dbSourceName).append("\r\n").append(msg0).append("\r\n");
                sb.append(msg1).append("\r\n").append(msg2).append("\r\n").append(msg3).append("\r\n").append(msg4).append("\r\n").append(msg5).append("\r\n").append(msge);
                throw new Exception(sb.toString());
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("type", "sql_ksql");
            map.put("dbsourceid", dbsourceid);
            map.put("model", model);
            reportDBModel.add(map);
            mapDesignParam = RunReportParam.getParamDefalutValue(ctx, model);
        }
        StringBuffer define = new StringBuffer();
        define.append(isKSQL ? "sql_ksql" : "sql_enum");
        define.append(splitArt);
        define.append(Slash);
        define.append(dbSourceName);
        define.append(Slash);
        define.append(orgID).append(" ");
        define.append(orgName);
        define.append(Slash);
        define.append(systemID);
        define.append(Slash);
        define.append(dbsourceid);
        ArrayList lst = new ArrayList();
        ExtBizData ebd = new ExtBizData();
        ebd.setRefresh(true);
        ebd.setBICtx(ctx);
        ebd.setReportDBModel(reportDBModel);
        if (ctx != null) {
            RunReportParam.putServerDefalutListParamsMap(ctx, mapDesignParam);
        }
        ebd.setParams(mapDesignParam);
        ebd.execute(define.toString(), 0, -1);
        ResultSet rs = ebd.getRs();
        lst = ExtDBUtil.setDataToList(rs);
        rs.close();
        return lst;
    }

    public static String getTimeValue(String timeValue) {
        if (timeValue != null && timeValue.startsWith("getSystemTime()")) {
            java.util.Date date = RunReportParam.getServerDate(null);
            timeValue = CtrlReportUtil.formatTime(date);
        }
        return timeValue;
    }

    public static String getTimeString(String timeValue) {
        if (timeValue == null || timeValue.equals("")) {
            return " 00:00:00";
        }
        return " " + RunReportParam.getTimeValue(timeValue);
    }

    public static String getDateValue(Context ctx, DesignDataType ddt, String dateValue) {
        dateValue = CtrlReportUtil.getObjectString(dateValue);
        String timeValue = "";
        if (dateValue.indexOf("|") != -1) {
            String[] arr = dateValue.split("\\|");
            dateValue = arr[0];
            timeValue = arr[1];
        }
        java.util.Date date = null;
        String dateString = "";
        if (dateValue != null) {
            if (dateValue.startsWith("getSystemDate()")) {
                date = RunReportParam.getServerDate(ctx);
                dateString = ddt.equals(DesignDataType.DATETIME) ? CtrlReportUtil.formatDate(date) : CtrlReportUtil.formatDateTime(date);
            } else if (dateValue.startsWith("dayBegin")) {
                date = RunReportParam.getServerDate(ctx);
                dateString = DateUtil.getMonthFirstDay(date);
                if (ddt.equals(DesignDataType.DATETIME)) {
                    dateString = dateString + RunReportParam.getTimeString(timeValue);
                }
            } else if (dateValue.startsWith("dayEnd")) {
                date = RunReportParam.getServerDate(ctx);
                dateString = DateUtil.getMonthLastDay(date);
                if (ddt.equals(DesignDataType.DATETIME)) {
                    dateString = dateString + RunReportParam.getTimeString(timeValue);
                }
            } else if (dateValue.startsWith("dateAdd + ")) {
                date = RunReportParam.getServerDate(ctx);
                dateValue = ExtStringUtil.replace(dateValue, "dateAdd + ", "");
                int lenth = dateValue.length();
                int addNumber = Integer.parseInt(dateValue.substring(0, lenth - 1));
                dateString = DateUtil.tuneDate(date, addNumber);
                if (ddt.equals(DesignDataType.DATETIME)) {
                    dateString = dateString + RunReportParam.getTimeString(timeValue);
                }
            } else if (dateValue.startsWith("dateSub - ")) {
                date = RunReportParam.getServerDate(ctx);
                dateValue = ExtStringUtil.replace(dateValue, "dateSub - ", "");
                int lenth = dateValue.length();
                int addNumber = Integer.parseInt(dateValue.substring(0, lenth - 1));
                dateString = DateUtil.tuneDate(date, 0 - addNumber);
                if (ddt.equals(DesignDataType.DATETIME)) {
                    dateString = dateString + RunReportParam.getTimeString(timeValue);
                }
            } else {
                dateString = dateValue;
            }
        }
        return dateString;
    }

    public static final Map extParam2DesignParma(Map mapParameterImpl) throws SyntaxErrorException {
        HashMap<String, DesignParameter> mapDesignParam = new HashMap<String, DesignParameter>();
        if (null != mapParameterImpl && !mapParameterImpl.isEmpty()) {
            for (String name : mapParameterImpl.keySet()) {
                Variant vt;
                IParameter p = (IParameter)mapParameterImpl.get(name);
                int dataType = p.getDataType();
                String valueString = CtrlReportUtil.getObjectString(p.getValue().toString());
                Variant valueObject = p.getValue();
                if (valueObject instanceof Variant && valueObject.isArray()) {
                    Variant[] vts = (Variant[])valueObject.getValue();
                    if (null != vts) {
                        valueString = "";
                        for (Variant vt2 : vts) {
                            java.util.Date date;
                            String vtTemp = "";
                            if (dataType == 2) {
                                date = vt2.toDate();
                                vtTemp = CtrlReportUtil.sdf_yyyy_MM_dd.format(date);
                            } else if (dataType == 4) {
                                date = vt2.toDate();
                                vtTemp = CtrlReportUtil.sdfDateTime.format(date);
                            } else if (dataType == 5) {
                                date = vt2.toDate();
                                vtTemp = CtrlReportUtil.sdfTime.format(date);
                            } else {
                                vtTemp = CtrlReportUtil.getObjectString(vt2.toString());
                            }
                            valueString = valueString + vtTemp + "0xx1xx";
                        }
                        if (!valueString.equals("")) {
                            valueString = valueString.substring(0, valueString.length() - "0xx1xx".length());
                        }
                    }
                } else if (dataType == 2) {
                    if (valueObject instanceof Variant && !valueString.equals("")) {
                        vt = valueObject;
                        java.util.Date date = vt.toDate();
                        valueString = CtrlReportUtil.sdf_yyyy_MM_dd.format(date);
                    }
                } else if (dataType == 4) {
                    if (valueObject instanceof Variant && !valueString.equals("")) {
                        vt = valueObject;
                        java.util.Date date = vt.toDate();
                        valueString = CtrlReportUtil.sdfDateTime.format(date);
                    }
                } else if (dataType == 5 && valueObject instanceof Variant && !valueString.equals("")) {
                    vt = valueObject;
                    java.util.Date date = vt.toDate();
                    valueString = CtrlReportUtil.sdfTime.format(date);
                }
                DesignParameter dp = new DesignParameter();
                dp.setName(name);
                dp.setCurentValue(valueString);
                dp.setDesignDataType(DesignDataType.getDataType(dataType));
                mapDesignParam.put(name, dp);
            }
        }
        return mapDesignParam;
    }
}

