/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.snapshot.manage.client.mview;

import com.kingdee.bos.ctrl.common.ui.textfield.SearchTextField;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.CellTreeNode;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.base.reportmeta.ctrlreport.adapter.TableManager;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.icon.SSIcons;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.mview.IManageView;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.mview.MViewUIConfig;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.mview.SSCellTreeNode;
import com.kingdee.eas.base.reportmeta.snapshot.manage.consta.FolderType;
import com.kingdee.eas.base.reportmeta.snapshot.manage.pojo.PhantomSnapshot;
import com.kingdee.eas.base.reportmeta.snapshot.manage.pojo.so.BridgeItem;
import com.kingdee.eas.base.reportmeta.snapshot.manage.pojo.so.ReportGroupItem;
import com.kingdee.eas.base.reportmeta.sumreport.client.task.statusMgr.IntList;
import com.kingdee.eas.base.reportmeta.sumreport.client.task.statusMgr.KMP;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;

public abstract class AbstractManageView
implements IManageView {
    protected KDTable _table;
    protected Map _parentMap;
    protected Map _kidsMap;
    protected Map _id2RowMap;
    protected Map _id2MoreMap;
    protected SSCellTreeNode _moreNode;
    protected boolean _report;
    protected String _lastQuery;
    protected IntList _displayRows;
    protected String _niceNote = "\u8bf7\u8f93\u5165\u6a21\u677f\u540d\u79f0\u8fc7\u6ee4...";
    protected SearchTextField _tfSearch;
    protected Map _filterMap = null;
    protected Set _willexpansions = new HashSet(5);
    protected RefreshManageAction _refreshAction = new RefreshManageAction();

    public AbstractManageView() {
        this._moreNode = new SSCellTreeNode();
        this._moreNode.setType(2);
        this._moreNode.setTreeLevel(1);
        this._moreNode.setValue("\u66f4\u591a\u5feb\u7167...");
    }

    protected void initSearch() {
        this._tfSearch = new SearchTextField(this._niceNote){

            public void clearAction(SearchTextField srcComp) {
                srcComp.setText(null);
            }

            public void searchAction(SearchTextField srcComp) {
                AbstractManageView.this.filter(srcComp.getText());
            }
        };
        this._tfSearch.setSize(new Dimension(300, 20));
        this._tfSearch.setFocusTraversalKeysEnabled(false);
    }

    public BridgeItem getBridge() {
        int[] lst = TableManager.getSelectedTableIndexs2(this._table);
        BridgeItem item = new BridgeItem();
        ArrayList<Object> phantoms = new ArrayList<Object>();
        ArrayList<Object> reports = new ArrayList<Object>();
        for (int i = 0; i < lst.length; ++i) {
            Object obj = this._table.getRow(lst[i]).getUserObject();
            if (!(obj instanceof PhantomSnapshot)) {
                if (this._table.getCell(lst[i], 0).getValue() == this._moreNode) continue;
                reports.add(obj);
                continue;
            }
            phantoms.add(obj);
        }
        item.setDatas(phantoms);
        item.setGroupItems(reports);
        return item;
    }

    protected void add2ParentMap(List kids, String parentID) {
        if (this._parentMap == null) {
            this._parentMap = new HashMap();
        }
        int size = kids.size();
        for (int i = 0; i < size; ++i) {
            PhantomSnapshot ps = (PhantomSnapshot)kids.get(i);
            this._parentMap.put(ps.getId(), parentID);
        }
    }

    protected void add2KidsMap(String parentId, List kids) {
        if (this._kidsMap == null) {
            this._kidsMap = new HashMap();
        }
        this._kidsMap.put(parentId, kids);
    }

    protected void addkids2RowMap(List rows) {
        if (this._id2RowMap == null) {
            this._id2RowMap = new HashMap();
        }
        int size = rows.size();
        for (int i = 0; i < size; ++i) {
            IRow row = (IRow)rows.get(i);
            PhantomSnapshot ps = (PhantomSnapshot)row.getUserObject();
            this._id2RowMap.put(ps.getId(), row);
        }
    }

    protected void addParents2RowMap(List rows) {
        if (this._id2RowMap == null) {
            this._id2RowMap = new HashMap();
        }
        int size = rows.size();
        for (int i = 0; i < size; ++i) {
            IRow row = (IRow)rows.get(i);
            ReportGroupItem rgi = (ReportGroupItem)row.getUserObject();
            this._id2RowMap.put(rgi.getId(), row);
        }
    }

    protected void add2MoreMap(String groupID, IRow row) {
        if (this._id2MoreMap == null) {
            this._id2MoreMap = new HashMap();
        }
        this._id2MoreMap.put(groupID, row);
    }

    public void clearAllMap() {
        if (this._id2RowMap != null) {
            this._id2RowMap.clear();
            this._id2RowMap = null;
        }
        if (this._kidsMap != null) {
            this._kidsMap.clear();
            this._kidsMap = null;
        }
        if (this._parentMap != null) {
            this._parentMap.clear();
            this._parentMap = null;
        }
        if (this._id2MoreMap != null) {
            this._id2MoreMap.clear();
            this._id2MoreMap = null;
        }
    }

    protected void makeSureNotNull() {
        if (this._id2RowMap == null) {
            this._id2RowMap = new HashMap();
        }
        if (this._kidsMap == null) {
            this._kidsMap = new HashMap();
        }
        if (this._parentMap == null) {
            this._parentMap = new HashMap();
        }
        if (this._id2MoreMap == null) {
            this._id2MoreMap = new HashMap();
        }
    }

    public void deleteRows(BridgeItem item) {
        List kids;
        int i;
        IntList rows = new IntList();
        HashSet<String> parentIDSet = new HashSet<String>();
        HashSet<String> idSet = new HashSet<String>();
        this.makeSureNotNull();
        this.syncMap();
        List groups = item.getGroupItems();
        boolean commonFolder = this.getManageViewType() == FolderType.COMMON_FOLDER;
        int size = groups.size();
        for (i = 0; i < size; ++i) {
            IRow moreRow;
            ReportGroupItem group = (ReportGroupItem)groups.get(i);
            String gid = group.getId();
            IRow groupRow = (IRow)this._id2RowMap.get(gid);
            if (!commonFolder) {
                rows.add(groupRow.getRowIndex());
            }
            parentIDSet.add(gid);
            idSet.add(gid);
            kids = (List)this._kidsMap.get(gid);
            if (kids != null) {
                int jsize = kids.size();
                for (int j = 0; j < jsize; ++j) {
                    PhantomSnapshot ps = (PhantomSnapshot)kids.get(j);
                    String itemId = ps.getId();
                    IRow row = (IRow)this._id2RowMap.get(itemId);
                    if (row == null) continue;
                    rows.add(row.getRowIndex());
                    idSet.add(itemId);
                }
            }
            if ((moreRow = (IRow)this._id2MoreMap.get(gid)) == null) continue;
            rows.add(moreRow.getRowIndex());
        }
        List items = item.getDatas();
        int size2 = items.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            PhantomSnapshot ps = (PhantomSnapshot)items.get(i2);
            String itemId = ps.getId();
            IRow row = (IRow)this._id2RowMap.get(itemId);
            rows.add(row.getRowIndex());
            idSet.add(itemId);
            Object parentID = this._parentMap.get(itemId);
            if (parentID == null) continue;
            kids = (List)this._kidsMap.get(parentID);
            kids.remove(ps);
        }
        if (this._table == null || this._table.getRowCount() == 0) {
            return;
        }
        int[] rowIdxs = rows.toArray();
        Arrays.sort(rowIdxs);
        int preIdx = -1;
        for (i = rowIdxs.length - 1; i >= 0; --i) {
            if (preIdx == rowIdxs[i]) continue;
            this._table.removeRow(rowIdxs[i]);
            preIdx = rowIdxs[i];
        }
        this.syncMap();
        for (String id : parentIDSet) {
            this._kidsMap.remove(id);
        }
        for (String id : idSet) {
            this._id2RowMap.remove(id);
            this._parentMap.remove(id);
        }
        rows.clear();
        parentIDSet.clear();
        idSet.clear();
        rows = null;
        parentIDSet = null;
        idSet = null;
        this._displayRows = null;
    }

    protected void syncMap() {
        this._id2MoreMap.clear();
        this._id2RowMap.clear();
        String groupID = null;
        int size = this._table.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this._table.getRow(i);
            Object cllValue = this._table.getCell(i, 0).getValue();
            if (cllValue instanceof CellTreeNode) {
                CellTreeNode node = (CellTreeNode)cllValue;
                if (node.getTreeLevel() == 0) {
                    ReportGroupItem item = (ReportGroupItem)row.getUserObject();
                    groupID = item.getId();
                    this._id2RowMap.put(groupID, row);
                    continue;
                }
                if (node.getTreeLevel() != 1) continue;
                if (node == this._moreNode) {
                    this._id2MoreMap.put(groupID, row);
                    continue;
                }
                PhantomSnapshot ps = (PhantomSnapshot)row.getUserObject();
                this._id2RowMap.put(ps.getId(), row);
                continue;
            }
            PhantomSnapshot ps = (PhantomSnapshot)row.getUserObject();
            this._id2RowMap.put(ps.getId(), row);
        }
    }

    protected boolean isSelectedChange() {
        BridgeItem item = this.getBridge();
        List data = item.getDatas();
        List reports = item.getGroupItems();
        if (this._report && data.size() > 0) {
            this._report = !this._report;
            return true;
        }
        if (!this._report && reports.size() > 0 && data.size() == 0) {
            this._report = !this._report;
            return true;
        }
        return false;
    }

    public void updateEntity(PhantomSnapshot ps) {
    }

    protected void filterAllSnap(String text) {
        if (StringUtil.isEmptyString((String)text) || StringUtil.isEmptyString((String)text.trim()) || this._niceNote.equals(text)) {
            int rowCount = this._table.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                this._table.getRow(i).getStyleAttributes().setHided(false);
            }
            this._lastQuery = null;
            this._displayRows = null;
        } else {
            text = text.toLowerCase().trim();
            if (null != this._displayRows && KMP.kmp(text, this._lastQuery)) {
                IntList displayRows = new IntList(8);
                int size = this._displayRows.size();
                for (int i = size - 1; i > -1; --i) {
                    String name = ((PhantomSnapshot)this._table.getRow(this._displayRows.get(i)).getUserObject()).getName().toLowerCase();
                    boolean visible = KMP.kmp(name, text);
                    if (!visible) {
                        this._table.getRow(this._displayRows.get(i)).getStyleAttributes().setHided(!visible);
                        continue;
                    }
                    displayRows.add(this._displayRows.get(i));
                }
                this._lastQuery = text;
                this._displayRows = null;
                this._displayRows = displayRows;
            } else {
                this._displayRows = new IntList(8);
                int rowCount = this._table.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    String name = ((PhantomSnapshot)this._table.getRow(i).getUserObject()).getName().toLowerCase();
                    boolean visible = KMP.kmp(name, text);
                    if (visible) {
                        this._displayRows.add(i);
                    }
                    this._table.getRow(i).getStyleAttributes().setHided(!visible);
                }
                this._lastQuery = text;
            }
        }
    }

    public void loadListData(Map filterObj) {
        this._filterMap = filterObj;
        if (!this._niceNote.equals(this._tfSearch.getText())) {
            this._tfSearch.setText("");
            this._tfSearch.invalidate();
            this._tfSearch.repaint();
        }
        this.loadData(this._filterMap);
    }

    public abstract void loadData(Map var1);

    protected void filter(String text) {
        this.makeSureNotNull();
        this.syncMap();
        if (StringUtil.isEmptyString((String)text) || StringUtil.isEmptyString((String)text.trim()) || this._niceNote.equals(text)) {
            int rowCount = this._table.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                IRow moreRow;
                CellTreeNode node;
                Object uObj = this._table.getRow(i).getUserObject();
                if (uObj instanceof PhantomSnapshot || !(uObj instanceof ReportGroupItem) || (node = (CellTreeNode)this._table.getRow(i).getCell(0).getValue()).getTreeLevel() != 0) continue;
                this._table.getRow(i).getStyleAttributes().setHided(false);
                if (node.isCollapse()) continue;
                List kids = (List)this._kidsMap.get(((ReportGroupItem)uObj).getId());
                if (kids != null) {
                    for (PhantomSnapshot ps : kids) {
                        IRow row = (IRow)this._id2RowMap.get(ps.getId());
                        row.getStyleAttributes().setHided(false);
                    }
                }
                if ((moreRow = (IRow)this._id2MoreMap.get(((ReportGroupItem)uObj).getId())) == null) continue;
                moreRow.getStyleAttributes().setHided(false);
            }
            this._lastQuery = null;
            this._displayRows = null;
        } else {
            text = text.toLowerCase().trim();
            if (null != this._displayRows && KMP.kmp(text, this._lastQuery)) {
                IntList displayRows = new IntList(8);
                int size = this._displayRows.size();
                for (int i = size - 1; i > -1; --i) {
                    Object uObj = this._table.getRow(this._displayRows.get(i)).getUserObject();
                    CellTreeNode node = (CellTreeNode)this._table.getRow(this._displayRows.get(i)).getCell(0).getValue();
                    String name = ((ReportGroupItem)uObj).getName().toLowerCase();
                    boolean visible = KMP.kmp(name, text);
                    if (!visible) {
                        IRow moreRow;
                        this._table.getRow(this._displayRows.get(i)).getStyleAttributes().setHided(!visible);
                        if (node.isCollapse()) continue;
                        List kids = (List)this._kidsMap.get(((ReportGroupItem)uObj).getId());
                        if (kids != null) {
                            for (PhantomSnapshot ps : kids) {
                                IRow row = (IRow)this._id2RowMap.get(ps.getId());
                                row.getStyleAttributes().setHided(true);
                            }
                        }
                        if ((moreRow = (IRow)this._id2MoreMap.get(((ReportGroupItem)uObj).getId())) == null) continue;
                        moreRow.getStyleAttributes().setHided(true);
                        continue;
                    }
                    displayRows.add(this._displayRows.get(i));
                }
                this._lastQuery = text;
                this._displayRows = null;
                this._displayRows = displayRows;
            } else {
                this._displayRows = new IntList(8);
                int rowCount = this._table.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    IRow moreRow;
                    CellTreeNode node;
                    Object uObj = this._table.getRow(i).getUserObject();
                    if (uObj instanceof PhantomSnapshot || !(uObj instanceof ReportGroupItem) || (node = (CellTreeNode)this._table.getRow(i).getCell(0).getValue()).getTreeLevel() != 0) continue;
                    String name = ((ReportGroupItem)uObj).getName().toLowerCase();
                    boolean visible = KMP.kmp(name, text);
                    if (visible) {
                        this._displayRows.add(i);
                    }
                    this._table.getRow(i).getStyleAttributes().setHided(!visible);
                    if (node.isCollapse()) continue;
                    List kids = (List)this._kidsMap.get(((ReportGroupItem)uObj).getId());
                    if (kids != null) {
                        for (PhantomSnapshot ps : kids) {
                            IRow row = (IRow)this._id2RowMap.get(ps.getId());
                            row.getStyleAttributes().setHided(!visible);
                        }
                    }
                    if ((moreRow = (IRow)this._id2MoreMap.get(((ReportGroupItem)uObj).getId())) == null) continue;
                    moreRow.getStyleAttributes().setHided(!visible);
                }
                this._lastQuery = text;
            }
        }
    }

    protected void tableAppearance() {
        this._table.getStyleAttributes().setBorderColor(Styles.Position.TOP, MViewUIConfig.BODY_LINE_BORDER);
        this._table.getStyleAttributes().setBorderColor(Styles.Position.RIGHT, MViewUIConfig.BODY_LINE_BORDER);
        this._table.getStyleAttributes().setBorderColor(Styles.Position.BOTTOM, MViewUIConfig.BODY_LINE_BORDER);
        this._table.getStyleAttributes().setBorderColor(Styles.Position.LEFT, MViewUIConfig.BODY_LINE_BORDER);
        this._table.getStyleAttributes().setBorderLineStyle(Styles.Position.TOP, LineStyle.SINGLE_LINE);
        this._table.getStyleAttributes().setBorderLineStyle(Styles.Position.RIGHT, LineStyle.SINGLE_LINE);
        this._table.getStyleAttributes().setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.SINGLE_LINE);
        this._table.getStyleAttributes().setBorderLineStyle(Styles.Position.LEFT, LineStyle.SINGLE_LINE);
        this._table.getStyleAttributes().setFont(MViewUIConfig.Song_Ti);
    }

    protected void groupRowAppearance(IRow row, ICell cell) {
        cell.getStyleAttributes().setFontColor(MViewUIConfig.GROUP_FONT_CLR);
        cell.getStyleAttributes().setBold(true);
        cell.getStyleAttributes().setFontSize(9);
        row.setHeight(25);
        row.getStyleAttributes().setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.DOUBLE_LINE_A);
        row.getStyleAttributes().setBorderColor(Styles.Position.BOTTOM, MViewUIConfig.GROUP_LINE_BORDER);
        row.getStyleAttributes().setBorderPenStyle(Styles.Position.BOTTOM, PenStyle.PS_SOLID);
    }

    protected class RefreshManageAction
    extends AbstractAction {
        public RefreshManageAction() {
            this.putValue("Name", "\u5237\u65b0");
            this.putValue("SmallIcon", SSIcons.REFRESH_ICON);
        }

        public void actionPerformed(ActionEvent e) {
            for (KDTMergeBlock block : AbstractManageView.this._table.getMergeManager().getMergeBlockSet()) {
                Object obj;
                CellTreeNode value = (CellTreeNode)AbstractManageView.this._table.getCell(block.getTop(), block.getLeft()).getValue();
                if (value.isCollapse() || !((obj = value.getValue()) instanceof ReportGroupItem)) continue;
                AbstractManageView.this._willexpansions.add((ReportGroupItem)obj);
            }
            if (!AbstractManageView.this._niceNote.equals(AbstractManageView.this._tfSearch.getText())) {
                AbstractManageView.this._tfSearch.setText("");
                AbstractManageView.this._tfSearch.invalidate();
                AbstractManageView.this._tfSearch.repaint();
            }
            AbstractManageView.this.loadData(AbstractManageView.this._filterMap);
            AbstractManageView.this._tfSearch.requestFocus();
        }
    }
}

