/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.snapshot.manage.client.mview;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.kdf.table.CellTreeNode;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.event.NodeClickListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.model.util.ObjectStack;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.MoreSnapshotListUI;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.SnapshotManageUI;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.mview.AbstractManageView;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.mview.MViewUIConfig;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.mview.SSCellTreeNode;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.mview.action.FavoriteAction;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.mview.action.MarkReadAction;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.mview.action.SSDelSnapshotAction;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.mview.action.ShareAction;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.mview.action.ViewSnapshotManageAction;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.tree.CustomTreeRender;
import com.kingdee.eas.base.reportmeta.snapshot.manage.consta.FolderType;
import com.kingdee.eas.base.reportmeta.snapshot.manage.exception.ShortcutMailboxException;
import com.kingdee.eas.base.reportmeta.snapshot.manage.pojo.PhantomSnapshot;
import com.kingdee.eas.base.reportmeta.snapshot.manage.pojo.so.BridgeItem;
import com.kingdee.eas.base.reportmeta.snapshot.manage.pojo.so.ReportGroupItem;
import com.kingdee.eas.base.reportmeta.snapshot.manage.service.mailbox.ISSExpressDeliveryService;
import com.kingdee.eas.base.reportmeta.snapshot.manage.service.mailbox.SSExpressDeliveryService;
import com.kingdee.eas.base.reportmeta.sumreport.util.EASUtil;
import com.kingdee.eas.base.reportmeta.sumreport.util.ExtMsgBox;
import com.kingdee.eas.common.client.UIContext;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class MailboxManageView
extends AbstractManageView {
    public static final int COL_THEME = 0;
    public static final int COL_SENDER = 1;
    public static final int COL_SEND_TIME = 2;
    protected SnapshotManageUI _owner;
    protected KDPanel _panel;
    protected ISSExpressDeliveryService _mailService;
    private NodeClickObserver _nodeClickObserver = new NodeClickObserver();
    protected Action[] _actions;
    private static int INDEX = 0;
    private static final int ACTION_VIEW = INDEX++;
    private static final int ACTION_DEL = INDEX++;
    private static final int ACTION_READ = INDEX++;
    private static final int ACTION_UNREAD = INDEX++;
    private static final int ACTION_SEPARATOR = INDEX++;
    private static final int ACTION_REFRESH = INDEX++;
    private static final int ACTION_SEPARATOR_1 = INDEX++;
    private static final int ACTION_FAVORITE = INDEX++;
    private static final int ACTION_SEPARATOR2 = INDEX++;
    private static final int ACTION_SHARE = INDEX++;

    public MailboxManageView(SnapshotManageUI mainUI) {
        this._owner = mainUI;
        this.init();
        this.installListener();
    }

    private void init() {
        this._table = new KDTable();
        this._table.addColumns(3);
        this._table.getColumn(0).setWidth(600);
        this._table.getColumn(1).setWidth(128);
        this._table.getColumn(2).setWidth(128);
        IRow header = this._table.addHeadRow();
        header.getCell(0).setValue((Object)"\u540d\u79f0");
        header.getCell(1).setValue((Object)"\u53d1\u9001\u8005");
        header.getCell(2).setValue((Object)"\u53d1\u9001\u65f6\u95f4");
        Object delKey = this._table.getInputMap().get(KeyStroke.getKeyStroke(127, 0));
        this._table.getActionMap().put(delKey, null);
        this.tableAppearance();
        this._table.getColumn(1).getStyleAttributes().setLocked(true);
        this._table.getColumn(2).getStyleAttributes().setLocked(true);
        this._table.getSelectManager().setSelectMode(10);
        this._table.getColumn(2).getStyleAttributes().setNumberFormat("yyyy-MM-dd  HH:mm");
        this._table.putDefaultRenderers(CellTreeNode.class, (IBasicRender)CustomTreeRender.getInst());
        this.initSearch();
        TableLayout2 ly = new TableLayout2(2, 2);
        ly.setFixedWidth(0, 300);
        ly.setRatableWidth(1, 110);
        ly.setFixedHeight(0, 20);
        ly.setRatableHeight(1, 500);
        ly.setColsSpacing(TableLayout2.ALL, 20);
        ly.setRowSpacing(0, 6);
        this._panel = new KDPanel((LayoutManager)ly);
        this._panel.add((Component)this._tfSearch, (Object)TableLayout2.param((int)0, (int)0));
        this._panel.add((Component)this._table, (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)1));
    }

    public Action[] getManageActions() {
        if (this._actions == null) {
            this._actions = new Action[INDEX];
            this._actions[MailboxManageView.ACTION_VIEW] = new ViewSnapshotManageAction(this._owner);
            this._actions[MailboxManageView.ACTION_DEL] = new SSDelSnapshotAction(this._owner);
            this._actions[MailboxManageView.ACTION_READ] = new MarkReadAction(this._owner, 1);
            this._actions[MailboxManageView.ACTION_UNREAD] = new MarkReadAction(this._owner, 0);
            this._actions[MailboxManageView.ACTION_SEPARATOR] = SEPARATOR_ACTION;
            this._actions[MailboxManageView.ACTION_REFRESH] = this._refreshAction;
            this._actions[MailboxManageView.ACTION_SEPARATOR_1] = SEPARATOR_ACTION;
            this._actions[MailboxManageView.ACTION_FAVORITE] = new FavoriteAction(this._owner);
            this._actions[MailboxManageView.ACTION_SEPARATOR2] = SEPARATOR_ACTION;
            this._actions[MailboxManageView.ACTION_SHARE] = new ShareAction(this._owner);
        }
        return this._actions;
    }

    public KDPanel getUI() {
        return this._panel;
    }

    private void installListener() {
        this._table.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                boolean change = MailboxManageView.this.isSelectedChange();
                if (change) {
                    MailboxManageView.this._actions[ACTION_VIEW].setEnabled(!MailboxManageView.this._report);
                    MailboxManageView.this._actions[ACTION_FAVORITE].setEnabled(!MailboxManageView.this._report);
                    MailboxManageView.this._actions[ACTION_SHARE].setEnabled(!MailboxManageView.this._report);
                    MailboxManageView.this._owner.updateToolBar();
                }
            }
        });
        this._table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (SwingUtilities.isLeftMouseButton((MouseEvent)e) && e.getClickCount() == 2) {
                    ICell cell = MailboxManageView.this._table.getCell(e.getRowIndex(), e.getColIndex());
                    if (cell != null && cell.getValue() instanceof CellTreeNode && cell.getValue() == MailboxManageView.this._moreNode) {
                        ReportGroupItem groupItem = (ReportGroupItem)MailboxManageView.this._table.getRow(e.getRowIndex()).getUserObject();
                        UIContext uiCtx = new UIContext();
                        uiCtx.put("GROUP", groupItem);
                        uiCtx.put("FOLDER_TYPE", new Integer(FolderType.MAILBOX));
                        uiCtx.put("UIClassParam", FolderType.MAILBOX + 42 + groupItem.getId() + "MAIL_BOX");
                        ArrayList kids = (ArrayList)MailboxManageView.this._kidsMap.get(groupItem.getId());
                        if (kids == null) {
                            kids = new ArrayList(1);
                        }
                        uiCtx.put("FILTER_SET", new HashSet(kids));
                        EASUtil.showUIOnNewTab(MoreSnapshotListUI.class.getName(), (Map)uiCtx, MailboxManageView.this._owner);
                    } else if (e.getClickCount() == 2 && cell != null && cell.getValue() instanceof CellTreeNode && ((CellTreeNode)cell.getValue()).getTreeLevel() == 1) {
                        MailboxManageView.this._actions[0].actionPerformed(null);
                    } else if (e.getClickCount() == 2 && cell != null && cell.getValue() instanceof CellTreeNode && ((CellTreeNode)cell.getValue()).getTreeLevel() == 0) {
                        ((CellTreeNode)cell.getValue()).doTreeClick(MailboxManageView.this._table, cell);
                        MailboxManageView.this._nodeClickObserver.doClick((CellTreeNode)cell.getValue(), cell, 2);
                    } else if (!(cell.getValue() instanceof CellTreeNode)) {
                        MailboxManageView.this._actions[0].actionPerformed(null);
                    }
                }
            }
        });
    }

    public void loadData(Map filterObj) {
        try {
            this._mailService = SSExpressDeliveryService.getInst();
            List lst = this._mailService.getReportGroups();
            this._table.removeRows();
            HashSet<String> _removeDuplication = new HashSet<String>();
            ArrayList<IRow> rows = new ArrayList<IRow>();
            ArrayList<ICell> willExpandCells = new ArrayList<ICell>();
            boolean refresh = !this._willexpansions.isEmpty();
            ObjectStack stack = new ObjectStack();
            int size = lst.size();
            for (int i = 0; i < size; ++i) {
                ReportGroupItem groupItem = (ReportGroupItem)lst.get(i);
                if (_removeDuplication.contains(groupItem.getId())) continue;
                IRow row = this._table.addRow();
                SSCellTreeNode node = new SSCellTreeNode();
                node.setValue(groupItem);
                node.setHasChildren(true);
                node.setTreeLevel(0);
                node.setCollapse(true);
                ICell cell = row.getCell(0);
                cell.setValue((Object)node);
                this.groupRowAppearance(row, cell);
                KDTMergeManager mgr = this._table.getMergeManager();
                mgr.mergeBlock(cell.getRowIndex(), 0, cell.getRowIndex(), this._table.getColumnCount() - 1);
                node.addClickListener(this._nodeClickObserver);
                row.setUserObject((Object)groupItem);
                rows.add(row);
                if (!refresh && groupItem.isHasUnread()) {
                    willExpandCells.add(cell);
                }
                if (refresh && this._willexpansions.contains(groupItem)) {
                    stack.push((Object)cell);
                }
                _removeDuplication.add(groupItem.getId());
            }
            super.addParents2RowMap(rows);
            this.expandHavingUnReadMailsGroup(willExpandCells);
            this.revertTreeState(stack);
        }
        catch (ShortcutMailboxException e) {
            ExtMsgBox.showError((Component)((Object)this._owner), "\u83b7\u5f97\u5f53\u524d\u7528\u6237\u5feb\u7167\u90ae\u4ef6\u5931\u8d25", e.toString());
        }
    }

    private void expandHavingUnReadMailsGroup(List cells) {
        for (int i = cells.size() - 1; i >= 0; --i) {
            ICell cell = (ICell)cells.get(i);
            ((CellTreeNode)cell.getValue()).doTreeClick(this._table, cell);
            this._nodeClickObserver.doClick((CellTreeNode)cell.getValue(), cell, 2);
        }
        cells.clear();
    }

    protected void revertTreeState(ObjectStack stack) {
        if (!stack.isEmpty()) {
            Object[] objs = stack.getArray();
            for (int i = objs.length - 1; i >= 0; --i) {
                ICell cell = (ICell)objs[i];
                ((CellTreeNode)cell.getValue()).doTreeClick(this._table, cell);
                this._nodeClickObserver.doClick((CellTreeNode)cell.getValue(), cell, 2);
            }
            stack.clear();
            this._willexpansions.clear();
        }
    }

    public BridgeItem getBridge() {
        return super.getBridge();
    }

    public String getBranchName() {
        return null;
    }

    public void updateReadState(BridgeItem item, int readState) {
        List mails;
        this.makeSureNotNull();
        this.syncMap();
        HashSet mailSet = new HashSet();
        List reportGroups = item.getGroupItems();
        if (reportGroups != null && reportGroups.size() > 0) {
            int size = reportGroups.size();
            for (int i = 0; i < size; ++i) {
                ReportGroupItem group = (ReportGroupItem)reportGroups.get(i);
                List childs = (List)this._kidsMap.get(group.getId());
                if (childs == null || childs.size() <= 0) continue;
                mailSet.addAll(childs);
            }
        }
        if ((mails = item.getDatas()) != null && mails.size() > 0) {
            mailSet.addAll(mails);
        }
        for (PhantomSnapshot mail : mailSet) {
            mail.setReadState(readState);
            IRow row = (IRow)this._id2RowMap.get(mail.getId());
            row.getStyleAttributes().setBold(readState == 0);
        }
        this._table.repaint();
    }

    public int getManageViewType() {
        return FolderType.MAILBOX;
    }

    public KDWorkButton[] getWorkButtons() {
        return null;
    }

    private class NodeClickObserver
    implements NodeClickListener {
        private NodeClickObserver() {
        }

        public void doClick(CellTreeNode source, ICell cell, int type) {
            if (!source.isCollapse()) {
                ReportGroupItem item = (ReportGroupItem)source.getValue();
                if (item.isLoadedData()) {
                    return;
                }
                try {
                    MailboxManageView.this._mailService = SSExpressDeliveryService.getInst();
                    List lst = MailboxManageView.this._mailService.getMailsByReportGroupID(item.getId());
                    int size = lst.size();
                    size = size > 5 ? 5 : size;
                    ArrayList<IRow> rows = new ArrayList<IRow>();
                    for (int i = 0; i < size; ++i) {
                        PhantomSnapshot phantom = (PhantomSnapshot)lst.get(i);
                        IRow row = MailboxManageView.this._table.addRow(cell.getRowIndex() + i + 1);
                        SSCellTreeNode node = new SSCellTreeNode();
                        node.setTreeLevel(1);
                        node.setValue(phantom.getName());
                        node.setType(phantom.isFake());
                        row.getCell(0).setValue((Object)node);
                        row.getCell(1).setValue((Object)phantom.getSenderName());
                        row.getCell(2).setValue((Object)phantom.getSendTime());
                        row.getStyleAttributes().setBold(phantom.getReadState() == 0);
                        row.setUserObject((Object)phantom);
                        node.setUserObj(phantom);
                        rows.add(row);
                    }
                    if (lst.size() > 5) {
                        IRow row = MailboxManageView.this._table.addRow(cell.getRowIndex() + 5 + 1);
                        ICell moreCell = row.getCell(0);
                        moreCell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
                        moreCell.getStyleAttributes().setFontColor(MViewUIConfig.MORE_BUTTON_COLOR);
                        KDTMergeManager mgr = MailboxManageView.this._table.getMergeManager();
                        row.getCell(0).setValue((Object)MailboxManageView.this._moreNode);
                        mgr.mergeBlock(moreCell.getRowIndex(), 0, moreCell.getRowIndex(), MailboxManageView.this._table.getColumnCount() - 1);
                        lst.remove(lst.size() - 1);
                        row.setUserObject((Object)item);
                        MailboxManageView.this.add2MoreMap(item.getId(), row);
                    }
                    item.setLoadedData(true);
                    MailboxManageView.this.add2ParentMap(lst, item.getId());
                    MailboxManageView.this.add2KidsMap(item.getId(), lst);
                    MailboxManageView.this.addkids2RowMap(rows);
                }
                catch (ShortcutMailboxException e) {
                    ExtMsgBox.showError((Component)((Object)MailboxManageView.this._owner), "\u5c55\u5f00\u5931\u8d25", e.toString());
                }
            }
        }
    }
}

