/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.snapshot.manage.client.mview.action;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.immit.IExtRuntimeDataProvider;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.base.reportmeta.base.execution.SnapExecutor;
import com.kingdee.eas.base.reportmeta.ctrlreport.DefineReportInfo;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.ExtReportRunUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.ReportRunTimeUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.ExtCallbackImpl;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.AbstractManageUI;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.SnapshotRunUI;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.mview.action.ManageAbstractAction;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.mview.action.SaveAsManageAction;
import com.kingdee.eas.base.reportmeta.snapshot.manage.consta.SnapshotSourceType;
import com.kingdee.eas.base.reportmeta.snapshot.manage.exception.SnapshotException;
import com.kingdee.eas.base.reportmeta.snapshot.manage.pojo.PhantomSnapshot;
import com.kingdee.eas.base.reportmeta.snapshot.manage.pojo.so.ReportGroupItem;
import com.kingdee.eas.base.reportmeta.sumreport.util.EASUtil;
import com.kingdee.eas.base.reportmeta.sumreport.util.ExtMsgBox;
import com.kingdee.eas.base.uiframe.client.UIFrameUtil;
import com.kingdee.eas.common.client.UIContext;
import java.awt.Component;
import java.awt.Frame;
import java.util.Map;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public abstract class AbstractViewSnapshotOrReportAction
extends ManageAbstractAction {
    public AbstractViewSnapshotOrReportAction(AbstractManageUI ui) {
        super(ui);
    }

    protected void viewSnapshot(PhantomSnapshot snapshot) {
        String snapshotID = snapshot.getSnapshotId();
        if (StringUtil.isEmptyString((String)snapshotID)) {
            snapshotID = snapshot.getId();
        }
        try {
            byte[] data = null;
            data = snapshot.getSourceType() == SnapshotSourceType.SUM_UPLOAD ? this._serv.getSumUploadSnapshotData(snapshotID) : this._serv.getSnapshotData(snapshotID);
            if (data == null || data.length == 0) {
                ExtMsgBox.showInfo((Component)((Object)this._mainUI), "\u5feb\u7167\u6570\u636e\u5df2\u88ab\u5220\u9664");
                return;
            }
            Frame mainFrame = UIFrameUtil.getCurrMainFrame((Component)((Object)this._mainUI));
            UIContext uiContext = new UIContext((Object)mainFrame);
            uiContext.put("MainMenuName", snapshot.getName());
            uiContext.put("SNAPSHOT_DATA", data);
            IUIWindow window = EASUtil.getUIObjectwhichWillShowOnNewTab(SnapshotRunUI.class.getName(), (Map)uiContext, this._mainUI);
            if (window == null) {
                return;
            }
            SnapshotRunUI ui = (SnapshotRunUI)window.getUIObject();
            ui.setExtraActions(new Action[]{new SaveAsManageAction(snapshot, ui)});
            ui.setFrontTask(new RetrieveTemplate(snapshot.getReportId()));
            ui.runEXT();
            window.show();
        }
        catch (SnapshotException e) {
            ExtMsgBox.showError((Component)((Object)this._mainUI), "\u52a0\u8f7d\u5feb\u7167\u4fe1\u606f\u5f02\u5e38\uff01", e.toString());
        }
    }

    protected void viewReport(ReportGroupItem item) {
        try {
            final DefineReportInfo info = this._serv.queryReportTemplateInfo(item.getId());
            if (info == null) {
                ExtMsgBox.showInfo((Component)((Object)this._mainUI), "\u6a21\u677f\u6570\u636e\u5df2\u88ab\u5220\u9664");
                return;
            }
            item.setTemplateType(info.getTempletType());
            if (!item.canExecute()) {
                ExtMsgBox.showInfo((Component)((Object)this._mainUI), "\u4e0d\u53ef\u6267\u884c\u6c47\u603b\u4e0a\u62a5\u6a21\u677f");
                return;
            }
            Frame mainFrame = UIFrameUtil.getCurrMainFrame((Component)((Object)this._mainUI));
            UIContext uiContext = new UIContext((Object)mainFrame);
            uiContext.put("UIClassParam", info.getId().toString());
            uiContext.put("MainMenuName", item.getName());
            uiContext.put("checkLicense", "true");
            SwingUtilities.invokeLater(new Runnable((Map)uiContext){
                final /* synthetic */ Map val$uiContext;
                {
                    this.val$uiContext = map;
                }

                public void run() {
                    String className = ReportRunTimeUI.class.getName();
                    if (info.getLicenseStrategy() == 1) {
                        className = ExtReportRunUI.class.getName();
                    }
                    EASUtil.showUIOnNewTab(className, this.val$uiContext, AbstractViewSnapshotOrReportAction.this._mainUI);
                }
            });
        }
        catch (SnapshotException e) {
            ExtMsgBox.showError((Component)((Object)this._mainUI), "\u83b7\u5f97\u62a5\u8868\u4fe1\u606f\u5f02\u5e38\uff01", e.toString());
        }
    }

    protected class RetrieveTemplate
    implements SnapshotRunUI.FrontTask {
        private String _reportID;

        public RetrieveTemplate(String reportID) {
            this._reportID = reportID;
        }

        public void deal(SnapExecutor executor) throws Exception {
            DefineReportInfo info = AbstractViewSnapshotOrReportAction.this._serv.queryReportTemplateInfo(this._reportID);
            executor.setDataProvider((IExtRuntimeDataProvider)new ExtCallbackImpl(info, false, true));
        }
    }
}

