/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.snapshot.manage.client.mview.action.ui;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.base.reportmeta.snapshot.manage.pojo.PhantomSnapshot;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class NameConflictTreatmentUI
extends KDDialog {
    private KDTable _table;
    private List _conflictNames;
    private Window _owner;
    private static final int COL_NAME = 0;
    private static final int COL_NEW_NAME = 1;
    private static final int COL_STRATEGY = 2;
    private Map _result = new HashMap();
    private boolean _cancel;
    private static final TreatmentStrategy IGNORE_STRATEGY = new IgnoreStrategy("\u8df3\u8fc7");
    private static final RenameStrategy RENAME_STRATEGY = new RenameStrategy("\u91cd\u547d\u540d");

    public NameConflictTreatmentUI(List conflictNames, Window ownerWindow) {
        super((Frame)ownerWindow, true);
        this._conflictNames = conflictNames;
        this._owner = ownerWindow;
        this.initUI();
        this.initUIData();
    }

    private void initUI() {
        this._table = new KDTable();
        this._table.addColumns(3);
        IRow headRow = this._table.addHeadRow();
        headRow.getCell(0).setValue((Object)"\u540d\u79f0");
        headRow.getCell(1).setValue((Object)"\u65b0\u540d\u79f0");
        headRow.getCell(2).setValue((Object)"\u5904\u7406\u7b56\u7565");
        this._table.setEditable(true);
        this._table.getColumn(0).setWidth(128);
        this._table.getColumn(0).getStyleAttributes().setLocked(true);
        this._table.getColumn(1).setWidth(128);
        this._table.getColumn(2).setWidth(100);
        KDComboBox cbStrategy = new KDComboBox(new Object[]{IGNORE_STRATEGY, RENAME_STRATEGY});
        this._table.getColumn(2).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbStrategy));
        this._table.getColumn(1).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)new KDTextField()));
        this._table.getScriptManager().setScriptDisabled(true);
        KDSeparator separator = new KDSeparator();
        KDWorkButton btnOk = new KDWorkButton("\u786e\u5b9a");
        btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NameConflictTreatmentUI.this.actionOK();
                NameConflictTreatmentUI.this.dispose();
            }
        });
        KDWorkButton btnCancel = new KDWorkButton("\u53d6\u6d88");
        btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NameConflictTreatmentUI.this._cancel = true;
                NameConflictTreatmentUI.this.dispose();
            }
        });
        btnOk.setPreferredSize(new Dimension(74, 21));
        btnCancel.setPreferredSize(new Dimension(74, 21));
        TableLayout2 ly = new TableLayout2(3, 3);
        ly.setRatableHeight(0, 400);
        ly.setFixedHeight(1, 3);
        ly.setFixedHeight(2, 21);
        ly.setFixedWidth(new int[]{1, 2}, 74);
        ly.setRatableWidth(0, 300);
        ly.setColsSpacing(TableLayout2.ALL, 0);
        ly.setColSpacing(1, 3);
        ly.setRowsSpacing(TableLayout2.ALL, 9);
        KDPanel panel = new KDPanel((LayoutManager)ly);
        panel.setCustomInsets(new Insets(10, 10, 10, 10));
        panel.add((Component)this._table, (Object)TableLayout2.param((int)0, (int)0, (int)0, (int)2));
        panel.add((Component)separator, (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)2));
        panel.add((Component)btnOk, (Object)TableLayout2.param((int)2, (int)1));
        panel.add((Component)btnCancel, (Object)TableLayout2.param((int)2, (int)2));
        this.setContentPane((Container)panel);
        this.setSize(new Dimension(525, 350));
    }

    private void initUIData() {
        if (this._conflictNames == null) {
            return;
        }
        this._table.removeRows();
        int size = this._conflictNames.size();
        for (int i = 0; i < size; ++i) {
            PhantomSnapshot ps = (PhantomSnapshot)this._conflictNames.get(i);
            IRow row = this._table.addRow();
            row.getCell(0).setValue((Object)ps.getName());
            row.getCell(1).setValue((Object)ps.getName());
            row.getCell(2).setValue((Object)RENAME_STRATEGY);
            row.setUserObject((Object)ps);
        }
    }

    private void actionOK() {
        this._result.clear();
        this._table.getEditManager().stopEditing();
        int size = this._table.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this._table.getRow(i);
            Object strategy = row.getCell(2).getValue();
            PhantomSnapshot ps = (PhantomSnapshot)this._table.getRow(i).getUserObject();
            PhantomSnapshot newNameEntity = ((TreatmentStrategy)strategy).deal(row);
            this._result.put(ps.getId(), newNameEntity);
        }
    }

    public Map getResult() {
        return this._result;
    }

    public boolean isCancel() {
        return this._cancel;
    }

    private static class RenameStrategy
    implements TreatmentStrategy {
        private String _name;

        public RenameStrategy(String name) {
            this._name = name;
        }

        public PhantomSnapshot deal(IRow row) {
            PhantomSnapshot ps = (PhantomSnapshot)row.getUserObject();
            String newName = (String)row.getCell(1).getValue();
            if (!StringUtil.isEmptyString((String)newName) || !StringUtil.isEmptyString((String)newName.trim())) {
                ps.setName(newName.trim());
                return ps;
            }
            return null;
        }

        public String toString() {
            return this._name;
        }
    }

    private static class IgnoreStrategy
    implements TreatmentStrategy {
        private String _name;

        public IgnoreStrategy(String name) {
            this._name = name;
        }

        public PhantomSnapshot deal(IRow row) {
            return null;
        }

        public String toString() {
            return this._name;
        }
    }

    private static interface TreatmentStrategy {
        public PhantomSnapshot deal(IRow var1);
    }
}

