/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.snapshot.manage.client.tree;

import com.kingdee.bos.ctrl.kdf.table.CellTreeNode;
import com.kingdee.bos.ctrl.kdf.util.render.AbstractBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.TextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFont;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.icon.SSIcons;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.mview.SSCellTreeNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;

public class CustomTreeRender
extends AbstractBasicRender {
    private static final Color BACK_GROUND_CLR = new Color(240, 248, 255);
    private static final Color TOP_LEFT_CLR = new Color(160, 168, 192);
    private static final Color RIGHT_BOTTOM_CENTER_CLR = new Color(48, 72, 96);
    private static final Stroke LINE_STROKE = new BasicStroke(1.0f);
    private static final Icon SNAPSHOT_ICON = SSIcons.createIcon("report.png");
    private static final Icon SHORTCUT_ICON = SSIcons.createIcon("shortcut.png");
    private static CustomTreeRender _render;
    private TextRender _textRender = new TextRender();
    private com.kingdee.bos.ctrl.kdf.util.render.icon.Icon _icon = new CustomTreeIcon();

    public static CustomTreeRender getInst() {
        if (_render == null) {
            _render = new CustomTreeRender();
        }
        return _render;
    }

    private CustomTreeRender() {
    }

    public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
        if (object instanceof CellTreeNode) {
            CellTreeNode cell = (CellTreeNode)object;
            String text = cell.getValue() != null ? cell.getValue().toString() : "";
            int level = cell.getTreeLevel();
            Rectangle rect = clip.getBounds();
            int x = rect.x + level * 8;
            int y = rect.y + (rect.height - this._icon.getHeight()) / 2;
            graphics.setColor(Color.BLACK);
            int imageWidth = 0;
            if (cell.isHasChildren()) {
                Styles.HorizontalAlignment hAlign = cellStyle.getHorizontalAlign();
                if (hAlign == Styles.HorizontalAlignment.CENTER && cell.getTreeType() != 0) {
                    Graphics2D g2d = (Graphics2D)graphics;
                    KDFont font = cellStyle.getKDFont();
                    Rectangle2D fontRect = font.getStringBounds(text, g2d.getFontRenderContext());
                    int fontWidth = (int)fontRect.getWidth();
                    if (rect.width > fontWidth) {
                        x = rect.x + level * 8 + this._icon.getWidth() + (rect.width - level * 8 - this._icon.getWidth() - fontWidth) / 2;
                        x -= this._icon.getWidth() * 2;
                    } else {
                        x = rect.x + level * 8;
                    }
                }
                cell.setIconPosition(x, y, this._icon.getWidth());
                if (cell.isCollapse()) {
                    this._icon.paint((Object)new Integer(1), graphics, x, y);
                } else {
                    this._icon.paint((Object)new Integer(2), graphics, x, y);
                }
            } else if (cell.getTreeLevel() == 1 && cell instanceof SSCellTreeNode && ((SSCellTreeNode)cell).getType() != 2) {
                ((CustomTreeIcon)this._icon)._type = ((SSCellTreeNode)cell).getType();
                imageWidth = 16;
                x += imageWidth;
                y = rect.y + (rect.height - 16) / 2;
                if (y < rect.y) {
                    y = rect.y;
                }
                this._icon.paint((Object)new Integer(0), graphics, x, y);
            }
            if (cell.getTreeType() == CellTreeNode.TREE_TYPE_COLUMN) {
                int space = level * 8 + this._icon.getWidth() + imageWidth;
                rect.setRect(x + this._icon.getWidth() + 8, rect.y, rect.getWidth() - (double)space, rect.getHeight());
                this._textRender.draw(graphics, (Shape)rect, text, cellStyle);
            }
        }
    }

    private class CustomTreeIcon
    implements com.kingdee.bos.ctrl.kdf.util.render.icon.Icon {
        int _type = -1;

        protected void drawExpanded(Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            int width = this.getWidth();
            int height = this.getHeight();
            this.drawOutline(g2d, x, y, width, height);
            int lineSize = width - 4;
            g2d.setColor(RIGHT_BOTTOM_CENTER_CLR);
            g.drawLine(x + 2, y + height / 2, x + 2 + lineSize, y + height / 2);
        }

        protected void drawCollapsed(Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            int width = this.getWidth();
            int height = this.getHeight();
            this.drawOutline(g2d, x, y, width, height);
            int lineSize = width - 4;
            g2d.setColor(RIGHT_BOTTOM_CENTER_CLR);
            g.drawLine(x + 2, y + height / 2, x + 2 + lineSize, y + height / 2);
            g.drawLine(x + width / 2, y + 2, x + width / 2, y + lineSize + 2);
        }

        private void drawOutline(Graphics2D g2d, int x, int y, int width, int height) {
            g2d.setColor(BACK_GROUND_CLR);
            g2d.fillRect(x, y, width, height);
            g2d.setColor(TOP_LEFT_CLR);
            g2d.setStroke(LINE_STROKE);
            g2d.drawLine(x + 1, y, x + width - 1, y);
            g2d.drawLine(x, y + 1, x, y + height - 1);
            g2d.setColor(RIGHT_BOTTOM_CENTER_CLR);
            int x2 = x + width;
            int y2 = y + height;
            g2d.drawLine(x2 - width + 1, y2, x2 - 1, y2);
            g2d.drawLine(x2, y2 - height + 1, x2, y2 - 1);
        }

        public int getHeight() {
            return 10;
        }

        public int getWidth() {
            return 10;
        }

        public void paint(Object value, Graphics g, int x, int y) {
            if (value instanceof Integer) {
                int type = (Integer)value;
                if (type == 0) {
                    this.drawLeaf(g, x, y);
                } else if (type == 1) {
                    this.drawCollapsed(g, x, y);
                } else {
                    this.drawExpanded(g, x, y);
                }
            }
        }

        private void drawLeaf(Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            if (this._type == 1) {
                SHORTCUT_ICON.paintIcon(null, g2d, x, y);
            } else if (this._type == 0) {
                SNAPSHOT_ICON.paintIcon(null, g2d, x, y);
            }
        }
    }
}

