/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.snapshot.manage.client.usergroup;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.icon.SSIcons;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.usergroup.CustomListCellRender;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.usergroup.SSUserListUI;
import com.kingdee.eas.base.reportmeta.snapshot.manage.exception.ShortcutMailboxException;
import com.kingdee.eas.base.reportmeta.snapshot.manage.pojo.ug.SSUserInfo;
import com.kingdee.eas.base.reportmeta.snapshot.manage.pojo.ug.UserGroupInfo;
import com.kingdee.eas.base.reportmeta.snapshot.manage.service.mailbox.ISSExpressDeliveryService;
import com.kingdee.eas.base.reportmeta.snapshot.manage.service.mailbox.SSExpressDeliveryService;
import com.kingdee.eas.base.reportmeta.sumreport.client.common.AbstractUILongTask;
import com.kingdee.eas.base.reportmeta.sumreport.util.ExtMsgBox;
import com.kingdee.eas.base.reportmeta.sumreport.util.MixUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SSUserGroupEditUI
extends KDDialog {
    private UserGroupInfo _entity;
    private boolean _cancel;
    private KDList _users;
    private KDTextField _tfName;
    private SSUserListUI _userListUI;
    private KDWorkButton _btnExport;
    private KDWorkButton _btnOK;
    private boolean _update;

    public SSUserGroupEditUI(UserGroupInfo entity, Dialog owner) {
        super(owner, true);
        this._entity = entity;
        this.initUI();
        this.installListeners();
        if (this._entity != null) {
            new UsersLoader((Window)((Object)this), 0){

                public void finished() {
                    super.finished();
                }
            }.start();
        }
    }

    public SSUserGroupEditUI(UserGroupInfo entity, Frame owner) {
        super(owner, true);
        this._entity = entity;
        this.initUI();
        this.installListeners();
        new UsersLoader((Window)((Object)this), 0){

            public void finished() {
                super.finished();
            }
        }.start();
    }

    private void initUI() {
        this.setTitle("\u7528\u6237\u7ec4");
        this.setDefaultCloseOperation(2);
        KDLabelContainer lc = new KDLabelContainer();
        lc.setBoundLabelText("\u7ec4\u540d\uff1a");
        lc.setBoundLabelUnderline(true);
        this._tfName = new KDTextField();
        KDLabel lb = new KDLabel("\u6210\u5458\uff1a");
        this._users = new KDList(new DefaultListModel());
        this._users.setAutoscrolls(true);
        this._users.setCellRenderer((ListCellRenderer)((Object)new CustomListCellRender()));
        KDWorkButton btnImport = new KDWorkButton();
        btnImport.setText("\u6dfb\u52a0");
        btnImport.setIcon((Icon)SSIcons.createIcon("tbtn_New.gif"));
        btnImport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SSUserGroupEditUI.this.actionImport();
            }
        });
        this._btnExport = new KDWorkButton();
        this._btnExport.setText("\u5220\u9664");
        this._btnExport.setIcon((Icon)SSIcons.createIcon("tbtn_Delete.gif"));
        this._btnExport.setEnabled(false);
        this._btnExport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SSUserGroupEditUI.this.actionExport();
            }
        });
        this._btnOK = new KDWorkButton("\u786e\u5b9a");
        this._btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SSUserGroupEditUI.this.actionOK();
            }
        });
        this._btnOK.setEnabled(this._entity != null);
        KDWorkButton btnCancel = new KDWorkButton("\u53d6\u6d88");
        btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SSUserGroupEditUI.this._cancel = true;
                SSUserGroupEditUI.this.dispose();
            }
        });
        TableLayout2 ly = new TableLayout2(7, 4);
        ly.setFixedHeight(new int[]{0, 1, 2, 3, 6}, 21);
        ly.setFixedHeight(5, 3);
        ly.setRatableHeight(4, 200);
        ly.setFixedWidth(new int[]{0, 2, 3}, 74);
        ly.setRatableWidth(1, 100);
        ly.setRowsSpacing(TableLayout2.ALL, 3);
        ly.setRowsSpacing(new int[]{4, 5}, 9);
        ly.setColsSpacing(TableLayout2.ALL, 0);
        ly.setColSpacing(2, 6);
        KDPanel board = new KDPanel((LayoutManager)ly);
        board.setCustomInsets(new Insets(10, 10, 10, 10));
        board.add((Component)lc, (Object)TableLayout2.param((int)0, (int)0));
        board.add((Component)this._tfName, (Object)TableLayout2.param((int)0, (int)1, (int)0, (int)3));
        board.add((Component)lb, (Object)TableLayout2.param((int)1, (int)0));
        board.add((Component)btnImport, (Object)TableLayout2.param((int)2, (int)3));
        board.add((Component)this._btnExport, (Object)TableLayout2.param((int)3, (int)3));
        KDScrollPane userPane = new KDScrollPane((Component)this._users);
        board.add((Component)userPane, (Object)TableLayout2.param((int)2, (int)0, (int)4, (int)2));
        board.add((Component)new KDSeparator(), (Object)TableLayout2.param((int)5, (int)0, (int)5, (int)3));
        board.add((Component)this._btnOK, (Object)TableLayout2.param((int)6, (int)2));
        board.add((Component)btnCancel, (Object)TableLayout2.param((int)6, (int)3));
        this.setContentPane((Container)board);
        this.setSize(300, 415);
    }

    public boolean isCancel() {
        return this._cancel;
    }

    private void installListeners() {
        this._users.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (SSUserGroupEditUI.this._users.getSelectedIndices().length > 0) {
                    SSUserGroupEditUI.this._btnExport.setEnabled(true);
                    return;
                }
                SSUserGroupEditUI.this._btnExport.setEnabled(false);
            }
        });
        this._users.getModel().addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent e) {
                SSUserGroupEditUI.this._update = true;
            }

            public void intervalAdded(ListDataEvent e) {
                SSUserGroupEditUI.this._update = true;
                SSUserGroupEditUI.this._btnOK.setEnabled(true);
            }

            public void intervalRemoved(ListDataEvent e) {
                DefaultListModel model = (DefaultListModel)SSUserGroupEditUI.this._users.getModel();
                SSUserGroupEditUI.this._btnOK.setEnabled(model.getSize() != 0);
                SSUserGroupEditUI.this._update = true;
            }
        });
    }

    private void actionOK() {
        String name = MixUtil.toString(this._tfName.getText()).trim();
        if (StringUtil.isEmptyString((String)name)) {
            ExtMsgBox.showInfo((Component)((Object)this), "\u7ec4\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (this._entity != null && !this._update) {
            if (name.equals(this._entity.getName())) {
                this._update = true;
            } else {
                return;
            }
        }
        UserGroupInfo entity = null;
        entity = this._entity == null ? new UserGroupInfo() : (UserGroupInfo)this._entity.clone();
        entity.setName(name);
        DefaultListModel model = (DefaultListModel)this._users.getModel();
        Object[] items = new SSUserInfo[model.size()];
        model.copyInto(items);
        entity.setItems(Arrays.asList(items));
        try {
            ISSExpressDeliveryService serv = SSExpressDeliveryService.getInst();
            if (this._entity == null) {
                this._entity = serv.saveUserGroup(entity);
            } else {
                entity = serv.saveUserGroup(entity);
                this._entity.setName(entity.getName());
            }
            this._cancel = false;
        }
        catch (ShortcutMailboxException e) {
            ExtMsgBox.showError((Component)((Object)this), "\u7ef4\u62a4\u7528\u6237\u7ec4\u5931\u8d25", e.toString());
            this._cancel = true;
        }
        this.dispose();
    }

    private void actionImport() {
        if (this._userListUI == null) {
            this._userListUI = new SSUserListUI((Dialog)((Object)this));
        }
        this._userListUI.setLocationRelativeTo(null);
        this._userListUI.setVisible(true);
        List lst = this._userListUI.getReturnData();
        if (lst != null) {
            DefaultListModel model = (DefaultListModel)this._users.getModel();
            int size = lst.size();
            for (int i = 0; i < size; ++i) {
                Object obj = lst.get(i);
                if (model.contains(obj)) continue;
                model.addElement(obj);
            }
        }
    }

    private void actionExport() {
        Object[] seleds = this._users.getSelectedValues();
        if (seleds != null && seleds.length > 0) {
            DefaultListModel model = (DefaultListModel)this._users.getModel();
            model.ensureCapacity(seleds.length);
            for (int i = 0; i < seleds.length; ++i) {
                model.removeElement(seleds[i]);
            }
        }
    }

    public boolean isUpdate() {
        return this._update;
    }

    public UserGroupInfo getEntity() {
        return this._entity;
    }

    private class UsersLoader
    extends AbstractUILongTask {
        private Window _window;

        public UsersLoader(Window targetWindow, int mode) {
            super(targetWindow, mode);
            this._window = targetWindow;
        }

        public void doTask() {
            try {
                ISSExpressDeliveryService serv = SSExpressDeliveryService.getInst();
                final List users = serv.queryUsersByGroupID(SSUserGroupEditUI.this._entity.getId());
                if (users == null || users.size() == 0) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DefaultListModel model = (DefaultListModel)SSUserGroupEditUI.this._users.getModel();
                        model.ensureCapacity(users.size());
                        int size = users.size();
                        for (int i = 0; i < size; ++i) {
                            model.addElement(users.get(i));
                        }
                        SSUserGroupEditUI.this._tfName.setText(SSUserGroupEditUI.this._entity.getName());
                    }
                });
            }
            catch (ShortcutMailboxException e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ExtMsgBox.showError(UsersLoader.this._window, "\u52a0\u8f7d\u7528\u6237\u7ec4\u7684\u7528\u6237\u5217\u8868\u5931\u8d25", e.toString());
                    }
                });
            }
        }
    }
}

