/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.base.reportmeta.ctrlreport.adapter.TableManager;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.SumRangeEditUI;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.base.BaseListUI;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.importexport.ExportXML;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.importexport.ImportXML;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.query.SumRangeQueryModel;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.query.SumRangeQueryUI;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.unit.SumUnitManagerUI;
import com.kingdee.eas.base.reportmeta.sumreport.data.SumRangeInfo;
import com.kingdee.eas.base.reportmeta.sumreport.model.DefaultInfo;
import com.kingdee.eas.base.reportmeta.sumreport.model.DefaultInfoHandler;
import com.kingdee.eas.base.reportmeta.sumreport.model.IInfoHandler;
import com.kingdee.eas.base.reportmeta.sumreport.service.SumRangeService;
import com.kingdee.eas.base.reportmeta.sumreport.util.EASUtil;
import com.kingdee.eas.base.reportmeta.sumreport.util.ExtMsgBox;
import com.kingdee.eas.base.reportmeta.sumreport.util.MixUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class SumRangeListUI
extends BaseListUI {
    private static final int COL_CODE = 0;
    private static final int COL_NAME = 1;
    private static final int COL_DISCRIBE = 2;
    private static final int COL_STATUS = 3;
    private static final int COL_STARTTIME = 4;
    private static final int COL_STOPTIME = 5;
    private static final int COL_EDITEDPERSON = 6;
    private static final int COL_EDITEDTIME = 7;
    private static IInfoHandler _infoHandler = new DefaultInfoHandler();
    private KDWorkButton _btnNew;
    private KDWorkButton _btnView;
    private KDWorkButton _btnEdit;
    private KDWorkButton _btnDel;
    private KDWorkButton _btnRefresh;
    private KDWorkButton _btnQuery;
    private KDWorkButton _btnStart;
    private KDWorkButton _btnStop;
    private KDWorkButton _btnSumUnit;
    private KDWorkButton _btnNewVersion;
    private KDWorkButton _btnExport;
    private KDWorkButton _btnImport;
    private SumRangeEditUI _editUI;
    private SumRangeService _service;
    private SumRangeInfo _activeRowData;
    private SumRangeQueryUI _queryUI;

    public SumRangeListUI() throws Exception {
        this.init();
        this.installListeners();
        this.actionRefresh();
    }

    private void installListeners() {
        this._table.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                KDTSelectBlock block = e.getSelectBlock();
                int end = block.getEndRow();
                SumRangeListUI.this._activeRowData = (SumRangeInfo)SumRangeListUI.this._table.getRow(end).getUserObject();
                SumRangeListUI.this._btnEdit.setEnabled(SumRangeListUI.this.isEditable());
                SumRangeListUI.this._btnDel.setEnabled(SumRangeListUI.this.isEditable());
                if (SumRangeListUI.this._activeRowData != null) {
                    SumRangeListUI.this._btnStop.setEnabled(SumRangeListUI.this._activeRowData.getUsingFlag() == 1);
                    SumRangeListUI.this._btnStart.setEnabled(SumRangeListUI.this._activeRowData.getUsingFlag() != 1);
                }
            }
        });
        this._table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton((MouseEvent)e) && (e.getType() == 1 || e.getType() == 2)) {
                    SumRangeListUI.this.actionView();
                    return;
                }
            }
        });
    }

    private void init() {
        this.setUITitle("\u6c47\u603b\u8303\u56f4\u7ba1\u7406");
        BaseListUI.ActionDispatch action = new BaseListUI.ActionDispatch(this);
        this._btnNew = this.initWBTN("\u65b0\u5efa", "imgTbtn_new", action);
        this._btnView = this.initWBTN("\u67e5\u770b", "imgTbtn_view", action);
        this._btnEdit = this.initWBTN("\u4fee\u6539", "imgTbtn_edit", action);
        this._btnDel = this.initWBTN("\u5220\u9664", "imgTbtn_delete", action);
        this._btnRefresh = this.initWBTN("\u5237\u65b0", "imgTbtn_refresh", action);
        this._btnQuery = this.initWBTN("\u67e5\u8be2", "imgTbtn_filter", action);
        this._btnStart = this.initWBTN("\u542f\u7528", "imgTbtn_staruse", action);
        this._btnStop = this.initWBTN("\u505c\u7528", "imgTbtn_forbid", action);
        this._btnSumUnit = this.initWBTN("\u6c47\u603b\u5355\u5143", "imgTbtn_collect", action);
        this._btnNewVersion = this.initWBTN("\u589e\u52a0\u65b0\u7248\u672c", "imgTbtn_copy", action);
        this._btnExport = this.initWBTN("\u5bfc\u51fa", "imgTbtn_output", action);
        this._btnImport = this.initWBTN("\u5bfc\u5165", "imgTbtn_input", action);
        this._service = new SumRangeService();
        this.initTable();
    }

    private void installEditUI(int mode) {
        this._editUI = new SumRangeEditUI((Frame)((KDFrame)ComponentUtil.getCurrentActiveWindow()), this, mode);
        this._editUI.setSize(new Dimension(500, 250));
        this._editUI.setModal(true);
        this._editUI.setDefaultCloseOperation(2);
        this._editUI.setLocationRelativeTo((Component)((Object)this));
        if (mode != 1 && mode != 4 && mode != 3 && !this.isEditable()) {
            this._editUI.addComponentListener(new ComponentAdapter(){

                public void componentShown(ComponentEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SumRangeListUI.this.disableAllCmps((Container)((Object)SumRangeListUI.this._editUI), SumRangeListUI.this._editUI.getCloseBtn());
                        }
                    });
                }
            });
        }
    }

    private void initTable() {
        this._table = new KDTable();
        this._table.addColumns(8);
        this._table.getColumn(0).setWidth(128);
        this._table.getColumn(1).setWidth(128);
        this._table.getColumn(2).setWidth(128);
        this._table.getColumn(3).setWidth(128);
        this._table.getColumn(4).setWidth(128);
        this._table.getColumn(5).setWidth(128);
        this._table.getColumn(6).setWidth(128);
        this._table.getColumn(7).setWidth(128);
        this._table.getColumn(3).setSortable(true);
        IRow header = this._table.addHeadRow();
        this._table.getColumn(0).setSortable(true);
        header.getCell(0).setValue((Object)"\u7f16\u7801");
        header.getCell(1).setValue((Object)"\u540d\u79f0");
        header.getCell(2).setValue((Object)"\u5907\u6ce8");
        header.getCell(3).setValue((Object)"\u72b6\u6001");
        header.getCell(4).setValue((Object)"\u542f\u7528\u65f6\u95f4");
        header.getCell(5).setValue((Object)"\u505c\u7528\u65f6\u95f4");
        header.getCell(6).setValue((Object)"\u4fee\u6539\u4eba");
        header.getCell(7).setValue((Object)"\u4fee\u6539\u65f6\u95f4");
        this._table.setEditable(false);
        this._table.getStyleAttributes().setLocked(true);
        this._table.getSelectManager().setSelectMode(2);
        this._table.getColumn(4).getStyleAttributes().setNumberFormat("yyyy-MM-dd  HH:mm");
        this._table.getColumn(5).getStyleAttributes().setNumberFormat("yyyy-MM-dd  HH:mm");
        this._table.getColumn(7).getStyleAttributes().setNumberFormat("yyyy-MM-dd  HH:mm");
        KDTSortManager sortManager = new KDTSortManager(this._table);
        sortManager.setSortAuto(true);
        this._table.setSortMange(sortManager);
    }

    public void onLoad() throws Exception {
        this.licVerify();
        super.onLoad();
        this.setLayout(new BorderLayout());
        this.add((Component)this._table, "Center");
    }

    public Insets getInsets() {
        return new Insets(10, 10, 10, 10);
    }

    public void initUIToolBarLayout() {
        this.toolBar.add((Component)this._btnNew);
        this.toolBar.add((Component)this._btnView);
        this.toolBar.add((Component)this._btnEdit);
        this.toolBar.add((Component)this._btnDel);
        this.toolBar.add((Component)this._btnRefresh);
        this.toolBar.add((Component)this._btnQuery);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this._btnStart);
        this.toolBar.add((Component)this._btnStop);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this._btnSumUnit);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this._btnNewVersion);
        this.toolBar.add((Component)this._btnExport);
        this.toolBar.add((Component)this._btnImport);
    }

    public void actionSumUnit() {
        SumUnitManagerUI managerUI = new SumUnitManagerUI((KDFrame)ComponentUtil.getCurrentActiveWindow(), this._activeRowData.getId());
        managerUI.setModal(true);
        managerUI.setEnableUI(this.isEditable());
        managerUI.setVisible(true);
    }

    public IMetaDataPK getMetaDataPK() {
        return new MetaDataPK("com.kingdee.eas.base.reportmeta.ctrlreport.client.ReportStudioUI");
    }

    public void actionQuery() {
        if (this._queryUI == null) {
            this._queryUI = new SumRangeQueryUI((Frame)((KDFrame)ComponentUtil.getCurrentActiveWindow()), this);
            this._queryUI.pack();
            this._queryUI.setDefaultCloseOperation(1);
            this._queryUI.setLocationRelativeTo(null);
        }
        this._queryUI.setVisible(true);
    }

    public void actionExport() {
        ArrayList ranges = this.retrieveRanges();
        if (ranges == null || ranges.size() == 0) {
            MsgBox.showWarning((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6c47\u603b\u8303\u56f4");
            return;
        }
        ArrayList<SumRangeInfo> sumRangeInfoList = new ArrayList<SumRangeInfo>(1);
        sumRangeInfoList.add((SumRangeInfo)ranges.get(0));
        ExportXML importExportXML = new ExportXML(sumRangeInfoList, this);
        importExportXML.exportData();
    }

    public void actionImport() {
        ImportXML importXML = new ImportXML(this, (KDFrame)ComponentUtil.getCurrentActiveWindow());
        importXML.importData();
    }

    public void actionNewVersion() {
        this.installEditUI(3);
        this._editUI.setTitle("\u5efa\u7acb\u6c47\u603b\u8303\u56f4\u65b0\u7248\u672c");
        this._editUI.clearUI().requestFocus(3);
        this._editUI.setFlag(SumRangeEditUI.BTN_SAVE);
        this._editUI.setValues((SumRangeInfo)this._activeRowData.clone());
        this._editUI.setMode(3);
        this._editUI.setVisible(true);
    }

    public void actionStop() {
        if (this._activeRowData.getUsingFlag() != 1) {
            ExtMsgBox.showWarning((Component)((Object)this), "\u53ea\u6709\u5df2\u542f\u7528\u7684\u6c47\u603b\u8303\u56f4\u624d\u53ef\u4ee5\u505c\u6b62\uff01");
            return;
        }
        if (ExtMsgBox.showConfirm2("\u786e\u5b9a\u505c\u6b62\u9009\u62e9\u7684\u6c47\u603b\u8303\u56f4\u5417\uff1f") == 2) {
            return;
        }
        ArrayList ranges = this.retrieveRanges();
        try {
            List unstop = this._service.stopSumRange(ranges);
            this.actionRefresh();
            String msg = "\u505c\u6b62\u9009\u62e9\u7684\u6c47\u603b\u8303\u56f4\u6210\u529f\uff01";
            if (unstop.size() > 0) {
                msg = "\u6709\u6b63\u5728\u8fd0\u884c\u7684\u4efb\u52a1\u5f15\u7528\u5230\u8be5\u6c47\u603b\u8303\u56f4\uff0c\u4e0d\u80fd\u505c\u6b62";
            }
            _infoHandler.handleInfoTips(new DefaultInfo(msg));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    protected ArrayList retrieveRangeIDs() {
        ArrayList selectedList = TableManager.getSelectedTableIndexs(this._table);
        ArrayList<String> rangeIDs = new ArrayList<String>();
        int size = selectedList.size();
        for (int i = 0; i < size; ++i) {
            SumRangeInfo item = (SumRangeInfo)this._table.getRow(Integer.parseInt((String)selectedList.get(i))).getUserObject();
            rangeIDs.add(item.getId());
        }
        return rangeIDs;
    }

    protected ArrayList retrieveRanges() {
        ArrayList selectedList = TableManager.getSelectedTableIndexs(this._table);
        ArrayList<SumRangeInfo> rangeIDs = new ArrayList<SumRangeInfo>();
        int size = selectedList.size();
        for (int i = 0; i < size; ++i) {
            SumRangeInfo item = (SumRangeInfo)this._table.getRow(Integer.parseInt((String)selectedList.get(i))).getUserObject();
            rangeIDs.add(item);
        }
        return rangeIDs;
    }

    public void actionDel() {
        if (!this.isEditable()) {
            ExtMsgBox.showInfo((Component)((Object)this), "\u53ea\u6709\u672a\u542f\u7528\u7684\u6c47\u603b\u8303\u56f4\u624d\u53ef\u4ee5\u5220\u9664\uff01");
            return;
        }
        if (ExtMsgBox.showConfirm2("\u786e\u5b9a\u5220\u9664\u9009\u62e9\u7684\u6c47\u603b\u8303\u56f4\u5417\uff1f") == 2) {
            return;
        }
        ArrayList ranges = this.retrieveRanges();
        try {
            this._service.deleteSumRange(ranges);
            this.actionRefresh();
            _infoHandler.handleInfoTips(new DefaultInfo("\u5220\u9664\u9009\u62e9\u7684\u6c47\u603b\u8303\u56f4\u6210\u529f\uff01"));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public void actionView() {
        this.installEditUI(4);
        this._editUI.setTitle("\u67e5\u770b\u6c47\u603b\u8303\u56f4");
        int flag = SumRangeEditUI.TXT_NAME | SumRangeEditUI.TXT_CODE | SumRangeEditUI.TXT_DEC;
        if (this.isEditable()) {
            flag |= SumRangeEditUI.BTN_EDIT;
        }
        this._editUI.clearUI().setValues(this._activeRowData).setFlag(flag);
        this._editUI.setMode(4);
        this._editUI.setVisible(true);
    }

    public void actionStart() {
        if (this._activeRowData.getUsingFlag() == 1) {
            ExtMsgBox.showWarning((Component)((Object)this), "\u5df2\u542f\u7528\u7684\u6c47\u603b\u8303\u56f4\u4e0d\u9700\u8981\u542f\u52a8\uff01");
            return;
        }
        if (ExtMsgBox.showConfirm2("\u786e\u5b9a\u542f\u7528\u9009\u62e9\u7684\u6c47\u603b\u8303\u56f4\u5417\uff1f") == 2) {
            return;
        }
        ArrayList ranges = this.retrieveRanges();
        try {
            this._service.startSumRange(ranges);
            this.actionRefresh();
            _infoHandler.handleInfoTips(new DefaultInfo("\u542f\u52a8\u9009\u62e9\u7684\u6c47\u603b\u8303\u56f4\u6210\u529f\uff01"));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public void actionNew() {
        this.installEditUI(1);
        this._editUI.setTitle("\u589e\u52a0\u6c47\u603b\u8303\u56f4");
        this._editUI.clearUI().requestFocus(2);
        this._editUI.setFlag(1 | SumRangeEditUI.BTN_SAVE);
        this._editUI.setMode(1);
        this._editUI.setVisible(true);
        this._table.getSelectManager().setActiveRowIndex(0);
    }

    protected boolean isEditable() {
        return this._activeRowData == null || this._activeRowData.getUsingFlag() == 0;
    }

    private void disableAllCmps(Container parentUI, Container excluse) {
        Component[] childs;
        if (null != parentUI && null != (childs = parentUI.getComponents()) && childs.length > 0) {
            for (int i = 0; i < childs.length; ++i) {
                Component c = childs[i];
                if (c == excluse) continue;
                c.setEnabled(false);
                this.disableAllCmps((Container)c, excluse);
            }
        }
    }

    public void actionEdit() {
        int activeRow = this._table.getSelectManager().getActiveRowIndex();
        if (!this.isEditable()) {
            ExtMsgBox.showInfo((Component)((Object)this), "\u53ea\u6709\u672a\u542f\u7528\u7684\u6c47\u603b\u8303\u56f4\u624d\u53ef\u4ee5\u4fee\u6539\uff01");
            return;
        }
        this.installEditUI(2);
        this._editUI.setTitle("\u4fee\u6539\u6c47\u603b\u8303\u56f4");
        this._editUI.clearUI().requestFocus(3);
        this._editUI.setFlag(SumRangeEditUI.BTN_EDIT | SumRangeEditUI.BTN_SAVE);
        this._editUI.setValues(this._activeRowData);
        this._editUI.setMode(2);
        this._editUI.setVisible(true);
        this._table.getSelectManager().setActiveRowIndex(activeRow);
    }

    public synchronized void actionRefresh() {
        String localString = EASUtil.gelLoginLocal();
        try {
            List lstData = this._service.queryAllSumRange(localString);
            this._table.removeRows();
            this._activeRowData = null;
            int s = lstData.size();
            for (int i = 0; i < s; ++i) {
                Map rowData = (Map)lstData.get(i);
                SumRangeInfo rowInfo = new SumRangeInfo();
                IRow row = this._table.addRow();
                rowInfo.setId((String)rowData.get("id"));
                row.getCell(0).setValue((Object)rowInfo.setNumber(MixUtil.toString(rowData.get("code"))).getNumber());
                row.getCell(1).setValue((Object)rowInfo.setName(MixUtil.toString(rowData.get("name"))).getName());
                row.getCell(2).setValue((Object)rowInfo.setDes(MixUtil.toString(rowData.get("discribe"))).getDes());
                row.getCell(3).setValue((Object)SumRangeInfo.toString(MixUtil.toString(rowInfo.setUsingFlag(((Number)rowData.get("status")).intValue()).getUsingFlag())));
                String varTime = MixUtil.toString(rowData.get("starttime"));
                if (!StringUtil.isEmptyString((String)varTime)) {
                    row.getCell(4).setValue((Object)varTime);
                    rowInfo.setBeginDate((Timestamp)rowData.get("starttime"));
                }
                if (!StringUtil.isEmptyString((String)(varTime = MixUtil.toString(rowData.get("stoptime"))))) {
                    row.getCell(5).setValue((Object)varTime);
                    rowInfo.setBeginDate((Timestamp)rowData.get("stoptime"));
                }
                if (!StringUtil.isEmptyString((String)(varTime = MixUtil.toString(rowData.get("editedtime"))))) {
                    row.getCell(7).setValue((Object)varTime);
                    rowInfo.setBeginDate((Timestamp)rowData.get("editedtime"));
                }
                row.getCell(6).setValue((Object)MixUtil.toString(rowData.get("editedperson")));
                row.setUserObject((Object)rowInfo);
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private boolean verifySelection() {
        return this._activeRowData != null;
    }

    public void filter(SumRangeQueryModel model) {
        int rowCount = this._table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this._table.getRow(i);
            SumRangeInfo info = (SumRangeInfo)row.getUserObject();
            boolean visible = model.meet(info.getName(), info.getNumber(), info.getUsingFlag());
            row.getStyleAttributes().setHided(!visible);
        }
    }

    public void dispatchAction(ActionEvent e) {
        Object srcO = e.getSource();
        try {
            if (srcO == this._btnNew) {
                this.actionNew();
                return;
            }
            if (srcO == this._btnRefresh) {
                this.actionRefresh();
                return;
            }
            if (srcO == this._btnImport) {
                this.actionImport();
                return;
            }
            if (srcO == this._btnQuery) {
                this.actionQuery();
                return;
            }
            if (!this.verifySelection()) {
                ExtMsgBox.showWarning("\u8bf7\u9009\u62e9\u4e00\u6761\u6c47\u603b\u8303\u56f4");
                return;
            }
            if (srcO == this._btnEdit) {
                this.actionEdit();
            } else if (srcO == this._btnView) {
                this.actionView();
            } else if (srcO == this._btnDel) {
                this.actionDel();
            } else if (srcO == this._btnStart) {
                this.actionStart();
            } else if (srcO == this._btnStop) {
                this.actionStop();
            } else if (srcO == this._btnNewVersion) {
                this.actionNewVersion();
            } else if (srcO == this._btnExport) {
                this.actionExport();
            } else if (srcO == this._btnSumUnit) {
                this.actionSumUnit();
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }
}

