/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.base.reportmeta.ctrlreport.data.ReportSnapType;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.base.BaseListUI;
import com.kingdee.eas.base.reportmeta.sumreport.client.task.TaskDistributeUI;
import com.kingdee.eas.base.reportmeta.sumreport.client.task.statusMgr.StatusManagmentUI;
import com.kingdee.eas.base.reportmeta.sumreport.data.TaskDistributeInfo;
import com.kingdee.eas.base.reportmeta.sumreport.model.StatusEngine;
import com.kingdee.eas.base.reportmeta.sumreport.service.TaskService;
import com.kingdee.eas.base.reportmeta.sumreport.util.ExtMsgBox;
import com.kingdee.eas.base.reportmeta.sumreport.util.MixUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class TaskDistributeListUI
extends BaseListUI {
    private static final int COL_TASK_NUMBER = 0;
    private static final int COL_TASK_NAME = 1;
    private static final int COL_SUM_RANGE = 2;
    private static final int COL_U_TEMPLET_NAME = 3;
    private static final int COL_S_TEMPLET_NAME = 4;
    private static final int COL_U_PERIOD = 5;
    private static final int COL_CREATOR = 6;
    private static final int COL_CREATE_TIME = 7;
    private static final int COL_LAST_UPDATE_TIME = 8;
    private static final int COL_LAST_UPDATE_PERSON = 9;
    private static final int COL_STATUS = 10;
    private KDWorkButton _btnNew;
    private KDWorkButton _btnEdit;
    private KDWorkButton _btnDel;
    private KDWorkButton _btnDetail;
    private KDWorkButton _btnStatusMgr;
    private TaskService _taskSrsv;
    private TaskDistributeInfo _info;
    private Logger _logger = Logger.getLogger(TaskDistributeListUI.class);

    public TaskDistributeListUI() throws Exception {
        this.init();
        this.installListeners();
    }

    public void onLoad() throws Exception {
        this.licVerify();
        super.onLoad();
        this.setLayout(new BorderLayout());
        this.add((Component)this._table, "Center");
        this.refresh();
    }

    private void init() {
        this.setUITitle("\u4efb\u52a1\u5206\u914d");
        this.setPreferredSize(new Dimension(942, 700));
        BaseListUI.ActionDispatch action = new BaseListUI.ActionDispatch(this);
        this._btnNew = this.initWBTN("\u5206\u914d\u4efb\u52a1", "imgTbtn_new", action);
        this._btnEdit = this.initWBTN("\u4fee\u6539", "imgTbtn_edit", action);
        this._btnDel = this.initWBTN("\u5220\u9664", "imgTbtn_delete", action);
        this._btnDetail = this.initWBTN("\u5206\u914d\u660e\u7ec6", "imgTbtn_distributelog", action);
        this._btnStatusMgr = this.initWBTN("\u72b6\u6001\u7ba1\u7406", "imgTbtn_estatechart", action);
        this.initTable();
        this._taskSrsv = new TaskService();
    }

    private void installListeners() {
        this._table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                ArrayList blocks;
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton((MouseEvent)e) && (e.getType() == 1 || e.getType() == 2)) {
                    TaskDistributeListUI.this.actionDetail();
                    return;
                }
                if (e.getClickCount() == 1 && SwingUtilities.isLeftMouseButton((MouseEvent)e) && (e.getType() == 1 || e.getType() == 2) && !(blocks = TaskDistributeListUI.this._table.getSelectManager().getBlocks()).isEmpty()) {
                    KDTSelectBlock block = (KDTSelectBlock)blocks.get(0);
                    int top = block.getTop();
                    int bottom = block.getBottom();
                    if (bottom - top == 0) {
                        TaskDistributeListUI.this._info = (TaskDistributeInfo)TaskDistributeListUI.this._table.getRow(bottom).getUserObject();
                    }
                    boolean enable = TaskDistributeListUI.this._info.getStatus() != 2;
                    TaskDistributeListUI.this._btnEdit.setEnabled(enable);
                    TaskDistributeListUI.this._btnStatusMgr.setEnabled(true);
                }
            }
        });
    }

    private void initTable() {
        this._table = new KDTable();
        this._table.addColumns(11);
        this._table.getColumn(0).setWidth(128);
        this._table.getColumn(0).setSortable(true);
        this._table.getColumn(1).setWidth(128);
        this._table.getColumn(2).setWidth(128);
        this._table.getColumn(3).setWidth(128);
        this._table.getColumn(4).setWidth(128);
        this._table.getColumn(5).setWidth(128);
        this._table.getColumn(6).setWidth(128);
        this._table.getColumn(7).setWidth(128);
        this._table.getColumn(8).setWidth(128);
        this._table.getColumn(9).setWidth(128);
        this._table.getColumn(10).setWidth(64);
        IRow header = this._table.addHeadRow();
        header.getCell(0).setValue((Object)"\u4efb\u52a1\u7f16\u7801");
        header.getCell(1).setValue((Object)"\u4efb\u52a1\u540d\u79f0");
        header.getCell(2).setValue((Object)"\u6c47\u603b\u8303\u56f4");
        header.getCell(3).setValue((Object)"\u4e0a\u62a5\u6a21\u677f\u540d\u79f0");
        header.getCell(4).setValue((Object)"\u6c47\u603b\u6a21\u677f\u540d\u79f0");
        header.getCell(5).setValue((Object)"\u4e0a\u62a5\u5468\u671f");
        header.getCell(6).setValue((Object)"\u521b\u5efa\u4eba");
        header.getCell(7).setValue((Object)"\u5efa\u7acb\u65f6\u95f4");
        header.getCell(8).setValue((Object)"\u4fee\u6539\u65f6\u95f4");
        header.getCell(9).setValue((Object)"\u4fee\u6539\u4eba");
        header.getCell(10).setValue((Object)"\u72b6\u6001");
        this._table.setEditable(false);
        this._table.getStyleAttributes().setLocked(true);
        this._table.getSelectManager().setSelectMode(2);
        this._table.getColumn(7).getStyleAttributes().setNumberFormat("yyyy-MM-dd  HH:mm");
        this._table.getColumn(8).getStyleAttributes().setNumberFormat("yyyy-MM-dd  HH:mm");
        KDTSortManager sortManager = new KDTSortManager(this._table);
        sortManager.setSortAuto(true);
        this._table.setSortMange(sortManager);
    }

    public void initUIToolBarLayout() {
        this.toolBar.add((Component)this._btnNew);
        this.toolBar.add((Component)this._btnEdit);
        this.toolBar.add((Component)this._btnDel);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this._btnDetail);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this._btnStatusMgr);
    }

    public void dispatchAction(ActionEvent e) {
        Object srcO = e.getSource();
        if (srcO == this._btnNew) {
            this.actionNew();
            return;
        }
        if (!this.verifySelection()) {
            ExtMsgBox.showInfo((Component)((Object)this), "\u8bf7\u5148\u9009\u62e9\u4e00\u6761\u4efb\u52a1\u8bb0\u5f55\uff01\u518d\u8fdb\u884c\u64cd\u4f5c\u3002");
            return;
        }
        if (srcO == this._btnEdit) {
            this.actionEdit();
        } else if (srcO == this._btnDel) {
            this.actionDel();
        } else if (srcO == this._btnDetail) {
            this.actionDetail();
        } else if (srcO == this._btnStatusMgr) {
            this.actionStatusMgr();
        }
    }

    public IMetaDataPK getMetaDataPK() {
        return new MetaDataPK("com.kingdee.eas.base.reportmeta.ctrlreport.client.ReportStudioUI");
    }

    private void actionNew() {
        TaskDistributeUI editUI = null;
        Window window = ComponentUtil.getCurrentActiveWindow();
        if (window instanceof KDDialog) {
            editUI = new TaskDistributeUI((KDDialog)window, 1);
        } else if (window instanceof Frame) {
            editUI = new TaskDistributeUI((Frame)window, 1);
        } else {
            return;
        }
        editUI.setOwner(this);
        editUI.pack();
        editUI.setLocationRelativeTo(null);
        editUI.setVisible(true);
    }

    public void refresh() {
        try {
            this._table.removeRows();
            List tasks = this._taskSrsv.queryTasksByOrg();
            int size = tasks.size();
            for (int i = 0; i < size; ++i) {
                Map itemMap = (Map)tasks.get(i);
                IRow row = this._table.addRow();
                row.getCell(7).setValue(itemMap.get("fcreatetime"));
                row.getCell(0).setValue(itemMap.get("fnumber"));
                row.getCell(1).setValue(itemMap.get("task_name"));
                row.getCell(6).setValue(itemMap.get("create_name"));
                row.getCell(4).setValue(itemMap.get("sum_report_name"));
                row.getCell(2).setValue(itemMap.get("range_name"));
                Number period = (Number)itemMap.get("freportperiod");
                row.getCell(5).setValue((Object)ReportSnapType.getDataType(period.intValue()));
                row.getCell(3).setValue(itemMap.get("upload_report_name"));
                row.getCell(9).setValue((Object)MixUtil.toString(itemMap.get("update_person")));
                row.getCell(8).setValue(itemMap.get("flastupdatetime"));
                row.getCell(10).setValue((Object)StatusEngine.getTaskStatus(((Number)itemMap.get("fstatus")).intValue()));
                row.setUserObject((Object)this.box(itemMap));
            }
            this._info = null;
        }
        catch (BOSException e) {
            ExtMsgBox.showError((Component)((Object)this), "\u5237\u65b0\u4efb\u52a1\u5217\u8868\u5931\u8d25", e.getMessage());
        }
    }

    private TaskDistributeInfo box(Map itemMap) {
        TaskDistributeInfo info = new TaskDistributeInfo();
        info.setQueryMap(new HashMap(8));
        info.setId(MixUtil.toString(itemMap.get("fid")));
        info.setNumber(MixUtil.toString(itemMap.get("fnumber")));
        info.setName(MixUtil.toString(itemMap.get("task_name")));
        info.setReportPeriod(((Number)itemMap.get("freportperiod")).intValue());
        info.setSumRangeID(MixUtil.toString(itemMap.get("fsumrangeid")));
        info.setSumRangeName(MixUtil.toString(itemMap.get("range_name")));
        info.setSumReportID(MixUtil.toString(itemMap.get("fsumreportid")));
        info.setSumReportName(MixUtil.toString(itemMap.get("sum_report_name")));
        info.setUpLoadReportID(MixUtil.toString(itemMap.get("fuploadreportid")));
        info.setUpLoadReportName(MixUtil.toString(itemMap.get("upload_report_name")));
        info.setDes(MixUtil.toString(itemMap.get("task_des")));
        info.setWeekBegin(((Number)itemMap.get("fweekbegin")).intValue());
        info.setBeginTime((Timestamp)itemMap.get("fbegindate"));
        info.setEndTime((Timestamp)itemMap.get("fenddate"));
        info.setStatus(((Number)itemMap.get("fstatus")).intValue());
        return info;
    }

    private boolean verifySelection() {
        return this._info != null;
    }

    private void actionEdit() {
        Window window = ComponentUtil.getCurrentActiveWindow();
        final TaskDistributeUI editUI = window instanceof KDDialog ? new TaskDistributeUI((KDDialog)window, 2) : new TaskDistributeUI((Frame)window, 2);
        editUI.setValue(this._info);
        editUI.setOwner(this);
        editUI.setTitle("\u4fee\u6539\u4efb\u52a1");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    editUI.setTaskRunning(TaskDistributeListUI.this._taskSrsv.isTaskRuning(TaskDistributeListUI.this._info.getId()));
                }
                catch (BOSException e) {
                    TaskDistributeListUI.this._logger.warn((Object)"\u786e\u8ba4\u4efb\u52a1\u662f\u5426\u72b6\u6001\u5931\u8d25", e.getCause());
                }
            }
        });
        editUI.pack();
        editUI.setLocationRelativeTo(null);
        editUI.setVisible(true);
    }

    private void actionDel() {
        try {
            if (this._taskSrsv.isTaskRuning(this._info.getId())) {
                ExtMsgBox.showInfo((Component)((Object)this), "\u8fdb\u884c\u4e2d\u7684\u4efb\u52a1\u4e0d\u80fd\u5220\u9664\uff01");
                return;
            }
            if (ExtMsgBox.showConfirm2((Component)((Object)this), "\u786e\u8ba4\u5220\u9664\u8be5\u4efb\u52a1\uff1f") == 0) {
                this._taskSrsv.deleteTask(new TaskDistributeInfo[]{this._info});
                this.refresh();
            }
        }
        catch (BOSException e) {
            this._logger.warn((Object)"\u5220\u9664\u4efb\u52a1\u5931\u8d25\uff01", e.getCause());
            this.handUIException(e);
        }
    }

    private void actionDetail() {
        Window window = ComponentUtil.getCurrentActiveWindow();
        TaskDistributeUI detailUI = window instanceof KDDialog ? new TaskDistributeUI((KDDialog)window, 3) : new TaskDistributeUI((Frame)window, 3);
        detailUI.setValue(this._info);
        detailUI.setOwner(this);
        detailUI.setTitle("\u4efb\u52a1\u8be6\u7ec6");
        detailUI.pack();
        detailUI.setLocationRelativeTo(null);
        detailUI.setVisible(true);
    }

    private void actionStatusMgr() {
        Window window = ComponentUtil.getCurrentActiveWindow();
        StatusManagmentUI statusMgr = window instanceof KDDialog ? new StatusManagmentUI((KDDialog)window) : new StatusManagmentUI((Frame)window);
        statusMgr.setValue(this._info);
        statusMgr.pack();
        statusMgr.setLocationRelativeTo(null);
        statusMgr.setVisible(true);
    }
}

