/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.client.execution;

import com.kingdee.bos.ctrl.common.ui.worker.LongTaskWorker;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.fulfil.ExtGuiExecutor;
import com.kingdee.bos.ctrl.ext.immit.IExtRuntimeDataProvider;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.undo.UndoManager;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.base.reportmeta.base.execution.SnapExecutor;
import com.kingdee.eas.base.reportmeta.ctrlreport.DefineReportInfo;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.ExtCallbackImpl;
import com.kingdee.eas.base.reportmeta.sumreport.client.common.LoadingPanel;
import com.kingdee.eas.base.reportmeta.sumreport.client.execution.ExecutorUIHelper;
import com.kingdee.eas.base.reportmeta.sumreport.client.execution.TransitionLowerUI;
import com.kingdee.eas.base.reportmeta.sumreport.client.execution.action.AbstractAction;
import com.kingdee.eas.base.reportmeta.sumreport.client.icon.UploadSumIcons;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.base.BaseListUI;
import com.kingdee.eas.base.reportmeta.sumreport.data.ExecuteContext;
import com.kingdee.eas.base.reportmeta.sumreport.data.TaskDetailInfo;
import com.kingdee.eas.base.reportmeta.sumreport.exceptions.ExecutorException;
import com.kingdee.eas.base.reportmeta.sumreport.service.ExecutorService;
import com.kingdee.eas.base.reportmeta.sumreport.use.model.ExtCallBackConst;
import com.kingdee.eas.base.reportmeta.sumreport.use.model.RunType;
import com.kingdee.eas.base.reportmeta.sumreport.util.ExtMsgBox;
import com.kingdee.eas.base.reportmeta.sumreport.util.MixUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class SNRRExecutor
extends BaseListUI {
    public static final Integer PROVIDER = new Integer(2);
    public static final Integer ENTITY = new Integer(3);
    public static final Integer TASK_DETAIL_ID = new Integer(1);
    private SnapExecutor _snapExe;
    private ExtGuiExecutor _reportExe;
    private TaskDetailInfo _entity;
    private KDWorkButton _moreBtn;
    private ExecuteContext _ctx;
    private ExecutorService _executorSrsv;
    private TransitionLowerUI _transitionLowerUI;

    private void addSNRToolbar() {
        int state = this._entity.getState();
        this._moreBtn = new KDWorkButton();
        this._moreBtn.setText("\u66f4\u591a");
        ExecutorUIHelper.setUpToolBar(this.toolBar, state, this);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this._moreBtn);
        this.toolBar.addSeparator();
        if (!this._ctx.isUpload()) {
            this.toolBar.add((Action)new TransitionLowerAction());
            this.toolBar.addSeparator();
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this._ctx = new ExecuteContext(this.getUIContext());
        this._entity = this._ctx.getActivityInfo();
        this._executorSrsv = new ExecutorService();
        this.setUITitle(this._entity.getTaskName());
        if (!this.preCheck()) {
            this.abort();
        }
        this.doCustomInitial();
    }

    private boolean preCheck() {
        if (this._entity != null && this._entity.getIdFlag() == 0 && this._ctx.isTemplate()) {
            try {
                String msg = this._executorSrsv.determineChildAState(this._entity);
                if (!StringUtil.isEmptyString((String)msg) && ExtMsgBox.showConfirm2((Component)((Object)this), msg + "\u662f\u5426\u7ee7\u7eed\u751f\u6210\u6c47\u603b\u62a5\u8868 \uff1f") != 0) {
                    return false;
                }
            }
            catch (ExecutorException e) {
                this.handUIException(e);
                return false;
            }
        }
        return true;
    }

    public TaskDetailInfo getValue() {
        return this._entity;
    }

    public ExecuteContext getContext() {
        return this._ctx;
    }

    public Book getBook() {
        return this.getSContext().getSpread().getBook();
    }

    public void commitEdit() {
        this.getSContext().getStateManager().stopEditing();
    }

    private SpreadContext getSContext() {
        SpreadContext sCtx = null;
        sCtx = this._ctx.isTemplate() ? this._reportExe.getSpreadContext() : this._snapExe.getSpreadContext();
        return sCtx;
    }

    public boolean destroyWindow() {
        if (this._transitionLowerUI != null) {
            this._transitionLowerUI.dispose();
        }
        return super.destroyWindow();
    }

    private void doCustomInitial() {
        LongTaskWorker worker = new LongTaskWorker(){

            public Object construct() {
                final SNRRExecutor executor = SNRRExecutor.this;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        executor.setLayout(new BorderLayout());
                        executor.add(new LoadingPanel(), "Center");
                        executor.revalidate();
                    }
                });
                if (!SNRRExecutor.this.load()) {
                    return null;
                }
                try {
                    int i;
                    Action[] actions;
                    boolean result;
                    boolean bl = result = SNRRExecutor.this._ctx.isTemplate() ? SNRRExecutor.this._reportExe.execute() : SNRRExecutor.this._snapExe.execute();
                    if (!result) {
                        executor.getUIWindow().close();
                        return null;
                    }
                    if (SNRRExecutor.this._reportExe != null) {
                        SNRRExecutor.this._reportExe.getSpreadContext().getActionManager().getAction("Copy").setEnabled(true);
                        SNRRExecutor.this._reportExe.getSpreadContext().getActionManager().getAction("Cut").setEnabled(true);
                        SNRRExecutor.this._reportExe.getSpreadContext().getActionManager().getAction("Paste").setEnabled(true);
                        actions = SNRRExecutor.this._reportExe.getContextualActions(3);
                        for (i = 0; i < actions.length; ++i) {
                            actions[i].setEnabled(true);
                        }
                        SNRRExecutor.this._reportExe.getSpreadContext().getBook().getDeps().clearCalcList();
                    } else if (SNRRExecutor.this._snapExe != null) {
                        SNRRExecutor.this._snapExe.getSpreadContext().getActionManager().getAction("Copy").setEnabled(true);
                        SNRRExecutor.this._snapExe.getSpreadContext().getActionManager().getAction("Cut").setEnabled(true);
                        SNRRExecutor.this._snapExe.getSpreadContext().getActionManager().getAction("Paste").setEnabled(true);
                        actions = SNRRExecutor.this._snapExe.getRealExecutor().getContextualActions(3);
                        for (i = 0; i < actions.length; ++i) {
                            actions[i].setEnabled(true);
                        }
                        SNRRExecutor.this._snapExe.getSpreadContext().getBook().getDeps().clearCalcList();
                    }
                    SpreadContext sc = SNRRExecutor.this.getSContext();
                    UndoManager um = sc.getBook().getUndoManager();
                    um.enable(true);
                    InputMap inputMap = sc.getInputMap(2);
                    inputMap.put(KeyStroke.getKeyStroke(90, 128), "Undo");
                    ActionMap actionMap = sc.getActionMap();
                    actionMap.put("Undo", (Action)sc.getActionManager().getAction("Undo"));
                    inputMap.put(KeyStroke.getKeyStroke(89, 128), "Redo");
                    actionMap.put("Redo", (Action)sc.getActionManager().getAction("Redo"));
                    return Boolean.TRUE;
                }
                catch (Exception e) {
                    ExtMsgBox.showError(SNRRExecutor.this.toolBar.getParent(), "\u6267\u884c\u62a5\u8868\u51fa\u9519", e.toString());
                    return null;
                }
            }

            public void finished() {
                Object obj = this.get();
                if (obj != null && obj == Boolean.TRUE) {
                    SNRRExecutor.this.setUpUI();
                }
            }
        };
        worker.start();
    }

    private void setUpUI() {
        Window cr;
        Action[] actions;
        this.addSNRToolbar();
        Action[] actionArray = actions = this._ctx.isTemplate() ? this._reportExe.getContextualActions(5) : this._snapExe.getContextualActions(5);
        if (null != actions) {
            for (int i = 0; i < actions.length - 1; ++i) {
                if (actions[i] instanceof ExtGuiExecutor.SchedularAction) continue;
                this._moreBtn.addAssistMenuItem((Action)new DelegateAction((javax.swing.AbstractAction)actions[i]));
            }
        }
        if (null != (cr = SwingUtilities.getWindowAncestor((Component)((Object)this)))) {
            this.removeAll();
            this.getSContext().getSpread().setEditable(this._ctx.isEditable());
            this.add((Component)this.getSContext(), "Center");
            cr.validate();
            cr.repaint();
        }
    }

    public void dispatchAction(ActionEvent e) {
    }

    public void refreshToolBar() {
        Component[] comps = this.toolBar.getComponents();
        for (int i = comps.length - 1; i >= 0; --i) {
            if (!(comps[i] instanceof AbstractButton) || !(((AbstractButton)comps[i]).getAction() instanceof AbstractAction)) continue;
            this.toolBar.remove(comps[i]);
        }
        ExecutorUIHelper.setUpToolBar(this.toolBar, this._entity.getState(), this);
        this.toolBar.revalidate();
    }

    protected boolean load() {
        try {
            if (this._ctx.isTemplate()) {
                DefineReportInfo info = this._executorSrsv.queryReportTemplateInfo(this._entity.getReportID());
                HashMap<String, Object> sumReported = new HashMap<String, Object>();
                sumReported.put(ExtCallBackConst.TASK_ID, this._entity.getTaskDistributeID());
                sumReported.put(ExtCallBackConst.TASK_ACTIVITY_ID, this._entity.getId());
                sumReported.put(ExtCallBackConst.SUM_PERIOD_BEGIN, MixUtil.getDateFromTimestamp(this._entity.getBeginDate()));
                sumReported.put(ExtCallBackConst.SUM_PERIOD_END, MixUtil.getDateFromTimestamp(this._entity.getEndDate()));
                sumReported.put(ExtCallBackConst.SUM_REPORT_RUN_TYPE, RunType.IN_BIZ);
                sumReported.put(ExtCallBackConst.SUM_UNIT_ORG_ID, this._entity.getUnitOrOrgID());
                this._reportExe = new ExtGuiExecutor(info.getContent(), (IExtRuntimeDataProvider)new ExtCallbackImpl(info, false, true, sumReported), false);
            } else {
                byte[] snapData = this._executorSrsv.queryASnapshotData(this._entity.getId());
                if (snapData == null || snapData.length == 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ExtMsgBox.showInfo((Component)((Object)SNRRExecutor.this), "\u6ca1\u6709\u751f\u6210\u5feb\u7167\uff01");
                            SNRRExecutor.this.getUIWindow().close();
                        }
                    });
                    return false;
                }
                this._snapExe = new SnapExecutor(snapData);
                if (SnapExecutor.isBookEditable(this._snapExe)) {
                    DefineReportInfo info = this._executorSrsv.queryReportTemplateInfo(this._entity.getReportID());
                    this._snapExe.setDataProvider((IExtRuntimeDataProvider)new ExtCallbackImpl(info, false, true));
                }
            }
        }
        catch (Exception e) {
            ExtMsgBox.showError((Component)((Object)this), "\u6267\u884c\u9519\u8bef", e.toString());
        }
        return true;
    }

    private class TransitionLowerAction
    extends javax.swing.AbstractAction {
        public TransitionLowerAction() {
            this.putValue("Name", "\u8054\u67e5\u4e2a\u522b\u62a5\u8868");
            this.putValue("SmallIcon", UploadSumIcons.createIcon("tbtn_Sequencecheck.gif"));
        }

        public void actionPerformed(ActionEvent e) {
            if (SNRRExecutor.this._transitionLowerUI == null) {
                SNRRExecutor.this._transitionLowerUI = new TransitionLowerUI(SNRRExecutor.this);
            }
            SNRRExecutor.this._transitionLowerUI.setVisible(true);
        }
    }

    private class DelegateAction
    extends javax.swing.AbstractAction {
        private javax.swing.AbstractAction _action;

        public DelegateAction(javax.swing.AbstractAction action) {
            this._action = action;
            this.putValue("Name", this._action.getValue("Name"));
            this.putValue("SmallIcon", this._action.getValue("SmallIcon"));
            this.putValue("AcceleratorKey", this._action.getValue("AcceleratorKey"));
        }

        public void actionPerformed(ActionEvent e) {
            this._action.actionPerformed(e);
            SpreadContext comp = SNRRExecutor.this.getSContext();
            if (comp instanceof SpreadContext) {
                comp.getSpread().setEditable(true);
            }
        }
    }
}

