/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.client.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.tree.IEach;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.tree.TreeUtil;
import com.kingdee.eas.base.reportmeta.sumreport.client.task.TaskDistributeUI;
import com.kingdee.eas.base.reportmeta.sumreport.data.SumRangeInfo;
import com.kingdee.eas.base.reportmeta.sumreport.data.SumUnitInfo;
import com.kingdee.eas.base.reportmeta.sumreport.data.SumUnitOrgInfo;
import com.kingdee.eas.base.reportmeta.sumreport.debug.client.task.main.DebugActivityTreeBuilder;
import com.kingdee.eas.base.reportmeta.sumreport.util.ExtMsgBox;
import java.awt.Component;
import java.util.Collection;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

class ActivityTreeBuilder {
    private TaskDistributeUI _taskUI;

    private ActivityTreeBuilder(TaskDistributeUI taskUI) {
        this._taskUI = taskUI;
    }

    public static ActivityTreeBuilder getInst(TaskDistributeUI taskUI) {
        return new ActivityTreeBuilder(taskUI);
    }

    public void build() {
        if (this._taskUI._4debug) {
            this.buildDebugActivityTree();
        } else {
            this.buildFormalActivityTree();
        }
    }

    private void buildFormalActivityTree() {
        SumRangeInfo params = new SumRangeInfo();
        params.setId(this._taskUI._info.getSumRangeID());
        this._taskUI.updateTree(params);
        try {
            this._taskUI._set = this._taskUI._taskSusrv.queryTaskDetailsByTask(this._taskUI._info.getId());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TreeModel treeModel = ((ActivityTreeBuilder)ActivityTreeBuilder.this)._taskUI._view.getTree().getModel();
                    if (treeModel != null) {
                        TreeUtil.depthFirstTravel((DefaultKingdeeTreeNode)treeModel.getRoot(), new IEach(){

                            public void each(DefaultKingdeeTreeNode node) {
                                Object info = node.getUserObject();
                                boolean checked = false;
                                if (info instanceof SumUnitInfo) {
                                    if (((ActivityTreeBuilder)ActivityTreeBuilder.this)._taskUI._set.contains(((SumUnitInfo)info).getId())) {
                                        checked = true;
                                    }
                                } else if (info instanceof SumUnitOrgInfo && ((ActivityTreeBuilder)ActivityTreeBuilder.this)._taskUI._set.contains(((SumUnitOrgInfo)info).getOrgID())) {
                                    checked = true;
                                }
                                node.setChecked(checked);
                            }
                        });
                        ((ActivityTreeBuilder)ActivityTreeBuilder.this)._taskUI._view.getTree().invalidate();
                        ((ActivityTreeBuilder)ActivityTreeBuilder.this)._taskUI._view.getTree().repaint();
                    }
                }
            });
        }
        catch (BOSException e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ExtMsgBox.showError((Component)((Object)ActivityTreeBuilder.this._taskUI), "\u83b7\u53d6\u4efb\u52a1\u660e\u7ec6\u5217\u8868\u5931\u8d25\uff01", e.getCause().toString());
                }
            });
        }
    }

    private void buildDebugActivityTree() {
        try {
            final Collection collection = this._taskUI._taskSusrv.queryTaskDetailsByTask(this._taskUI._info.getId());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DefaultKingdeeTreeNode root = DebugActivityTreeBuilder.build(collection, true);
                    if (root != null) {
                        KingdeeTreeModel treeModel = new KingdeeTreeModel((TreeNode)root);
                        KDTree tree = ((ActivityTreeBuilder)ActivityTreeBuilder.this)._taskUI._view.getTree();
                        tree.setUserObject((Object)"DEBUG ACTIVITY TREE");
                        tree.setModel((TreeModel)treeModel);
                        tree.expandAllNodes(true, (TreeNode)root);
                        ((ActivityTreeBuilder)ActivityTreeBuilder.this)._taskUI._view.invalidate();
                        ((ActivityTreeBuilder)ActivityTreeBuilder.this)._taskUI._view.repaint();
                    }
                }
            });
        }
        catch (BOSException e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ExtMsgBox.showError((Component)((Object)ActivityTreeBuilder.this._taskUI), "\u83b7\u53d6\u4efb\u52a1\u660e\u7ec6\u5217\u8868\u5931\u8d25\uff01");
                }
            });
        }
    }
}

