/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.client.task.algorithm;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.eas.base.reportmeta.ctrlreport.data.ReportSnapType;
import com.kingdee.eas.base.reportmeta.sumreport.client.task.algorithm.PeriodCalculator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class PeriodSettingPanel
extends KDPanel {
    KDComboBox _cbHalfYear;
    KDComboBox _cbQuarter;
    KDComboBox _cbMonth;
    KDComboBox _cbHalfModth;
    KDComboBox _cbWeek;
    KDComboBox _cbWeekBegin;
    KDSpinner _spinYear;
    KDDatePicker _dpDay;
    KDDatePicker _dpFrom;
    KDDatePicker _dpTo;
    ReportSnapType _type;
    TableLayout2 _ply;
    Date _start;
    Date _end;
    KDLabel _attention;
    private PeriodCalculator _calculator;
    private Logger _log = Logger.getLogger(PeriodSettingPanel.class);
    private int _tableLayoutRow;
    private String _notePrefix;

    private PeriodSettingPanel(ReportSnapType type) {
        this._type = type;
        this.init();
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    private PeriodSettingPanel(int type, TableLayout2 ply) {
        this(type, ply, 6, null);
    }

    private PeriodSettingPanel(int type, TableLayout2 ply, int tableLayoutRow, String notePrefix) {
        this._type = ReportSnapType.getDataType(type);
        this._ply = ply;
        this._tableLayoutRow = tableLayoutRow;
        this._notePrefix = notePrefix;
        this.init();
    }

    private KDLabelContainer getLabel(String text) {
        KDLabelContainer lc = new KDLabelContainer();
        lc.setPreferredSize(new Dimension(84, 21));
        lc.setBoundLabelText(text);
        lc.setBoundLabelUnderline(true);
        return lc;
    }

    private KDComboBox getComboBox(Object[] objs) {
        KDComboBox combo = new KDComboBox(objs);
        combo.setPreferredSize(new Dimension(242, 21));
        return combo;
    }

    private void init() {
        block16: {
            int rowCount = 3;
            if (this._type != ReportSnapType.MONTHHALF && this._type != ReportSnapType.WEEK && this._ply != null) {
                this._ply.setFixedHeight(this._tableLayoutRow, 69);
            }
            if (this._type == ReportSnapType.MONTHHALF) {
                if (this._ply != null) {
                    this._ply.setFixedHeight(this._tableLayoutRow, 93);
                }
                rowCount = 4;
            } else if (this._type == ReportSnapType.WEEK) {
                if (this._ply != null) {
                    this._ply.setFixedHeight(this._tableLayoutRow, 117);
                }
                rowCount = 5;
            }
            TableLayout2 ly = new TableLayout2(rowCount, 2);
            ly.setColsSpacing(TableLayout2.ALL, 0);
            ly.setFixedWidth(0, 84);
            ly.setRatableWidth(1, 242);
            ly.setFixedHeight(TableLayout2.ALL, 21);
            ly.setRowsSpacing(TableLayout2.ALL, 3);
            this.setLayout((LayoutManager)ly);
            SuperAction action = new SuperAction();
            if (this._type == ReportSnapType.UNKNOW) {
                this.add((Component)this.getLabel("\u4ece\uff1a"), TableLayout2.param((int)0, (int)0));
                this._dpFrom = new KDDatePicker();
                this._dpFrom.setPreferredSize(new Dimension(242, 21));
                this.add((Component)this._dpFrom, TableLayout2.param((int)0, (int)1));
                this._dpFrom.setDatePattern("yyyy-MM-dd");
                this.add((Component)this.getLabel("\u5230\uff1a"), TableLayout2.param((int)1, (int)0));
                this._dpTo = new KDDatePicker();
                this._dpTo.setPreferredSize(new Dimension(242, 21));
                this._dpTo.setDatePattern("yyyy-MM-dd");
                this.add((Component)this._dpTo, TableLayout2.param((int)1, (int)1));
                this._dpFrom.addDataChangeListener((DataChangeListener)action);
                this._dpTo.addDataChangeListener((DataChangeListener)action);
            }
            if (this._type != ReportSnapType.DAY && this._type != ReportSnapType.UNKNOW) {
                this.add((Component)this.getLabel("\u5e74\uff1a"), TableLayout2.param((int)0, (int)0));
                this._spinYear = new KDSpinner();
                int year = Calendar.getInstance().get(1);
                this._spinYear.setValue((Object)new Integer(year));
                this._spinYear.setPreferredSize(new Dimension(242, 21));
                this._spinYear.addChangeListener((ChangeListener)action);
                this.add((Component)this._spinYear, TableLayout2.param((int)0, (int)1));
            }
            if (this._type == ReportSnapType.YEARHALF) {
                this.add((Component)this.getLabel("\u534a\u5e74\uff1a"), TableLayout2.param((int)1, (int)0));
                this._cbHalfYear = this.getComboBox(new Object[]{"\u4e0a\u534a\u5e74", "\u4e0b\u534a\u5e74"});
                this._cbHalfYear.addActionListener((ActionListener)action);
                this.add((Component)this._cbHalfYear, TableLayout2.param((int)1, (int)1));
            }
            if (this._type == ReportSnapType.QUARTER) {
                this.add((Component)this.getLabel("\u5b63\u5ea6\uff1a"), TableLayout2.param((int)1, (int)0));
                this._cbQuarter = this.getComboBox(new Object[]{"\u7b2c\u4e00\u5b63\u5ea6", "\u7b2c\u4e8c\u5b63\u5ea6", "\u7b2c\u4e09\u5b63\u5ea6", "\u7b2c\u56db\u5b63\u5ea6"});
                this.add((Component)this._cbQuarter, TableLayout2.param((int)1, (int)1));
                this._cbQuarter.addActionListener((ActionListener)action);
            }
            if (this._type == ReportSnapType.MONTH || this._type == ReportSnapType.MONTHHALF || this._type == ReportSnapType.WEEK) {
                this.add((Component)this.getLabel("\u6708\uff1a"), TableLayout2.param((int)1, (int)0));
                this._cbMonth = this.getComboBox(new Object[]{"1\u6708", "2\u6708", "3\u6708", "4\u6708", "5\u6708", "6\u6708", "7\u6708", "8\u6708", "9\u6708", "10\u6708", "11\u6708", "12\u6708"});
                this._cbMonth.addActionListener((ActionListener)action);
                this.add((Component)this._cbMonth, TableLayout2.param((int)1, (int)1));
            }
            if (this._type == ReportSnapType.MONTHHALF) {
                this.add((Component)this.getLabel("\u534a\u6708\uff1a"), TableLayout2.param((int)2, (int)0));
                this._cbHalfModth = this.getComboBox(new Object[]{"\u4e0a\u534a\u6708", "\u4e0b\u534a\u6708"});
                this._cbHalfModth.addActionListener((ActionListener)action);
                this.add((Component)this._cbHalfModth, TableLayout2.param((int)2, (int)1));
            }
            if (this._type == ReportSnapType.WEEK) {
                this.add((Component)this.getLabel("\u5468\uff1a"), TableLayout2.param((int)2, (int)0));
                this._cbWeek = this.getComboBox(new Object[]{"\u7b2c\u4e00\u661f\u671f", "\u7b2c\u4e8c\u661f\u671f", "\u7b2c\u4e09\u661f\u671f", "\u7b2c\u56db\u661f\u671f"});
                this._cbWeek.addActionListener((ActionListener)action);
                this.add((Component)this._cbWeek, TableLayout2.param((int)2, (int)1));
                this.add((Component)this.getLabel("\u5468\u8d77\u59cb\u65e5\uff1a"), TableLayout2.param((int)3, (int)0));
                this._cbWeekBegin = this.getComboBox(new Object[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"});
                this._cbWeekBegin.addActionListener((ActionListener)action);
                this.add((Component)this._cbWeekBegin, TableLayout2.param((int)3, (int)1));
            }
            if (this._type == ReportSnapType.DAY) {
                this.add((Component)this.getLabel("\u65e5\uff1a"), TableLayout2.param((int)0, (int)0));
                this._dpDay = new KDDatePicker();
                this._dpDay.setDatePattern("yyyy-MM-dd");
                this._dpDay.setPreferredSize(new Dimension(242, 21));
                this._dpDay.addDataChangeListener((DataChangeListener)action);
                this.add((Component)this._dpDay, TableLayout2.param((int)0, (int)1));
            }
            this._attention = new KDLabel();
            this._attention.setForeground(Color.RED);
            this._calculator = new PeriodCalculator(this, this._type);
            this._calculator.setNotePrefix(this._notePrefix);
            try {
                this._attention.setText(this._calculator.cal());
                this.add((Component)this._attention, TableLayout2.param((int)(rowCount - 1), (int)0, (int)(rowCount - 1), (int)1));
            }
            catch (ParseException e) {
                if (!this._log.isDebugEnabled()) break block16;
                this._log.debug((Object)"Period Setting Panel ParseException", (Throwable)e);
            }
        }
    }

    public static PeriodSettingPanel getPeriodSettingPanel(ReportSnapType type) {
        return new PeriodSettingPanel(type);
    }

    public static PeriodSettingPanel getPeriodSettingPanel(int type, TableLayout2 ply) {
        return new PeriodSettingPanel(type, ply);
    }

    public static PeriodSettingPanel getPeriodSettingPanel(int type, TableLayout2 ply, int tableLayoutRow, String notePrefix) {
        return new PeriodSettingPanel(type, ply, tableLayoutRow, notePrefix);
    }

    public Date getPeriodFrom() {
        return this._start;
    }

    public void revert(Date from, Date to, int weekBegin) {
        this._start = from;
        this._end = to;
        if (this._cbWeekBegin != null) {
            this._cbWeekBegin.setSelectedIndex(weekBegin, false);
        }
        this._attention.setText(this._calculator.revert());
    }

    public Date getPeriodTo() {
        return this._end;
    }

    public int getWeekBegin() {
        if (this._cbWeekBegin == null) {
            return -1;
        }
        return this._cbWeekBegin.getSelectedIndex();
    }

    public void commitEdit() {
        block2: {
            try {
                this._calculator.cal();
            }
            catch (ParseException e) {
                if (!this._log.isDebugEnabled()) break block2;
                this._log.debug((Object)"Period Setting Panel ParseException", (Throwable)e);
            }
        }
    }

    private class SuperAction
    implements DataChangeListener,
    ChangeListener,
    ActionListener {
        private SuperAction() {
        }

        public void cal() {
            block2: {
                try {
                    PeriodSettingPanel.this._attention.setText(PeriodSettingPanel.this._calculator.cal());
                }
                catch (ParseException e) {
                    if (!PeriodSettingPanel.this._log.isDebugEnabled()) break block2;
                    PeriodSettingPanel.this._log.debug((Object)"Period Setting Panel ParseException", (Throwable)e);
                }
            }
        }

        public void dataChanged(DataChangeEvent eventObj) {
            this.cal();
        }

        public void stateChanged(ChangeEvent e) {
            this.cal();
        }

        public void actionPerformed(ActionEvent e) {
            this.cal();
        }
    }
}

