/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.debug.client.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.base.reportmeta.ctrlreport.data.ReportSnapType;
import com.kingdee.eas.base.reportmeta.sumreport.client.icon.UploadSumIcons;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.base.BaseListUI;
import com.kingdee.eas.base.reportmeta.sumreport.client.task.TaskDistributeUI;
import com.kingdee.eas.base.reportmeta.sumreport.data.TaskDistributeInfo;
import com.kingdee.eas.base.reportmeta.sumreport.debug.client.task.main.DebugTaskMainUI;
import com.kingdee.eas.base.reportmeta.sumreport.debug.client.task.main.action.BuildActivityTreeAction;
import com.kingdee.eas.base.reportmeta.sumreport.debug.model.DebugUserOrgModel;
import com.kingdee.eas.base.reportmeta.sumreport.debug.service.DebugTaskService;
import com.kingdee.eas.base.reportmeta.sumreport.service.inf.ITaskService;
import com.kingdee.eas.base.reportmeta.sumreport.util.EASUtil;
import com.kingdee.eas.base.reportmeta.sumreport.util.ExtMsgBox;
import com.kingdee.eas.util.client.ComponentUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class DebugTaskDistributeListUI
extends BaseListUI {
    private static final int COL_TASK_NUMBER = 0;
    private static final int COL_TASK_NAME = 1;
    private static final int COL_SUM_RANGE = 2;
    private static final int COL_U_TEMPLET_NAME = 3;
    private static final int COL_S_TEMPLET_NAME = 4;
    private static final int COL_U_PERIOD = 5;
    private static final int COL_CREATOR = 6;
    private static final int COL_CREATE_TIME = 7;
    private static final int COL_LAST_UPDATE_TIME = 8;
    private static final int COL_LAST_UPDATE_PERSON = 9;
    private KDWorkButton _btnNew;
    private KDWorkButton _btnEdit;
    private KDWorkButton _btnDel;
    private KDWorkButton _btnDebug;
    private ITaskService _taskSrsv;
    private TaskDistributeInfo _info;
    private Logger _logger = Logger.getLogger(DebugTaskDistributeListUI.class);
    public static final boolean DEBUG = true;
    private Map _debuggers = new HashMap();

    public DebugTaskDistributeListUI() throws Exception {
        this.init();
        this.installListeners();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setLayout(new BorderLayout());
        this.add((Component)this._table, "Center");
        this.refresh();
    }

    public void initUIToolBarLayout() {
        this.toolBar.add((Component)this._btnNew);
        this.toolBar.add((Component)this._btnEdit);
        this.toolBar.add((Component)this._btnDel);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this._btnDebug);
        this.toolBar.addSeparator();
    }

    public void refresh() {
        try {
            this._table.removeRows();
            List tasks = this._taskSrsv.queryTasksByOrg();
            int size = tasks.size();
            for (int i = 0; i < size; ++i) {
                TaskDistributeInfo item = (TaskDistributeInfo)tasks.get(i);
                IRow row = this._table.addRow();
                row.getCell(7).setValue((Object)item.getCreateTime());
                row.getCell(0).setValue((Object)item.getNumber());
                row.getCell(1).setValue((Object)item.getName(EASUtil.gelLoginLocal()));
                row.getCell(6).setValue((Object)item.getCreator());
                row.getCell(4).setValue((Object)item.getSumReportName());
                row.getCell(2).setValue((Object)item.getSumRangeName());
                row.getCell(5).setValue((Object)ReportSnapType.getDataType(item.getReportPeriod()));
                row.getCell(3).setValue((Object)item.getUpLoadReportName());
                row.getCell(9).setValue((Object)item.getUpdatePerson());
                row.getCell(8).setValue((Object)item.getLastUpdateTime());
                row.setUserObject((Object)item);
            }
            this._info = null;
        }
        catch (BOSException e) {
            ExtMsgBox.showError((Component)((Object)this), "\u5237\u65b0\u4efb\u52a1\u5217\u8868\u5931\u8d25", e.getMessage());
        }
    }

    private boolean verifySelection() {
        return this._info != null;
    }

    private void init() {
        this.setUITitle("\u4efb\u52a1\u5206\u914d");
        this.setPreferredSize(new Dimension(942, 700));
        BaseListUI.ActionDispatch action = new BaseListUI.ActionDispatch();
        this._btnNew = this.initWBTN("\u5206\u914d\u4efb\u52a1", "imgTbtn_new", action);
        this._btnEdit = this.initWBTN("\u4fee\u6539", "imgTbtn_edit", action);
        this._btnDel = this.initWBTN("\u5220\u9664", "imgTbtn_delete", action);
        this._btnDebug = this.initWBTN("\u8c03\u8bd5", null, action);
        this._btnDebug.setIcon((Icon)UploadSumIcons.createIcon("tbtn_debug.gif"));
        this.initTable();
        this._taskSrsv = new DebugTaskService();
    }

    private void initTable() {
        this._table = new KDTable();
        this._table.addColumns(10);
        this._table.getColumn(0).setWidth(128);
        this._table.getColumn(0).setSortable(true);
        this._table.getColumn(1).setWidth(128);
        this._table.getColumn(2).setWidth(128);
        this._table.getColumn(3).setWidth(128);
        this._table.getColumn(4).setWidth(128);
        this._table.getColumn(5).setWidth(128);
        this._table.getColumn(6).setWidth(128);
        this._table.getColumn(7).setWidth(128);
        this._table.getColumn(8).setWidth(128);
        this._table.getColumn(9).setWidth(128);
        IRow header = this._table.addHeadRow();
        header.getCell(0).setValue((Object)"\u4efb\u52a1\u7f16\u7801");
        header.getCell(1).setValue((Object)"\u4efb\u52a1\u540d\u79f0");
        header.getCell(2).setValue((Object)"\u6c47\u603b\u8303\u56f4");
        header.getCell(3).setValue((Object)"\u4e0a\u62a5\u6a21\u677f\u540d\u79f0");
        header.getCell(4).setValue((Object)"\u6c47\u603b\u6a21\u677f\u540d\u79f0");
        header.getCell(5).setValue((Object)"\u4e0a\u62a5\u5468\u671f");
        header.getCell(6).setValue((Object)"\u521b\u5efa\u4eba");
        header.getCell(7).setValue((Object)"\u5efa\u7acb\u65f6\u95f4");
        header.getCell(8).setValue((Object)"\u4fee\u6539\u65f6\u95f4");
        header.getCell(9).setValue((Object)"\u4fee\u6539\u4eba");
        this._table.setEditable(false);
        this._table.getStyleAttributes().setLocked(true);
        this._table.getSelectManager().setSelectMode(2);
        this._table.getColumn(7).getStyleAttributes().setNumberFormat("yyyy-MM-dd  HH:mm");
        this._table.getColumn(8).getStyleAttributes().setNumberFormat("yyyy-MM-dd  HH:mm");
        KDTSortManager sortManager = new KDTSortManager(this._table);
        sortManager.setSortAuto(true);
        this._table.setSortMange(sortManager);
    }

    private void installListeners() {
        this._table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                ArrayList blocks;
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton((MouseEvent)e) && e.getType() == 1) {
                    return;
                }
                if (e.getClickCount() == 1 && SwingUtilities.isLeftMouseButton((MouseEvent)e) && (e.getType() == 1 || e.getType() == 2) && !(blocks = DebugTaskDistributeListUI.this._table.getSelectManager().getBlocks()).isEmpty()) {
                    KDTSelectBlock block = (KDTSelectBlock)blocks.get(0);
                    int top = block.getTop();
                    int bottom = block.getBottom();
                    if (bottom - top == 0) {
                        DebugTaskDistributeListUI.this._info = (TaskDistributeInfo)DebugTaskDistributeListUI.this._table.getRow(bottom).getUserObject();
                        DebugTaskDistributeListUI.this.updateBtnsState();
                    }
                }
            }
        });
    }

    private void updateBtnsState() {
        boolean enable = this._debuggers == null ? true : this._debuggers.get(this._info.getId()) == null;
        this._btnEdit.setEnabled(enable);
        this._btnDel.setEnabled(enable);
    }

    public void dispatchAction(ActionEvent e) throws Exception {
        Object srcO = e.getSource();
        if (srcO == this._btnNew) {
            this.actionNew();
            return;
        }
        if (!this.verifySelection()) {
            ExtMsgBox.showInfo((Component)((Object)this), "\u8bf7\u5148\u9009\u62e9\u4e00\u6761\u4efb\u52a1\u8bb0\u5f55\uff01\u518d\u8fdb\u884c\u64cd\u4f5c\u3002");
            return;
        }
        if (srcO == this._btnEdit) {
            this.actionEdit();
        } else if (srcO == this._btnDel) {
            this.actionDel();
        } else if (srcO == this._btnDebug) {
            this.actionDebug();
        }
    }

    private void actionDebug() {
        DebugTaskMainUI debugMainUI = (DebugTaskMainUI)((Object)this._debuggers.get(this._info.getId()));
        if (debugMainUI != null) {
            debugMainUI.setVisible(true);
            return;
        }
        debugMainUI = new DebugTaskMainUI(this._info.getId());
        debugMainUI.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                DebugTaskMainUI ui = (DebugTaskMainUI)((Object)e.getSource());
                if (DebugTaskDistributeListUI.this._debuggers != null) {
                    DebugTaskDistributeListUI.this._debuggers.remove(ui.getTaskID());
                }
                DebugUserOrgModel.clearModel(ui.getTaskID());
                DebugTaskDistributeListUI.this.updateBtnsState();
                ui.removeWindowListener(this);
            }

            public void windowOpened(WindowEvent e) {
                DebugTaskMainUI ui = (DebugTaskMainUI)((Object)e.getSource());
                BuildActivityTreeAction buildTreeAction = new BuildActivityTreeAction(ui);
                buildTreeAction.actionPerformed(null);
            }
        });
        debugMainUI.setVisible(true);
        this._debuggers.put(this._info.getId(), debugMainUI);
        this.updateBtnsState();
    }

    private void actionDel() {
        try {
            if (ExtMsgBox.showConfirm2((Component)((Object)this), "\u786e\u8ba4\u5220\u9664\u8be5\u4efb\u52a1\uff1f") == 0) {
                this._taskSrsv.deleteTask(new TaskDistributeInfo[]{this._info});
                this.refresh();
            }
        }
        catch (BOSException e) {
            this._logger.warn((Object)"\u5220\u9664\u4efb\u52a1\u5931\u8d25\uff01", e.getCause());
            this.handUIException(e);
        }
    }

    private void actionEdit() {
        Window window = ComponentUtil.getCurrentActiveWindow();
        TaskDistributeUI editUI = window instanceof KDDialog ? new TaskDistributeUI((KDDialog)window, 2, true) : new TaskDistributeUI((Frame)window, 2, true);
        editUI.setValue(this._info);
        editUI.setOwner(this);
        editUI.setTitle("\u4fee\u6539\u4efb\u52a1");
        editUI.setTaskRunning(false);
        editUI.pack();
        editUI.setLocationRelativeTo(null);
        editUI.setVisible(true);
    }

    private void actionNew() {
        TaskDistributeUI editUI = null;
        Window window = ComponentUtil.getCurrentActiveWindow();
        if (window instanceof KDDialog) {
            editUI = new TaskDistributeUI((KDDialog)window, 1, true);
        } else if (window instanceof Frame) {
            editUI = new TaskDistributeUI((Frame)window, 1, true);
        } else {
            return;
        }
        editUI.setOwner(this);
        editUI.pack();
        editUI.setLocationRelativeTo(null);
        editUI.setVisible(true);
    }

    public boolean destroyWindow() {
        boolean rsboolean = super.destroyWindow();
        Iterator itor = this._debuggers.keySet().iterator();
        while (itor.hasNext()) {
            DebugTaskMainUI ui = (DebugTaskMainUI)((Object)this._debuggers.get(itor.next()));
            ui.setVisible(false);
            ui.dispose();
        }
        this._debuggers.clear();
        this._debuggers = null;
        DebugUserOrgModel.clearCache();
        return rsboolean;
    }
}

