/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.debug.server.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UID;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.eas.base.reportmeta.sumreport.data.F7VO;
import com.kingdee.eas.base.reportmeta.sumreport.data.SumRangeInfo;
import com.kingdee.eas.base.reportmeta.sumreport.data.SumUnitInfo;
import com.kingdee.eas.base.reportmeta.sumreport.data.SumUnitOrgInfo;
import com.kingdee.eas.base.reportmeta.sumreport.debug.server.IDebugSumRangeBOFacade;
import com.kingdee.eas.base.reportmeta.sumreport.exceptions.SumRangeException;
import com.kingdee.eas.base.reportmeta.sumreport.util.MixUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DebugSumRangeBOFacade
implements IDebugSumRangeBOFacade {
    public String addNewVersion(SumRangeInfo newVO, String oriRangeID, String local) throws SumRangeException {
        List unitLst = newVO.getUnitList();
        List orgLst = newVO.getOrgList();
        String[] sqls = new String[unitLst.size() + orgLst.size() + 1];
        sqls[0] = DebugSumRangeBOFacade.getInsertSumRangeSQL(newVO);
        int start = DebugSumRangeBOFacade.addInsertUnitSQL(sqls, unitLst, 1);
        DebugSumRangeBOFacade.addInsertOrgSQL(sqls, orgLst, start);
        try {
            DbUtil.executeBatchUpdate((String[])sqls);
            return newVO.getName(local);
        }
        catch (SQLException e) {
            throw SumRangeException.wrap(e);
        }
    }

    private static int addInsertUnitSQL(String[] sqls, List unitLst, int start) {
        String prefix = "INSERT INTO T_EXT_DebugSumUnit(FID, FNumber, FLongNumber, FName_l2, FName_l3, FDes_l2, FDes_l3, FParentID, FLevel, FManageOrgID,FSumRangeID,fcreatetime) values ('";
        int prefixLen = prefix.length();
        StringBuffer sqlBuf = new StringBuffer(prefix);
        for (SumUnitInfo info : unitLst) {
            sqlBuf.append(info.getId()).append("','");
            sqlBuf.append(info.getNumber().replaceAll("'", "''")).append("','");
            sqlBuf.append(info.getLongNumber().replaceAll("'", "''")).append("','");
            sqlBuf.append(info.getName("l2").replaceAll("'", "''")).append("','");
            sqlBuf.append(info.getName("l3").replaceAll("'", "''")).append("','");
            sqlBuf.append(info.getDes("l2").replaceAll("'", "''")).append("','");
            sqlBuf.append(info.getDes("l3").replaceAll("'", "''")).append("','");
            sqlBuf.append(info.getParentID()).append("',");
            sqlBuf.append(String.valueOf(info.getLevel())).append(",'");
            sqlBuf.append(MixUtil.toString(info.getManageOrgID())).append("','");
            sqlBuf.append(info.getSumRangeID()).append("',");
            sqlBuf.append("{ts'").append(MixUtil.getDateFromTimestamp(info.getCreateTime())).append("'})");
            sqls[start++] = sqlBuf.toString();
            sqlBuf.delete(prefixLen, sqlBuf.length());
        }
        return start;
    }

    private static int addInsertOrgSQL(String[] sqls, List orgLst, int start) {
        String prefix = "insert into T_EXT_DebugSumUnitOrg(FOrgID, FOrgName,FSumRangeID, FSumUnitID,FCreateTime, FLongNumber) values (";
        int prefixLen = prefix.length();
        StringBuffer sqlBuf = new StringBuffer(prefix);
        for (SumUnitOrgInfo orgInfo : orgLst) {
            sqlBuf.append("'").append(orgInfo.getOrgID()).append("', ");
            sqlBuf.append("'").append(orgInfo.getOrgName()).append("', ");
            sqlBuf.append("'").append(orgInfo.getSumRangeID()).append("', ");
            sqlBuf.append("'").append(orgInfo.getSumUnitID()).append("', ");
            sqlBuf.append("{ts'").append(MixUtil.getDateFromTimestamp(orgInfo.getCreateTime())).append("'}, ");
            sqlBuf.append("'").append(orgInfo.getLongNumber()).append("')");
            sqls[start++] = sqlBuf.toString();
            sqlBuf.delete(prefixLen, sqlBuf.length());
        }
        return start;
    }

    public void deleteSumRange(List rangeIDs) throws SumRangeException {
        String[] sqls = new String[3];
        StringBuffer sqlRangeBuf = new StringBuffer("delete T_EXT_DebugSumRange where fid in (");
        StringBuffer sqlUnitBuf = new StringBuffer("delete T_EXT_DebugSumUnit where FSumRangeID in(");
        StringBuffer sqlOrgBuf = new StringBuffer("delete T_EXT_DebugSumUnitOrg where FSumRangeID in(");
        int size = rangeIDs.size();
        for (int i = 0; i < size; ++i) {
            sqlRangeBuf.append('\'').append(rangeIDs.get(i)).append("',");
            sqlUnitBuf.append('\'').append(rangeIDs.get(i)).append("',");
            sqlOrgBuf.append('\'').append(rangeIDs.get(i)).append("',");
        }
        sqlRangeBuf.setCharAt(sqlRangeBuf.length() - 1, ')');
        sqlUnitBuf.setCharAt(sqlUnitBuf.length() - 1, ')');
        sqlOrgBuf.setCharAt(sqlOrgBuf.length() - 1, ')');
        sqls[0] = sqlRangeBuf.toString();
        sqls[1] = sqlUnitBuf.toString();
        sqls[2] = sqlOrgBuf.toString();
        try {
            DbUtil.executeBatchUpdate((String[])sqls);
        }
        catch (SQLException e) {
            throw SumRangeException.wrap(e);
        }
    }

    public List getRangList(String local) throws SumRangeException {
        ArrayList<SumRangeInfo> arrayList;
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("SELECT s.FID as Id ,s.FNumber as Code , s.FCreatorID as CreatorID,s.FLastUpdateTime as EditedTime,s.FCreateTime as CreateTime,");
        sbSQL.append("s.Fname_").append(local).append(" as Name, ");
        sbSQL.append("s.Fdes_").append(local).append(" as Discribe, ");
        sbSQL.append("u.Fname_").append(local).append(" as EditedPerson,");
        sbSQL.append("u2.Fname_").append(local).append(" as CreatePerson ");
        sbSQL.append("FROM T_EXT_DebugSumRange s LEFT OUTER JOIN t_pm_user u on s.FLastUpdateUserID = u.fid ");
        sbSQL.append(" LEFT OUTER JOIN t_pm_user u2 on s.FCreatorID = u2.fid ");
        sbSQL.append("order by s.fcreatetime desc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((String)sbSQL.toString(), null);
            ArrayList<SumRangeInfo> rsLst = new ArrayList<SumRangeInfo>(rs.size());
            while (rs.next()) {
                SumRangeInfo vo = new SumRangeInfo();
                vo.setId(rs.getString("Id"));
                vo.setName(rs.getString("Name"), local);
                vo.setCreator(rs.getString("CreatorID"));
                vo.setCreatorName(rs.getString("CreatePerson"));
                vo.setLastUpdateUser(rs.getString("EditedPerson"));
                vo.setDes(rs.getString("Discribe"), local);
                vo.setNumber(rs.getString("Code"));
                vo.setCreateTime(rs.getTimestamp("CreateTime"));
                vo.setLastUpdateTime(rs.getTimestamp("EditedTime"));
                rsLst.add(vo);
            }
            arrayList = rsLst;
        }
        catch (SQLException e) {
            try {
                throw SumRangeException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return arrayList;
    }

    public void insertSumRange(SumRangeInfo sumRangeInfo) throws SumRangeException {
        Timestamp createTime = new Timestamp(new Date().getTime());
        sumRangeInfo.setCreateTime(createTime);
        String sql = DebugSumRangeBOFacade.getInsertSumRangeSQL(sumRangeInfo);
        try {
            DbUtil.executeUpdate((String)sql, null);
        }
        catch (SQLException e) {
            throw SumRangeException.wrap(e);
        }
    }

    private static String getInsertSumRangeSQL(SumRangeInfo sumRangeInfo) {
        StringBuffer sqlBuf = new StringBuffer("insert into T_EXT_DebugSumRange(FID, FNumber, FName_l2, FName_l3, FDes_l2, FDes_l3, FCreatorID, FCreateTime) values ('");
        sqlBuf.append(sumRangeInfo.getId()).append("','");
        sqlBuf.append(sumRangeInfo.getNumber().replaceAll("'", "''")).append("','");
        sqlBuf.append(sumRangeInfo.getName("l2").replaceAll("'", "''")).append("','");
        sqlBuf.append(sumRangeInfo.getName("l3").replaceAll("'", "''")).append("','");
        sqlBuf.append(sumRangeInfo.getDes("l2").replaceAll("'", "''")).append("','");
        sqlBuf.append(sumRangeInfo.getDes("l3").replaceAll("'", "''")).append("','");
        sqlBuf.append(sumRangeInfo.getCreator()).append("',");
        sqlBuf.append("{ts'").append(MixUtil.getDateFromTimestamp(sumRangeInfo.getCreateTime())).append("'} )");
        return sqlBuf.toString();
    }

    public boolean isExistRangeName(String id, String name, String local) throws SumRangeException {
        boolean bl;
        Object[] paramObjs;
        StringBuffer sqlBuf = new StringBuffer("SELECT top 1 FID FROM T_EXT_DebugSumRange where ");
        if (StringUtil.isEmptyString((String)id)) {
            sqlBuf.append("fname_").append(local).append(" = ? ");
            paramObjs = new Object[]{name};
        } else {
            sqlBuf.append("fid <> ? and FName_").append(local).append(" = ? ");
            paramObjs = new Object[]{id, name};
        }
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((String)sqlBuf.toString(), (Object[])paramObjs);
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                throw SumRangeException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return bl;
    }

    public boolean isExistRangeNumber(String id, String number) throws SumRangeException {
        boolean bl;
        Object[] paramObjs;
        StringBuffer sqlBuf = new StringBuffer("SELECT top 1 FID FROM T_EXT_DebugSumRange where ");
        if (StringUtil.isEmptyString((String)id)) {
            sqlBuf.append("fnumber = ? ");
            paramObjs = new Object[]{number};
        } else {
            sqlBuf.append("fid <> ? and fnumber = ? ");
            paramObjs = new Object[]{id, number};
        }
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((String)sqlBuf.toString(), (Object[])paramObjs);
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                throw SumRangeException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return bl;
    }

    public void updateSumRange(SumRangeInfo sumRangeInfo) throws SumRangeException {
        Timestamp updateTime = new Timestamp(new Date().getTime());
        sumRangeInfo.setLastUpdateTime(updateTime);
        String sql = "update T_EXT_DebugSumRange set FNumber = ?, FName_l2 = ?, FName_l3 = ?, FDes_l2 = ?, FDes_l3 = ?, FLastUpdateUserID = ?, FLastUpdateTime = ? where FID = ? ";
        Object[] paramObjs = new Object[]{sumRangeInfo.getNumber(), sumRangeInfo.getName("l2"), sumRangeInfo.getName("l3"), sumRangeInfo.getDes("l2"), sumRangeInfo.getDes("l3"), sumRangeInfo.getUpdateUserId(), sumRangeInfo.getLastUpdateTime(), sumRangeInfo.getId()};
        try {
            DbUtil.executeUpdate((String)sql, (Object[])paramObjs);
        }
        catch (SQLException e) {
            throw SumRangeException.wrap(e);
        }
    }

    public IORMModel queryInterface(Class type) throws ORMCoreException {
        return null;
    }

    public List getCurrentOrgUnitListByRangeID(String rangeID, String local) throws SumRangeException {
        ArrayList<SumUnitInfo> arrayList;
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select su.FID as Id, su.FNumber as Number, su.FLongNumber as LongNumber, su.fmanageorgid as ManageOrgId,su.FParentID as ParentId,");
        sbSQL.append(" su.FLevel as Lev,  ");
        sbSQL.append("su.Fname_").append(local).append(" as Name, ");
        sbSQL.append("su.Fdes_").append(local).append(" as Dec ,");
        sbSQL.append("org.Fname_").append(local).append(" as OrgName,");
        sbSQL.append("org.fnumber as OrgNumber ");
        sbSQL.append(" from T_EXT_DebugSumUnit as su left outer join T_ORG_BaseUnit org on su.fmanageorgid=org.fid ");
        sbSQL.append("where su.FSumRangeID = ? ");
        sbSQL.append(" order by su.flevel asc,su.fcreatetime asc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((String)sbSQL.toString(), (Object[])new Object[]{rangeID});
            ArrayList<SumUnitInfo> rsLst = new ArrayList<SumUnitInfo>(rs.size());
            while (rs.next()) {
                SumUnitInfo vo = new SumUnitInfo();
                vo.setId(rs.getString("Id"));
                vo.setNumber(rs.getString("Number"));
                vo.setLongNumber(rs.getString("LongNumber"));
                vo.setManageOrgID(rs.getString("ManageOrgId"));
                vo.setParentID(rs.getString("ParentId"));
                vo.setLevel(rs.getInt("Lev"));
                vo.setName(rs.getString("Name"), local);
                vo.setDes(rs.getString("Dec"), local);
                vo.setManageOrgName(rs.getString("OrgName"));
                vo.setOrgNumber(rs.getString("OrgNumber"));
                rsLst.add(vo);
            }
            arrayList = rsLst;
        }
        catch (SQLException e) {
            try {
                throw SumRangeException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return arrayList;
    }

    public List getOrgListByRangeID(String rangeID, String local) throws SumRangeException {
        ArrayList<SumUnitOrgInfo> arrayList;
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" select so.FOrgID as OrgId, so.FSumRangeID as SumRangeId, so.FSumUnitID as SumUnitId, so.FLongNumber as LongNumber, ");
        sbSQL.append(" org.Fname_").append(local).append(" as OrgName, ");
        sbSQL.append(" org.fnumber as OrgNumber");
        sbSQL.append(" from T_EXT_DebugSumUnitOrg so inner join T_ORG_BaseUnit org on so.FOrgID = org.fid ");
        sbSQL.append(" where so.FSumRangeID = ?");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((String)sbSQL.toString(), (Object[])new Object[]{rangeID});
            ArrayList<SumUnitOrgInfo> rsLst = new ArrayList<SumUnitOrgInfo>(rs.size());
            while (rs.next()) {
                SumUnitOrgInfo vo = new SumUnitOrgInfo();
                vo.setOrgID(rs.getString("OrgId"));
                vo.setSumRangeID(rs.getString("SumRangeId"));
                vo.setSumUnitID(rs.getString("SumUnitId"));
                vo.setOrgNumber(rs.getString("OrgNumber"));
                vo.setOrgName(rs.getString("OrgName"));
                vo.setLongNumber(rs.getString("LongNumber"));
                rsLst.add(vo);
            }
            arrayList = rsLst;
        }
        catch (SQLException e) {
            try {
                throw SumRangeException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return arrayList;
    }

    public List getRangeList4F7(String local) throws SumRangeException {
        StringBuffer sqlBuf = new StringBuffer("SELECT FID, FNUMBER,FNAME_");
        sqlBuf.append(local).append(" AS NAME FROM T_EXT_DEBUGSUMRANGE");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((String)sqlBuf.toString(), null);
            ArrayList<F7VO> rsLst = new ArrayList<F7VO>(rs.size());
            while (rs.next()) {
                F7VO vo = new F7VO();
                vo.setId(rs.getString("FID"));
                vo.setName(rs.getString("NAME"));
                vo.setCode(rs.getString("FNUMBER"));
                rsLst.add(vo);
            }
            return rsLst;
        }
        catch (SQLException e) {
            throw SumRangeException.wrap(e);
        }
    }

    public List getSumRangeUnitList(List sumRangeInfoList) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select range.fnumber as rangeNumber,range.fname_l1 as rangeName_l1,range.fname_l2 as rangeName_l2,").append(" range.fname_l3 as rangeName_l3,range.fdes_l1 as rangefdes_l1,range.fdes_l2 as rangefdes_l2,").append(" range.fdes_l3 as rangefdes_l3,unit.FNumber as unitNumber,unit.FLongNumber,unit.fId as unitId,unit.fparentId,unit.FName_l1 as unitfname_l1,").append(" unit.FName_l2 as unitfname_l2,unit.FName_l3 as unitfname_l3,unit.FDes_l1 as unitfdes_l1,").append(" unit.FDes_l2 as unitfdes_l2,unit.FDes_l3 as unitfdes_l3,unit.FLevel,unit.FManageOrgID,org.fnumber as orgNumber ").append(" from t_ext_debugsumrange range left join t_ext_debugsumunit unit on range.fid=unit.fsumrangeid").append(" left join t_org_baseunit org on unit.fmanageorgid = org.fid ").append(" where range.fnumber in ");
        StringBuffer whereSql = new StringBuffer();
        ArrayList<String> queryValue = new ArrayList<String>();
        SumRangeInfo sumRangeInfo = null;
        for (int i = 0; i < sumRangeInfoList.size(); ++i) {
            whereSql.append("(").append("?").append(",");
            sumRangeInfo = (SumRangeInfo)sumRangeInfoList.get(i);
            queryValue.add(sumRangeInfo.getNumber());
        }
        ArrayList result = null;
        if (whereSql.length() > 0) {
            whereSql.deleteCharAt(whereSql.length() - 1);
            whereSql.append(")");
            sql.append(whereSql);
            sql.append(" order by unit.FLongNumber");
            result = ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sql.toString(), queryValue);
        }
        return result;
    }

    public List getOrgListByRangeID2(String rangeID, String localString) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" select so.FOrgID, so.FSumRangeID, so.FSumUnitID, so.FLongNumber, ");
        sbSQL.append(" org.Fname_").append(localString).append(" as orgname, ");
        sbSQL.append(" org.fnumber as orgnumber");
        sbSQL.append(" from T_EXT_DebugSumUnitOrg so inner join T_ORG_BaseUnit org on so.FOrgID = org.fid ");
        sbSQL.append(" where so.FSumRangeID = ?");
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(rangeID);
        return ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sbSQL.toString(), queryValue);
    }

    public List getSumRangeListByNumber(List sumRangeInfoList) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select range.fnumber as rangeNumber,range.fname_l1 as rangeName_l1,range.fname_l2 as rangeName_l2,").append(" range.fname_l3 as rangeName_l3,range.fdes_l1 as rangefdes_l1,range.fdes_l2 as rangefdes_l2,").append(" range.fdes_l3 as rangefdes_l3").append(" from t_ext_debugsumrange range ").append(" where range.fnumber in ");
        StringBuffer numWhereSql = new StringBuffer();
        StringBuffer nameWhereSql = new StringBuffer();
        ArrayList<String> numQueryValue = new ArrayList<String>();
        ArrayList<String> nameQueryValue = new ArrayList<String>();
        SumRangeInfo sumRangeInfo = null;
        if (sumRangeInfoList.size() > 0) {
            numWhereSql.append("(");
            nameWhereSql.append("  or Range.fname_l2 in (");
        }
        for (int i = 0; i < sumRangeInfoList.size(); ++i) {
            numWhereSql.append("?").append(",");
            nameWhereSql.append("?").append(",");
            sumRangeInfo = (SumRangeInfo)sumRangeInfoList.get(i);
            numQueryValue.add(sumRangeInfo.getNumber());
            nameQueryValue.add(sumRangeInfo.getName());
        }
        ArrayList result = null;
        if (numWhereSql.length() > 0 && nameWhereSql.length() > 0) {
            numWhereSql.deleteCharAt(numWhereSql.length() - 1);
            numWhereSql.append(")");
            nameWhereSql.deleteCharAt(nameWhereSql.length() - 1);
            nameWhereSql.append(")");
            sql.append(numWhereSql);
            sql.append(nameWhereSql);
            numQueryValue.addAll(nameQueryValue);
            result = ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sql.toString(), numQueryValue);
        }
        return result;
    }

    public List getOrgUnitListBaseNumber(List orgList) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select org.fid,org.fnumber,org.fname_l2").append(" from t_org_baseunit org ").append(" where org.fisfreeze = 0 and org.fnumber in ");
        StringBuffer whereSql = new StringBuffer();
        ArrayList queryValue = new ArrayList();
        if (orgList.size() > 0) {
            whereSql.append("(");
        }
        for (int i = 0; i < orgList.size(); ++i) {
            whereSql.append("?").append(",");
            queryValue.add(orgList.get(i));
        }
        ArrayList result = null;
        if (whereSql.length() > 0) {
            whereSql.deleteCharAt(whereSql.length() - 1);
            whereSql.append(")");
            sql.append(whereSql);
            result = ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sql.toString(), queryValue);
        }
        return result;
    }

    public Map batchInsertSumRange(Map sumRangeInfoMap, String curUserId) throws BOSException {
        HashMap<String, String> errorMsgMap = new HashMap<String, String>();
        if (sumRangeInfoMap == null || sumRangeInfoMap.size() == 0) {
            return errorMsgMap;
        }
        StringBuffer errorMsg = new StringBuffer();
        StringBuffer successMsg = new StringBuffer();
        ArrayList<StringBuffer> sumRangeSql = new ArrayList<StringBuffer>();
        ArrayList sumUnitSql = new ArrayList();
        ArrayList sumUnitOrgSql = new ArrayList();
        StringBuffer sql = null;
        Timestamp curTime = new Timestamp(new Date().getTime());
        Iterator iter = sumRangeInfoMap.values().iterator();
        while (iter.hasNext()) {
            sql = new StringBuffer();
            SumRangeInfo sumRangeInfo = (SumRangeInfo)iter.next();
            sumRangeInfo.setId(UID.create((int)44));
            sumRangeInfo.setUpdateUserId(curUserId);
            sumRangeInfo.setCreator(curUserId);
            sumRangeInfo.setCreateTime(curTime);
            sumRangeInfo.setLastUpdateTime(curTime);
            sql.append(" insert into t_ext_debugsumrange(FID, FNumber, FName_l1, FName_l2, FName_l3, FDes_l1, FDes_l2, FDes_l3,").append(" FCreatorID, FCreateTime ").append(" ) values (");
            sql.append("'").append(sumRangeInfo.getId()).append("',");
            sql.append("'").append(sumRangeInfo.getNumber()).append("',");
            sql.append("'").append(sumRangeInfo.getName("l1")).append("',");
            sql.append("'").append(sumRangeInfo.getName("l2")).append("',");
            sql.append("'").append(sumRangeInfo.getName("l3")).append("',");
            sql.append("'").append(sumRangeInfo.getDes("l1")).append("',");
            sql.append("'").append(sumRangeInfo.getDes("l2")).append("',");
            sql.append("'").append(sumRangeInfo.getDes("l3")).append("',");
            sql.append("'").append(sumRangeInfo.getCreator()).append("',");
            sql.append("{ts'").append(MixUtil.getDateFromTimestamp(sumRangeInfo.getCreateTime())).append("'} ) ");
            sumRangeSql.add(sql);
            this.batchInsertSumUnit(sumRangeInfo, errorMsg, sumUnitSql, sumUnitOrgSql);
            if (successMsg.length() == 0) {
                successMsg.append("\u4ee5\u4e0b\u6c47\u603b\u8303\u56f4\u6570\u636e\u5bfc\u5165\u6210\u529f\uff1a\n");
            }
            successMsg.append("   \u6c47\u603b\u8303\u56f4\u7f16\u7801:").append(sumRangeInfo.getNumber()).append("  ");
            successMsg.append("\u6c47\u603b\u8303\u56f4\u540d\u79f0:").append(sumRangeInfo.getName("l2")).append(" \n");
        }
        Context ctx = ServerUtil.getContext();
        sumRangeSql.addAll(sumUnitSql);
        sumRangeSql.addAll(sumUnitOrgSql);
        ExtDBUtil.executeBatch(ctx, sumRangeSql);
        errorMsgMap.put("successMsg", successMsg.toString());
        errorMsgMap.put("errorMsg", errorMsg.toString());
        return errorMsgMap;
    }

    public void batchInsertSumUnit(SumRangeInfo sumRangeInfo, StringBuffer errorMsg, ArrayList sumUnitSql, ArrayList sumUnitOrgSql) throws BOSException {
        List unitList = sumRangeInfo.getUnitList();
        if (unitList == null || unitList.size() == 0) {
            return;
        }
        StringBuffer sql = null;
        HashMap<String, String> unitIdMap = new HashMap<String, String>();
        for (int j = 0; j < unitList.size(); ++j) {
            sql = new StringBuffer();
            SumUnitInfo sumUnitInfo = (SumUnitInfo)unitList.get(j);
            String oldId = sumUnitInfo.getId();
            String oldParentId = sumUnitInfo.getParentID();
            sumUnitInfo.setId(UID.create((int)44));
            if (StringUtil.isEmptyString((String)oldParentId)) {
                sumUnitInfo.setParentID("");
                unitIdMap.put(oldId, sumUnitInfo.getId());
            } else if (unitIdMap.containsKey(oldParentId)) {
                sumUnitInfo.setParentID((String)unitIdMap.get(oldParentId));
                unitIdMap.put(oldId, sumUnitInfo.getId());
            } else {
                if (errorMsg.length() == 0) {
                    errorMsg.append("\u4ee5\u4e0b\u6c47\u603b\u5355\u5143\u627e\u4e0d\u5230\u4e0a\u7ea7\u8282\u70b9\uff0c\u4e0d\u80fd\u5bfc\u5165\uff1a\n");
                }
                errorMsg.append("  \u6c47\u603b\u8303\u56f4\u7f16\u7801\uff1a").append(sumRangeInfo.getNumber()).append("  ");
                errorMsg.append("\u6c47\u603b\u5355\u5143\u7f16\u7801\uff1a").append(sumUnitInfo.getNumber()).append("\n");
                continue;
            }
            sumUnitInfo.setCreateTime(sumRangeInfo.getCreateTime());
            sumUnitInfo.setLastUpdateTime(sumRangeInfo.getCreateTime());
            sql.append(" insert into t_ext_debugsumunit(FID, FNumber, FLongNumber, FName_l1, FName_l2, ").append(" FName_l3, FDes_l1, FDes_l2, FDes_l3, FParentID, FLevel, FManageOrgID,FSumRangeID,fcreatetime) values (");
            sql.append("'").append(sumUnitInfo.getId()).append("',");
            sql.append("'").append(sumUnitInfo.getNumber()).append("',");
            sql.append("'").append(sumUnitInfo.getLongNumber()).append("',");
            sql.append("'").append(sumUnitInfo.getName("l1")).append("',");
            sql.append("'").append(sumUnitInfo.getName("l2")).append("',");
            sql.append("'").append(sumUnitInfo.getName("l3")).append("',");
            sql.append("'").append(sumUnitInfo.getDes("l1")).append("',");
            sql.append("'").append(sumUnitInfo.getDes("l2")).append("',");
            sql.append("'").append(sumUnitInfo.getDes("l3")).append("',");
            sql.append("'").append(sumUnitInfo.getParentID()).append("',");
            sql.append(sumUnitInfo.getLevel()).append(",");
            sql.append("'").append(sumUnitInfo.getManageOrgID()).append("',");
            sql.append("'").append(sumRangeInfo.getId()).append("',");
            sql.append("{ts'").append(MixUtil.getDateFromTimestamp(sumUnitInfo.getCreateTime())).append("'})");
            sumUnitSql.add(sql);
            this.batchInsertSumUnitOrg(sumRangeInfo, sumUnitInfo, sumUnitOrgSql, unitIdMap);
        }
    }

    public void batchInsertSumUnitOrg(SumRangeInfo sumRangeInfo, SumUnitInfo sumUnitInfo, ArrayList sumUnitOrgSql, Map unitIdMap) throws BOSException {
        StringBuffer sql = null;
        List orgList = null;
        orgList = sumRangeInfo.getOrgList();
        if (orgList == null || orgList.size() == 0) {
            return;
        }
        for (int j = 0; j < orgList.size(); ++j) {
            sql = new StringBuffer();
            SumUnitOrgInfo sumUnitOrgInfo = (SumUnitOrgInfo)orgList.get(j);
            if (!unitIdMap.containsKey(sumUnitOrgInfo.getSumUnitID())) continue;
            sumUnitOrgInfo.setSumUnitID((String)unitIdMap.get(sumUnitOrgInfo.getSumUnitID()));
            sumUnitOrgInfo.setSumRangeID(sumRangeInfo.getId());
            sumUnitOrgInfo.setCreateTime(sumRangeInfo.getCreateTime());
            sql.append("insert into T_EXT_DebugSumUnitOrg(FOrgID, FSumRangeID, FSumUnitID,FCreateTime, FOrgName,FLongNumber) values (");
            sql.append("'").append(sumUnitOrgInfo.getOrgID()).append("', ");
            sql.append("'").append(sumUnitOrgInfo.getSumRangeID()).append("', ");
            sql.append("'").append(sumUnitInfo.getId()).append("', ");
            sql.append("{ts'").append(MixUtil.getDateFromTimestamp(sumUnitOrgInfo.getCreateTime())).append("'}, ");
            sql.append("'").append(sumUnitOrgInfo.getOrgName()).append("',");
            sql.append("'").append(sumUnitOrgInfo.getLongNumber()).append("')");
            sumUnitOrgSql.add(sql);
        }
    }
}

