/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.server.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.eas.base.reportmeta.ctrlreport.email.MailInfo;
import com.kingdee.eas.base.reportmeta.ctrlreport.email.SmtpSender;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.eas.base.reportmeta.snapshot.dispatch.util.DispatchCommonUtil;
import com.kingdee.eas.base.reportmeta.sumreport.data.MessageTemplateinfo;
import com.kingdee.eas.base.reportmeta.sumreport.data.TaskDetailInfo;
import com.kingdee.eas.base.reportmeta.sumreport.data.TaskDistributeInfo;
import com.kingdee.eas.base.reportmeta.sumreport.model.StatusEngine;
import com.kingdee.eas.base.reportmeta.sumreport.server.ISumTaskBOFacade;
import com.kingdee.eas.base.reportmeta.sumreport.util.MixUtil;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SumTaskBOFacade
implements ISumTaskBOFacade {
    private static Logger log = LogUtil.getPackageLogger(SumTaskBOFacade.class);

    public List getTaskListByOrgID(String orgID, String localString) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select td.fid,td.fnumber, td.FSumRangeID, td.FUpLoadReportID, td.FSumReportID, td.FReportPeriod,");
        sbSQL.append("td.FOrgID, td.FCreatorID, td.FCreateTime,td.FLastUpdateTime,td.FWeekBegin,td.FBeginDate,td.FendDate,td.fstatus, ");
        sbSQL.append("td.Fname_").append(localString).append(" as task_name, ");
        sbSQL.append("td.FDes_").append(localString).append(" as task_des, ");
        sbSQL.append("sr.Fname_").append(localString).append(" as range_name, ");
        sbSQL.append("ur.Fname_").append(localString).append(" as upload_report_name, ");
        sbSQL.append("sdr.Fname_").append(localString).append(" as sum_report_name, ");
        sbSQL.append("u.Fname_").append(localString).append(" as create_name, ");
        sbSQL.append("up.Fname_").append(localString).append(" as update_person ");
        sbSQL.append("from T_EXT_TaskDistribute td ");
        sbSQL.append("LEFT OUTER JOIN T_EXT_SumRange sr on td.FSumRangeID = sr.fid ");
        sbSQL.append("LEFT OUTER JOIN T_RM_DefineReport ur on td.FUpLoadReportID = ur.fid ");
        sbSQL.append("LEFT OUTER JOIN T_RM_DefineReport sdr on td.FSumReportID = sdr.fid ");
        sbSQL.append("LEFT OUTER JOIN t_pm_user u on td.FCreatorID = u.fid ");
        sbSQL.append("LEFT OUTER JOIN t_pm_user up on td.FUpdatePerson = up.fid ");
        sbSQL.append("where td.FOrgID = ? ");
        sbSQL.append("order by td.FCreateTime desc");
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(orgID);
        return ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sbSQL.toString(), queryValue);
    }

    public List getTaskList(String localString) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select td.fid,td.fnumber, td.FSumRangeID, td.FUpLoadReportID, td.FSumReportID, td.FReportPeriod,");
        sbSQL.append("td.FOrgID, td.FCreatorID, td.FCreateTime,td.FLastUpdateTime,td.FWeekBegin,td.FBeginDate,td.FendDate,td.fstatus, ");
        sbSQL.append("td.Fname_").append(localString).append(" as task_name, ");
        sbSQL.append("td.FDes_").append(localString).append(" as task_des, ");
        sbSQL.append("sr.Fname_").append(localString).append(" as range_name, ");
        sbSQL.append("ur.Fname_").append(localString).append(" as upload_report_name, ");
        sbSQL.append("sdr.Fname_").append(localString).append(" as sum_report_name, ");
        sbSQL.append("u.Fname_").append(localString).append(" as create_name, ");
        sbSQL.append("up.Fname_").append(localString).append(" as update_person ");
        sbSQL.append("from T_EXT_TaskDistribute td ");
        sbSQL.append("LEFT OUTER JOIN T_EXT_SumRange sr on td.FSumRangeID = sr.fid ");
        sbSQL.append("LEFT OUTER JOIN T_RM_DefineReport ur on td.FUpLoadReportID = ur.fid ");
        sbSQL.append("LEFT OUTER JOIN T_RM_DefineReport sdr on td.FSumReportID = sdr.fid ");
        sbSQL.append("LEFT OUTER JOIN t_pm_user u on td.FCreatorID = u.fid ");
        sbSQL.append("LEFT OUTER JOIN t_pm_user up on td.FUpdatePerson = up.fid ");
        sbSQL.append("order by td.FCreateTime desc");
        return ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sbSQL.toString(), null);
    }

    public List getTaskDetailsIDsByTask(String taskID) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select detail.FUnitOrOrgID ");
        sbSQL.append("from T_EXT_TaskDetail detail ");
        sbSQL.append("where detail.FTaskDistributeID = ? ");
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(taskID);
        return ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sbSQL.toString(), queryValue);
    }

    public List getTaskDetailsTree(String sumRangeID, String taskID, String local) throws BOSException {
        StringBuffer sqlBuf = new StringBuffer(530);
        sqlBuf.append("(select '0' as type, u.fid as id ,et.fid as tdid , u.fname_").append(local).append(" as name, u.fparentid as pid, u.flevel as flevel,u.fcreatetime as createtime, et.FState as state,usr.fname_").append(local).append(" as distribute_name, et.FDistributeTime as distribute_time from t_ext_sumunit u").append(" inner join T_EXT_TaskDetail et on u.fid = et.FUnitOrOrgID  left outer join t_pm_user usr on ").append(" usr.fid = et.FDistributorID where u.fsumrangeid= ? and FTaskDistributeID = ? and et.fidflag =0)");
        sqlBuf.append("union all");
        sqlBuf.append("(select '1' as type, uo.forgid as id ,et.fid as tdid , uo.forgname ").append(" as name, uo.fsumunitid as pid, 1000 as flevel, uo.fcreatetime as createtime, et.FState as state, usr.fname_").append(local).append(" as distribute_name, et.FDistributeTime as distribute_time from t_ext_sumunitorg uo ").append("inner join T_EXT_TaskDetail et on uo.forgid = et.FUnitOrOrgID left outer join t_pm_user usr on ").append("usr.fid = et.FDistributorID where uo.fsumrangeid = ? ").append("and FTaskDistributeID = ? and et.fidflag = 1 ) order by flevel asc,createtime asc");
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(sumRangeID);
        queryValue.add(taskID);
        queryValue.add(sumRangeID);
        queryValue.add(taskID);
        return ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sqlBuf.toString(), queryValue);
    }

    public void insertTask(TaskDistributeInfo taskInfo) throws BOSException {
        ArrayList<String> lstTotalSQL = new ArrayList<String>();
        lstTotalSQL.add(SumTaskBOFacade.getInsertTaskDistributeSQL(taskInfo));
        Timestamp now = new Timestamp(new Date().getTime());
        List detailList = taskInfo.getDetailList();
        for (TaskDetailInfo detailInfo : detailList) {
            detailInfo.setDistributeTime(now);
            lstTotalSQL.add(SumTaskBOFacade.getInsertTaskDetailSQL(detailInfo));
        }
        ExtDBUtil.executeBatch(ServerUtil.getContext(), lstTotalSQL);
    }

    private static final String getInsertTaskDistributeSQL(TaskDistributeInfo taskInfo) {
        String createTime = CtrlReportUtil.getDateFromTimestamp(new Timestamp(new Date().getTime()));
        String periodBeginTime = CtrlReportUtil.getDateFromTimestamp(taskInfo.getBeginTime());
        String periodEndTime = CtrlReportUtil.getDateFromTimestamp(taskInfo.getEndTime());
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("insert into T_EXT_TaskDistribute(FID,FSumRangeID,FName_l2,FName_l3,FDes_l2,FDes_l3,FUpLoadReportID,");
        sbSQL.append("FSumReportID,FReportPeriod,FOrgID,FCreatorID,FCreateTime,FBeginDate,FendDate,fnumber) values (");
        sbSQL.append("'").append(taskInfo.getId()).append("', ");
        sbSQL.append("'").append(taskInfo.getSumRangeID()).append("', ");
        sbSQL.append("'").append(taskInfo.getName("l2").replaceAll("'", "''")).append("', ");
        sbSQL.append("'").append(taskInfo.getName("l2").replaceAll("'", "''")).append("', ");
        sbSQL.append("'").append(taskInfo.getDes("l2").replaceAll("'", "''")).append("', ");
        sbSQL.append("'").append(taskInfo.getDes("l3").replaceAll("'", "''")).append("', ");
        sbSQL.append("'").append(taskInfo.getUpLoadReportID()).append("', ");
        sbSQL.append("'").append(taskInfo.getSumReportID()).append("', ");
        sbSQL.append("").append(taskInfo.getReportPeriod()).append(", ");
        sbSQL.append("'").append(taskInfo.getOrgID()).append("', ");
        sbSQL.append("'").append(taskInfo.getCreator()).append("', ");
        sbSQL.append("{ts'").append(createTime).append("'},");
        sbSQL.append("{ts'").append(periodBeginTime).append("'},");
        sbSQL.append("{ts'").append(periodEndTime).append("'},'");
        sbSQL.append(taskInfo.getNumber().replaceAll("'", "''")).append("'");
        sbSQL.append(")");
        return sbSQL.toString();
    }

    public boolean isExistTaskNumberAndName(String fid, String fnumber, String name) throws BOSException {
        HashMap map;
        ArrayList<String> queryValue = new ArrayList<String>();
        StringBuffer sbSQL = new StringBuffer();
        if (fid == null || fid.length() == 0) {
            sbSQL.append("SELECT top 1 FID FROM T_EXT_TaskDistribute WHERE (fnumber = ? or fname_l2 = ?) ");
            queryValue.add(fnumber);
            queryValue.add(name);
        } else {
            sbSQL.append("SELECT top 1 FID FROM T_EXT_TaskDistribute WHERE fid <> ? AND (fnumber = ? or fname_l2 = ? )");
            queryValue.add(fid);
            queryValue.add(fnumber);
            queryValue.add(name);
        }
        Context ctx = ServerUtil.getContext();
        if (ctx != null) {
            OrgUnitInfo info = ContextUtil.getCurrentOrgUnit((Context)ctx);
            String orgid = info.getId().toString();
            sbSQL.append(" AND FOrgID = ?");
            queryValue.add(orgid);
        }
        return !(map = ExtDBUtil.getResultMapBySql(ctx, sbSQL.toString(), queryValue)).isEmpty();
    }

    private static final String getUpdateTaskDistributeSQL(TaskDistributeInfo taskInfo) {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("update T_EXT_TaskDistribute set ");
        sbSQL.append("fnumber = '").append(taskInfo.getNumber().replaceAll("'", "''")).append("', ");
        sbSQL.append("FName_l2 = '").append(taskInfo.getName("l2").replaceAll("'", "''")).append("', ");
        sbSQL.append("FName_l3 = '").append(taskInfo.getName("l3").replaceAll("'", "''")).append("', ");
        sbSQL.append("FDES_L2 = '").append(taskInfo.getDes("l2").replaceAll("'", "''")).append("', ");
        sbSQL.append("FDES_L3 = '").append(taskInfo.getDes("l3").replaceAll("'", "''")).append("', ");
        sbSQL.append("fbegindate = {ts'").append(MixUtil.getDateFromTimestamp(taskInfo.getBeginTime())).append("'}, ");
        sbSQL.append("fenddate = {ts'").append(MixUtil.getDateFromTimestamp(taskInfo.getEndTime())).append("'}, ");
        sbSQL.append("FLASTUPDATETIME ={ts' ").append(MixUtil.getDateFromTimestamp(taskInfo.getLastUpdateTime())).append("'}, ");
        sbSQL.append("FUPDATEPERSON = '").append(taskInfo.getUpdatePerson()).append("', ");
        sbSQL.append("FUpLoadReportID = '").append(taskInfo.getUpLoadReportID()).append("', ");
        sbSQL.append("FSumReportID = '").append(taskInfo.getSumReportID()).append("', ");
        sbSQL.append("FReportPeriod = ").append(taskInfo.getReportPeriod()).append(",");
        sbSQL.append("FWeekBegin = ").append(taskInfo.getWeekBegin()).append("");
        sbSQL.append("where FID = '").append(taskInfo.getId()).append("'");
        return sbSQL.toString();
    }

    private static final String getUpdateTaskDetailUpLoadTemplate(TaskDistributeInfo taskInfo) {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("update T_EXT_TaskDetail set FReportID= '");
        sbSQL.append(taskInfo.getUpLoadReportID()).append("'");
        sbSQL.append(" where FTaskDistributeID = '");
        sbSQL.append(taskInfo.getId()).append("' and fidflag = 1");
        return sbSQL.toString();
    }

    private static String getUpdateTaskDetailSumTemplate(TaskDistributeInfo taskInfo) {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("update T_EXT_TaskDetail set FReportID= '");
        sbSQL.append(taskInfo.getSumReportID()).append("'");
        sbSQL.append(" where FTaskDistributeID = '");
        sbSQL.append(taskInfo.getId()).append("' and fidflag = 0");
        return sbSQL.toString();
    }

    private static String getInsertTaskDetailSQL(TaskDetailInfo detailInfo) {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("insert into T_EXT_TaskDetail(FID,FTaskDistributeID,FUnitOrOrgID,FIDFlag,FState,FDistributorID,FDistributeTime,");
        sbSQL.append(" FReportID)values('");
        sbSQL.append(detailInfo.getId()).append("','").append(detailInfo.getTaskDistributeID()).append("','").append(detailInfo.getUnitOrOrgID()).append("',").append(detailInfo.getIdFlag()).append(",0,'").append(detailInfo.getDistributorID()).append("',{ts'").append(MixUtil.getDateFromTimestamp(detailInfo.getDistributeTime())).append("'},'").append(detailInfo.getReportID()).append("'");
        sbSQL.append(")");
        return sbSQL.toString();
    }

    public boolean isTaskRunning(String taskID) throws BOSException {
        String sql = "select top 1 FID from T_EXT_TaskDetail where FTaskDistributeID = ? and FState  in (1,2,3,4)";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(taskID);
        HashMap map = ExtDBUtil.getResultMapBySql(ServerUtil.getContext(), sql, queryValue);
        return !map.isEmpty();
    }

    public boolean isCanChangeTempletType(String reportID) {
        String sql = "select top 1 FID from T_EXT_TaskDetail where FReportID = ?";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(reportID);
        try {
            HashMap map = ExtDBUtil.getResultMapBySql(ServerUtil.getContext(), sql, queryValue);
            return map.isEmpty();
        }
        catch (BOSException e) {
            return false;
        }
    }

    public boolean isMakeReport(String reportID) {
        String sql = "select top 1 FID from T_EXT_TaskDetail where FReportID = ? and FState in (0,1,2,3,4)";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(reportID);
        try {
            HashMap map = ExtDBUtil.getResultMapBySql(ServerUtil.getContext(), sql, queryValue);
            return !map.isEmpty();
        }
        catch (BOSException e) {
            return false;
        }
    }

    public static final TaskDistributeInfo getTaskInfoByID(Context ctx, String taskID, String localString, boolean isSearchDetail) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select td.FID, td.FSumRangeID, td.FUpLoadReportID, td.FSumReportID, td.FReportPeriod ");
        sbSQL.append("td.Fname_").append(localString).append(" as task_name, ");
        sbSQL.append("ur.Fname_").append(localString).append(" as upload_report_name, ");
        sbSQL.append("sr.Fname_").append(localString).append(" as sum_report_name, ");
        sbSQL.append("from T_EXT_TaskDistribute td ");
        sbSQL.append("LEFT OUTER JOIN T_RM_DefineReport ur on td.FUpLoadReportID = ur.fid ");
        sbSQL.append("LEFT OUTER JOIN T_RM_DefineReport sr on td.FSumReportID = sr.fid ");
        sbSQL.append("LEFT OUTER JOIN t_pm_user u on td.FCreatorID = u.fid ");
        sbSQL.append("where td.FID = ? ");
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(taskID);
        TaskDistributeInfo distrubuteInfo = null;
        HashMap map = ExtDBUtil.getResultMapBySql(ctx, sbSQL.toString(), queryValue);
        if (!map.isEmpty()) {
            distrubuteInfo = new TaskDistributeInfo();
            distrubuteInfo.setId(taskID);
            distrubuteInfo.setMultiLangItem("name", CtrlReportUtil.getObjectString(map.get("fname_l2")), "l2");
            distrubuteInfo.setMultiLangItem("name", CtrlReportUtil.getObjectString(map.get("fname_l3")), "l3");
            distrubuteInfo.setMultiLangItem("des", CtrlReportUtil.getObjectString(map.get("fname_l2")), "l2");
            distrubuteInfo.setMultiLangItem("des", CtrlReportUtil.getObjectString(map.get("fname_l3")), "l3");
            distrubuteInfo.setSumRangeID(CtrlReportUtil.getObjectString(map.get("fsumrangeid")));
            distrubuteInfo.setUpLoadReportID(CtrlReportUtil.getObjectString(map.get("fupLoadreportid")));
            distrubuteInfo.setUpLoadReportName(CtrlReportUtil.getObjectString(map.get("upload_report_name")));
            distrubuteInfo.setSumReportID(CtrlReportUtil.getObjectString(map.get("fsumreportid")));
            distrubuteInfo.setSumReportName(CtrlReportUtil.getObjectString(map.get("sum_report_name")));
            distrubuteInfo.setReportPeriod(Integer.parseInt(CtrlReportUtil.getObjectString(map.get("freportperiod"))));
            if (isSearchDetail) {
                distrubuteInfo.setDetailList(SumTaskBOFacade.getTaskDetailListByTaskID(taskID, localString));
            }
        }
        return distrubuteInfo;
    }

    public static final List getTaskDetailListByTaskID(String taskID, String localString) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select detail.FID, detail.FUnitOrOrgID, detail.FIDFlag,").append("detail.FState, detail.FDistributorID, detail.FDistributeTime, ");
        sbSQL.append("case when detail.FIDFlag == 0 then select org.number from T_ORG_BaseUnit org where org.fid=detail.FUnitOrOrgID ");
        sbSQL.append("else select unit.number from T_EXT_SumUnit unit where unit.fid=detail.FUnitOrOrgID end as unit_org_number, ");
        sbSQL.append("case when detail.FIDFlag == 0 then select org.Fname_").append(localString).append(" from T_ORG_BaseUnit org where org.fid=detail.FUnitOrOrgID ");
        sbSQL.append("else select unit.Fname_").append(localString).append(" from T_EXT_SumUnit unit where unit.fid=detail.FUnitOrOrgID end as unit_org_name, ");
        sbSQL.append("u.Fname_").append(localString).append(" as distributor_name ");
        sbSQL.append("from T_EXT_TaskDetail detail ");
        sbSQL.append("LEFT OUTER JOIN t_pm_user u on detail.FDistributorID = u.fid ");
        sbSQL.append("where detail.FTaskDistributeID = ? ");
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(taskID);
        return ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sbSQL.toString(), queryValue);
    }

    private static final String getDelTaskDetailSQL(String taskID, String unitOrOrgID) {
        String sql = "delete T_EXT_TaskDetail where FTaskDistributeID = '" + taskID + "' and FUnitOrOrgID = '" + unitOrOrgID + "'";
        return sql;
    }

    private static final String getDelSnapSQL(String taskID, String unitOrOrgID) {
        String sql = "delete T_RM_ReportSnap where FTaskDistributeID = '" + taskID + "' and FOrgID = '" + unitOrOrgID + "'";
        return sql;
    }

    private static final String getDelSnapByteSQL(String taskID, String unitOrOrgID) {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("delete T_EXT_SNAPSHOTDATA where FID in (select fid from T_RM_ReportSnap where FTaskDistributeID = ");
        sbSQL.append("'").append(taskID).append("' ");
        sbSQL.append("and FOrgID = '").append(unitOrOrgID).append("')");
        return sbSQL.toString();
    }

    private static final String getUpdateTaskDetailStatus(String distributor, String distributedTime, String unitOrOrgID, String taskID) {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("update t_ext_taskdetail set FDistributorID = '").append(distributor).append("'");
        sbSQL.append(",  FDistributeTime = {ts'").append(distributedTime).append("'}");
        sbSQL.append(",FState = 0, FMakerID = null, FMakeTime = null, FApproverID = null,FApproveTime = null,FUploadUserID = null,");
        sbSQL.append("FUploadTime = null ");
        sbSQL.append(" where FUnitOrOrgID = '").append(unitOrOrgID).append("' and FTaskDistributeID ='");
        sbSQL.append(taskID).append("'");
        return sbSQL.toString();
    }

    public void updateTask(TaskDistributeInfo taskInfo, Set updateSet, List insertDetailInfos, List delDetailInfos) throws BOSException {
        int i;
        String taskID = taskInfo.getId();
        ArrayList<String> lstTotalSQL = new ArrayList<String>();
        Timestamp now = new Timestamp(new Date().getTime());
        taskInfo.setLastUpdateTime(now);
        lstTotalSQL.add(SumTaskBOFacade.getUpdateTaskDistributeSQL(taskInfo));
        Iterator itor = updateSet.iterator();
        String distributor = taskInfo.getUpdatePerson();
        String distributedTime = MixUtil.getToDay();
        while (itor.hasNext()) {
            String unitOrOrgID = (String)itor.next();
            lstTotalSQL.add(SumTaskBOFacade.getUpdateTaskDetailStatus(distributor, distributedTime, unitOrOrgID, taskID));
            lstTotalSQL.add(SumTaskBOFacade.getDelSnapByteSQL(taskID, unitOrOrgID));
            lstTotalSQL.add(SumTaskBOFacade.getDelSnapSQL(taskID, unitOrOrgID));
        }
        int size = insertDetailInfos.size();
        for (i = 0; i < size; ++i) {
            TaskDetailInfo detailInfo = (TaskDetailInfo)insertDetailInfos.get(i);
            detailInfo.setTaskDistributeID(taskID);
            detailInfo.setDistributeTime(now);
            lstTotalSQL.add(SumTaskBOFacade.getInsertTaskDetailSQL(detailInfo));
        }
        size = delDetailInfos.size();
        for (i = 0; i < size; ++i) {
            String unitOrOrgID = (String)delDetailInfos.get(i);
            lstTotalSQL.add(SumTaskBOFacade.getDelSnapByteSQL(taskID, unitOrOrgID));
            lstTotalSQL.add(SumTaskBOFacade.getDelSnapSQL(taskID, unitOrOrgID));
            lstTotalSQL.add(SumTaskBOFacade.getDelTaskDetailSQL(taskID, unitOrOrgID));
        }
        lstTotalSQL.trimToSize();
        ExtDBUtil.executeBatch(ServerUtil.getContext(), lstTotalSQL);
    }

    public void updateTask(TaskDistributeInfo taskInfo, List insertDetailInfos, List delDetailInfos) throws BOSException {
        int i;
        String taskID = taskInfo.getId();
        ArrayList<String> lstTotalSQL = new ArrayList<String>();
        Timestamp now = new Timestamp(new Date().getTime());
        taskInfo.setLastUpdateTime(now);
        lstTotalSQL.add(SumTaskBOFacade.getUpdateTaskDistributeSQL(taskInfo));
        lstTotalSQL.add(SumTaskBOFacade.getUpdateTaskDetailSumTemplate(taskInfo));
        lstTotalSQL.add(SumTaskBOFacade.getUpdateTaskDetailUpLoadTemplate(taskInfo));
        int size = insertDetailInfos.size();
        for (i = 0; i < size; ++i) {
            TaskDetailInfo detailInfo = (TaskDetailInfo)insertDetailInfos.get(i);
            detailInfo.setDistributeTime(now);
            detailInfo.setTaskDistributeID(taskID);
            lstTotalSQL.add(SumTaskBOFacade.getInsertTaskDetailSQL(detailInfo));
        }
        size = delDetailInfos.size();
        for (i = 0; i < size; ++i) {
            String unitOrOrgID = (String)delDetailInfos.get(i);
            lstTotalSQL.add(SumTaskBOFacade.getDelTaskDetailSQL(taskID, unitOrOrgID));
        }
        lstTotalSQL.trimToSize();
        ExtDBUtil.executeBatch(ServerUtil.getContext(), lstTotalSQL);
    }

    public void deleteTask(TaskDistributeInfo[] taskInfos) throws BOSException {
        ArrayList<String> lstTotalSQL = new ArrayList<String>();
        for (int i = 0; i < taskInfos.length; ++i) {
            TaskDistributeInfo taskInfo = taskInfos[i];
            String taskSQL = "delete T_EXT_TaskDistribute where FID = '" + taskInfo.getId() + "'";
            lstTotalSQL.add(taskSQL);
            String detailSQL = "delete T_EXT_TaskDetail where FTaskDistributeID = '" + taskInfo.getId() + "'";
            lstTotalSQL.add(detailSQL);
        }
        lstTotalSQL.trimToSize();
        ExtDBUtil.executeBatch(ServerUtil.getContext(), lstTotalSQL);
    }

    public void updateDetailState(ObjectArray objs) throws BOSException {
        ArrayList<String> lstTotalSQL = new ArrayList<String>();
        int size = objs.size();
        for (int i = 0; i < size; i += 2) {
            lstTotalSQL.add(StatusEngine.updateTaskAStatusSQL((String)objs.get(i), (Integer)objs.get(i + 1)));
        }
        lstTotalSQL.trimToSize();
        ExtDBUtil.executeBatch(ServerUtil.getContext(), lstTotalSQL);
    }

    public List getUploadManageList(String curOrgID, String localString, String orgWhereSql, String unitWhereSql) throws BOSException {
        ArrayList<String> param = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select detail.fid as detailId,unit.fid as unitId,");
        sql.append(" task.fname_").append(localString).append(" as taskName,");
        sql.append(" range.fname_").append(localString).append(" as rangeName,");
        sql.append(" range.fid as rangeid,");
        sql.append(" range.fnumber as rangenumber,");
        sql.append(" unit.fnumber as unitNumber,");
        sql.append(" null as orgNumber,");
        sql.append(" unit.fname_").append(localString).append(" as unitName,");
        sql.append(" report.fname_").append(localString).append(" as reportName,");
        sql.append(" report.fid as reportid,");
        sql.append(" task.FReportPeriod, detail.fstate as detailState,");
        sql.append(" userUpload.Fid as useruploadid,");
        sql.append(" userUpload.Fnumber as useruploadnumber,");
        sql.append(" userUpload.fname_").append(localString).append(" as uploaderName,");
        sql.append(" detail.FUploadTime as detailUploadTime,");
        sql.append(" report.ftemplettype as templatetype");
        sql.append(" from T_EXT_TaskDistribute task");
        sql.append(" inner join T_EXT_TaskDetail detail on task.fid = detail.FTaskDistributeID");
        sql.append(" inner join t_ext_sumunit unit on detail.funitororgid = unit.fid");
        sql.append(" inner join t_ext_sumrange range on range.fid = unit.fsumrangeid");
        sql.append(" inner join T_RM_DefineReport report on detail.freportid = report.fid");
        sql.append(" left join t_pm_user userUpload on detail.fuploaduserid = userUpload.fid");
        sql.append(" where ");
        sql.append(" unit.fparentid in (");
        sql.append(" select fid from t_ext_sumunit where fmanageorgid = ?").append(" ) ");
        sql.append(" and range.fusingflag=1 ");
        if (!StringUtil.isEmptyString((String)unitWhereSql)) {
            sql.append(unitWhereSql);
        }
        sql.append(" union all ");
        sql.append(" select distinct detail.fid as detailId, org.fid as unitId,");
        sql.append("  task.fname_").append(localString).append(" as taskName,");
        sql.append(" range.fname_").append(localString).append(" as rangeName,");
        sql.append(" range.fid as rangeid,");
        sql.append(" range.fnumber as rangenumber,");
        sql.append(" null as unitNumber,");
        sql.append(" org.fnumber as orgNumber,");
        sql.append(" org.fname_").append(localString).append(" as unitName,");
        sql.append(" report.fname_").append(localString).append(" as reportName,");
        sql.append(" report.fid as reportid,");
        sql.append(" task.FReportPeriod, detail.fstate as detailState,");
        sql.append(" userUpload.Fid as useruploadid,");
        sql.append(" userUpload.Fnumber as useruploadnumber,");
        sql.append(" userUpload.fname_").append(localString).append(" as uploaderName,");
        sql.append(" detail.FUploadTime as detailUploadTime,");
        sql.append(" report.ftemplettype as templatetype");
        sql.append(" from T_EXT_TaskDistribute task");
        sql.append(" inner join T_EXT_TaskDetail detail on task.fid = detail.FTaskDistributeID");
        sql.append(" inner join t_ext_sumrange range on task.FSumRangeID = range.fid ");
        sql.append(" inner join t_ext_sumunitorg unitorg on detail.funitororgid = unitorg.forgid");
        sql.append(" inner join t_org_baseunit org on unitorg.forgid = org.fid");
        sql.append(" inner join T_RM_DefineReport report on detail.freportid = report.fid");
        sql.append(" left join t_pm_user userUpload on detail.fuploaduserid = userUpload.fid");
        sql.append(" where unitorg.fsumunitid in ");
        sql.append(" ( select fid from t_ext_sumunit where fmanageorgid = ?)");
        sql.append(" and range.fusingflag=1");
        if (!StringUtil.isEmptyString((String)orgWhereSql)) {
            sql.append(orgWhereSql);
        }
        sql.append("  order by taskName, rangeName, unitName");
        param.add(curOrgID);
        param.add(curOrgID);
        return ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sql.toString(), param);
    }

    public List getUploadReportList(String curOrgID, String localString, String filterWhereSql) throws BOSException {
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select detail.freportid,");
        sql.append(" task.fname_").append(localString).append(" as taskName,").append(" report.fname_").append(localString);
        sql.append(" as reportName, task.FReportPeriod,range.fname_").append(localString).append(" as rangeName,");
        sql.append(" detail.fstate as detailState,detail.FMakeTime as detailMakeTime,detail.FUploadTime as detailUploadTime,");
        sql.append(" detail.fapprovetime as detailApproveTime,");
        sql.append(" userMake.fname_").append(localString).append(" as makerName,");
        sql.append(" userAppr.fname_").append(localString).append(" as approverName,");
        sql.append(" userUpload.fname_").append(localString).append(" as uploaderName,");
        sql.append(" detail.fidflag,");
        sql.append(" task.fid as taskId,");
        sql.append(" detail.fid as detailId,");
        sql.append(" detail.funitororgid as unitororgid,");
        sql.append(" task.fbegindate as taskbegindate,");
        sql.append(" snap.fid as snapid,");
        sql.append(" task.fenddate as taskenddate");
        sql.append(" from T_EXT_TaskDistribute task inner join T_EXT_TaskDetail detail");
        sql.append(" on task.fid = detail.FTaskDistributeID ");
        sql.append(" inner join T_RM_DefineReport report on detail.freportid=report.fid ");
        sql.append(" inner join T_EXT_SUMRANGE range on task.FSumRangeID = range.fid");
        sql.append(" left join T_RM_ReportSnap snap on detail.fid = snap.ftaskdetailid");
        sql.append(" left join t_pm_user userMake on detail.fmakerid=userMake.fid ");
        sql.append(" left join t_pm_user userAppr on  detail.fapproverid=userAppr.fid");
        sql.append(" left join t_pm_user userUpload on  detail.fuploaduserid=userUpload.fid");
        sql.append(" where detail.FUnitOrOrgID = ?").append(" and range.fusingflag=1 ");
        params.add(curOrgID);
        sql.append(" and detail.fidflag = ").append(1);
        if (!StringUtil.isEmptyString((String)filterWhereSql)) {
            sql.append(filterWhereSql);
        }
        sql.append(" order by taskName");
        return ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sql.toString(), params);
    }

    public List getUploadUserList(String curOrgID, String localString, String whereSql) throws BOSException {
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct userMake.fid as userMakerId,userAppr.fid as userApprId,");
        sql.append(" userUpload.fid as userUploadId,");
        sql.append(" userMake.Fnumber as makerNumber,userAppr.Fnumber as approverNumber,");
        sql.append(" userUpload.Fnumber as uploaderNumber,");
        sql.append(" userMake.fname_").append(localString).append(" as makerName,");
        sql.append(" userAppr.fname_").append(localString).append(" as approverName,");
        sql.append(" userUpload.fname_").append(localString).append(" as uploaderName");
        sql.append(" from T_EXT_TaskDetail detail ");
        sql.append(" left join t_pm_user userMake on detail.fmakerid=userMake.fid ");
        sql.append(" left join t_pm_user userAppr on  detail.fapproverid=userAppr.fid");
        sql.append(" left join t_pm_user userUpload on  detail.fuploaduserid=userUpload.fid");
        sql.append(" where detail.FUnitOrOrgID = ? ");
        if (!StringUtil.isEmptyString((String)whereSql)) {
            sql.append(whereSql);
        }
        params.add(curOrgID);
        return ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sql.toString(), params);
    }

    public List getSumUploadUserList(String curOrgID, String localString, String whereSql) throws BOSException {
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct userMake.fid as userMakerId,userAppr.fid as userApprId,");
        sql.append(" userUpload.fid as userUploadId,");
        sql.append(" userMake.Fnumber as makerNumber,userAppr.Fnumber as approverNumber,");
        sql.append(" userUpload.Fnumber as uploaderNumber,");
        sql.append(" userMake.fname_").append(localString).append(" as makerName,");
        sql.append(" userAppr.fname_").append(localString).append(" as approverName,");
        sql.append(" userUpload.fname_").append(localString).append(" as uploaderName");
        sql.append(" from T_EXT_TaskDetail detail ");
        sql.append(" inner join t_ext_sumunit unit on detail.funitororgid = unit.fid");
        sql.append(" left join t_pm_user userMake on detail.fmakerid=userMake.fid ");
        sql.append(" left join t_pm_user userAppr on  detail.fapproverid=userAppr.fid");
        sql.append(" left join t_pm_user userUpload on  detail.fuploaduserid=userUpload.fid");
        sql.append(" where unit.fmanageorgid = ? ");
        params.add(curOrgID);
        if (!StringUtil.isEmptyString((String)whereSql)) {
            sql.append(whereSql);
        }
        return ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sql.toString(), params);
    }

    public List getSumReportList(String curOrgID, String localString, String filterWhereSql) throws BOSException {
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select detail.freportid,");
        sql.append(" task.fname_").append(localString).append(" as taskName,").append(" report.fname_").append(localString);
        sql.append(" as reportName, task.FReportPeriod,range.fname_").append(localString).append(" as rangeName,");
        sql.append(" unit.fname_").append(localString).append(" unitName,");
        sql.append(" unit.fparentid as parentid,");
        sql.append(" detail.fstate as detailState,detail.FMakeTime as detailMakeTime,detail.FUploadTime as detailUploadTime,");
        sql.append(" detail.fapprovetime as detailApproveTime,");
        sql.append(" userMake.fname_").append(localString).append(" as makerName,");
        sql.append(" userAppr.fname_").append(localString).append(" as approverName,");
        sql.append(" userUpload.fname_").append(localString).append(" as uploaderName,");
        sql.append(" detail.fidflag,");
        sql.append(" task.fid as taskId,");
        sql.append(" detail.funitororgid as unitororgid,");
        sql.append(" detail.fid as detailId,");
        sql.append(" task.fbegindate as taskbegindate,");
        sql.append(" snap.fid as snapid,");
        sql.append(" task.fenddate as taskenddate");
        sql.append(" from T_EXT_TaskDistribute task inner join T_EXT_TaskDetail detail");
        sql.append(" on task.fid = detail.FTaskDistributeID ");
        sql.append(" inner join t_ext_sumunit unit on detail.funitororgid = unit.fid");
        sql.append(" inner join t_ext_sumrange range on range.fid = task.fsumrangeid");
        sql.append(" inner join T_RM_DefineReport report on detail.freportid=report.fid ");
        sql.append(" left join T_RM_ReportSnap snap on detail.fid = snap.ftaskdetailid");
        sql.append(" left join t_pm_user userMake on detail.fmakerid=userMake.fid ");
        sql.append(" left join t_pm_user userAppr on  detail.fapproverid=userAppr.fid");
        sql.append(" left join t_pm_user userUpload on  detail.fuploaduserid=userUpload.fid");
        sql.append(" where detail.fidflag = ").append(0);
        sql.append(" and unit.fmanageorgid = ?").append(" and range.fusingflag = 1 ");
        params.add(curOrgID);
        if (!StringUtil.isEmptyString((String)filterWhereSql)) {
            sql.append(filterWhereSql);
        }
        sql.append(" order by taskName,rangename,unitname");
        return ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sql.toString(), params);
    }

    public IORMModel queryInterface(Class arg0) throws ORMCoreException {
        throw new UnsupportedOperationException("Unsupported");
    }

    public Object getMessageTemplateInfoById(MessageTemplateinfo info) throws BOSException {
        String sql = "select fid,femailcontent from T_Ext_MessageTemplate where fid=?";
        ArrayList<String> param = new ArrayList<String>(1);
        param.add(info.getId());
        ArrayList result = ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sql.toString(), param);
        Object returnObj = null;
        if (result != null && result.size() > 0) {
            returnObj = result.get(0);
            Map resultMap = returnObj;
            resultMap.put("curServerTime", new Timestamp(new Date().getTime()));
        }
        return returnObj;
    }

    public void updateMessageTemplate(MessageTemplateinfo info) throws BOSException {
        Timestamp curTime = new Timestamp(new Date().getTime());
        info.setCreateTime(curTime);
        info.setLastUpdateTime(curTime);
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_Ext_MessageTemplate set fnumber=?,fname_l1=?,fname_l2=?,fname_l3=?,fdes_l1=?,fdes_l2=?,fdes_l3=?,");
        sql.append(" femailcontent=?,fcreatorId=?,fcreateTime=?,flastupdateUserId=?,fLastupdateTime=?");
        sql.append(" where fid=?");
        ArrayList<Object> param = new ArrayList<Object>();
        param.add(info.getNumber());
        param.add(info.getName("l1"));
        param.add(info.getName("l2"));
        param.add(info.getName("l3"));
        param.add(info.getDes("l1"));
        param.add(info.getDes("l2"));
        param.add(info.getDes("l3"));
        param.add(info.getEmailContent());
        param.add(info.getCreatorId());
        param.add(info.getCreateTime());
        param.add(info.getLastUpdateUserId());
        param.add(info.getLastUpdateTime());
        param.add(info.getId());
        ExtDBUtil.maintainRecord(ServerUtil.getContext(), sql.toString(), param);
    }

    public void updateMessageTemplateContent(String curId, String initialId, String curUserId) throws BOSException {
        MessageTemplateinfo info = new MessageTemplateinfo();
        info.setId(initialId);
        Map message = (Map)this.getMessageTemplateInfoById(info);
        if (message != null && message.size() > 0) {
            Object msg = message.get("femailcontent");
            String initialContent = null;
            try {
                initialContent = DispatchCommonUtil.clob2String(msg);
            }
            catch (IOException e) {
                throw new BOSException((Throwable)e);
            }
            Timestamp curTime = new Timestamp(new Date().getTime());
            StringBuffer sql = new StringBuffer();
            sql.append(" update T_Ext_MessageTemplate set femailcontent=?,fcreatorId=?,fcreateTime=?,");
            sql.append(" flastupdateUserId=?,fLastupdateTime=? where fid=?");
            ArrayList<Object> param = new ArrayList<Object>(6);
            param.add(initialContent);
            param.add(curUserId);
            param.add(curTime);
            param.add(curUserId);
            param.add(curTime);
            param.add(curId);
            ExtDBUtil.maintainRecord(ServerUtil.getContext(), sql.toString(), param);
        }
    }

    public Object getCurUserEmail(String curUserId) throws BOSException {
        String sql = "select femail from t_pm_user where fid=?";
        ArrayList<String> param = new ArrayList<String>(1);
        param.add(curUserId);
        ArrayList result = ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sql.toString(), param);
        Object returnObj = null;
        if (result != null && result.size() > 0) {
            returnObj = result.get(0);
        }
        return returnObj;
    }

    public boolean sendUrgeEmail(MailInfo mailInfo, String curUserName) throws Exception {
        mailInfo.setMailSubject("\u50ac\u62a5\u90ae\u4ef6,\u6765\u81ea " + curUserName);
        Timestamp curServerTime = new Timestamp(new Date().getTime());
        String regex = "\\[\u5f53\u524d\u670d\u52a1\u5668\u7cfb\u7edf\u65f6\u95f4\\]";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd  HH:mm");
        String curTime = dateFormat.format(curServerTime);
        String content = mailInfo.getMailBody();
        mailInfo.setMailBody(content.replaceAll(regex, curTime));
        return SmtpSender.sendMail(mailInfo, 0);
    }

    public Map getChildsNameID(String parentID, TaskDistributeInfo info, String local) throws BOSException {
        HashMap<String, String> hashMap;
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("(SELECT et.fid as id, u.fname_").append(local).append(" as name from t_ext_sumunit u inner join T_EXT_TaskDetail et");
        sqlBuf.append(" on u.fid = et.FUnitOrOrgID where u.fsumrangeid= ? and u.fparentid = ? ").append("and FTaskDistributeID = ? and et.fidflag =0 )");
        sqlBuf.append("UNION ALL");
        sqlBuf.append("(select et.fid as id , o.fname_").append(local).append(" as name from t_ext_sumunitorg uo ");
        sqlBuf.append(" inner join T_EXT_TaskDetail et on uo.forgid = et.FUnitOrOrgID left outer join ");
        sqlBuf.append(" t_org_baseunit o on uo.forgid = o.fid where uo.fsumrangeid = ? and FTaskDistributeID = ? ");
        sqlBuf.append(" and et.fidflag =1 and uo.fsumunitid = ?)");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((String)sqlBuf.toString(), (Object[])new Object[]{info.getSumRangeID(), parentID, info.getId(), info.getSumRangeID(), info.getId(), parentID});
            HashMap<String, String> rsMap = new HashMap<String, String>(rs.size());
            while (rs.next()) {
                rsMap.put(rs.getString("id"), rs.getString("name"));
            }
            hashMap = rsMap;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return hashMap;
    }

    public TaskDistributeInfo getTaskInfoByID(String taskID) throws BOSException {
        TaskDistributeInfo taskDistributeInfo;
        StringBuffer sqlBuf = new StringBuffer("select fsumrangeid from T_EXT_TaskDistribute where fid = ?");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((String)sqlBuf.toString(), (Object[])new Object[]{taskID});
            TaskDistributeInfo info = new TaskDistributeInfo();
            while (rs.next()) {
                info.setId(taskID);
                info.setSumRangeID(rs.getString("fsumrangeid"));
            }
            taskDistributeInfo = info;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return taskDistributeInfo;
    }

    public List getReportLog(String taskDetailId, String localString) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select extlog.fid as fid, extlog.fedittime as edittime,");
        sql.append(" pmuser.fname_").append(localString).append(" as username,");
        sql.append(" extlog.fremark as remark from T_EXT_LOG extlog inner join t_pm_user pmuser on extlog.feditor = pmuser.fid");
        sql.append(" where factivityid=?").append(" order by fedittime desc");
        ArrayList<String> param = new ArrayList<String>(1);
        param.add(taskDetailId);
        return ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sql.toString(), param);
    }

    public Timestamp getSystemTime() {
        return new Timestamp(new Date().getTime());
    }

    public List getUrgeCommitReportList(String curOrgID, String localString, String orgWhereSql, String unitWhereSql) throws BOSException {
        ArrayList<String> param = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select detail.fid,");
        sql.append(" unit.fmanageorgid as unitId,");
        sql.append(" unit.fnumber as unitNumber,");
        sql.append(" unit.fname_").append(localString).append(" as unitName,");
        sql.append(" task.fname_").append(localString).append(" as taskName,");
        sql.append(" range.fname_").append(localString).append(" as rangeName,");
        sql.append(" range.fid as rangeid,");
        sql.append(" range.fnumber as rangenumber,");
        sql.append(" org.fnumber as manageorgnum,");
        sql.append(" null as orgNumber,");
        sql.append(" org.fname_l2 as manageorgname,");
        sql.append(" report.fname_").append(localString).append(" as reportName,");
        sql.append(" report.fid as reportid,");
        sql.append(" task.FReportPeriod, detail.fstate as detailState,");
        sql.append(" userUpload.Fid as useruploadid,");
        sql.append(" userUpload.Fnumber as useruploadnumber,");
        sql.append(" userUpload.fname_").append(localString).append(" as uploaderName,");
        sql.append(" detail.FUploadTime as detailUploadTime,");
        sql.append(" report.ftemplettype as templatetype");
        sql.append(" from T_EXT_TaskDistribute task");
        sql.append(" inner join T_EXT_TaskDetail detail on task.fid = detail.FTaskDistributeID");
        sql.append(" inner join t_ext_sumunit unit on detail.funitororgid = unit.fid");
        sql.append(" inner join t_org_baseunit org on unit.fmanageorgid = org.fid");
        sql.append(" inner join t_ext_sumrange range on range.fid = unit.fsumrangeid");
        sql.append(" inner join T_RM_DefineReport report on detail.freportid = report.fid");
        sql.append(" left join t_pm_user userUpload on detail.fuploaduserid = userUpload.fid");
        sql.append(" where ");
        sql.append(" unit.fparentid in (");
        sql.append(" select fid from t_ext_sumunit where fmanageorgid = ?").append(" ) ");
        sql.append(" and range.fusingflag=1 ");
        if (!StringUtil.isEmptyString((String)unitWhereSql)) {
            sql.append(unitWhereSql);
        }
        sql.append(" union all ");
        sql.append(" select distinct detail.fid as detailId, org.fid as unitId,");
        sql.append(" null as unitNumber,");
        sql.append(" null as unitName,");
        sql.append("  task.fname_").append(localString).append(" as taskName,");
        sql.append(" range.fname_").append(localString).append(" as rangeName,");
        sql.append(" range.fid as rangeid,");
        sql.append(" range.fnumber as rangenumber,");
        sql.append(" null as manageorgnum,");
        sql.append(" org.fnumber as orgNumber,");
        sql.append(" org.fname_").append(localString).append(" as manageorgname,");
        sql.append(" report.fname_").append(localString).append(" as reportName,");
        sql.append(" report.fid as reportid,");
        sql.append(" task.FReportPeriod, detail.fstate as detailState,");
        sql.append(" userUpload.Fid as useruploadid,");
        sql.append(" userUpload.Fnumber as useruploadnumber,");
        sql.append(" userUpload.fname_").append(localString).append(" as uploaderName,");
        sql.append(" detail.FUploadTime as detailUploadTime,");
        sql.append(" report.ftemplettype as templatetype");
        sql.append(" from T_EXT_TaskDistribute task");
        sql.append(" inner join T_EXT_TaskDetail detail on task.fid = detail.FTaskDistributeID");
        sql.append(" inner join t_ext_sumrange range on task.FSumRangeID = range.fid ");
        sql.append(" inner join t_ext_sumunitorg unitorg on detail.funitororgid = unitorg.forgid");
        sql.append(" inner join t_org_baseunit org on unitorg.forgid = org.fid");
        sql.append(" inner join T_RM_DefineReport report on detail.freportid = report.fid");
        sql.append(" left join t_pm_user userUpload on detail.fuploaduserid = userUpload.fid");
        sql.append(" where unitorg.fsumunitid in ");
        sql.append(" ( select fid from t_ext_sumunit where fmanageorgid = ?)");
        sql.append(" and range.fusingflag=1");
        if (!StringUtil.isEmptyString((String)orgWhereSql)) {
            sql.append(orgWhereSql);
        }
        sql.append("  order by taskName, rangeName, unitName");
        param.add(curOrgID);
        param.add(curOrgID);
        return ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sql.toString(), param);
    }
}

