/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ctrl.common.util.UID;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import com.kingdee.eas.base.reportmeta.sumreport.data.TaskDetailInfo;
import com.kingdee.eas.base.reportmeta.sumreport.data.TaskDistributeInfo;
import com.kingdee.eas.base.reportmeta.sumreport.exceptions.SumTaskException;
import com.kingdee.eas.base.reportmeta.sumreport.model.InfoException;
import com.kingdee.eas.base.reportmeta.sumreport.server.ISumTaskBOFacade;
import com.kingdee.eas.base.reportmeta.sumreport.server.impl.SumTaskBOFacade;
import com.kingdee.eas.base.reportmeta.sumreport.service.inf.ITaskService;
import com.kingdee.eas.base.reportmeta.sumreport.util.EASUtil;
import com.kingdee.eas.base.reportmeta.sumreport.util.MixUtil;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TaskService
implements ITaskService {
    private ISumTaskBOFacade _facade;
    public String _local = EASUtil.gelLoginLocal();

    public ISumTaskBOFacade getFacade() throws SumTaskException {
        if (this._facade == null) {
            String rpcUrl = ORMRPCServiceLocator.getCurrentServiceURL();
            try {
                this._facade = (ISumTaskBOFacade)BOSObjectFactory.createRemoteObject((String)rpcUrl, (String)SumTaskBOFacade.class.getName(), ISumTaskBOFacade.class);
            }
            catch (BOSException e) {
                throw SumTaskException.wrap("Initial summary task facade error.", (Exception)((Object)e));
            }
        }
        return this._facade;
    }

    public static void addUpInfos(TaskDistributeInfo vo, boolean update) {
        if (!update) {
            vo.setId(UID.create((int)44));
        }
        vo.setCreator(EASUtil.getCurrentUserID());
        vo.setCreateTime(new Timestamp(new Date().getTime()));
        vo.setOrgID(EASUtil.getCurrentOrgID());
        List details = vo.getDetailList();
        int size = details.size();
        for (int i = 0; i < size; ++i) {
            TaskDetailInfo info = (TaskDetailInfo)details.get(i);
            info.setId(UID.create((int)44));
            info.setTaskDistributeID(vo.getId());
            info.setDistributorID(vo.getCreator());
            info.setDistributeTime(new Timestamp(new Date().getTime()));
        }
    }

    public void addTask(TaskDistributeInfo vo) throws BOSException, InfoException {
        if (this.verifySame(vo, vo.getId())) {
            throw new InfoException("\u5df2\u5b58\u5728\u8be5\u7f16\u7801\u6216\u8005\u540d\u79f0\u7684\u4efb\u52a1,\u8bf7\u4fee\u6539\uff01");
        }
        TaskService.addUpInfos(vo, false);
        this.getFacade().insertTask(vo);
    }

    public boolean verifySame(TaskDistributeInfo vo, String taskID) throws BOSException, InfoException {
        if (this.getFacade().isExistTaskNumberAndName(taskID, vo.getNumber(), vo.getName(this._local))) {
            throw new InfoException("\u5df2\u5b58\u5728\u8be5\u7f16\u7801\u6216\u8005\u540d\u79f0\u7684\u4efb\u52a1,\u8bf7\u4fee\u6539\uff01");
        }
        return false;
    }

    public void updateTask(TaskDistributeInfo oldVO, TaskDistributeInfo newVO, Map info) throws BOSException, InfoException {
        Set updateSet = (Set)info.get(UPDATE_ACTIVITY_LIST);
        List insLst = (List)info.get(INSERT_ACTIVITY_LIST);
        List delLst = (List)info.get(DEL_ACTIVITY_LIST);
        boolean running = (Boolean)info.get(TASK_STATE);
        newVO.setId(oldVO.getId());
        newVO.setUpdatePerson(EASUtil.getCurrentUserID());
        newVO.setLastUpdateTime(new Timestamp(new Date().getTime()));
        if (running) {
            this.getFacade().updateTask(newVO, updateSet, insLst, delLst);
        } else {
            this.getFacade().updateTask(newVO, insLst, delLst);
        }
    }

    public List queryTasksByOrg() throws BOSException {
        return this.getFacade().getTaskListByOrgID(EASUtil.getCurrentOrgID(), this._local);
    }

    public Collection queryTaskDetailsByTask(String taskId) throws BOSException {
        List list = this.getFacade().getTaskDetailsIDsByTask(taskId);
        if (list == null) {
            return null;
        }
        HashSet<String> set = new HashSet<String>(list.size());
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Map map = (Map)list.get(i);
            set.add(MixUtil.toString(map.get("funitororgid")));
        }
        return set;
    }

    public boolean isTaskRuning(String taskId) throws BOSException {
        return this.getFacade().isTaskRunning(taskId);
    }

    public void deleteTask(TaskDistributeInfo[] infos) throws BOSException {
        this.getFacade().deleteTask(infos);
    }

    private TaskDetailInfo box(Map item) {
        TaskDetailInfo detail = new TaskDetailInfo();
        detail.setName(MixUtil.toString(item.get("name")));
        detail.setId(MixUtil.toString(item.get("tdid")));
        detail.setLevel(((Number)item.get("flevel")).intValue());
        detail.setDistributeTime((Timestamp)item.get("distribute_time"));
        detail.setState(((Number)item.get("state")).intValue());
        detail.setDistributeName(MixUtil.toString(item.get("distribute_name")));
        return detail;
    }

    public TaskDetailInfo queryTaskDetail(TaskDistributeInfo info) throws BOSException {
        List rsL = this.getFacade().getTaskDetailsTree(info.getSumRangeID(), info.getId(), this._local);
        if (rsL != null && rsL.size() > 0) {
            Map item = (Map)rsL.get(0);
            if (!"0".equals(item.get("type"))) {
                return null;
            }
            TaskDetailInfo rootDetail = this.box(item);
            HashMap<String, TaskDetailInfo> cache = new HashMap<String, TaskDetailInfo>();
            cache.put(MixUtil.toString(item.get("id")), rootDetail);
            int maxLevel = 0;
            int size = rsL.size();
            for (int i = 1; i < size; ++i) {
                item = (Map)rsL.get(i);
                TaskDetailInfo detail = this.box(item);
                String pid = MixUtil.toString(item.get("pid"));
                TaskDetailInfo pDetail = null;
                if (cache.containsKey(pid)) {
                    pDetail = (TaskDetailInfo)cache.get(pid);
                    pDetail.addChild(detail);
                }
                if ("0".equals(item.get("type"))) {
                    cache.put(MixUtil.toString(item.get("id")), detail);
                    maxLevel = Math.max(maxLevel, detail.getLevel());
                    continue;
                }
                if (null == pDetail) continue;
                int level = pDetail.getLevel() + 1;
                detail.setLevel(level);
                maxLevel = Math.max(maxLevel, level);
            }
            rootDetail.setTreeDepth(maxLevel);
            return rootDetail;
        }
        return null;
    }

    public void updateStatus(ObjectArray objs) throws BOSException {
        if (objs == null) {
            return;
        }
        this.getFacade().updateDetailState(objs);
    }

    public boolean isCanChangeTempletType(String reportID) throws BOSException {
        return this.getFacade().isCanChangeTempletType(reportID);
    }

    public boolean isMakeReport(String reportID) throws BOSException {
        return this.getFacade().isMakeReport(reportID);
    }

    public List queryAllTasks() throws BOSException {
        return this.getFacade().getTaskList(this._local);
    }
}

