/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.tobi;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.ProcessingInstruction;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class FilterXmlTrans {
    private Document source;
    private Document destination;
    private int index;

    private FilterXmlTrans(String source) throws JDOMException, IOException {
        SAXBuilder saxBuilder = new SAXBuilder();
        this.source = saxBuilder.build((Reader)new StringReader(source));
        this.initDestDocument();
    }

    protected void initDestDocument() {
        Element root = new Element("Filter");
        this.destination = new Document(root);
    }

    private Document translate() {
        this.index = 0;
        if (this.source != null) {
            List children = this.source.getRootElement().getContent();
            for (Object o : children) {
                if (o instanceof Element) {
                    Element element = (Element)o;
                    String name = element.getName();
                    if (!"FilterItem".equals(name)) continue;
                    Element counterpart = new Element("FilterItem");
                    this.buildFilterItem(element, counterpart);
                    this.destination.getRootElement().addContent(counterpart);
                    continue;
                }
                if (o instanceof Comment) {
                    this.doComment((Comment)o);
                    continue;
                }
                if (!(o instanceof ProcessingInstruction)) continue;
                this.doPI((ProcessingInstruction)o);
            }
        }
        return this.destination;
    }

    private void buildFilterItem(Element info, Element element) {
        ++this.index;
        String value = null;
        element.setAttribute("index", String.valueOf(this.index));
        value = info.getAttributeValue("name");
        element.setAttribute("name", value == null ? "" : value);
        value = info.getAttributeValue("caption");
        element.setAttribute("caption", value == null ? "" : value);
        value = info.getAttributeValue("required");
        element.setAttribute("required", value == null ? "" : value);
        value = info.getAttributeValue("defaultValue");
        element.setAttribute("defaultValue", value == null ? "" : value);
        String tmp = value;
        value = info.getAttributeValue("defaultAlais");
        value = value == null ? tmp : value;
        element.setAttribute("defaultCaption", value == null ? "" : value);
        value = info.getAttributeValue("rowLimit");
        element.setAttribute("rowLimit", value == null ? "" : value);
        value = info.getAttributeValue("isAllowEdit");
        if ("true".equals(value)) {
            element.setAttribute("isAllowEdit", "true");
        } else {
            element.setAttribute("isAllowEdit", "false");
        }
        value = info.getAttributeValue("isReadOnly");
        if ("true".equals(value)) {
            element.setAttribute("isReadOnly", "true");
        } else {
            element.setAttribute("isReadOnly", "false");
        }
        value = info.getAttributeValue("isAllowMultipleSelected");
        if ("true".equals(value)) {
            element.setAttribute("operator", "IN");
            String strRowLimit = info.getAttributeValue("rowLimit");
            if (strRowLimit != null) {
                element.setAttribute("rowLimit", strRowLimit);
            }
        } else {
            element.setAttribute("operator", "EQ");
        }
        value = info.getAttributeValue("type");
        element.setAttribute("type", value == null ? "" : value);
        if ("list".equals(value)) {
            this.buildListItem(info, element);
        } else if ("sql".equals(value)) {
            value = info.getAttributeValue("errMsg");
            if (value != null && value.length() > 0) {
                element.setAttribute("errMsg", value);
            }
            element.setAttribute("valueColumn", (value = info.getAttributeValue("valueColumn")) == null ? "" : value);
            value = info.getAttributeValue("displayColumn");
            element.setAttribute("displayColumn", value == null ? "" : value);
            value = info.getAttributeValue("fullname");
            element.setAttribute("fullname", value == null ? "" : value);
        }
        value = info.getAttributeValue("dataType");
        element.setAttribute("dataType", value == null ? "string" : value);
        if ("date".equalsIgnoreCase(value)) {
            String[] dateElements;
            String defaultDate = element.getAttributeValue("defaultValue");
            if (!"".equals(defaultDate) && (dateElements = defaultDate.split("-")).length == 3) {
                defaultDate = dateElements[1] + "/" + dateElements[2] + "/" + dateElements[0];
            }
            element.setAttribute("defaultValue", defaultDate);
        }
    }

    private void buildListItem(Element info, Element parent) {
        String value = null;
        List listItems = info.getChildren("ListItem");
        Iterator iterator = listItems.iterator();
        while (iterator.hasNext()) {
            Element listItem = new Element("ListItem");
            Object o = iterator.next();
            if (o instanceof Element) {
                Element item = (Element)o;
                value = item.getAttributeValue("caption");
                listItem.setAttribute("caption", value == null ? "" : value);
                value = item.getAttributeValue("value");
                listItem.setAttribute("value", value == null ? "" : value);
            }
            parent.addContent(listItem);
        }
    }

    protected void doComment(Comment c) {
        System.out.println("Comment: " + c);
    }

    protected void doPI(ProcessingInstruction pi) {
        System.out.println("PI: " + pi);
    }

    public static String translate(String source) {
        if (source == null) {
            return null;
        }
        try {
            FilterXmlTrans translater = new FilterXmlTrans(source);
            XMLOutputter outter = new XMLOutputter("\t", true, "UTF-8");
            String xmlstr = outter.outputString(translater.translate());
            return xmlstr;
        }
        catch (JDOMException e) {
            System.err.println("The source is not a well formed XML document.");
            System.err.println(e.getMessage());
        }
        catch (IOException ex) {
            System.out.println("Input or Output error:" + ex);
        }
        return null;
    }
}

