/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.third.login;

import com.kingdee.bos.openapi.third.ctx.IloginContext;
import com.kingdee.bos.openapi.third.invoker.AbstractHttpLoginContext;
import com.kingdee.bos.openapi.third.utils.OpenApiTools;

public class EASLoginContext
extends AbstractHttpLoginContext {
    private EASLoginContext(Builder builder) {
        this.ip = builder.ip;
        this.port = builder.port;
        this.loginContext = builder.loginContext;
        if (builder.isHttps) {
            this.setHttps();
        }
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
    }

    public static class Builder {
        private final String ip;
        private final int port;
        private final IloginContext loginContext;
        private boolean isHttps;
        private int connectTimeout = 120000;
        private int readTimeout = 120000;

        public Builder(String ip, int port, IloginContext loginContext) {
            this.ip = ip;
            this.port = port;
            this.loginContext = loginContext;
        }

        public Builder https(boolean isHttps) {
            this.isHttps = isHttps;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public EASLoginContext build() {
            if (OpenApiTools.isEmpty(this.ip)) {
                throw new IllegalArgumentException("Invalid parameters ip");
            }
            if (this.loginContext == null) {
                throw new IllegalArgumentException("Invalid parameters loginContext");
            }
            return new EASLoginContext(this);
        }
    }
}

