/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qingReport.client.qingReportUI;

import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import com.kingdee.bos.qingReport.client.js.QingAnalysisJSFacade;
import com.kingdee.bos.qingReport.client.js.handler.QingAnalysisNewTabFunction;
import com.kingdee.bos.qingReport.client.listener.IQingAnalysisReportListener;
import com.kingdee.bos.qingReport.client.listener.IQingReportActionListener;
import com.kingdee.bos.qingReport.client.qingReportUI.IQingAnalysisReport;
import com.kingdee.bos.qingReport.common.utils.PortalUtil;
import com.kingdee.bos.qingReport.common.utils.QingAnalysisComponentUtil;
import com.kingdee.bos.qingReport.common.utils.QingAnalysisFilterSynCacheUtil;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.rpts.qinganalysis.SWTSwitchUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractBaseQingAnalysisReportUI
extends CoreUI
implements IQingAnalysisReport {
    private JWebBrowser browser;
    private QingAnalysisJSFacade jsFacade;
    private String tag;
    private String bizTag;
    private String className;
    private String schemaId;
    private String title;
    private String url;
    protected static final Logger logger = CommonLogger.getLogger(AbstractBaseQingAnalysisReportUI.class);
    protected List<IQingAnalysisReportListener> listenerList = new ArrayList<IQingAnalysisReportListener>();

    public void onLoad() throws Exception {
        this.initReportActionListener();
        this.fireBeforeOnloadReportAction(this);
        SWTSwitchUtil.switchSWTLib(true, true);
        QingAnalysisComponentUtil.loadComponent();
        this.initUILayout();
        this.fireAfterOnloadReportAction(this);
    }

    private void initUILayout() {
        this.browser = new JWebBrowser(SWTSwitchUtil.getNSOptions());
        this.browser.setJavascriptEnabled(true);
        this.browser.setBarsVisible(false);
        this.browser.setDefaultPopupMenuRegistered(false);
        this.jsFacade = new QingAnalysisJSFacade(this.browser);
        this.jsFacade.registerFunction(new QingAnalysisNewTabFunction());
        this.setLayout(new BorderLayout());
        this.add((Component)this.browser);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.showPage();
    }

    protected void showPage() throws UnsupportedEncodingException {
        this.initParam();
        this.initUrl();
        this.browser.navigate(this.url);
    }

    private void initUrl() throws UnsupportedEncodingException {
        this.url = PortalUtil.getGUItoPortalUrl("/easweb/bos/qing-analysis/controller-index.do?&tag=" + URLEncoder.encode(this.tag, "UTF-8") + "&" + "bizTag" + "=" + URLEncoder.encode(this.bizTag, "UTF-8") + "&" + "className" + "=" + URLEncoder.encode(this.className, "UTF-8") + "&" + "schemaId" + "=" + URLEncoder.encode(this.schemaId, "UTF-8"));
    }

    protected boolean checkParam() {
        if (StringUtil.isEmptyString((String)this.bizTag)) {
            MessageDialog.show((Component)((Object)this), (Object)"\u53c2\u6570BizTag\u4e0d\u5141\u8bb8\u4e3a\u7a7a!", (String)"\u9519\u8bef", (int)-1);
            return false;
        }
        if (StringUtil.isEmptyString((String)this.className)) {
            MessageDialog.show((Component)((Object)this), (Object)"\u53c2\u6570ClassName\u4e0d\u5141\u8bb8\u4e3a\u7a7a!", (String)"\u9519\u8bef", (int)-1);
            return false;
        }
        return true;
    }

    public String getUITitle() {
        return StringUtil.isEmptyString((String)this.title) ? "\u8f7b\u5206\u6790\u62a5\u8868" : this.title;
    }

    public boolean destroyWindow() {
        this.fireBeforeDisposeUIAction(this);
        try {
            QingAnalysisFilterSynCacheUtil.removeFilterForClient(this.tag);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        boolean destroyWindow = super.destroyWindow();
        this.fireAfterDisposeUIAction(this);
        return destroyWindow;
    }

    public String getFilterTag() {
        if (StringUtil.isEmptyString((String)this.tag)) {
            this.tag = QingAnalysisFilterSynCacheUtil.getTagForClient();
        }
        return this.tag;
    }

    private void initParam() {
        this.tag = this.getFilterTag();
        this.bizTag = this.getBizTag();
        this.className = this.getQingDataProviderClass();
        this.schemaId = this.getSchemaId();
        this.checkParam();
    }

    public void registerReportActionListener(IQingReportActionListener listener) {
        this.listenerList.add(listener);
    }

    private IQingReportActionListener getReportExtListener() {
        Class calzz = AbstractBaseQingAnalysisReportUI.getClass(this.getClass().getName());
        IQingReportActionListener listener = null;
        if (calzz != null) {
            try {
                listener = (IQingReportActionListener)calzz.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return listener;
    }

    protected static Class getClass(String name) {
        Class<?> c = null;
        try {
            c = Class.forName(name + "CTExListener", false, IQingAnalysisReportListener.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            try {
                c = Class.forName(name + "PIExListener", false, IQingAnalysisReportListener.class.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return c;
    }

    private void initReportActionListener() {
        IQingReportActionListener reportExtListener;
        boolean haslistener = false;
        for (IQingAnalysisReportListener listener : this.listenerList) {
            if (!(listener instanceof IQingReportActionListener)) continue;
            haslistener = true;
        }
        if (!haslistener && (reportExtListener = this.getReportExtListener()) != null) {
            this.registerReportActionListener(reportExtListener);
        }
    }

    public void fireBeforeOnloadReportAction(Object obj) {
        for (IQingAnalysisReportListener listener : this.listenerList) {
            if (!(listener instanceof IQingReportActionListener)) continue;
            ((IQingReportActionListener)listener).beforeOnload(obj);
        }
    }

    public void fireAfterOnloadReportAction(Object obj) {
        for (IQingAnalysisReportListener listener : this.listenerList) {
            if (!(listener instanceof IQingReportActionListener)) continue;
            ((IQingReportActionListener)listener).afterOnload(obj);
        }
    }

    public void fireBeforeDisposeUIAction(Object obj) {
        for (IQingAnalysisReportListener listener : this.listenerList) {
            if (!(listener instanceof IQingReportActionListener)) continue;
            ((IQingReportActionListener)listener).beforeDisposeUI(obj);
        }
    }

    public void fireAfterDisposeUIAction(Object obj) {
        for (IQingAnalysisReportListener listener : this.listenerList) {
            if (!(listener instanceof IQingReportActionListener)) continue;
            ((IQingReportActionListener)listener).afterDisposeUI(obj);
        }
    }
}

