/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qingReport.server.dataProvider.dataWrapper;

import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.FieldAdapter;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.QingFieldType;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.QingMeta;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class QingReportFilterWrapper {
    private static Logger logger = Logger.getLogger(QingReportFilterWrapper.class);

    public List<Object> getFieldList(String className, String tag) {
        logger.debug((Object)("QingReportFilterWrapper:className=" + className + "   tag=" + tag));
        ArrayList<Object> fields = new ArrayList<Object>();
        if (className != null && tag != null) {
            try {
                Object instance = null;
                Method method = null;
                QingMeta qingMeta = null;
                instance = Class.forName(className).newInstance();
                method = instance.getClass().getMethod("getQingMeta", String.class);
                qingMeta = (QingMeta)((Object)method.invoke(instance, tag));
                int size = qingMeta.getColumns().size();
                for (int i = 0; i < size; ++i) {
                    FieldAdapter fieldAdapter = new FieldAdapter();
                    Field field = (Field)((Object)qingMeta.getColumns().get(i));
                    int fieldType = field.getFieldType();
                    if (fieldType == QingFieldType.String.toNumber()) {
                        fieldAdapter.setType("String");
                        if (field.getRealType() == QingFieldType.Link.toNumber()) {
                            if (field.isTreeGrid()) {
                                fieldAdapter.setTreeGrid(field.isTreeGrid());
                                fieldAdapter.setTreePromptQuery(field.getTreePromptQuery());
                                fieldAdapter.setGridPromptQuery(field.getGridPromptQuery());
                                fieldAdapter.setLinkId(field.getLinkId());
                            }
                            if (field.isOrgFiled()) {
                                fieldAdapter.setOrgField(field.isOrgFiled());
                            }
                            HashMap<String, Object> f7Prop = new HashMap<String, Object>();
                            fieldAdapter.setType("link");
                            String filterName = field.getFilterName() == null ? field.getDisplayFormat() : field.getFilterName() + "." + field.getDisplayFormat();
                            f7Prop.put("filterName", filterName);
                            f7Prop.put("displayFormat", "{" + field.getDisplayFormat() + "}");
                            f7Prop.put("submitFormat", "{" + field.getSubmitFormat() + "}");
                            f7Prop.put("searchItem", field.getSearchItem());
                            fieldAdapter.setPromptQuery(field.getPromptQuery());
                            fieldAdapter.setExtProperty(f7Prop);
                        } else if (field.getRealType() == QingFieldType.Enum.toNumber()) {
                            fieldAdapter.setType("Enum");
                            fieldAdapter.setEnumSource(field.getEnumSource());
                        }
                    } else if (fieldType == QingFieldType.Date.toNumber()) {
                        fieldAdapter.setType("Date");
                    } else if (fieldType == QingFieldType.Boolean.toNumber()) {
                        fieldAdapter.setType("Boolean");
                    } else if (fieldType == QingFieldType.Number.toNumber()) {
                        fieldAdapter.setType("Number");
                    } else if (fieldType == QingFieldType.DateTime.toNumber()) {
                        fieldAdapter.setType("DateTime");
                    } else if (fieldType == QingFieldType.Int.toNumber()) {
                        fieldAdapter.setType("Int");
                    } else if (fieldType == QingFieldType.Enum.toNumber()) {
                        fieldAdapter.setType("Enum");
                    } else {
                        fieldAdapter.setType("String");
                    }
                    fieldAdapter.setAlias(field.getAlias());
                    fieldAdapter.setValue(field.getName());
                    fieldAdapter.setHidden(field.isHide());
                    fieldAdapter.setFilter(field.isFilter());
                    fieldAdapter.setSearch(false);
                    fieldAdapter.setWidth(100);
                    fields.add(fieldAdapter);
                }
            }
            catch (Exception e) {
                logger.error((Object)("getFieldList" + e));
            }
        }
        return fields;
    }
}

