/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.qinganalysis.ui;

import com.kingdee.bos.ctrl.kds.model.struct.embed.browser.jfx.KDWebViewPanel;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.rpts.qinganalysis.i18n.QingAnalysisLanguageUtil;
import com.kingdee.eas.rpts.qinganalysis.js.handler.QingAnalysisExitFullScreenFunction;
import com.kingdee.eas.rpts.qinganalysis.js.util.QingAnalysisFunctionUtil;
import com.kingdee.eas.rpts.qinganalysis.ui.AbstractQingAnalysisCommonExplorer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.Timer;

public class QingAnalysisFullScreenExplorer
extends AbstractQingAnalysisCommonExplorer {
    private Container parent;
    private JPanel tipPan;
    private Timer autoHideTimer;
    private JLayeredPane pane;

    @Override
    public void initUIToolBarLayout() {
        this.idKey = (String)this.uiContext.get((Object)"qingAnalysisId");
        this.browser = (KDWebViewPanel)this.uiContext.get((Object)"webBrowser");
        this.parent = this.browser.getParent();
        this.setLayout(new BorderLayout());
        this.add((Component)this.browser);
    }

    @Override
    public void onShow() throws Exception {
        UIModelDialog dialog = null;
        Container parent = this.getParent();
        for (int i = 0; parent != null && i <= 10; parent = parent.getParent(), ++i) {
            if (parent instanceof JLayeredPane) {
                this.pane = (JLayeredPane)parent;
            }
            if (!(parent instanceof UIModelDialog)) continue;
            dialog = (UIModelDialog)parent;
            break;
        }
        if (this.pane != null) {
            this.createTimerTip();
        }
        if (dialog != null) {
            this.initDialogListener(dialog);
        }
    }

    private void initDialogListener(UIModelDialog dialog) {
        dialog.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    QingAnalysisExitFullScreenFunction.exitFullScreenGUI(QingAnalysisFullScreenExplorer.this.idKey);
                }
            }
        });
    }

    private void createTipPane() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int screenWidth = (int)screenSize.getWidth();
        this.tipPan = new JPanel(null);
        this.tipPan.setBounds((screenWidth - 135) / 2, 30, 135, 23);
        this.tipPan.setBackground(Color.BLACK);
        this.tipPan.setOpaque(true);
        KDLabel tip = new KDLabel(QingAnalysisLanguageUtil.getMLS("exitFullScreen", "\u6309 Esc \u952e\u9000\u51fa\u5168\u5c4f"));
        tip.setBounds(20, 0, 135, 23);
        tip.setOpaque(true);
        tip.setBackground(Color.BLACK);
        tip.setForeground(Color.WHITE);
        tip.setVisible(true);
        this.tipPan.add((Component)tip);
    }

    private void createTimerTip() {
        if (this.tipPan != null) {
            this.pane.remove(this.tipPan);
        } else {
            this.createTipPane();
        }
        this.pane.add((Component)this.tipPan, new Integer(100));
        this.tipPan.setVisible(true);
        if (this.autoHideTimer != null) {
            this.autoHideTimer.setDelay(3000);
            this.autoHideTimer.start();
            return;
        }
        HideTipAction hideTipAction = new HideTipAction();
        this.autoHideTimer = new Timer(3000, hideTipAction);
        this.autoHideTimer.setRepeats(false);
        this.autoHideTimer.start();
    }

    @Override
    public boolean destroyWindow() {
        QingAnalysisFunctionUtil.removeFullScreenUI(this.idKey);
        this.parent.add((Component)this.browser);
        return super.destroyWindow();
    }

    private void hideTip_actionPerformed() {
        this.tipPan.setVisible(false);
        this.autoHideTimer.stop();
    }

    public void showTip() {
        this.createTimerTip();
    }

    class HideTipAction
    implements ActionListener {
        HideTipAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QingAnalysisFullScreenExplorer.this.hideTip_actionPerformed();
        }
    }
}

