/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.explorer.common;

import com.kingdee.bos.ctrl.explorer.common.ScaleInfo;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageBreviary {
    public static byte[] createBreviaryImage(BufferedImage bis, int width, int height) throws IOException {
        AffineTransform transform = new AffineTransform();
        int w = bis.getWidth();
        int h = bis.getHeight();
        ScaleInfo scaleInfo = ImageBreviary.scale(w, h, width, height);
        Dimension scaleDimension = scaleInfo.getDimension();
        double scale = scaleInfo.getScale();
        if (scale > 1.0) {
            transform.setToScale(1.0, 1.0);
        } else {
            transform.setToScale(scale, scale);
        }
        AffineTransformOp ato = new AffineTransformOp(transform, null);
        BufferedImage bid = new BufferedImage(scaleDimension.width, scaleDimension.height, 2);
        ato.filter(bis, bid);
        ByteArrayOutputStream imageStream = new ByteArrayOutputStream();
        boolean resultWrite = ImageIO.write((RenderedImage)bid, "png", imageStream);
        if (!resultWrite) {
            return null;
        }
        byte[] tagInfo = imageStream.toByteArray();
        return tagInfo;
    }

    public static ScaleInfo scale(int width, int height, int scaleWidth, int scaleHeight) {
        double sx = (double)scaleWidth / (double)width;
        double sy = (double)scaleHeight / (double)height;
        double scale = Math.min(sx, sy);
        if (sx > sy) {
            width = (int)((double)width * sy);
            height = scaleHeight;
        } else {
            height = (int)((double)height * sx);
            width = scaleWidth;
        }
        ScaleInfo scaleInfo = new ScaleInfo(new Dimension(width, height), scale);
        return scaleInfo;
    }
}

