/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.explorer.common.client;

import com.kingdee.bos.ctrl.explorer.common.client.TreeNodeUserObject;
import com.kingdee.bos.ctrl.explorer.manage.client.SourceTree;
import com.kingdee.bos.ctrl.explorer.model.ILightSource;
import com.kingdee.bos.ctrl.semantic.common.Util;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;

public class TreeBuilder {
    private KDTree _tree;

    public TreeBuilder(KDTree tree) {
        this._tree = tree;
    }

    public void refreshRoot(List lightSource) {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this._tree.getModel().getRoot();
        this.refresh(root, "", lightSource, true);
    }

    public void refreshNode(DefaultKingdeeTreeNode parentNode, List lightSource) {
        this.refresh(parentNode, SourceTree.lookupPath(parentNode), lightSource, false);
    }

    private void refresh(DefaultKingdeeTreeNode parentNode, String path, List lightSource, boolean isRoot) {
        int pathLen = path.length();
        NodesMap parentCache = new NodesMap();
        this.storeCache(parentNode, parentCache);
        int c = lightSource.size();
        for (int i = 0; i < c; ++i) {
            ILightSource info = (ILightSource)lightSource.get(i);
            String subPath = info.getPath();
            if (pathLen > 0) {
                subPath = subPath.substring(pathLen);
            }
            if (subPath.startsWith(Util.PATH_SPLIT)) {
                subPath = subPath.substring(1);
            }
            String[] ps = Util.splitPath(subPath);
            DefaultKingdeeTreeNode pNode = parentNode;
            NodesMap cache = parentCache;
            for (int j = 0; j < ps.length; ++j) {
                String name = ps[j];
                DefaultKingdeeTreeNode tempNode = cache.getNode(name);
                if (tempNode == null) {
                    tempNode = new DefaultKingdeeTreeNode((Object)name);
                    tempNode.setCustomIcon(parentNode.getRenderIcon(false, false));
                    this._tree.addNodeInto((MutableTreeNode)tempNode, (MutableTreeNode)pNode);
                    cache.putNode(name, tempNode);
                }
                pNode = tempNode;
                cache = cache.getChildMap(name);
            }
            if (isRoot) continue;
            if (!(pNode.getUserObject() instanceof TreeNodeUserObject)) {
                TreeNodeUserObject userObject = new TreeNodeUserObject();
                pNode.setUserObject((Object)userObject);
            }
            ((TreeNodeUserObject)pNode.getUserObject()).addNodeUserObject(info);
        }
    }

    private void storeCache(DefaultKingdeeTreeNode folder, NodesMap cache) {
        int c = folder.getChildCount();
        for (int i = 0; i < c; ++i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)folder.getChildAt(i);
            NodesMap childCache = cache.putNode(child.toString(), child);
            this.storeCache(child, childCache);
        }
    }

    public static class NodesMap {
        private Map _mapNodes = new HashMap();
        private Map _mapChildrenMap = new HashMap();

        public NodesMap putNode(String name, DefaultKingdeeTreeNode node) {
            this._mapNodes.put(name, node);
            NodesMap childMap = new NodesMap();
            this._mapChildrenMap.put(name, childMap);
            return childMap;
        }

        public DefaultKingdeeTreeNode getNode(String name) {
            return (DefaultKingdeeTreeNode)this._mapNodes.get(name);
        }

        public NodesMap getChildMap(String name) {
            return (NodesMap)this._mapChildrenMap.get(name);
        }
    }
}

