/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.explorer.manage.client;

import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.explorer.manage.exception.SourceManageException;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class NameDialog
extends TypicalDialog {
    private static final Logger log = LogUtil.getPackageLogger(NameDialog.class);
    public static final char SPLIT_CHAR = '/';
    public static final String ROOT_PATH_TEXT = "/";
    public static final String INVALID_CHARS = "\\:*?\"<>|";
    protected KDTextField _txtName;
    private String _oldName;
    private IChecker _checker;

    public static NameDialog create(Component parentCtrl, String title) {
        Window win = SwingUtilities.getWindowAncestor(parentCtrl);
        if (win instanceof Frame) {
            return new NameDialog((Frame)win, title);
        }
        if (win instanceof Dialog) {
            return new NameDialog((Dialog)win, title);
        }
        return new NameDialog(title);
    }

    public NameDialog(String title) {
        this.setTitle(title);
    }

    public NameDialog(Dialog owner, String title) {
        super(owner);
        this.setTitle(title);
    }

    public NameDialog(Frame owner, String title) {
        super(owner);
        this.setTitle(title);
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        super.setSize(320, 115);
        KDLabelContainer lbc = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtName, (String)"\u540d\u79f0", (int)80);
        parent.add((Component)lbc, thisCell);
        this.btnOk.setEnabled(false);
        this._txtName.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                String name = NameDialog.this.getNewName();
                NameDialog.this.btnOk.setEnabled(!"".equals(name) && NameDialog.isValidPath(NameDialog.ROOT_PATH_TEXT + name) && !name.equals(NameDialog.this._oldName));
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    protected void todoInit() {
        this._txtName = new KDTextField();
    }

    public String getNewName() {
        return this._txtName.getText().trim();
    }

    public void setOldName(String text) {
        this._oldName = text;
        this._txtName.setText(text);
    }

    public void setChecker(IChecker checker) {
        this._checker = checker;
    }

    public static final boolean isValidPath(String p) {
        boolean valid;
        boolean bl = valid = p.length() > 0 && p.charAt(0) == '/';
        if (valid) {
            if (p.length() > 1 && p.charAt(p.length() - 1) == '/') {
                return false;
            }
            for (int i = 1; i < p.length(); ++i) {
                if (INVALID_CHARS.indexOf(p.charAt(i)) != -1) {
                    return false;
                }
                if (p.charAt(i) != '/' || p.charAt(i - 1) != '/') continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    protected boolean verify() {
        if (this._checker != null) {
            try {
                return !this._checker.isNameExist(this._txtName.getText(), (Component)((Object)this));
            }
            catch (SourceManageException e) {
                log.error((Object)"check floder node exist error", (Throwable)e);
                MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u68c0\u67e5\u540d\u79f0\u662f\u5426\u5b58\u5728\u51fa\u9519\uff0c\u68c0\u67e5\u65e5\u5fd7\u3002");
                return false;
            }
        }
        return true;
    }

    public static interface IChecker {
        public boolean isNameExist(String var1, Component var2) throws SourceManageException;
    }
}

