/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.explorer.manage.client;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.UID;
import com.kingdee.bos.ctrl.explorer.common.FacadeCreator;
import com.kingdee.bos.ctrl.explorer.manage.IExtManageFacade;
import com.kingdee.bos.ctrl.explorer.manage.client.SourceEditorDialog;
import com.kingdee.bos.ctrl.explorer.manage.client.SourceTree;
import com.kingdee.bos.ctrl.explorer.manage.client.UpdataBlock;
import com.kingdee.bos.ctrl.explorer.manage.exception.SourceManageException;
import com.kingdee.bos.ctrl.explorer.model.ILightSource;
import com.kingdee.bos.ctrl.explorer.model.LightSource;
import com.kingdee.bos.ctrl.explorer.model.base.EditorModel;
import com.kingdee.bos.ctrl.explorer.model.base.SourceType;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.eas.util.client.ComponentUtil;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ResourceManage {
    private static final Logger log = LogUtil.getPackageLogger(ResourceManage.class);
    private SourceTree _sourceTree;

    public ResourceManage(SourceTree sourceTree) {
        this._sourceTree = sourceTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(ILightSource source, File file, IExtManageFacade mangeFacade) throws SourceManageException {
        File gifFile = null;
        try {
            UpdataBlock up = null;
            String sfile = file.getAbsolutePath();
            if (sfile.substring(sfile.length() - 4).equalsIgnoreCase(".gif")) {
                gifFile = File.createTempFile("Temp", ".gif");
                short time = 10;
                CtrlSwingUtilities.readImgFromFile2((File)file, (short)time, (File)gifFile);
                up = new UpdataBlock(source.getID(), gifFile, mangeFacade);
            } else {
                up = new UpdataBlock(source.getID(), file, mangeFacade);
            }
            up.updata();
        }
        catch (IOException e) {
            log.error((Object)"upLoad source failed", (Throwable)e);
            MessageUtil.msgboxInfo((Component)this._sourceTree.getTree(), (String)"\u8d44\u6e90\u4e0a\u4f20\u6216\u4fdd\u5b58\u5931\u8d25\u3002");
            boolean bl = false;
            return bl;
        }
        finally {
            if (gifFile != null) {
                gifFile.delete();
            }
        }
        return true;
    }

    public ILightSource mode2source(EditorModel model) {
        LightSource source = new LightSource();
        if (model.getID() == null) {
            String uid = UID.create16();
            source.setID(uid);
        } else {
            source.setID(model.getID());
        }
        Window owner = ComponentUtil.getCurrentActiveWindow();
        String orgID = this._sourceTree.getOrgID(owner);
        source.setOrg(orgID);
        source.setBreviary(model.getBrevuary());
        source.setHeight(model.getHeight());
        source.setWidth(model.getWidth());
        source.setSize(model.getSize());
        source.setName(model.getName());
        String name = model.getFile().getName();
        source.setType(SourceType.toSourceType(name.substring(name.lastIndexOf(".") + 1)));
        source.setPath(this._sourceTree.getSelectPath());
        return source;
    }

    public class Checker
    implements SourceEditorDialog.IChecker {
        private String _path;
        private FacadeCreator _facade;

        public Checker(String path, FacadeCreator facade) {
            this._path = path;
            this._facade = facade;
        }

        @Override
        public boolean isNameExist(String name, Component owner) {
            try {
                IExtManageFacade mangeFacade = this._facade.getManageFacade();
                String orgID = ResourceManage.this._sourceTree.getOrgID(owner);
                if (orgID == null) {
                    return false;
                }
                if (mangeFacade.checkExist(name, this._path, orgID)) {
                    MessageUtil.msgboxWarning((Component)owner, (String)"\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002");
                    return true;
                }
            }
            catch (SourceManageException e) {
                log.error((Object)"upLoad source failed", (Throwable)e);
            }
            return false;
        }
    }
}

