/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.explorer.manage.client;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.explorer.common.FacadeCreator;
import com.kingdee.bos.ctrl.explorer.common.client.TreeNodeUserObject;
import com.kingdee.bos.ctrl.explorer.manage.IExtManageFacade;
import com.kingdee.bos.ctrl.explorer.manage.client.PreviewPane;
import com.kingdee.bos.ctrl.explorer.manage.client.ResourceManage;
import com.kingdee.bos.ctrl.explorer.manage.client.SourceEditorDialog;
import com.kingdee.bos.ctrl.explorer.manage.client.SourceTree;
import com.kingdee.bos.ctrl.explorer.manage.client.SourceViewDialog;
import com.kingdee.bos.ctrl.explorer.manage.exception.BadDataException;
import com.kingdee.bos.ctrl.explorer.manage.exception.NotExitSourceException;
import com.kingdee.bos.ctrl.explorer.manage.exception.SourceManageException;
import com.kingdee.bos.ctrl.explorer.model.ILightSource;
import com.kingdee.bos.ctrl.explorer.model.base.EditorModel;
import com.kingdee.bos.ctrl.explorer.model.base.SourceType;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.apache.log4j.Logger;

public class ResourceManageUI
extends CoreUI {
    private static final Logger logger = CoreUIObject.getLogger(ResourceManageUI.class);
    private static final int COL_NAME = 0;
    private static final int COL_DIMENSION = 1;
    private static final int COL_SIZE = 2;
    private static final int COL_TYPE = 3;
    private static final int COL_CREATOR = 4;
    private static final int COL_TIME = 5;
    private KDWorkButton _btnNew;
    private KDWorkButton _btnView;
    private KDWorkButton _btnEdit;
    private KDWorkButton _btnDelete;
    private KDWorkButton _btnRefresh;
    private SourceTree _sourceTree;
    private KDTable _table;
    private List _nowSource;
    private PreviewPane _viewPane;
    private KDCheckBox _showChild;
    private FacadeCreator facede = new FacadeCreator();
    private ResourceManage _resManage;

    public ResourceManageUI() throws Exception {
        this.init();
        this._resManage = new ResourceManage(this._sourceTree);
        this.action_refresh();
    }

    private void init() {
        this.setUITitle("\u8d44\u6e90\u7ba1\u7406\u4e2d\u5fc3");
        ButtonActionHandler action = new ButtonActionHandler();
        this._btnNew = new KDWorkButton();
        this._btnNew.setText("\u65b0\u5efa");
        this._btnNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this._btnNew.addActionListener((ActionListener)action);
        this._btnView = new KDWorkButton();
        this._btnView.setText("\u67e5\u770b");
        this._btnView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this._btnView.addActionListener((ActionListener)action);
        this._btnEdit = new KDWorkButton();
        this._btnEdit.setText("\u7f16\u8f91");
        this._btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this._btnEdit.addActionListener((ActionListener)action);
        this._btnDelete = new KDWorkButton();
        this._btnDelete.setText("\u5220\u9664");
        this._btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this._btnDelete.addActionListener((ActionListener)action);
        this._btnRefresh = new KDWorkButton();
        this._btnRefresh.setText("\u5237\u65b0");
        this._btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this._btnRefresh.addActionListener((ActionListener)action);
        this._sourceTree = new SourceTree();
        this._sourceTree.setFacade(this.facede);
        this._sourceTree.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    if (ResourceManageUI.this._sourceTree.getTree().getSelectionPath() == null) {
                        ResourceManageUI.this._nowSource = null;
                        ResourceManageUI.this._table.removeRows();
                        ResourceManageUI.this._viewPane.setImage(null);
                        return;
                    }
                    ResourceManageUI.this.action_showChild();
                }
                catch (SourceManageException e1) {
                    ResourceManageUI.this.handUIException(e1);
                }
            }
        });
        this._viewPane = new PreviewPane();
        this._viewPane.setBorder(BorderFactory.createTitledBorder(""));
        this._viewPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    try {
                        ResourceManageUI.this.action_view();
                    }
                    catch (SourceManageException e1) {
                        ResourceManageUI.this.handUIException(e1);
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ResourceManageUI.this._viewPane.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ResourceManageUI.this._viewPane.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            }
        });
        this._showChild = new KDCheckBox("\u5305\u542b\u4e0b\u7ea7\u8282\u70b9");
        this._showChild.addActionListener((ActionListener)action);
        this._table = new KDTable();
        this._table.addColumns(6);
        this._table.getColumn(0).setWidth(240);
        this._table.getColumn(1).setWidth(140);
        this._table.getColumn(2).setWidth(140);
        this._table.getColumn(3).setWidth(140);
        this._table.getColumn(4).setWidth(180);
        this._table.getColumn(5).setWidth(180);
        IRow row = this._table.addHeadRow();
        row.getCell(0).setValue((Object)"\u540d\u79f0");
        row.getCell(1).setValue((Object)"\u56fe\u7247\u5927\u5c0f");
        row.getCell(2).setValue((Object)"\u6587\u4ef6\u5927\u5c0f\uff08KB\uff09");
        row.getCell(3).setValue((Object)"\u56fe\u7247\u683c\u5f0f");
        row.getCell(4).setValue((Object)"\u521b\u5efa\u8005");
        row.getCell(5).setValue((Object)"\u521b\u5efa\u65f6\u95f4");
        this._table.setEditable(false);
        this._table.getSelectManager().setSelectMode(2);
        this._table.getColumn(5).getStyleAttributes().setNumberFormat("yyyy-MM-dd");
        this._table.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int index = ResourceManageUI.this._table.getSelectManager().getActiveRowIndex();
                ILightSource source = (ILightSource)ResourceManageUI.this._nowSource.get(index);
                if (source.getBreviary() == null) {
                    try {
                        source.setBreviary(ResourceManageUI.this.facede.getManageFacade().getBreviary(source.getID()));
                    }
                    catch (SourceManageException e1) {
                        ResourceManageUI.this.handUIException(e1);
                    }
                }
                ImageIcon image = new ImageIcon(source.getBreviary());
                ResourceManageUI.this._viewPane.setImage(image.getImage());
            }
        });
        this._table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (ResourceManageUI.this._table.getSelectManager().getActiveRowIndex() < 0) {
                        return;
                    }
                    try {
                        ResourceManageUI.this.action_edit();
                    }
                    catch (SourceManageException e1) {
                        ResourceManageUI.this.handUIException(e1);
                    }
                }
            }
        });
    }

    public void onLoad() throws Exception {
        this.getUIContext().put("checkLicense", "false");
        int lt = FrameWorkClientUtils.getLicenseController().requestLicenseByUserAndSubSystemOnCache((LicenseUserInfo)SysContext.getSysContext().getProperty((Object)"License.UserInfo"), "BOS_RPTC_MOBILE_STUDIO");
        if (lt != 1) {
            this.getUIContext().put("checkLicense", "true");
        }
        super.onLoad();
        this.setCustomInsets(new Insets(0, 5, 5, 5));
        KDPanel panel1 = new KDPanel();
        TableLayout2 layout1 = new TableLayout2(2, 1);
        layout1.setRatableHeight(0, 1);
        layout1.setRowSpacing(0, 5);
        layout1.setFixedHeight(1, 150);
        panel1.setLayout((LayoutManager)layout1);
        panel1.add((Component)this._sourceTree.getUI(), (Object)TableLayout2.param((int)0, (int)0));
        panel1.add((Component)((Object)this._viewPane), (Object)TableLayout2.param((int)1, (int)0));
        KDPanel panel2 = new KDPanel();
        TableLayout2 layout2 = new TableLayout2(2, 1);
        layout2.setFixedHeight(0, 20);
        layout2.setRatableHeight(1, 1);
        panel2.setLayout((LayoutManager)layout2);
        panel2.add((Component)this._showChild, (Object)TableLayout2.param((int)0, (int)0));
        panel2.add((Component)this._table, (Object)TableLayout2.param((int)1, (int)0));
        KDSplitPane splitPane = new KDSplitPane(1, (Component)panel1, (Component)panel2);
        splitPane.setDividerLocation(200);
        splitPane.setDividerOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
        this.tHelper.getDisabledTables().add(this._table);
    }

    public boolean destroyWindow() {
        try {
            FrameWorkClientUtils.getLicenseController().releaseLicenseBySessionIDAndSubSystemOnCache(SysContext.getSysContext().getSessionID(), "BOS_RPTC_MOBILE_STUDIO");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.destroyWindow();
    }

    public void initUIToolBarLayout() {
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this._btnNew);
        this.toolBar.add((Component)this._btnView);
        this.toolBar.add((Component)this._btnEdit);
        this.toolBar.add((Component)this._btnDelete);
        this.toolBar.add((Component)this._btnRefresh);
    }

    private void action_new() throws SourceManageException {
        int selectCount = this._sourceTree.getTree().getSelectionCount();
        if (selectCount == 0) {
            this.showInfo("\u8bf7\u5148\u9009\u62e9\u65b0\u5efa\u76ee\u6807\u7684\u6587\u4ef6\u5939\u3002");
            return;
        }
        SourceEditorDialog dialog = this.createDialog((Component)((Object)this), 0);
        if (dialog.showDialog()) {
            EditorModel model = new EditorModel();
            if (!dialog.updateEditedResult(model)) {
                return;
            }
            IExtManageFacade mangeFacade = this.facede.getManageFacade();
            ILightSource source = this._resManage.mode2source(model);
            try {
                source = mangeFacade.createLightSource(source);
            }
            catch (SourceManageException e) {
                this.showInfo("\u65b0\u5efa\u8d44\u6e90\u5931\u8d25\uff0c\u8d44\u6e90\u540d\u79f0\u8fc7\u957f\u6216\u8d44\u6e90\u7c7b\u578b\u4e0d\u7b26\u5408\u8981\u6c42\u3002");
                return;
            }
            File file = model.getFile();
            if (!this._resManage.save(source, file, mangeFacade)) {
                return;
            }
            DefaultKingdeeTreeNode node = this._sourceTree.getSelectNode();
            if (node.getUserObject() instanceof TreeNodeUserObject) {
                ((TreeNodeUserObject)node.getUserObject()).addNodeUserObject(source);
            } else {
                TreeNodeUserObject userObject = new TreeNodeUserObject();
                userObject.addNodeUserObject(source);
                node.setUserObject((Object)userObject);
            }
            if (!this._nowSource.contains(source)) {
                this._nowSource.add(source);
            }
            this.addOneRow(source, this._table.getRowCount());
            KDTableUtil.setSelectedRow((KDTable)this._table, (int)(this._table.getRowCount() - 1));
        }
    }

    private void action_view() throws SourceManageException {
        int index = this._table.getSelectManager().getActiveRowIndex();
        if (index < 0) {
            this.showInfo("\u8bf7\u9009\u62e9\u8d44\u6e90\u3002");
            return;
        }
        ILightSource source = (ILightSource)this._nowSource.get(index);
        IExtManageFacade mangeFacade = this.facede.getManageFacade();
        SourceViewDialog viewDialog = SourceViewDialog.create((Component)((Object)this));
        ImageIcon image = null;
        try {
            image = new ImageIcon(mangeFacade.getViewImage(source.getID(), 557, 368));
        }
        catch (BadDataException e) {
            this.showInfo("\u635f\u574f\u7684\u6587\u4ef6\uff0c\u5efa\u8bae\u5220\u9664\u8be5\u8d44\u6e90\u3002");
            return;
        }
        catch (NotExitSourceException e) {
            this.showInfo("\u8d44\u6e90\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u5efa\u8bae\u5220\u9664\u8be5\u8d44\u6e90\u3002");
            return;
        }
        EditorModel model = this.source2model(source);
        model.setImage(image.getImage());
        viewDialog.setEditData(model);
        viewDialog.show();
    }

    private void action_edit() throws SourceManageException {
        int index = this._table.getSelectManager().getActiveRowIndex();
        if (index < 0) {
            this.showInfo("\u8bf7\u9009\u62e9\u8d44\u6e90\u3002");
            return;
        }
        ILightSource source = (ILightSource)this._nowSource.get(index);
        SourceEditorDialog editDialog = this.createDialog((Component)((Object)this), 1);
        IExtManageFacade mangeFacade = this.facede.getManageFacade();
        ImageIcon image = null;
        try {
            image = new ImageIcon(mangeFacade.getViewImage(source.getID(), 577, 368));
        }
        catch (BadDataException e) {
            this.showInfo("\u635f\u574f\u7684\u6587\u4ef6\uff0c\u5efa\u8bae\u5220\u9664\u8be5\u8d44\u6e90\u3002");
            return;
        }
        catch (NotExitSourceException e) {
            this.showInfo("\u8d44\u6e90\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u5efa\u8bae\u5220\u9664\u8be5\u8d44\u6e90\u3002");
            return;
        }
        catch (SourceManageException e) {
            this.showInfo("\u521b\u5efa\u56fe\u7247\u5931\u8d25\u3002");
        }
        EditorModel model = this.source2model(source);
        if (null != image) {
            model.setImage(image.getImage());
        }
        editDialog.setEditData(model);
        if (editDialog.showDialog()) {
            if (!editDialog.updateEditedResult(model)) {
                return;
            }
            if (model.isDirty()) {
                source = this._resManage.mode2source(model);
                if (!this._resManage.save(source, model.getFile(), mangeFacade)) {
                    return;
                }
                try {
                    source = mangeFacade.updataLightSource(source);
                }
                catch (SourceManageException e) {
                    this.showInfo("\u7f16\u8f91\u8d44\u6e90\u5931\u8d25\uff0c\u8d44\u6e90\u540d\u79f0\u8fc7\u957f\u6216\u8d44\u6e90\u7c7b\u578b\u4e0d\u7b26\u5408\u8981\u6c42\u3002");
                    return;
                }
                this._nowSource.set(index, source);
                this.refreshOneRow(source, index);
                ImageIcon vreviary = new ImageIcon(source.getBreviary());
                this._viewPane.setImage(vreviary.getImage());
                TreeNodeUserObject userObject = (TreeNodeUserObject)this._sourceTree.getNode(source.getPath()).getUserObject();
                userObject.insertSrouce(source);
            } else if (!source.getName().equalsIgnoreCase(model.getName())) {
                source.setName(model.getName());
                try {
                    source = mangeFacade.updataLightSource(source);
                }
                catch (SourceManageException e) {
                    this.showInfo("\u7f16\u8f91\u8d44\u6e90\u5931\u8d25\uff0c\u8d44\u6e90\u540d\u79f0\u8fc7\u957f\u6216\u8d44\u6e90\u7c7b\u578b\u4e0d\u7b26\u5408\u8981\u6c42\u3002");
                    return;
                }
                this._nowSource.set(index, source);
                this.refreshOneRow(source, index);
                ImageIcon vreviary = new ImageIcon(source.getBreviary());
                this._viewPane.setImage(vreviary.getImage());
                TreeNodeUserObject userObject = (TreeNodeUserObject)this._sourceTree.getNode(source.getPath()).getUserObject();
                userObject.insertSrouce(source);
            }
        }
    }

    private void action_refresh() throws SourceManageException {
        int selectCount = this._sourceTree.getTree().getSelectionCount();
        if (selectCount == 0) {
            this.showInfo("\u8bf7\u5148\u9009\u62e9\u65b0\u5efa\u76ee\u6807\u7684\u6587\u4ef6\u5939\u3002");
            return;
        }
        this.refreshOnePath();
    }

    private void action_showChild() throws SourceManageException {
        List list = null;
        list = this._showChild.isSelected() ? this._sourceTree.getAllSource(this._sourceTree.getSelectNode(), list) : this._sourceTree.getSource(this._sourceTree.getSelectNode());
        this._nowSource = list;
        this.refreshTabel();
    }

    private void action_delete() throws SourceManageException {
        int index = this._table.getSelectManager().getActiveRowIndex();
        if (index < 0) {
            this.showInfo("\u8bf7\u9009\u62e9\u8d44\u6e90\u3002");
            return;
        }
        ILightSource source = (ILightSource)this._nowSource.get(index);
        if (MessageUtil.msgboxOkCancel((Component)this._sourceTree.getTree(), (String)("\u786e\u5b9a\u5220\u9664\u8d44\u6e90\uff1a" + source.getName()))) {
            IExtManageFacade mangeFacade = this.facede.getManageFacade();
            mangeFacade.deleteSource(source.getID());
            this._table.removeRow(index);
            this._nowSource.remove(source);
            TreeNodeUserObject userObject = (TreeNodeUserObject)this._sourceTree.getNode(source.getPath()).getUserObject();
            userObject.remove(source);
            if (this._table.getRowCount() > 0) {
                KDTableUtil.setSelectedRow((KDTable)this._table, (int)this._table.getSelectManager().getActiveRowIndex());
            } else {
                this._viewPane.setImage(null);
            }
        }
    }

    private SourceEditorDialog createDialog(Component parentCtrl, int editor) {
        SourceEditorDialog dialog = SourceEditorDialog.create((Component)((Object)this), editor);
        if (editor == 0) {
            ResourceManage resourceManage = this._resManage;
            resourceManage.getClass();
            ResourceManage.Checker checker = resourceManage.new ResourceManage.Checker(this._sourceTree.getSelectPath(), this.facede);
            dialog.setChecker(checker);
        } else if (editor == 1) {
            int index = this._table.getSelectManager().getActiveRowIndex();
            String path = ((ILightSource)this._nowSource.get(index)).getPath();
            ResourceManage resourceManage = this._resManage;
            resourceManage.getClass();
            ResourceManage.Checker checker = resourceManage.new ResourceManage.Checker(path, this.facede);
            dialog.setChecker(checker);
        }
        return dialog;
    }

    private EditorModel source2model(ILightSource source) {
        EditorModel model = new EditorModel();
        model.setHeight(source.getHeight());
        model.setWidth(source.getWidth());
        model.setName(source.getName());
        model.setID(source.getID());
        return model;
    }

    private void refreshOnePath() throws SourceManageException {
        IExtManageFacade mangeFacade = this.facede.getManageFacade();
        List lightsource = null;
        lightsource = this._showChild.isSelected() ? mangeFacade.getFullPathSource(this._sourceTree.getSelectPath(), this._sourceTree.getOrgID(null)) : mangeFacade.getPathSource(this._sourceTree.getSelectPath(), this._sourceTree.getOrgID(null));
        this._sourceTree.freshTreeNode(this._sourceTree.getSelectNode(), lightsource, this._showChild.isSelected());
        this._nowSource = lightsource;
        this.refreshTabel();
    }

    private void refreshTabel() {
        this._table.removeRows();
        for (int i = 0; i < this._nowSource.size(); ++i) {
            ILightSource source = (ILightSource)this._nowSource.get(i);
            this.addOneRow(source, i);
        }
        if (this._table.getRowCount() > 0) {
            KDTableUtil.setSelectedRow((KDTable)this._table, (int)0);
        } else {
            this._viewPane.setImage(null);
        }
    }

    private void refreshOneRow(ILightSource source, int index) {
        if (this._table.getRowCount() < index + 1) {
            return;
        }
        IRow row = this._table.getRow(index);
        row.getCell(0).setValue((Object)source.getName());
        row.getCell(1).setValue((Object)(source.getWidth() + " x " + source.getHeight()));
        row.getCell(2).setValue((Object)new Integer(source.getSize()));
        row.getCell(3).setValue((Object)SourceType.toSourceName(source.getType()));
        row.getCell(4).setValue((Object)source.getCreator());
        row.getCell(5).setValue((Object)source.getCreateTime());
    }

    private void addOneRow(ILightSource source, int index) {
        this._table.addRow(index);
        IRow row = this._table.getRow(index);
        row.getCell(0).setValue((Object)source.getName());
        row.getCell(1).setValue((Object)(source.getWidth() + " x " + source.getHeight()));
        row.getCell(2).setValue((Object)new Integer(source.getSize()));
        row.getCell(3).setValue((Object)SourceType.toSourceName(source.getType()));
        row.getCell(4).setValue((Object)source.getCreator());
        row.getCell(5).setValue((Object)source.getCreateTime());
    }

    private void showInfo(String text) {
        MessageUtil.msgboxInfo((Component)this._sourceTree.getTree(), (String)text);
    }

    public IMetaDataPK getMetaDataPK() {
        return MetaDataPK.create((String)"com.kingdee.bos.ctrl.explorer.manage.client", (String)"ResourceManageUI");
    }

    private class ButtonActionHandler
    implements ActionListener {
        private ButtonActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block10: {
                Object ctrl = e.getSource();
                try {
                    if (ctrl == ResourceManageUI.this._btnNew) {
                        ResourceManageUI.this.action_new();
                        break block10;
                    }
                    if (ctrl == ResourceManageUI.this._btnView) {
                        ResourceManageUI.this.action_view();
                        break block10;
                    }
                    if (ctrl == ResourceManageUI.this._btnEdit) {
                        ResourceManageUI.this.action_edit();
                        break block10;
                    }
                    if (ctrl == ResourceManageUI.this._btnRefresh) {
                        ResourceManageUI.this.action_refresh();
                        break block10;
                    }
                    if (ctrl == ResourceManageUI.this._btnDelete) {
                        ResourceManageUI.this.action_delete();
                        break block10;
                    }
                    if (ctrl != ResourceManageUI.this._showChild) break block10;
                    int selectCount = ResourceManageUI.this._sourceTree.getTree().getSelectionCount();
                    if (selectCount == 0) {
                        ResourceManageUI.this.showInfo("\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u6587\u4ef6\u5939\u3002");
                        ResourceManageUI.this._showChild.setSelected(!ResourceManageUI.this._showChild.isSelected());
                        return;
                    }
                    try {
                        ResourceManageUI.this.action_showChild();
                    }
                    catch (SourceManageException se) {
                        ResourceManageUI.this._showChild.setSelected(!ResourceManageUI.this._showChild.isSelected());
                        throw se;
                    }
                }
                catch (Exception ex) {
                    ResourceManageUI.this.handUIException(ex);
                }
            }
        }
    }
}

