/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.explorer.manage.client;

import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.explorer.common.ImageBreviary;
import com.kingdee.bos.ctrl.explorer.manage.client.PreviewPane;
import com.kingdee.bos.ctrl.explorer.model.base.EditorModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.pic.ImageFilter;
import com.kingdee.bos.ctrl.ext.ui.wizards.pic.ImageUtils;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImagingOpException;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class SourceEditorDialog
extends TypicalDialog {
    public static final int NEW = 0;
    public static final int EDITOR = 1;
    private static int type = 1;
    private KDTextField dimension;
    private KDTextField nameLabel;
    private PreviewPane imagePane;
    private KDTextField pathLabel;
    private KDWorkButton viewButton;
    private KDLabelContainer path;
    private boolean isDirty = false;
    private String oldName = null;
    private int width;
    private int height;
    private int size;
    private BufferedImage bis = null;
    private File file;
    private IChecker checker;

    public static SourceEditorDialog create(Component parentCtrl, int editor) {
        Window win = SwingUtilities.getWindowAncestor(parentCtrl);
        type = editor;
        if (win instanceof Frame) {
            return new SourceEditorDialog((Frame)win);
        }
        if (win instanceof Dialog) {
            return new SourceEditorDialog((Dialog)win);
        }
        return new SourceEditorDialog();
    }

    public SourceEditorDialog(Dialog owner) {
        super(owner);
    }

    public SourceEditorDialog(Frame owner) {
        super(owner);
    }

    public SourceEditorDialog() {
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        KDLabelContainer dimensionContainer = CtrlSwingUtilities.createLabelContainer((JComponent)this.dimension, (String)"\u5c3a\u5bf8", (int)50);
        KDLabelContainer lbcName = CtrlSwingUtilities.createLabelContainer((JComponent)this.nameLabel, (String)"\u540d\u79f0", (int)80);
        KDPanel pane = new KDPanel();
        TableLayout2 tableLayout = new TableLayout2(3, 3);
        tableLayout.setFixedHeight(0, 20);
        tableLayout.setRowSpacing(0, 6);
        tableLayout.setFixedHeight(1, 20);
        tableLayout.setRowSpacing(1, 6);
        tableLayout.setRatableHeight(2, 1);
        tableLayout.setRatableWidth(0, 1);
        tableLayout.setColSpacing(0, 20);
        tableLayout.setFixedWidth(1, 100);
        tableLayout.setColSpacing(1, 2);
        tableLayout.setFixedWidth(2, 50);
        pane.setLayout((LayoutManager)tableLayout);
        pane.add((Component)this.path, (Object)TableLayout2.param((int)0, (int)0, (int)0, (int)1));
        pane.add((Component)this.viewButton, (Object)TableLayout2.param((int)0, (int)2));
        pane.add((Component)lbcName, (Object)TableLayout2.param((int)1, (int)0));
        pane.add((Component)dimensionContainer, (Object)TableLayout2.param((int)1, (int)1, (int)1, (int)2));
        pane.add((Component)((Object)this.imagePane), (Object)TableLayout2.param((int)2, (int)0, (int)2, (int)2));
        parent.add((Component)pane, thisCell);
    }

    protected void todoInit() {
        this.dimension = new KDTextField();
        this.dimension.setEditable(false);
        this.nameLabel = new KDTextField();
        this.pathLabel = new KDTextField();
        this.pathLabel.setEditable(false);
        this.viewButton = new KDWorkButton("\u6d4f\u89c8");
        this.viewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDFileChooser fc = new KDFileChooser();
                fc.setMultiSelectionEnabled(false);
                fc.setFileFilter((FileFilter)new ImageFilter());
                int result = fc.showOpenDialog((Component)((Object)SourceEditorDialog.this));
                if (result == 0) {
                    SourceEditorDialog.this.file = fc.getSelectedFile();
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (SourceEditorDialog.this.file.exists()) {
                                try {
                                    SourceEditorDialog.this.bis = ImageIO.read(SourceEditorDialog.this.file);
                                    if (SourceEditorDialog.this.bis == null) {
                                        MessageUtil.msgboxWarning((Component)((Object)SourceEditorDialog.this), (String)"\u56fe\u7247\u52a0\u8f7d\u5931\u8d25");
                                        SourceEditorDialog.this.clean();
                                        return;
                                    }
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            SourceEditorDialog.this.imagePane.setImage(SourceEditorDialog.this.bis);
                                        }
                                    });
                                    SourceEditorDialog.this.width = SourceEditorDialog.this.bis.getWidth();
                                    SourceEditorDialog.this.height = SourceEditorDialog.this.bis.getHeight();
                                    SourceEditorDialog.this.dimension.setText(SourceEditorDialog.this.width + " x " + SourceEditorDialog.this.height);
                                    SourceEditorDialog.this.pathLabel.setText(SourceEditorDialog.this.file.getAbsolutePath());
                                    SourceEditorDialog.this.size = ImageUtils.getImageByteContent((String)SourceEditorDialog.this.file.getAbsolutePath());
                                    if (type == 0) {
                                        SourceEditorDialog.this.nameLabel.setText(SourceEditorDialog.this.file.getName());
                                    }
                                }
                                catch (IOException e1) {
                                    MessageUtil.msgboxWarning((Component)((Object)SourceEditorDialog.this), (String)"\u56fe\u7247\u52a0\u8f7d\u5931\u8d25");
                                    SourceEditorDialog.this.clean();
                                }
                            }
                        }
                    }).start();
                    SourceEditorDialog.this.isDirty = true;
                }
            }
        });
        this.imagePane = new PreviewPane();
        this.imagePane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.path = CtrlSwingUtilities.createLabelContainer((JComponent)this.pathLabel, (String)"\u56fe\u7247\u6587\u4ef6", (int)80);
        this.setSize(600, 450);
        if (type == 0) {
            this.setTitle("\u65b0\u5efa\u8d44\u6e90");
        } else if (type == 1) {
            this.setTitle("\u7f16\u8f91\u8d44\u6e90");
        }
    }

    protected boolean verify() {
        if (StringUtil.isEmptyString((String)this.nameLabel.getText())) {
            MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return false;
        }
        if (!this.nameLabel.getText().equalsIgnoreCase(this.oldName) && this.checker != null && this.checker.isNameExist(this.nameLabel.getText(), (Component)((Object)this))) {
            return false;
        }
        if ((this.isDirty || type == 0) && !this.file.exists()) {
            MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6216\u91cd\u65b0\u5bfc\u5165\u3002");
            this.clean();
            return false;
        }
        return true;
    }

    private void clean() {
        this.width = 0;
        this.height = 0;
        this.dimension.setText(null);
        this.pathLabel.setText(null);
        this.nameLabel.setText(null);
        this.imagePane.setImage(null);
    }

    public boolean updateEditedResult(EditorModel data) {
        data.setName(this.nameLabel.getText());
        data.setDirty(this.isDirty);
        if (this.isDirty) {
            try {
                data.setBreviary(ImageBreviary.createBreviaryImage(this.bis, 100, 100));
            }
            catch (ImagingOpException e) {
                MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u751f\u6210\u7f29\u7565\u56fe\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
                return false;
            }
            catch (IOException e) {
                MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u7f29\u7565\u56fe\u8f93\u51fa\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
                return false;
            }
            data.setFile(this.file);
            data.setWidth(this.width);
            data.setHeight(this.height);
            data.setSize(this.size);
        }
        return true;
    }

    public Dimension getViewPaneSize() {
        return new Dimension(this.imagePane.getWidth(), this.imagePane.getHeight());
    }

    public void setChecker(IChecker checker) {
        this.checker = checker;
    }

    public void setEditData(EditorModel data) {
        this.width = data.getWidth();
        this.height = data.getHeight();
        this.dimension.setText(this.width + " x " + this.height);
        this.oldName = data.getName();
        this.nameLabel.setText(this.oldName);
        this.imagePane.setImage(data.getImage());
    }

    public void setImage(Image image) {
        this.imagePane.setImage(image);
        this.imagePane.repaint();
    }

    public static interface IChecker {
        public boolean isNameExist(String var1, Component var2);
    }
}

