/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.explorer.manage.client;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.UID;
import com.kingdee.bos.ctrl.explorer.common.FacadeCreator;
import com.kingdee.bos.ctrl.explorer.common.client.TreeBuilder;
import com.kingdee.bos.ctrl.explorer.common.client.TreeNodeUserObject;
import com.kingdee.bos.ctrl.explorer.manage.client.action.DeleteAction;
import com.kingdee.bos.ctrl.explorer.manage.client.action.NewAction;
import com.kingdee.bos.ctrl.explorer.manage.client.action.RenameAction;
import com.kingdee.bos.ctrl.explorer.manage.exception.SourceManageException;
import com.kingdee.bos.ctrl.explorer.model.LightSource;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.semantic.common.Util;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.eas.util.client.ComponentUtil;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class SourceTree {
    private static final Logger log = LogUtil.getPackageLogger(SourceTree.class);
    private KDTree _tree;
    private KDTreeView _treeView;
    private TreeBuilder _treeBuilder;
    private FacadeCreator _facade;
    private NewAction newAction;
    private RenameAction renameAction;
    private DeleteAction deleteAction;
    private DefaultKingdeeTreeNode _organizationRoot;
    private DefaultKingdeeTreeNode _commonRoot;

    public SourceTree() {
        this.initTree();
    }

    public void setFacade(FacadeCreator facade) {
        this._facade = facade;
        this.freshTreeRoot(this._facade);
    }

    public void setShowControlPanel(boolean isShow) {
        this._treeView.setShowControlPanel(isShow);
    }

    private void initTree() {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"/");
        this._organizationRoot = new DefaultKingdeeTreeNode((Object)"\u672c\u7ec4\u7ec7\u6587\u4ef6\u5939");
        this._organizationRoot.setCustomIcon(root.getRenderIcon(false, false));
        this._commonRoot = new DefaultKingdeeTreeNode((Object)"\u516c\u5171\u6587\u4ef6\u5939");
        this._commonRoot.setCustomIcon(root.getRenderIcon(false, false));
        KingdeeTreeModel treeModel = new KingdeeTreeModel((TreeNode)root);
        this._tree = new KDTree();
        this._tree.setModel((TreeModel)treeModel);
        this._tree.setShowsRootHandles(true);
        this._tree.addNodeInto((MutableTreeNode)this._organizationRoot, (MutableTreeNode)root);
        this._tree.addNodeInto((MutableTreeNode)this._commonRoot, (MutableTreeNode)root);
        this._tree.setRootVisible(false);
        this._tree.expandOnLevel(2);
        this._treeView = new KDTreeView(this._tree);
        this._treeView.setShowButton(false);
        this._tree.addTreeSelectionListener((TreeSelectionListener)new SourceTreeSelectionListener());
        this._treeBuilder = new TreeBuilder(this._tree);
        this.newAction = new NewAction(this);
        this.addAction(this.newAction);
        this.renameAction = new RenameAction(this);
        this.addAction(this.renameAction);
        this.deleteAction = new DeleteAction(this);
        this.addAction(this.deleteAction);
        this._tree.setSelectionNode(this._organizationRoot);
    }

    private void freshTreeRoot(FacadeCreator facade) {
        try {
            List sources = facade.getManageFacade().getFreshTreeSource(facade.getCurrentOrgUnitId((Component)this._tree));
            this._treeBuilder.refreshRoot(sources);
        }
        catch (SourceManageException e) {
            log.error((Object)"Refresh semantic schema tree error.", (Throwable)e);
        }
    }

    public void freshTreeNode(DefaultKingdeeTreeNode selectNode, List lightsource, boolean isFreshChild) {
        selectNode.setUserObject(null);
        if (isFreshChild) {
            this.removeUserObject(selectNode);
        }
        this._treeBuilder.refreshNode(selectNode, lightsource);
    }

    private void removeUserObject(DefaultKingdeeTreeNode selectNode) {
        selectNode.setUserObject(null);
        int count = selectNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.removeUserObject((DefaultKingdeeTreeNode)selectNode.getChildAt(i));
        }
    }

    public void addTreeNode(DefaultKingdeeTreeNode child, DefaultKingdeeTreeNode parent) {
        LightSource source = new LightSource();
        String uid = UID.create16();
        source.setID(uid);
        source.setName("ClxOwe88SRAMeb0P");
        source.setOrg(this.getOrgID(null));
        source.setPath(SourceTree.lookupPath(parent) + Util.PATH_SPLIT + child.toString());
        try {
            this._facade.getManageFacade().createFolderSource(source);
            child.setCustomIcon(parent.getRenderIcon(false, false));
            this._tree.addNodeInto((MutableTreeNode)child, (MutableTreeNode)parent);
        }
        catch (SourceManageException e) {
            log.error((Object)"create new floder failed", (Throwable)e);
            MessageUtil.msgboxWarning((Component)this._tree, (String)"\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\u3002");
        }
    }

    public void renameTreeNode(DefaultKingdeeTreeNode node, String newName) {
        String oldPath = SourceTree.lookupPath(node);
        String newPath = oldPath.substring(0, oldPath.lastIndexOf(Util.PATH_SPLIT) + 1) + newName;
        try {
            Window owner = ComponentUtil.getCurrentActiveWindow();
            this._facade.getManageFacade().updataPath(oldPath, newPath, this.getOrgID(owner));
            node.setText(newName);
        }
        catch (SourceManageException e) {
            log.error((Object)"rename floder failed", (Throwable)e);
            MessageUtil.msgboxWarning((Component)this._tree, (String)"\u91cd\u547d\u540d\u6587\u4ef6\u5939\u5931\u8d25\u3002");
        }
    }

    public void deleteTreeNode(DefaultKingdeeTreeNode node, String orgID) {
        try {
            this._facade.getManageFacade().deletePathSource(SourceTree.lookupPath(node), orgID);
        }
        catch (SourceManageException e) {
            log.error((Object)"delete floder failed", (Throwable)e);
            MessageUtil.msgboxWarning((Component)this._tree, (String)"\u5220\u9664\u6587\u4ef6\u5939\u5931\u8d25\u3002");
        }
        this._tree.removeNodeFromParent((MutableTreeNode)node);
    }

    private DefaultKingdeeTreeNode getTreeRoot() {
        return (DefaultKingdeeTreeNode)this._tree.getModel().getRoot();
    }

    public KDTree getTree() {
        return this._tree;
    }

    public JComponent getUI() {
        return this._treeView;
    }

    public void addAction(Action action) {
        KDWorkButton btn = new KDWorkButton(action);
        btn.setToolTipText(btn.getText());
        btn.setText(null);
        this._treeView.getControlPane().add((Component)btn);
    }

    public boolean isExitNode(String path) throws SourceManageException {
        return this._facade.getManageFacade().checkExist("ClxOwe88SRAMeb0P", path, this._facade.getCurrentOrgUnitId(null));
    }

    public static String lookupPath(DefaultKingdeeTreeNode node) {
        TreeNode[] nodes = node.getPath();
        StringBuffer sbPath = new StringBuffer();
        for (int i = 1; i < nodes.length; ++i) {
            if (i > 1) {
                sbPath.append(Util.PATH_SPLIT);
            }
            sbPath.append(nodes[i].toString());
        }
        return sbPath.toString();
    }

    public String getOrgID(Component owner) {
        TreePath path = this._tree.getSelectionPath();
        String parentPath = path.getPathComponent(1).toString();
        String orgID = null;
        if ("\u672c\u7ec4\u7ec7\u6587\u4ef6\u5939".equalsIgnoreCase(parentPath)) {
            orgID = this._facade.getCurrentOrgUnitId(owner);
        } else if ("\u516c\u5171\u6587\u4ef6\u5939".equalsIgnoreCase(parentPath)) {
            orgID = "5oUFBlMRzXgW3A9f";
        }
        return orgID;
    }

    public DefaultKingdeeTreeNode getNode(String path) {
        String[] paths = path.split(Util.PATH_SPLIT);
        DefaultKingdeeTreeNode node = this.getTreeRoot();
        block0: for (int i = 0; i < paths.length; ++i) {
            int child = node.getChildCount();
            for (int j = 0; j < child; ++j) {
                DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)node.getChildAt(j);
                if (!childNode.getText().equalsIgnoreCase(paths[i])) continue;
                node = childNode;
                continue block0;
            }
        }
        return node;
    }

    public String getSelectPath() {
        return SourceTree.lookupPath(this.getSelectNode());
    }

    public DefaultKingdeeTreeNode getSelectNode() {
        return (DefaultKingdeeTreeNode)this._tree.getSelectionPath().getLastPathComponent();
    }

    public List getSource(DefaultKingdeeTreeNode node) throws SourceManageException {
        if (node.getUserObject() instanceof TreeNodeUserObject) {
            return ((TreeNodeUserObject)node.getUserObject()).getNodeUserObject();
        }
        List source = this._facade.getManageFacade().getPathSource(SourceTree.lookupPath(node), this.getOrgID(null));
        TreeNodeUserObject object = new TreeNodeUserObject();
        object.setSource(source);
        node.setUserObject((Object)object);
        return source;
    }

    public List getAllSource(DefaultKingdeeTreeNode node, List list) throws SourceManageException {
        List nodeSource = this.getSource(node);
        if (list == null) {
            list = new ArrayList();
        }
        list.addAll(nodeSource);
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.getAllSource((DefaultKingdeeTreeNode)node.getChildAt(i), list);
        }
        return list;
    }

    private class SourceTreeSelectionListener
    implements TreeSelectionListener {
        private SourceTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath[] paths = SourceTree.this._tree.getSelectionPaths();
            if (paths == null) {
                return;
            }
            SourceTree.this.renameAction.setEnabled(true);
            SourceTree.this.deleteAction.setEnabled(true);
            for (int i = 0; i < paths.length; ++i) {
                if (paths[i].getLastPathComponent() != SourceTree.this._organizationRoot && paths[i].getLastPathComponent() != SourceTree.this._commonRoot) continue;
                SourceTree.this.renameAction.setEnabled(false);
                SourceTree.this.deleteAction.setEnabled(false);
            }
        }
    }
}

