/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.explorer.manage.client;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.explorer.manage.client.PreviewPane;
import com.kingdee.bos.ctrl.explorer.model.base.EditorModel;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class SourceViewDialog
extends KDDialog {
    private PreviewPane imagePane;
    private KDTextField nameLabel;
    private KDTextField dimension;

    public static SourceViewDialog create(Component parentCtrl) {
        Window win = SwingUtilities.getWindowAncestor(parentCtrl);
        if (win instanceof Frame) {
            return new SourceViewDialog((Frame)win);
        }
        if (win instanceof Dialog) {
            return new SourceViewDialog((Dialog)win);
        }
        return new SourceViewDialog();
    }

    public SourceViewDialog(Frame owner) {
        super(owner);
        this.init();
    }

    public SourceViewDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    public SourceViewDialog() {
        this.init();
    }

    private void init() {
        this.setTitle("\u67e5\u770b\u8d44\u6e90");
        this.setSize(new Dimension(600, 450));
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.imagePane = new PreviewPane();
        this.nameLabel = new KDTextField();
        this.nameLabel.setEditable(false);
        this.dimension = new KDTextField();
        this.dimension.setEditable(false);
        this.addControls();
        this.makeAlignBounds();
    }

    private void addControls() {
        KDPanel pane = new KDPanel();
        pane.setCustomInsets(new Insets(5, 5, 5, 5));
        KDLabelContainer dimensionContainer = CtrlSwingUtilities.createLabelContainer((JComponent)this.dimension, (String)"\u5c3a\u5bf8", (int)50);
        KDLabelContainer lbcName = CtrlSwingUtilities.createLabelContainer((JComponent)this.nameLabel, (String)"\u540d\u79f0", (int)80);
        TableLayout2 layout = new TableLayout2(2, 2);
        layout.setColSpacing(0, 10);
        layout.setRowSpacing(0, 10);
        layout.setFixedHeight(0, 20);
        layout.setRatableHeight(1, 1);
        layout.setRatableWidth(0, 1);
        layout.setFixedWidth(1, 200);
        pane.setLayout((LayoutManager)layout);
        pane.add((Component)lbcName, (Object)TableLayout2.param((int)0, (int)0));
        pane.add((Component)dimensionContainer, (Object)TableLayout2.param((int)0, (int)1));
        pane.add((Component)((Object)this.imagePane), (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)1));
        this.getContentPane().add((Component)pane);
    }

    private void makeAlignBounds() {
        Rectangle rc = new Rectangle(this.getBounds());
        Dimension sz = Toolkit.getDefaultToolkit().getScreenSize();
        int x = 0;
        int y = 0;
        int width = sz.width;
        int height = sz.height;
        rc.x = x + (width - rc.width) / 2;
        if (rc.x < 0) {
            rc.x = 0;
        }
        rc.y = y + (height - rc.height) / 2;
        if (rc.y < 0) {
            rc.y = 0;
        }
        this.setBounds(rc);
    }

    public void setEditData(EditorModel model) {
        this.dimension.setText(model.getWidth() + " x " + model.getHeight());
        this.nameLabel.setText(model.getName());
        this.imagePane.setImage(model.getImage());
    }
}

