/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.explorer.model.base;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.explorer.common.BlockDownLoader;
import com.kingdee.bos.ctrl.explorer.manage.exception.SourceManageException;
import com.kingdee.bos.ctrl.explorer.use.IExtUsedFacade;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.log4j.Logger;

public class ImageHandler
extends URLStreamHandler {
    private static final Logger log = LogUtil.getPackageLogger(URLStreamHandler.class);
    private IExtUsedFacade _extManage;
    private URLConnection connection;

    public ImageHandler(IExtUsedFacade extManage) {
        this._extManage = extManage;
    }

    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        if (this.connection == null) {
            this.connection = new ResourceURLConnection(u);
            System.out.println(u);
        }
        return this.connection;
    }

    private class ResourceInputSream
    extends FileInputStream {
        private File _file;

        public ResourceInputSream(File file) throws FileNotFoundException {
            super(file);
            this._file = file;
        }

        @Override
        public void close() throws IOException {
            super.close();
        }
    }

    private class ResourceURLConnection
    extends URLConnection {
        private File _file;

        protected ResourceURLConnection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            ResourceInputSream inputStream = new ResourceInputSream(this.getFile());
            return inputStream;
        }

        @Override
        public int getContentLength() {
            try {
                return (int)this.getFile().length();
            }
            catch (IOException iOException) {
                return 0;
            }
        }

        private File getFile() throws IOException {
            if (this._file != null) {
                return this._file;
            }
            BlockDownLoader loader = new BlockDownLoader(this.getURL().getHost(), ImageHandler.this._extManage);
            try {
                this._file = loader.loadSource();
            }
            catch (SourceManageException e) {
                log.error((Object)"load resource error!", (Throwable)e);
                this._file = null;
                loader.destroy();
                throw new IOException("Load resource error from Resource center!");
            }
            return this._file;
        }
    }
}

