/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.explorer.use.client;

import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.explorer.common.FacadeCreator;
import com.kingdee.bos.ctrl.explorer.common.ImageBreviary;
import com.kingdee.bos.ctrl.explorer.common.client.TreeNodeUserObject;
import com.kingdee.bos.ctrl.explorer.manage.IExtManageFacade;
import com.kingdee.bos.ctrl.explorer.manage.client.ResourceManage;
import com.kingdee.bos.ctrl.explorer.manage.client.SourceTree;
import com.kingdee.bos.ctrl.explorer.manage.exception.SourceManageException;
import com.kingdee.bos.ctrl.explorer.model.ILightSource;
import com.kingdee.bos.ctrl.explorer.model.base.EditorModel;
import com.kingdee.bos.ctrl.explorer.model.base.ImageHandler;
import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.ui.wizards.pic.ImageUtils;
import com.kingdee.bos.ctrl.ext.ui.wizards.pic.InsertPicWizzard;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.swing.DefaultKingdeeListCellRenderer;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImagingOpException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.apache.log4j.Logger;

public class SourceChooserUI
extends TypicalDialog {
    private static final Logger log = LogUtil.getPackageLogger(SourceChooserUI.class);
    private SourceTree _sourceTree;
    private KDList _list;
    private KDCheckBox _showChild;
    private List _nowSource;
    private FacadeCreator _facede;
    private KDExt _ext;
    private KDWorkButton _upLocalPic;
    private String _upPicId;
    private InsertPicWizzard wizzard;
    private File file;
    private BufferedImage bis = null;
    private int width;
    private int height;
    private int size;

    public static SourceChooserUI create(Component parentCtrl) {
        Window win = null;
        win = parentCtrl instanceof Window ? (Window)parentCtrl : SwingUtilities.getWindowAncestor(parentCtrl);
        if (win instanceof Frame) {
            return new SourceChooserUI((Frame)win);
        }
        if (win instanceof Dialog) {
            return new SourceChooserUI((Dialog)win);
        }
        return new SourceChooserUI();
    }

    public SourceChooserUI() {
    }

    public SourceChooserUI(Dialog owner) {
        super(owner);
    }

    public SourceChooserUI(Frame owner) {
        super(owner);
    }

    protected void todoInit() {
        this._facede = new FacadeCreator();
        this.setTitle("\u9009\u62e9\u8d44\u6e90");
        this._sourceTree = new SourceTree();
        this._sourceTree.setShowControlPanel(false);
        this._sourceTree.setFacade(this._facede);
        this._sourceTree.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (SourceChooserUI.this._sourceTree.getTree().getSelectionPath() == null) {
                    SourceChooserUI.this._nowSource = null;
                    return;
                }
                SourceChooserUI.this.refresh();
            }
        });
        this._list = new KDList();
        this._list.setSelectionMode(2);
        this._list.setLayoutOrientation(2);
        DefaultKingdeeListCellRenderer cellRenderer = new DefaultKingdeeListCellRenderer();
        cellRenderer.setVerticalAlignment(0);
        cellRenderer.setHorizontalAlignment(0);
        cellRenderer.setVerticalTextPosition(3);
        cellRenderer.setHorizontalTextPosition(0);
        this._list.setCellRenderer((ListCellRenderer)cellRenderer);
        this._list.setFixedCellHeight(120);
        this._list.setFixedCellWidth(120);
        this._list.setSelectionForeground(Color.WHITE);
        this._list.setSelectionBackground(new Color(10, 36, 106));
        this._list.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SourceChooserUI.this.onOk();
                }
            }
        });
        this._showChild = new KDCheckBox("\u5305\u542b\u5b50\u8282\u70b9");
        this._showChild.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SourceChooserUI.this.refresh();
            }
        });
        this._upLocalPic = new KDWorkButton("\u672c\u5730\u4e0a\u4f20");
        this._upLocalPic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SourceChooserUI.this.upLoadLocalPicture();
                }
                catch (SourceManageException e1) {
                    log.error((Object)"upLoad source failed", (Throwable)e1);
                }
            }
        });
        this.refresh();
    }

    protected void upLoadLocalPicture() throws SourceManageException {
        int selectCount = this._sourceTree.getTree().getSelectionCount();
        if (selectCount == 0) {
            this.showInfo("\u8bf7\u5148\u9009\u62e9\u65b0\u5efa\u76ee\u6807\u7684\u6587\u4ef6\u5939\u3002");
            return;
        }
        if (!this.upLoadPic2Resource()) {
            return;
        }
    }

    public boolean upLoadPic2Resource() throws SourceManageException {
        EditorModel model;
        KDFileChooser fileChooser;
        int mark;
        if (this.wizzard == null) {
            this.wizzard = new InsertPicWizzard(this._ext);
        }
        if ((mark = (fileChooser = this.wizzard.getFileChooser()).showOpenDialog((Component)this._ext)) != 0) {
            return false;
        }
        ResourceManage resManage = new ResourceManage(this._sourceTree);
        this.file = fileChooser.getSelectedFile();
        if (!this.checkImage(resManage, this.wizzard, fileChooser)) {
            return false;
        }
        if (this.file.exists()) {
            try {
                this.bis = ImageIO.read(this.file);
                if (this.bis == null) {
                    MessageUtil.msgboxWarning((Component)this._ext, (String)"\u56fe\u7247\u52a0\u8f7d\u5931\u8d25");
                    this.width = 0;
                    this.height = 0;
                    return false;
                }
                this.width = this.bis.getWidth();
                this.height = this.bis.getHeight();
                this.size = ImageUtils.getImageByteContent((String)this.file.getAbsolutePath());
            }
            catch (IOException e1) {
                MessageUtil.msgboxWarning((Component)this._ext, (String)"\u56fe\u7247\u52a0\u8f7d\u5931\u8d25");
                this.width = 0;
                this.height = 0;
            }
        }
        if (!this.getEditorModel(model = new EditorModel())) {
            return false;
        }
        IExtManageFacade mangeFacade = this._facede.getManageFacade();
        ILightSource source = resManage.mode2source(model);
        try {
            source = mangeFacade.createLightSource(source);
        }
        catch (SourceManageException e) {
            this.showInfo("\u65b0\u5efa\u8d44\u6e90\u5931\u8d25\uff0c\u8d44\u6e90\u540d\u79f0\u8fc7\u957f\u6216\u8d44\u6e90\u7c7b\u578b\u4e0d\u7b26\u5408\u8981\u6c42\u3002");
            return false;
        }
        if (!resManage.save(source, this.file, mangeFacade)) {
            return false;
        }
        this._upPicId = source.getID();
        DefaultKingdeeTreeNode node = this._sourceTree.getSelectNode();
        if (node.getUserObject() instanceof TreeNodeUserObject) {
            ((TreeNodeUserObject)node.getUserObject()).addNodeUserObject(source);
        } else {
            TreeNodeUserObject userObject = new TreeNodeUserObject();
            userObject.addNodeUserObject(source);
            node.setUserObject((Object)userObject);
        }
        this.refresh();
        return true;
    }

    private boolean checkImage(ResourceManage resManage, InsertPicWizzard wizzard, KDFileChooser fileChooser) {
        URL url;
        ResourceManage resourceManage = resManage;
        resourceManage.getClass();
        ResourceManage.Checker checker = resourceManage.new ResourceManage.Checker(this._sourceTree.getSelectPath(), this._facede);
        if (checker.isNameExist(this.file.getName(), (Component)((Object)this))) {
            return false;
        }
        try {
            url = wizzard.selectedURL();
        }
        catch (MalformedURLException e) {
            MessageUtil.msgboxWarning((Component)fileChooser, (String)("\u6587\u4ef6\u8def\u5f84\u5f02\u5e38\uff1a" + e), (String)"\u4fe1\u606f\u63d0\u793a");
            return false;
        }
        if (!ImageUtils.checkURL((URL)url)) {
            MessageUtil.msgboxWarning((Component)fileChooser, (String)("\u5bfc\u5165\u6b64\u6587\u4ef6\u65f6\u51fa\u9519\u3002" + url.toString()));
            return false;
        }
        return true;
    }

    private boolean getEditorModel(EditorModel model) {
        try {
            model.setBreviary(ImageBreviary.createBreviaryImage(this.bis, 100, 100));
        }
        catch (ImagingOpException e) {
            MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u751f\u6210\u7f29\u7565\u56fe\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
            return false;
        }
        catch (IOException e) {
            MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u7f29\u7565\u56fe\u8f93\u51fa\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
            return false;
        }
        model.setName(this.file.getName());
        model.setFile(this.file);
        model.setWidth(this.width);
        model.setHeight(this.height);
        model.setSize(this.size);
        return this.hasOwner;
    }

    protected boolean verify() {
        if (this._list.isSelectionEmpty()) {
            this.showInfo("\u8bf7\u9009\u62e9\u4e00\u4e2a\u8d44\u6e90");
            return false;
        }
        return true;
    }

    private void refresh() {
        try {
            int selectCount = this._sourceTree.getTree().getSelectionCount();
            if (selectCount == 0) {
                this.showInfo("\u8bf7\u5148\u9009\u62e9\u65b0\u5efa\u76ee\u6807\u7684\u6587\u4ef6\u5939\u3002");
                this._showChild.setSelected(!this._showChild.isSelected());
                return;
            }
            List list = null;
            list = this._showChild.isSelected() ? this._sourceTree.getAllSource(this._sourceTree.getSelectNode(), list) : this._sourceTree.getSource(this._sourceTree.getSelectNode());
            this._nowSource = list;
            this.refreshList(this._nowSource);
        }
        catch (SourceManageException ex) {
            log.error((Object)"downLoad source failed", (Throwable)ex);
        }
    }

    private void refreshList(List sources) {
        this._list.removeAllElements();
        int rowNumber = this._list.getWidth() / 120;
        rowNumber = rowNumber <= 0 ? 3 : rowNumber;
        this._list.setVisibleRowCount(sources.size() / rowNumber + (sources.size() % rowNumber == 0 ? 0 : 1));
        for (int i = 0; i < sources.size(); ++i) {
            ILightSource source = (ILightSource)sources.get(i);
            if (source.getBreviary() == null) {
                try {
                    source.setBreviary(this._facede.getManageFacade().getBreviary(source.getID()));
                }
                catch (SourceManageException sourceManageException) {
                    // empty catch block
                }
            }
            MyIcon icon = new MyIcon(source.getBreviary());
            this._list.addElement((Object)source.getName());
            this._list.setElementIcon((Icon)icon, i);
            if (!source.getID().equals(this._upPicId)) continue;
            this._list.setSelectedValue((Object)source.getName(), true);
        }
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        super.setSize(600, 450);
        KDPanel panel1 = new KDPanel();
        KDLabel text = new KDLabel("\u8d44\u6e90\u76ee\u5f55\uff1a");
        TableLayout2 layout = new TableLayout2(2, 1);
        layout.setFixedHeight(0, 20);
        layout.setRatableHeight(1, 1);
        panel1.setLayout((LayoutManager)layout);
        panel1.add((Component)text, (Object)TableLayout2.param((int)0, (int)0));
        panel1.add((Component)this._sourceTree.getUI(), (Object)TableLayout2.param((int)1, (int)0));
        KDPanel panel2 = new KDPanel();
        TableLayout2 layout2 = new TableLayout2(2, 3);
        KDLabel text2 = new KDLabel("\u8d44\u6e90\uff1a");
        layout2.setFixedHeight(0, 20);
        layout2.setRatableHeight(1, 1);
        layout2.setFixedWidth(1, 70);
        layout2.setFixedWidth(2, 90);
        layout2.setRatableWidth(0, 1);
        panel2.setLayout((LayoutManager)layout2);
        panel2.add((Component)text2, (Object)TableLayout2.param((int)0, (int)0));
        panel2.add((Component)this._upLocalPic, (Object)TableLayout2.param((int)0, (int)1));
        panel2.add((Component)this._showChild, (Object)TableLayout2.param((int)0, (int)2));
        final KDScrollPane scrollPane = new KDScrollPane((Component)this._list);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                int rowNumber = scrollPane.getWidth() / 120;
                if (rowNumber == 0) {
                    return;
                }
                int rowCount = SourceChooserUI.this._list.getElementCount() / rowNumber + (SourceChooserUI.this._list.getElementCount() % rowNumber == 0 ? 0 : 1);
                SourceChooserUI.this._list.setVisibleRowCount(rowCount);
            }
        });
        panel2.add((Component)scrollPane, (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)2));
        KDSplitPane splitPane = new KDSplitPane(1, (Component)panel1, (Component)panel2);
        splitPane.setDividerLocation(150);
        splitPane.setDividerOpaque(false);
        parent.add((Component)splitPane, thisCell);
    }

    public List getChooseRes() {
        ArrayList<URL> urlList = new ArrayList<URL>();
        int[] indices = this._list.getSelectedIndices();
        for (int i = 0; i < indices.length; ++i) {
            ILightSource source = (ILightSource)this._nowSource.get(indices[i]);
            String restp = "rtp://" + source.getID() + "#" + source.getName();
            try {
                ImageHandler handler = new ImageHandler(this._facede.getUsedFacade());
                URL url = new URL(null, restp, handler);
                urlList.add(url);
                continue;
            }
            catch (SourceManageException e) {
                log.error((Object)e);
                this.showInfo("\u521b\u5efa\u8d44\u6e90\u4e2d\u5fc3\u8fde\u63a5\u51fa\u9519\u3002\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
                continue;
            }
            catch (MalformedURLException e) {
                log.error((Object)e);
                this.showInfo("\u521b\u5efa\u8d44\u6e90URL\u51fa\u9519\u3002\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
            }
        }
        return urlList;
    }

    private void showInfo(String text) {
        MessageUtil.msgboxInfo((Component)this._sourceTree.getTree(), (String)text);
    }

    public void setExt(KDExt _ext) {
        this._ext = _ext;
    }

    public KDExt getExt() {
        return this._ext;
    }

    public void setSelectionMode(int mode) {
        this._list.setSelectionMode(mode);
    }

    private class MyIcon
    extends ImageIcon {
        public MyIcon(byte[] imageData) {
            super(imageData);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int offX = (100 - this.getImage().getWidth(this.getImageObserver())) / 2;
            int offY = (100 - this.getImage().getHeight(this.getImageObserver())) / 2;
            super.paintIcon(c, g, x + offX, y + offY + 3);
            Color color = g.getColor();
            g.setColor(Color.DARK_GRAY);
            g.drawRect(x - 1, y + 2, 101, 101);
            g.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 100;
        }

        @Override
        public int getIconHeight() {
            return 100;
        }
    }
}

