/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.extcommon.client;

import com.kingdee.bos.ctrl.common.ResourceManager;
import com.kingdee.bos.ctrl.swing.DefaultKingdeeListCellRenderer;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDEditorPane;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MapMessageInfoUI
extends KDDialog {
    private KDList _ltInfo;
    private KDEditorPane _epInfoDetail;
    private Map _msgMap;
    private String _title;
    private static final Icon ICON_INFO = ResourceManager.getIcon(MapMessageInfoUI.class, (String)"info.png");
    private static final Icon ICON_QUIT = ResourceManager.getIcon(MapMessageInfoUI.class, (String)"tbtn_quit.gif");

    public MapMessageInfoUI(Map msgMap, Dialog dialog, String title) {
        super(dialog, true);
        this._msgMap = msgMap;
        this._title = title;
        this.initUI();
    }

    public MapMessageInfoUI(Map msgMap, Frame frame, String title) {
        super(frame, true);
        this._msgMap = msgMap;
        this._title = title;
        this.initUI();
    }

    private void initUI() {
        this.setTitle(this._title);
        this._ltInfo = new KDList(new DefaultListModel());
        this._ltInfo.setCellRenderer((ListCellRenderer)((Object)new InfoListCellRender()));
        KDContainer ct = new KDContainer();
        ct.setEnableActive(false);
        ct.setTitle("\u4fe1\u606f");
        ct.setMinimumSize(new Dimension(0, 0));
        KDPanel leftPanel = new KDPanel((LayoutManager)new BorderLayout());
        leftPanel.add((Component)this._ltInfo, (Object)"Center");
        ct.setContentPane((Container)leftPanel);
        this._epInfoDetail = new KDEditorPane();
        this._epInfoDetail.setEditable(false);
        KDContainer ct1 = new KDContainer();
        ct1.setEnableActive(false);
        ct1.setTitle("\u8be6\u7ec6\u4fe1\u606f");
        ct1.setMinimumSize(new Dimension(0, 0));
        KDPanel rightPanel = new KDPanel((LayoutManager)new BorderLayout());
        rightPanel.add((Component)this._epInfoDetail, (Object)"Center");
        ct1.setContentPane((Container)rightPanel);
        KDWorkButton btnQuit = new KDWorkButton();
        btnQuit.setText(null);
        btnQuit.setIcon(ICON_QUIT);
        btnQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapMessageInfoUI.this.dispose();
            }
        });
        KDToolBar toolBar = new KDToolBar();
        toolBar.add((Component)btnQuit);
        this.addToolBar((JToolBar)toolBar);
        KDSplitPane sppLeftRight = new KDSplitPane(1);
        sppLeftRight.setDividerLocation(271);
        sppLeftRight.setLeftComponent((Component)ct);
        sppLeftRight.setRightComponent((Component)ct1);
        this._ltInfo.getSelectionModel().setSelectionMode(0);
        this._ltInfo.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MapMessageInfoUI.this.selectionChange();
            }
        });
        KDPanel board = new KDPanel((LayoutManager)new BorderLayout());
        board.add((Component)sppLeftRight, (Object)"Center");
        this.setContentPane((Container)board);
        this.setSize(749, 492);
        this.initUIData();
    }

    private void initUIData() {
        if (this._msgMap != null && this._msgMap.size() > 0) {
            Iterator itor = this._msgMap.keySet().iterator();
            DefaultListModel model = (DefaultListModel)this._ltInfo.getModel();
            while (itor.hasNext()) {
                model.addElement(itor.next());
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapMessageInfoUI.this._ltInfo.setSelectedIndex(0);
                }
            });
        }
    }

    private void selectionChange() {
        Object obj = this._ltInfo.getSelectedValue();
        Object value = this._msgMap.get(obj);
        this._epInfoDetail.setText(null);
        if (value != null) {
            if (value instanceof Exception) {
                ByteArrayOutputStream msgOut = new ByteArrayOutputStream();
                PrintStream psm = new PrintStream(msgOut);
                ((Exception)value).printStackTrace(psm);
                this._epInfoDetail.setText(msgOut.toString());
                psm.close();
            } else {
                this._epInfoDetail.setText(value.toString());
            }
        }
    }

    private class InfoListCellRender
    extends DefaultKingdeeListCellRenderer {
        private InfoListCellRender() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.setIcon(ICON_INFO);
            return c;
        }
    }
}

