/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.extcommon.client;

import com.kingdee.bos.ctrl.extcommon.client.ProgressUI;

public abstract class Progress
implements Runnable {
    private Exception _ex;
    private ProgressUI _ui;
    private boolean _isDelayEnd = true;
    private boolean _forceCancel;

    public Progress(ProgressUI bindUI) {
        this._ui = bindUI;
        this._ui.bindProgress(this);
    }

    public void startAndShowUi(String threadName) {
        new Thread((Runnable)this, threadName).start();
        this._ui.show();
    }

    @Override
    public void run() {
        if (!this._isDelayEnd) {
            this.delay(200);
        }
        try {
            this.work();
            if (this._isDelayEnd) {
                this.delay(1000);
            }
        }
        catch (Exception ex) {
            this._ex = ex;
        }
        finally {
            this._ui.dispose();
        }
    }

    protected abstract void work() throws Exception;

    protected ProgressUI getUI() {
        return this._ui;
    }

    protected void delay(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setDelayAtTheEnd(boolean is) {
        this._isDelayEnd = is;
    }

    public boolean isOk() {
        return this._ex == null;
    }

    public Exception getException() {
        return this._ex;
    }

    public void dealException() {
        Throwable ori = this._ex.getCause();
        if (ori instanceof IllegalStateException) {
            throw (IllegalStateException)ori;
        }
    }

    void forceCancel() {
        this._forceCancel = true;
    }

    protected boolean isForceCancel() {
        return this._forceCancel;
    }
}

