/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.extcommon.client;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.extcommon.client.Progress;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;

public class ProgressUI {
    private KDDialog _dlg;
    private KDLabel _lab;
    private KDProgressBar _bar;
    private int _maxValue = 100;
    private Progress _progress;

    public static ProgressUI create(Component owner) {
        Window win = SwingUtilities.getWindowAncestor(owner);
        if (win instanceof Frame) {
            return new ProgressUI((Frame)win);
        }
        if (win instanceof Dialog) {
            return new ProgressUI((Dialog)win);
        }
        return new ProgressUI();
    }

    private ProgressUI(Frame frame) {
        this._dlg = new KDDialog(frame);
        this.init();
    }

    private ProgressUI(Dialog dialog) {
        this._dlg = new KDDialog(dialog);
        this.init();
    }

    private ProgressUI() {
        this._dlg = new KDDialog();
        this.init();
    }

    private void init() {
        this._lab = new KDLabel();
        this._lab.setHorizontalAlignment(0);
        this._dlg.setModal(true);
        this._dlg.setUndecorated(true);
        this._dlg.setSize(400, 80);
        this._dlg.setLocationRelativeTo(null);
        this._bar = new KDProgressBar(0, 0, this._maxValue);
        this._bar.setStringPainted(true);
        TableLayout2 ly = new TableLayout2(4, 3);
        ly.setFixedHeight(new int[]{1, 2}, 26);
        ly.setRatableHeight(new int[]{0, 3}, 50);
        ly.setFixedWidth(new int[]{0, 2}, 40);
        ly.setRatableWidth(1, 100);
        KDPanel pan = new KDPanel((LayoutManager)ly);
        pan.setBorder(BorderFactory.createEtchedBorder());
        pan.setBackground(Color.WHITE);
        pan.add((Component)this._lab, (Object)TableLayout2.param((int)1, (int)1));
        pan.add((Component)this._bar, (Object)TableLayout2.param((int)2, (int)1));
        this._dlg.getContentPane().setLayout(new BorderLayout());
        this._dlg.getContentPane().add((Component)pan, "Center");
        this._dlg.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProgressUI.this._progress.forceCancel();
            }
        });
    }

    void bindProgress(Progress progress) {
        this._progress = progress;
    }

    void show() {
        this._dlg.setVisible(true);
    }

    public void setIndeterminate(boolean is) {
        this._bar.setIndeterminate(is);
    }

    public void setText(String text) {
        this._lab.setText(text);
    }

    public void setMaxValue(int maxValue) {
        this._maxValue = maxValue;
        this._bar.setMaximum(maxValue);
    }

    public void setProgressValue(final int value) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressUI.this._bar.setValue(value);
            }
        });
    }

    public void dispose() {
        this._dlg.dispose();
    }

    public Window getOwner() {
        return this.getDialog();
    }

    protected KDDialog getDialog() {
        return this._dlg;
    }

    protected KDProgressBar getProgressBar() {
        return this._bar;
    }
}

