/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.extcommon.server;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.datacenter.DataCenterConnUtil;
import com.kingdee.bos.ctrl.common.datacenter.DataCenterInfo;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DbUtil {
    private static Logger _logger = CommonLogger.getLogger(DbUtil.class);

    public static Connection getConnection() throws SQLException {
        return EJBFactory.getConnection((Context)ServerUtil.getContext());
    }

    public static void closeConnection(Connection conn) {
        SQLUtils.cleanup((Connection)conn);
    }

    public static Connection getOutDbConn(DataCenterInfo dcInfo) throws SQLException {
        try {
            return DataCenterConnUtil.openConnection((DataCenterInfo)dcInfo);
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SQLException("Caused by: " + ex.getClass() + ": " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(Connection conn, String sql, Object[] params) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            int n = ps.executeUpdate();
            return n;
        }
        finally {
            SQLUtils.cleanup((Statement)ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRowSet executeQuery(Connection conn, String sql, Object[] params) throws SQLException {
        JdbcRowSet jdbcRowSet;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return jdbcRowSet;
    }

    public static IRowSet executeQuery(String sql, Object[] params) throws SQLException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ServerUtil.getContext());
        }
        catch (SQLException ex) {
            SQLUtils.cleanup((Connection)conn);
            throw ex;
        }
        return DbUtil.executeQuery(conn, sql, params);
    }

    public static IRowSet executeQuery(Context ctx, String sql, Object[] params) throws SQLException {
        Connection conn = null;
        try {
            if (ctx == null) {
                ctx = ServerUtil.getContext();
            }
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException ex) {
            SQLUtils.cleanup(conn);
            throw ex;
        }
        return DbUtil.executeQuery(conn, sql, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(String sql, Object[] params) throws SQLException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ServerUtil.getContext());
        }
        catch (SQLException ex) {
            SQLUtils.cleanup((Connection)conn);
            throw ex;
        }
        try {
            ps = conn.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            int n = ps.executeUpdate();
            return n;
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(Context ctx, String sql, Object[] params) throws SQLException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            if (ctx == null) {
                ctx = ServerUtil.getContext();
            }
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException ex) {
            SQLUtils.cleanup(conn);
            throw ex;
        }
        try {
            ps = conn.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            int n = ps.executeUpdate();
            return n;
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        }
    }

    public static boolean executeBatchUpdate(String insSql, List params, int paramLen, String optionalDelSql) throws SQLException {
        int i;
        PreparedStatement ps;
        Connection conn;
        block21: {
            boolean isInTxt;
            conn = null;
            ps = null;
            Statement stmt = null;
            try {
                conn = EJBFactory.getConnection((Context)ServerUtil.getContext());
            }
            catch (SQLException ex) {
                SQLUtils.cleanup((Connection)conn);
                throw ex;
            }
            boolean bl = isInTxt = !conn.getAutoCommit();
            if (!isInTxt) {
                try {
                    conn.setAutoCommit(true);
                }
                catch (SQLException e) {
                    _logger.info((Object)"\u5c1d\u8bd5\u8bbe\u7f6eAutoCommit\u4e3atrue\u5931\u8d25\uff0c\u5728\u5168\u5c40\u4e8b\u52a1\u5f53\u4e2d", (Throwable)e);
                    isInTxt = true;
                }
            }
            try {
                if (!isInTxt) {
                    try {
                        conn.setAutoCommit(false);
                    }
                    catch (SQLException e) {
                        _logger.info((Object)"\u8bbe\u7f6eAutoCommit\u5931\u8d25", (Throwable)e);
                        isInTxt = true;
                    }
                }
                if (!StringUtil.isEmptyString((String)optionalDelSql)) {
                    stmt = conn.createStatement();
                    stmt.execute(optionalDelSql);
                }
                ps = conn.prepareStatement(insSql);
                int count = params.size() / paramLen;
                for (i = 0; i < count; ++i) {
                    for (int j = 0; j < paramLen; ++j) {
                        Object src = params.get(i * paramLen + j);
                        if (src instanceof byte[]) {
                            ps.setBinaryStream(j + 1, (InputStream)new ByteArrayInputStream((byte[])src), ((byte[])src).length);
                            continue;
                        }
                        ps.setObject(j + 1, src);
                    }
                    ps.execute();
                }
                if (!isInTxt) {
                    conn.commit();
                }
                i = 1;
                if (stmt == null) break block21;
            }
            catch (SQLException e) {
                try {
                    if (!isInTxt) {
                        try {
                            conn.rollback();
                        }
                        catch (SQLException ex) {
                            _logger.info((Object)"\u56de\u6eda\u9519\u8bef", (Throwable)ex);
                        }
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        SQLUtils.cleanup(stmt);
                    }
                    SQLUtils.cleanup(null, ps, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)stmt);
        }
        SQLUtils.cleanup(null, (Statement)ps, (Connection)conn);
        return i != 0;
    }

    public static boolean executeBatchUpdate(Context ctx, String insSql, List params, int paramLen, String optionalDelSql) throws SQLException {
        return DbUtil.executeBatchUpdate(ctx, insSql, params, paramLen, optionalDelSql, null);
    }

    public static boolean executeBatchUpdate(Context ctx, String insSql, List params, int paramLen, String optionalDelSql, Map mapParams) throws SQLException {
        int i;
        PreparedStatement ps;
        Connection conn;
        block24: {
            boolean isInTxt;
            conn = null;
            ps = null;
            Statement stmt = null;
            try {
                if (ctx == null) {
                    ctx = ServerUtil.getContext();
                }
                conn = EJBFactory.getConnection((Context)ctx);
            }
            catch (SQLException ex) {
                SQLUtils.cleanup(conn);
                throw ex;
            }
            boolean bl = isInTxt = !conn.getAutoCommit();
            if (!isInTxt) {
                try {
                    conn.setAutoCommit(true);
                }
                catch (SQLException e) {
                    _logger.info((Object)"\u5c1d\u8bd5\u8bbe\u7f6eAutoCommit\u4e3atrue\u5931\u8d25\uff0c\u5728\u5168\u5c40\u4e8b\u52a1\u5f53\u4e2d", (Throwable)e);
                    isInTxt = true;
                }
            }
            try {
                if (!isInTxt) {
                    try {
                        conn.setAutoCommit(false);
                    }
                    catch (SQLException e) {
                        isInTxt = true;
                        _logger.info((Object)"\u8bbe\u7f6eAutoCommit\u5931\u8d25", (Throwable)e);
                    }
                }
                if (!StringUtil.isEmptyString((String)optionalDelSql)) {
                    stmt = conn.createStatement();
                    stmt.execute(optionalDelSql);
                }
                ps = conn.prepareStatement(insSql);
                int count = params.size() / paramLen;
                for (i = 0; i < count; ++i) {
                    for (int j = 0; j < paramLen; ++j) {
                        Object src = params.get(i * paramLen + j);
                        if (src instanceof byte[]) {
                            ps.setBinaryStream(j + 1, (InputStream)new ByteArrayInputStream((byte[])src), ((byte[])src).length);
                            continue;
                        }
                        if (src instanceof Reader) {
                            int len = 0;
                            if (mapParams != null) {
                                len = (Integer)mapParams.get(src);
                            }
                            ps.setCharacterStream(j + 1, (Reader)src, len);
                            continue;
                        }
                        ps.setObject(j + 1, src);
                    }
                    ps.execute();
                }
                if (!isInTxt) {
                    conn.commit();
                }
                i = 1;
                if (stmt == null) break block24;
            }
            catch (SQLException e) {
                try {
                    if (!isInTxt) {
                        try {
                            conn.rollback();
                        }
                        catch (SQLException ex) {
                            _logger.info((Object)"\u56de\u6eda\u9519\u8bef", (Throwable)ex);
                        }
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        SQLUtils.cleanup(stmt);
                    }
                    SQLUtils.cleanup(null, ps, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)stmt);
        }
        SQLUtils.cleanup(null, (Statement)ps, (Connection)conn);
        return i != 0;
    }

    public static boolean executeBatchUpdate(String[] sqls) throws SQLException {
        Connection conn = null;
        Statement stmt = null;
        try {
            boolean i;
            conn = EJBFactory.getConnection((Context)ServerUtil.getContext());
            stmt = conn.createStatement();
            for (i = false; i < sqls.length; i += 1) {
                if (sqls[i] == null) continue;
                stmt.addBatch(sqls[i]);
            }
            stmt.executeBatch();
            i = true;
            return i;
        }
        catch (SQLException e) {
            if (conn != null) {
                conn.rollback();
            }
            throw e;
        }
        finally {
            SQLUtils.cleanup(null, (Statement)stmt, (Connection)conn);
        }
    }

    public static boolean executeBatchUpdate(Context ctx, String[] sqls) throws SQLException {
        boolean bl;
        Connection conn = null;
        Statement stmt = null;
        try {
            Context context = ctx;
            if (context == null) {
                context = ServerUtil.getContext();
            }
            conn = EJBFactory.getConnection((Context)context);
            stmt = conn.createStatement();
            for (int i = 0; i < sqls.length; ++i) {
                if (sqls[i] == null) continue;
                stmt.addBatch(sqls[i]);
            }
            stmt.executeBatch();
            bl = true;
        }
        catch (SQLException e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)stmt, (Connection)conn);
        return bl;
    }

    public static boolean executeBatchUpdateTx(Context ctx, String[] sqls) throws SQLException {
        boolean bl;
        Statement stmt;
        Connection conn;
        block8: {
            conn = null;
            stmt = null;
            boolean isAutoCommit = false;
            try {
                Context context = ctx;
                if (context == null) {
                    context = ServerUtil.getContext();
                }
                conn = EJBFactory.getConnection((Context)context);
                isAutoCommit = conn.getAutoCommit();
                conn.setAutoCommit(false);
                stmt = conn.createStatement();
                for (int i = 0; i < sqls.length; ++i) {
                    if (sqls[i] == null) continue;
                    stmt.addBatch(sqls[i]);
                }
                stmt.executeBatch();
                conn.commit();
                bl = true;
                if (conn == null) break block8;
            }
            catch (SQLException e) {
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    if (conn != null) {
                        conn.setAutoCommit(isAutoCommit);
                    }
                    SQLUtils.cleanup(null, stmt, (Connection)conn);
                    throw throwable;
                }
            }
            conn.setAutoCommit(isAutoCommit);
        }
        SQLUtils.cleanup(null, (Statement)stmt, (Connection)conn);
        return bl;
    }

    public static boolean checkExist(Context ctx, String table, String field, String value) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select 1 from ");
        sql.append(table);
        sql.append(" where ");
        sql.append(field);
        sql.append("=?");
        IRowSet rs = DbUtil.executeQuery(ctx, sql.toString(), (Object[])new String[]{value});
        return rs.next();
    }

    public static boolean checkExist(String table, String field, String value) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select 1 from ");
        sql.append(table);
        sql.append(" where ");
        sql.append(field);
        sql.append("=?");
        IRowSet rs = DbUtil.executeQuery(sql.toString(), new String[]{value});
        return rs.next();
    }

    public static boolean isMSSQL(Connection cn) throws SQLException {
        String productName = cn.getMetaData().getDatabaseProductName();
        return productName.toUpperCase().indexOf("SQL SERVER") >= 0;
    }

    public static boolean isOracle(Connection cn) throws SQLException {
        String productName = cn.getMetaData().getDatabaseProductName();
        return productName.equals("Oracle");
    }

    public static boolean isDB2(Connection cn) throws SQLException {
        String productName = cn.getMetaData().getDatabaseProductName();
        return productName.startsWith("DB2");
    }
}

