/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.common.client;

import com.kingdee.bos.ctrl.semantic.common.Util;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.util.backport.Collections;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;

public class TreeBuilder {
    private KDTree _tree;
    private ICustomBehavior _customBehavior;

    public TreeBuilder(KDTree tree) {
        this._tree = tree;
    }

    public void setCustomBehavior(ICustomBehavior cb) {
        this._customBehavior = cb;
    }

    public void refreshRoot(LazyInfo[] infos) {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this._tree.getModel().getRoot();
        this.refresh(root, "", infos, new NodesMap());
    }

    public void refresh(DefaultKingdeeTreeNode parentNode, String path, LazyInfo[] infos, NodesMap parentCache) {
        int pathLen = path.length();
        for (LazyInfo info : infos) {
            String subPath = info.getPath();
            if (subPath == null) {
                subPath = "";
            }
            if (pathLen > 0) {
                subPath = subPath.substring(pathLen);
            }
            if (subPath.startsWith(Util.PATH_SPLIT)) {
                subPath = subPath.substring(1);
            }
            String[] ps = Util.splitPath(subPath);
            DefaultKingdeeTreeNode pNode = parentNode;
            NodesMap cache = parentCache;
            for (int j = 0; j < ps.length; ++j) {
                String name = ps[j];
                DefaultKingdeeTreeNode tempNode = cache.getNode(name);
                if (tempNode == null) {
                    String tempPath;
                    if (pNode.getUserObject() instanceof LazyInfo) {
                        LazyInfo pInfo = (LazyInfo)pNode.getUserObject();
                        tempPath = Util.makePath(pInfo.getPath(), pInfo.getPhysicalName());
                    } else {
                        tempPath = "";
                    }
                    tempNode = this._customBehavior.createFolder(tempPath, name);
                    this._tree.addNodeInto((MutableTreeNode)tempNode, (MutableTreeNode)pNode);
                    cache.putNode(name, tempNode);
                }
                pNode = tempNode;
                cache = cache.getChildMap(name);
            }
            this._customBehavior.addEntityNode(pNode, info);
        }
    }

    public static void sort(KDTree tree, DefaultKingdeeTreeNode parent) {
        int i;
        ArrayList<DefaultKingdeeTreeNode> list = new ArrayList<DefaultKingdeeTreeNode>();
        for (i = parent.getChildCount() - 1; i >= 0; --i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)parent.getChildAt(i);
            if (child.getChildCount() > 0) {
                TreeBuilder.sort(tree, child);
            }
            list.add(child);
        }
        tree.removeAllChildrenFromParent((MutableTreeNode)parent);
        Collections.sort(list, (Comparator)new Sorter());
        int c = list.size();
        for (i = 0; i < c; ++i) {
            tree.addNodeInto((MutableTreeNode)((DefaultKingdeeTreeNode)list.get(i)), (MutableTreeNode)parent);
        }
    }

    private static class Sorter
    implements Comparator {
        private Sorter() {
        }

        public int compare(Object obj1, Object obj2) {
            DefaultKingdeeTreeNode n1 = (DefaultKingdeeTreeNode)obj1;
            DefaultKingdeeTreeNode n2 = (DefaultKingdeeTreeNode)obj2;
            LazyInfo info1 = (LazyInfo)n1.getUserObject();
            LazyInfo info2 = (LazyInfo)n2.getUserObject();
            if (info1.getType() == 0) {
                if (info2.getType() == 0) {
                    return info1.getPhysicalName().toUpperCase(Locale.ENGLISH).compareTo(info2.getPhysicalName().toUpperCase(Locale.ENGLISH));
                }
                return -1;
            }
            if (info1.getType() == 1) {
                if (info2.getType() == 0) {
                    return 1;
                }
                if (info2.getType() == 1) {
                    return info1.getLogicalName().compareTo(info2.getLogicalName());
                }
                if (info2.getType() == 2) {
                    return -1;
                }
            } else if (info1.getType() == 2) {
                if (info2.getType() == 2) {
                    return info1.getLogicalName().compareTo(info2.getLogicalName());
                }
                return 1;
            }
            return 0;
        }
    }

    public static class NodesMap {
        private Map _mapNodes = new HashMap();
        private Map _mapChildrenMap = new HashMap();

        public NodesMap putNode(String name, DefaultKingdeeTreeNode node) {
            this._mapNodes.put(name.toUpperCase(), node);
            NodesMap childMap = new NodesMap();
            this._mapChildrenMap.put(name.toUpperCase(), childMap);
            return childMap;
        }

        public DefaultKingdeeTreeNode getNode(String name) {
            return (DefaultKingdeeTreeNode)this._mapNodes.get(name.toUpperCase());
        }

        public NodesMap getChildMap(String name) {
            return (NodesMap)this._mapChildrenMap.get(name.toUpperCase());
        }
    }

    public static interface ICustomBehavior {
        public DefaultKingdeeTreeNode createFolder(String var1, String var2);

        public void addEntityNode(DefaultKingdeeTreeNode var1, LazyInfo var2);
    }
}

