/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.common.client.relation;

import com.kingdee.bos.ctrl.semantic.common.client.relation.RelationsConfirmer;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticRelation;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class RelationRenderModel {
    private List _pts;
    private Direction _startDirection;
    private Direction _endDirection;

    public RelationRenderModel() {
        this.clear();
    }

    public void copy(RelationRenderModel mo) {
        this._pts = mo._pts;
        this._startDirection = mo._startDirection;
        this._endDirection = mo._endDirection;
    }

    public void clear() {
        this._pts = new ArrayList();
    }

    public void addPoint(Point pt) {
        this._pts.add(pt);
    }

    public int getPointCount() {
        return this._pts.size();
    }

    public Point getPoint(int idx) {
        return (Point)this._pts.get(idx);
    }

    public void setStartDirection(Direction dir) {
        this._startDirection = dir;
    }

    public Direction getStartDirection() {
        return this._startDirection;
    }

    public void setEndDirection(Direction dir) {
        this._endDirection = dir;
    }

    public Direction getEndDirection() {
        return this._endDirection;
    }

    public void update(SemanticRelation relation) {
        Rectangle rectA = (Rectangle)relation.getClient().getProperty("rect");
        Rectangle rectB = (Rectangle)relation.getSupplier().getProperty("rect");
        this.update(rectA, rectB);
    }

    public void update(Rectangle rectA, Rectangle rectB) {
        RelationsConfirmer confirmer = new RelationsConfirmer();
        confirmer.update(rectA, rectB, this);
    }

    public static class Direction {
        public static final Direction EAST = new Direction(1);
        public static final Direction SOUTH = new Direction(2);
        public static final Direction WEST = new Direction(4);
        public static final Direction NORTH = new Direction(8);
        private int _dir;

        private Direction(int dir) {
            this._dir = dir;
        }

        private int getValue() {
            return this._dir;
        }

        public boolean isForwardEast() {
            return (this._dir & EAST.getValue()) == EAST.getValue();
        }

        public boolean isForwardWest() {
            return (this._dir & WEST.getValue()) == WEST.getValue();
        }

        public boolean isForwardNorth() {
            return (this._dir & NORTH.getValue()) == NORTH.getValue();
        }

        public boolean isForwardSouth() {
            return (this._dir & SOUTH.getValue()) == SOUTH.getValue();
        }

        public boolean isHorizontal() {
            return this.isForwardEast() || this.isForwardWest();
        }

        public boolean isVertical() {
            return this.isForwardNorth() || this.isForwardSouth();
        }

        public Direction append(Direction another) {
            return new Direction(this._dir | another.getValue());
        }
    }
}

