/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.common.client.relation;

import com.kingdee.bos.ctrl.semantic.common.client.relation.RelationRenderModel;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Rectangle2D;

public class RelationRenderer {
    public static void paintLine(Graphics g, RelationRenderModel line, String roleText) {
        int x1;
        int x2;
        int y2;
        int y1;
        int lastIdx;
        if (roleText == null) {
            roleText = "";
        }
        if ((lastIdx = line.getPointCount() - 1) < 1) {
            return;
        }
        for (int j = 1; j <= lastIdx; ++j) {
            g.drawLine(line.getPoint((int)(j - 1)).x, line.getPoint((int)(j - 1)).y, line.getPoint((int)j).x, line.getPoint((int)j).y);
        }
        int x = line.getPoint((int)lastIdx).x;
        int y = line.getPoint((int)lastIdx).y;
        RelationRenderModel.Direction dir = line.getEndDirection();
        if (dir.isHorizontal()) {
            y1 = y - 3;
            y2 = y + 3;
            x1 = dir == RelationRenderModel.Direction.WEST ? (x2 = x + 6) : (x2 = x - 6);
        } else {
            x1 = x - 3;
            x2 = x + 3;
            y1 = dir == RelationRenderModel.Direction.NORTH ? (y2 = y + 6) : (y2 = y - 6);
        }
        g.drawLine(x, y, x1, y1);
        g.drawLine(x, y, x2, y2);
        Point pt = RelationRenderer.calulateRoleTextPos(g, roleText, line, new Point(6, 4));
        g.drawString(roleText, pt.x, pt.y);
    }

    private static Point calulateRoleTextPos(Graphics g, String text, RelationRenderModel line, Point spacing) {
        RelationRenderModel.Direction dir = line.getEndDirection();
        Point point = new Point(line.getPoint(line.getPointCount() - 1));
        Rectangle2D rect = null;
        if (dir == RelationRenderModel.Direction.EAST) {
            rect = g.getFontMetrics().getStringBounds(text, g);
            point.x = (int)((double)point.x - rect.getWidth());
            point.x -= spacing.x;
        } else {
            point.x += spacing.x;
        }
        if (dir == RelationRenderModel.Direction.NORTH) {
            if (rect == null) {
                rect = g.getFontMetrics().getStringBounds(text, g);
            }
            point.y = (int)((double)point.y + rect.getHeight() * 0.7);
            point.y += spacing.y;
        } else {
            point.y -= spacing.y;
        }
        return point;
    }
}

