/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.common.client.relation;

import com.kingdee.bos.ctrl.semantic.common.client.relation.RelationRenderModel;
import com.kingdee.bos.ctrl.semantic.common.client.relation.RelativePos;
import java.awt.Point;
import java.awt.Rectangle;

class RelationsConfirmer {
    RelationsConfirmer() {
    }

    public void update(Rectangle rectClient, Rectangle rectSupplier, RelationRenderModel mo) {
        RelationRenderModel newMo;
        mo.clear();
        Rectangle rectA = rectClient;
        Rectangle rectB = rectSupplier;
        int[] aY = new int[]{rectA.y, rectA.y + rectA.height};
        int[] bY = new int[]{rectB.y, rectB.y + rectB.height};
        RelativePos vRP = this.getRelativePos(aY, bY);
        int[] aX = new int[]{rectA.x, rectA.x + rectA.width};
        int[] bX = new int[]{rectB.x, rectB.x + rectB.width};
        RelativePos hRP = this.getRelativePos(aX, bX);
        if (hRP.isLeave()) {
            if (vRP.isLeave()) {
                RelationRenderModel.Direction dirStart;
                int yEnd;
                int yStart;
                RelationRenderModel.Direction dirEnd;
                int xEnd;
                int xStart;
                if (hRP.isPrevious()) {
                    xStart = aX[1] - (aX[1] - aX[0]) / 5;
                    xEnd = bX[0];
                    dirEnd = RelationRenderModel.Direction.EAST;
                } else {
                    xStart = aX[0] + (aX[1] - aX[0]) / 5;
                    xEnd = bX[1];
                    dirEnd = RelationRenderModel.Direction.WEST;
                }
                if (vRP.isPrevious()) {
                    yStart = aY[1];
                    yEnd = bY[0] + (bY[1] - bY[0]) / 4;
                    dirStart = RelationRenderModel.Direction.SOUTH;
                } else {
                    yStart = aY[0];
                    yEnd = bY[1] - (bY[1] - bY[0]) / 4;
                    dirStart = RelationRenderModel.Direction.NORTH;
                }
                newMo = this.searchingLine(new Point(xStart, yStart), dirStart, new Point(xEnd, yEnd), dirEnd);
            } else {
                int y1 = Math.max(aY[0], bY[0]);
                int y2 = Math.min(aY[1], bY[1]);
                int y = (y2 + y1) / 2;
                if (hRP.isPrevious()) {
                    Point pStart = new Point(aX[1], y);
                    Point pEnd = new Point(bX[0], y);
                    newMo = this.searchingLine(pStart, RelationRenderModel.Direction.EAST, pEnd, RelationRenderModel.Direction.EAST);
                } else {
                    Point pStart = new Point(aX[0], y);
                    Point pEnd = new Point(bX[1], y);
                    newMo = this.searchingLine(pStart, RelationRenderModel.Direction.WEST, pEnd, RelationRenderModel.Direction.WEST);
                }
            }
        } else if (vRP.isLeave()) {
            int x1 = Math.max(aX[0], bX[0]);
            int x2 = Math.min(aX[1], bX[1]);
            int x = (x2 + x1) / 2;
            if (vRP.isPrevious()) {
                Point pStart = new Point(x, aY[1]);
                Point pEnd = new Point(x, bY[0]);
                newMo = this.searchingLine(pStart, RelationRenderModel.Direction.SOUTH, pEnd, RelationRenderModel.Direction.SOUTH);
            } else {
                Point pStart = new Point(x, aY[0]);
                Point pEnd = new Point(x, bY[1]);
                newMo = this.searchingLine(pStart, RelationRenderModel.Direction.NORTH, pEnd, RelationRenderModel.Direction.NORTH);
            }
        } else {
            newMo = null;
        }
        if (newMo != null) {
            mo.copy(newMo);
        }
    }

    private RelativePos getRelativePos(int[] aZ, int[] bZ) {
        if (aZ[1] < bZ[0]) {
            return RelativePos.PRE_LEAVE;
        }
        if (aZ[1] < bZ[1]) {
            if (aZ[0] < bZ[0]) {
                return RelativePos.PRE_CROSS;
            }
            return RelativePos.BE_CONTAINED;
        }
        if (aZ[0] > bZ[1]) {
            return RelativePos.POST_LEAVE;
        }
        if (aZ[0] < bZ[0]) {
            return RelativePos.CONTAIN;
        }
        return RelativePos.POST_CROSS;
    }

    private RelationRenderModel searchingLine(Point pStart, RelationRenderModel.Direction dirStart, Point pEnd, RelationRenderModel.Direction dirEnd) {
        RelationRenderModel mo = new RelationRenderModel();
        mo.setStartDirection(dirStart);
        mo.setEndDirection(dirEnd);
        mo.addPoint(pStart);
        Point pNext = pStart;
        RelationRenderModel.Direction dirNext = dirStart;
        do {
            Object[] objs = this.searchingNextPoint(pNext, dirNext, pEnd, dirEnd);
            pNext = (Point)objs[0];
            dirNext = (RelationRenderModel.Direction)objs[1];
            mo.addPoint(pNext);
        } while (!pNext.equals(pEnd));
        return mo;
    }

    private Object[] searchingNextPoint(Point pStart, RelationRenderModel.Direction dirStart, Point pEnd, RelationRenderModel.Direction dirEnd) {
        RelationRenderModel.Direction dir;
        Point pt = new Point();
        if (dirStart.isHorizontal()) {
            pt.y = pStart.y;
            pt.x = pEnd.x;
            dir = RelationRenderModel.Direction.NORTH.append(RelationRenderModel.Direction.SOUTH);
        } else {
            pt.x = pStart.x;
            pt.y = pEnd.y;
            dir = RelationRenderModel.Direction.WEST.append(RelationRenderModel.Direction.EAST);
        }
        return new Object[]{pt, dir};
    }
}

