/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.client;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.semantic.design.client.SchemaTree;
import com.kingdee.bos.ctrl.semantic.design.client.TabbedPane;
import com.kingdee.bos.ctrl.semantic.design.client.action.CloseTab;
import com.kingdee.bos.ctrl.semantic.design.client.action.DeleteEntity;
import com.kingdee.bos.ctrl.semantic.design.client.action.DeleteRelation;
import com.kingdee.bos.ctrl.semantic.design.client.action.EditEntity;
import com.kingdee.bos.ctrl.semantic.design.client.action.Exit;
import com.kingdee.bos.ctrl.semantic.design.client.action.NewEntity;
import com.kingdee.bos.ctrl.semantic.design.client.action.NewFolder;
import com.kingdee.bos.ctrl.semantic.design.client.action.Project;
import com.kingdee.bos.ctrl.semantic.design.client.action.Refactor;
import com.kingdee.bos.ctrl.semantic.design.client.action.Refresh;
import com.kingdee.bos.ctrl.semantic.design.client.action.Save;
import com.kingdee.bos.ctrl.semantic.design.client.action.SaveAll;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.EntityShower;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.property.PropertyArea;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.manage.client.EditingContext;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class DesignPane
extends KDPanel {
    private static final Logger log = LogUtil.getPackageLogger(DesignPane.class);
    public static final String ACTION_EXIT = "exit";
    public static final String ACTION_SAVE = "save";
    public static final String ACTION_SAVEALL = "saveAll";
    public static final String ACTION_CLOSE = "closeOne";
    public static final String ACTION_CLOSEAll = "closeAll";
    public static final String ACTION_CLOSEOTHERS = "closeOthers";
    public static final String ACTION_DELETE_RELATION = "deleteRelation";
    private KDSplitPane _sppLeftRight;
    private KDSplitPane _sppTopBottom;
    private SchemaTree _tree;
    private TabbedPane _tabbedPane;
    private KDContainer _panProperty;
    private EditingContext _editingContext;
    private Map _defaultActions;

    public DesignPane() {
        this.init();
        this.installListener();
        this.initActions();
    }

    private void init() {
        this.initTree();
        this._sppLeftRight = new KDSplitPane(1);
        this._sppLeftRight.setDividerLocation(260);
        this._sppTopBottom = new KDSplitPane(0);
        this._sppTopBottom.setResizeWeight(0.5);
        this._tabbedPane = new TabbedPane(this);
        this._panProperty = new KDContainer();
        this._panProperty.setTitle("\u5c5e\u6027");
        this._panProperty.setEnableActive(false);
        this._panProperty.getContentPane().setLayout(new BorderLayout());
        this._sppLeftRight.setLeftComponent((Component)this._tree.getUI());
        this._sppLeftRight.setRightComponent((Component)this._sppTopBottom);
        this._sppTopBottom.setTopComponent((Component)((Object)this._tabbedPane));
        this._sppTopBottom.setBottomComponent((Component)this._panProperty);
        this.setLayout(new BorderLayout());
        this.add((Component)this._sppLeftRight, "Center");
    }

    private void initTree() {
        EditEntity edit = new EditEntity(this);
        this._tree = new SchemaTree();
        this._tree.addAction(new Refresh(this));
        this._tree.addAction(new NewFolder(this));
        this._tree.addAction(new NewEntity(this));
        this._tree.addAction(edit);
        this._tree.addAction(new Refactor(this));
        this._tree.addAction(new DeleteEntity(this));
        this._tree.addDoubleClickAction(edit);
    }

    private void installListener() {
        this._tabbedPane.setTabChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PropertyArea pa = null;
                EntityShower shower = DesignPane.this.getCurrentEntityShower();
                if (shower != null) {
                    pa = shower.getCurrentPropertyArea();
                }
                DesignPane.this.changePropertyArea(pa);
            }
        });
        KeyStroke ks = KeyStroke.getKeyStroke(120, 704);
        this.getInputMap(2).put(ks, ks);
        this.getActionMap().put(ks, new Project(this));
    }

    private void initActions() {
        this._defaultActions = new HashMap();
        this._defaultActions.put(ACTION_SAVE, new Save(this));
        this._defaultActions.put(ACTION_SAVEALL, new SaveAll(this));
        this._defaultActions.put(ACTION_CLOSE, new CloseTab.CloseOne(this, this._tabbedPane));
        this._defaultActions.put(ACTION_CLOSEAll, new CloseTab.CloseAll(this, this._tabbedPane));
        this._defaultActions.put(ACTION_CLOSEOTHERS, new CloseTab.CloseOthers(this, this._tabbedPane));
        this._defaultActions.put(ACTION_EXIT, new Exit(this));
        this._defaultActions.put(ACTION_DELETE_RELATION, new DeleteRelation(this));
    }

    public void setEditingContext(EditingContext editingContext) {
        this._editingContext = editingContext;
        this._tree.setEditingContext(editingContext);
    }

    public EditingContext getEditingContext() {
        return this._editingContext;
    }

    public SchemaTree getSchemaTree() {
        return this._tree;
    }

    public EntityShower getCurrentEntityShower() {
        int idx = this._tabbedPane.getSelectedIndex();
        if (idx >= 0) {
            KDScrollPane scp = (KDScrollPane)this._tabbedPane.getComponentAt(idx);
            return (EntityShower)((Object)scp.getViewport().getComponent(0));
        }
        return null;
    }

    public EntityShower getEntityShower(int idx) {
        KDScrollPane scp = (KDScrollPane)this._tabbedPane.getComponentAt(idx);
        return (EntityShower)((Object)scp.getViewport().getComponent(0));
    }

    public EntityShower[] getAllEntityShower() {
        int count = this._tabbedPane.getTabCount();
        EntityShower[] result = new EntityShower[count];
        for (int i = 0; i < count; ++i) {
            KDScrollPane scp = (KDScrollPane)this._tabbedPane.getComponentAt(i);
            result[i] = (EntityShower)((Object)scp.getViewport().getComponent(0));
        }
        return result;
    }

    public int getIndexOfEntityShower(EntityShower entityShower) {
        EntityShower[] all = this.getAllEntityShower();
        for (int i = 0; i < all.length; ++i) {
            if (all[i] != entityShower) continue;
            return i;
        }
        return -1;
    }

    public void addTab(LazyInfo info) throws SemanticDesignException {
        EntityShower shower = new EntityShower(this);
        info.putProperty("editing", Boolean.TRUE);
        shower.setInfo(info);
        shower.setModelDirty(false);
        KDScrollPane comp = new KDScrollPane((Component)((Object)shower));
        comp.setBorder(null);
        this._tabbedPane.addTab(info.getLogicalName(), (Component)comp);
        this._tabbedPane.setSelectedComponent((Component)comp);
    }

    public void removeTab(int tabIdx, String entityId) {
        this._tabbedPane.closeTab(tabIdx);
        if (!StringUtil.isEmptyString((String)entityId)) {
            try {
                this.getEditingContext().getDesigntimeFacade().unlockEntity(this.getEditingContext().getSchemaId(), entityId, null);
            }
            catch (SemanticDesignException ex) {
                log.error((Object)"", (Throwable)ex);
            }
        }
    }

    public void selectTab(int tabIdx) {
        this._tabbedPane.setSelectedIndex(tabIdx);
    }

    public void setTabTitle(int tabIdx, String text) {
        this._tabbedPane.setTitleAt(tabIdx, text);
    }

    public void changePropertyArea(PropertyArea propertyArea) {
        JPanel pan = this._panProperty.getContentPane();
        pan.removeAll();
        if (propertyArea != null) {
            pan.add((Component)((Object)propertyArea), "Center");
        }
        pan.validate();
        pan.repaint();
    }

    public Action getDefaultAction(String key) {
        return (Action)this._defaultActions.get(key);
    }
}

